/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.xj3d.core.eventmodel.Router;
import org.xj3d.impl.core.eventmodel.RouteHolder;

public class SimpleRouter
implements Router {
    private static final int DEFAULT_SIZE = 32;
    private static final int ARRAY_INC = 8;
    private HashSet routeSet = new HashSet();
    private HashSet routesToAdd = new HashSet();
    private HashSet routesToRemove = new HashSet();
    private int routeCount = 0;
    private RouteHolder[] routeList = new RouteHolder[32];
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean processRoutes(double d) {
        if (this.routeCount <= 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.routeCount; ++i) {
            if (!this.routeList[i].needsProcessing()) continue;
            this.routeList[i].sendRoute(d);
            bl = true;
        }
        return bl;
    }

    public void addRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (this.routeSet.contains(routeHolder) || this.routesToAdd.contains(routeHolder)) {
            return;
        }
        if (this.routesToRemove.contains(routeHolder)) {
            this.routesToRemove.remove(routeHolder);
            return;
        }
        this.routesToAdd.add(routeHolder);
    }

    public void addRoutes(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ROUTE rOUTE = (ROUTE)arrayList.get(i);
            this.addRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
        }
    }

    public void removeRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (!this.routeSet.contains(routeHolder) || this.routesToRemove.contains(routeHolder)) {
            return;
        }
        if (this.routesToAdd.contains(routeHolder)) {
            this.routesToAdd.remove(routeHolder);
            return;
        }
        this.routesToRemove.add(routeHolder);
    }

    public void updateRoutes() {
        if (this.routesToRemove.size() == 0 && this.routesToAdd.size() == 0) {
            return;
        }
        this.routeSet.removeAll(this.routesToRemove);
        this.routeSet.addAll(this.routesToAdd);
        this.routeCount = this.routeSet.size();
        if (this.routeCount > this.routeList.length) {
            int n = this.routeList.length;
            int n2 = this.routeCount >= this.routeList.length + 8 ? this.routeCount : this.routeList.length + 8;
            RouteHolder[] routeHolderArray = new RouteHolder[n2];
            System.arraycopy(this.routeList, 0, routeHolderArray, 0, n);
            this.routeList = routeHolderArray;
        }
        this.routeSet.toArray(this.routeList);
        this.routesToAdd.clear();
        this.routesToRemove.clear();
    }

    public void clear() {
        this.routeSet.clear();
        this.routesToAdd.clear();
        this.routesToRemove.clear();
        for (int i = 0; i < this.routeCount; ++i) {
            this.routeList[i] = null;
        }
        this.routeCount = 0;
    }
}

