/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.web3d.util.IntStack;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.export.Exporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.parser.FieldParserFactory;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.VRMLParseException;

public class X3DClassicExporter
extends Exporter {
    public static final int INDENT_SIZE = 4;
    private PrintWriter pw;
    private HashMap nodeNum;
    private HashMap defNum;
    private int lastDef;
    private VRMLNodeFactory nodeFactory;
    protected static VRMLFieldReader fieldParser;
    private SimpleStack currentNode;
    private SimpleStack currentField;
    private IntStack inFieldType;
    private IntStack fieldCnt;
    private IntStack nodeCnt;
    private int ilevel;
    private String istring;
    private boolean upgrading;
    private HashMap nodeMap;
    protected HashMap protoMap;
    protected HashMap externProtoMap;
    private SimpleStack protoDeclStack;
    private SimpleStack protoMapStack;
    private AbstractProto currentProto;
    protected VRMLScriptNodeType currentScript;
    private boolean lastStartField;
    private boolean lastIS;
    private boolean gotFieldValue;
    private StringBuffer routeBuff;
    private boolean ignoreNode = false;
    private HashMap fieldDefaults;
    private boolean needSFNodeDefault;
    private HashMap defTable;
    private HashMap defRemapTable;
    private HashMap defNumTable;

    public X3DClassicExporter(OutputStream outputStream, int n, int n2) {
        super(n, n2);
        this.pw = new PrintWriter(outputStream, false);
        this.currentNode = new SimpleStack();
        this.currentField = new SimpleStack();
        this.fieldCnt = new IntStack();
        this.nodeCnt = new IntStack();
        this.inFieldType = new IntStack();
        this.protoDeclStack = new SimpleStack();
        this.protoMapStack = new SimpleStack();
        this.nodeFactory = DefaultNodeFactory.newInstance("null");
        this.nodeFactory.setSpecVersion(n, n2);
        this.nodeFactory.setProfile("Immersive");
        FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
        fieldParser = fieldParserFactory.newFieldParser(n, n2);
        this.ilevel = 0;
        this.upgrading = false;
        this.lastStartField = false;
        this.lastIS = false;
        this.gotFieldValue = true;
        this.routeBuff = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(' ');
        }
        this.istring = stringBuffer.toString();
        this.nodeMap = new HashMap(50);
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.fieldDefaults = new HashMap();
        this.fieldDefaults.put("MFString", "[]");
        this.fieldDefaults.put("MFFloat", "[]");
        this.fieldDefaults.put("MFInt32", "[]");
        this.fieldDefaults.put("MFDouble", "[]");
        this.fieldDefaults.put("MFTime", "[]");
        this.fieldDefaults.put("MFVec2f", "[]");
        this.fieldDefaults.put("MFVec2d", "[]");
        this.fieldDefaults.put("MFVec3f", "[]");
        this.fieldDefaults.put("MFVec3d", "[]");
        this.fieldDefaults.put("MFImage", "[]");
        this.fieldDefaults.put("MFLong", "[]");
        this.fieldDefaults.put("MFBool", "[]");
        this.fieldDefaults.put("MFRotation", "[]");
        this.fieldDefaults.put("MFColor", "[]");
        this.fieldDefaults.put("MFColorRGBA", "[]");
        this.fieldDefaults.put("SFString", "\"\"");
        this.fieldDefaults.put("SFBool", "FALSE");
        this.fieldDefaults.put("SFFloat", "0");
        this.fieldDefaults.put("SFInt32", "0");
        this.fieldDefaults.put("SFDouble", "0");
        this.fieldDefaults.put("SFTime", "-1");
        this.fieldDefaults.put("SFVec2f", "0 0");
        this.fieldDefaults.put("SFVec2d", "0 0");
        this.fieldDefaults.put("SFVec3f", "0 0 0");
        this.fieldDefaults.put("SFVec3d", "0 0");
        this.fieldDefaults.put("SFImage", "0 0 0");
        this.fieldDefaults.put("SFLong", "0");
        this.fieldDefaults.put("SFRotation", "0 0 1 0");
        this.fieldDefaults.put("SFColor", "0 0 0");
        this.fieldDefaults.put("SFColorRGBA", "0 0 0 0");
        this.needSFNodeDefault = false;
        this.defTable = new HashMap();
        this.defRemapTable = new HashMap();
        this.defNumTable = new HashMap();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        if (string5.equals("V2.0")) {
            this.upgrading = true;
            System.out.println("Upgrading content from VRML to X3D");
        }
        this.pw.println("#X3D V3.0 utf8\n");
        if (this.upgrading) {
            this.pw.println("PROFILE Immersive\n");
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.pw.print("PROFILE ");
        this.pw.println(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        Object object;
        int n = string.indexOf(58);
        String string2 = string;
        int n2 = -1;
        if (n != -1) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRMLParseException(0, 0, "Component level is malformed");
            }
        } else {
            throw new VRMLParseException(0, 0, "Component statement \"" + string + "\" is malformed. It must include " + "both name and level required.");
        }
        object = this.nodeFactory.addComponent(string2, n2);
        this.pw.print("COMPONENT ");
        this.pw.println(string);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        this.pw.print("# META: ");
        this.pw.print(string);
        this.pw.print(" = ");
        this.pw.println(string2);
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        this.pw.print("IMPORT ");
        this.pw.print(string);
        this.pw.print(".");
        this.pw.print(string2);
        this.pw.print(" AS ");
        this.pw.println(string3);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        this.pw.print("EXPORT ");
        this.pw.print(string);
        this.pw.print(" AS ");
        this.pw.print(string2);
    }

    public void endDocument() throws SAVException, VRMLException {
        if (this.routeBuff.length() > 0) {
            this.pw.print(this.routeBuff.toString());
            this.routeBuff.setLength(0);
        }
        this.pw.flush();
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        this.lastStartField = false;
        this.needSFNodeDefault = false;
        if (!this.inFieldType.isEmpty()) {
            int n = this.inFieldType.peek();
            int n2 = this.nodeCnt.pop();
            if (n == 0 && n2 == 0) {
                this.pw.println("[");
            }
            this.nodeCnt.push(++n2);
        }
        this.lastIS = false;
        VRMLNode vRMLNode = (VRMLNode)this.nodeMap.get(string);
        if (vRMLNode == null) {
            if (this.protoMap.containsKey(string) || this.externProtoMap.containsKey(string)) {
                PrototypeDecl prototypeDecl = null;
                prototypeDecl = (PrototypeDecl)this.protoMap.get(string);
                if (prototypeDecl == null) {
                    ExternalPrototypeDecl externalPrototypeDecl = (ExternalPrototypeDecl)this.externProtoMap.get(string);
                    this.currentNode.push(externalPrototypeDecl);
                } else {
                    this.currentNode.push(prototypeDecl);
                }
            } else {
                vRMLNode = this.nodeFactory.createVRMLNode(string, false);
                this.nodeMap.put(string, vRMLNode);
                this.currentNode.push(vRMLNode);
            }
        } else {
            this.currentNode.push(vRMLNode);
        }
        this.fieldCnt.push(0);
        ++this.ilevel;
        if (string.equals("Text")) {
            this.ignoreNode = true;
            return;
        }
        this.ignoreNode = false;
        if (string2 != null) {
            if (this.defTable.get(string2) != null) {
                Integer n = (Integer)this.defNumTable.get(string2);
                n = n != null ? new Integer(n + 1) : new Integer(1);
                this.defNumTable.put(string2, n);
                String string3 = string2 + n;
                System.out.println("Duplicate DEF detected, renamed to: " + string3);
                this.defRemapTable.put(string2, string3);
                string2 = string3;
            } else {
                this.defTable.put(string2, string);
            }
            this.pw.print("DEF ");
            this.pw.print(string2);
            this.pw.print(" ");
        }
        this.pw.print(string);
        this.pw.println(" {");
    }

    public void endNode() throws SAVException, VRMLException {
        --this.ilevel;
        this.currentNode.pop();
        int n = this.fieldCnt.pop();
        if (n > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            int n2 = this.inFieldType.pop();
            if (n2 < 2) {
                int n3 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n2 == 0) {
                    this.indent();
                    --this.ilevel;
                    if (n3 == 0 && !this.lastIS) {
                        this.pw.print("[");
                    }
                    this.pw.println("]");
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
                this.pw.println("[]");
            }
        }
        this.indent();
        if (!this.ignoreNode) {
            this.pw.println("}");
        }
        this.lastIS = false;
    }

    public void startField(String string) throws SAVException, VRMLException {
        int n;
        if (this.ignoreNode) {
            return;
        }
        this.lastStartField = true;
        int n2 = this.fieldCnt.pop();
        if (n2 > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            int n3 = this.inFieldType.pop();
            if (n3 < 2) {
                n = this.nodeCnt.pop();
                this.currentField.pop();
                if (n3 == 0) {
                    this.indent();
                    --this.ilevel;
                    if (n == 0 && !this.lastIS) {
                        this.pw.print("[");
                    }
                    this.pw.println("]");
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
                this.pw.println("[]");
            }
        }
        this.fieldCnt.push(++n2);
        this.lastIS = false;
        this.gotFieldValue = false;
        this.indent();
        this.pw.print(string);
        this.pw.print(" ");
        Object object = this.currentNode.peek();
        n = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldIndex(string) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldIndex(string) : ((ExternalPrototypeDecl)object).getFieldIndex(string));
        this.currentField.push(new Integer(n));
        if (this.isMFNode()) {
            this.inFieldType.push(0);
            this.pw.println();
            ++this.ilevel;
            this.indent();
        } else if (this.isSFNode()) {
            this.inFieldType.push(1);
        } else if (this.isSFField()) {
            this.inFieldType.push(2);
        } else {
            this.inFieldType.push(3);
        }
        this.nodeCnt.push(0);
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        if (this.ignoreNode) {
            return;
        }
        this.gotFieldValue = true;
        if (this.isMFField()) {
            this.pw.print("[");
        }
        if (string != null) {
            if (this.isField(1)) {
                this.pw.print(string.toUpperCase());
            } else if (this.isField(27) || this.isField(28)) {
                boolean bl = false;
                if (string.charAt(0) != '\"') {
                    bl = true;
                    this.pw.print("\"");
                } else {
                    bl = false;
                }
                this.pw.print(string);
                if (bl) {
                    this.pw.print("\"");
                }
            } else {
                this.pw.print(string);
            }
        }
        if (this.isMFField()) {
            this.pw.print("]");
        }
        this.pw.println();
        this.currentField.pop();
        this.nodeCnt.pop();
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        if (this.ignoreNode) {
            return;
        }
        this.gotFieldValue = true;
        if (this.isMFField()) {
            this.pw.print("[");
        }
        int n = (Integer)this.currentField.peek();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isField(27) || this.isField(28)) {
                if (stringArray[i].charAt(0) != '\"') {
                    bl = true;
                    this.pw.print("\"");
                } else {
                    bl = false;
                }
            }
            this.pw.print(stringArray[i]);
            if (bl) {
                this.pw.print("\"");
            }
            this.pw.print(" ");
        }
        this.pw.println("]");
        this.currentField.pop();
        this.nodeCnt.pop();
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        if (this.ignoreNode) {
            return;
        }
        int n = this.nodeCnt.pop();
        if (n == 0 && this.isMFNode()) {
            this.pw.print("[");
        }
        this.nodeCnt.push(++n);
        String string2 = (String)this.defRemapTable.get(string);
        if (string2 != null) {
            string = string2;
        }
        this.pw.print("USE ");
        this.pw.println(string);
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        this.routeBuff.append("ROUTE ");
        this.routeBuff.append(string);
        this.routeBuff.append(".");
        this.routeBuff.append(string2);
        this.routeBuff.append(" TO ");
        this.routeBuff.append(string3);
        this.routeBuff.append(".");
        this.routeBuff.append(string4);
        this.routeBuff.append("\n");
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode.peek();
        this.fieldCnt.push(0);
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        int n = this.fieldCnt.pop();
        if (n > 0 && !this.inFieldType.isEmpty()) {
            int n2 = this.inFieldType.pop();
            if (n2 < 2) {
                int n3 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n2 == 0) {
                    if (n3 == 0 && !this.lastIS) {
                        this.pw.print("[");
                    }
                    this.pw.println("]");
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
                this.pw.println("[]");
            }
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentScript.appendField(vRMLFieldDeclaration);
        this.printFieldDecl(n, string, string2, object);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        if (this.routeBuff.length() > 0) {
            this.pw.print(this.routeBuff.toString());
            this.routeBuff.setLength(0);
        }
        this.indent();
        ++this.ilevel;
        this.pw.print("PROTO ");
        this.pw.print(string);
        this.pw.println(" [");
        PrototypeDecl prototypeDecl = new PrototypeDecl(string, this.majorVersion, this.minorVersion, null);
        this.protoMap.put(string, prototypeDecl);
        this.protoDeclStack.push(prototypeDecl);
        this.currentProto = prototypeDecl;
        this.fieldCnt.push(0);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        int n = this.fieldCnt.pop();
        if (this.needSFNodeDefault) {
            this.needSFNodeDefault = false;
            this.pw.print("NULL\n");
        }
        if (n > 0 && !this.inFieldType.isEmpty()) {
            int n2 = this.inFieldType.pop();
            if (n2 < 2) {
                int n3 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n2 == 0) {
                    if (n3 == 0 && !this.lastIS) {
                        this.pw.print("[");
                    }
                    this.pw.println("]");
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
                this.pw.println("[]");
            }
        }
        --this.ilevel;
        this.indent();
        this.pw.println("]");
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        if (this.needSFNodeDefault) {
            this.needSFNodeDefault = false;
            this.pw.print("NULL\n");
        }
        this.printFieldDecl(n, string, string2, object);
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentProto.appendField(vRMLFieldDeclaration);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        int n = this.inFieldType.pop();
        this.needSFNodeDefault = false;
        if (this.lastStartField || n < 2) {
            this.nodeCnt.pop();
            this.currentField.pop();
        }
        this.lastIS = true;
        this.pw.print("IS ");
        this.pw.println(string);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        this.indent();
        this.pw.println("{");
        ++this.ilevel;
        this.protoMapStack.push(this.protoMap);
        this.protoMap = new HashMap();
    }

    public void endProtoBody() throws SAVException, VRMLException {
        if (this.routeBuff.length() > 0) {
            this.pw.print(this.routeBuff.toString());
            this.routeBuff.setLength(0);
        }
        --this.ilevel;
        this.indent();
        this.pw.println("}");
        this.protoMap = this.protoMapStack.size() > 0 ? (HashMap)this.protoMapStack.pop() : new HashMap();
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        this.indent();
        this.pw.print("EXTERNPROTO ");
        this.pw.print(string);
        this.pw.println(" [");
        ++this.ilevel;
        ExternalPrototypeDecl externalPrototypeDecl = new ExternalPrototypeDecl(string, this.majorVersion, this.minorVersion, null);
        this.externProtoMap.put(string, externalPrototypeDecl);
        this.currentProto = externalPrototypeDecl;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.indent();
        this.pw.print("] ");
        --this.ilevel;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        this.pw.print("\"");
        for (int i = 0; i < stringArray.length; ++i) {
            this.pw.print(stringArray[i]);
        }
        this.pw.println("\"\n");
    }

    private void indent() {
        for (int i = 0; i < this.ilevel; ++i) {
            this.pw.print(this.istring);
        }
    }

    private void printFieldDecl(int n, String string, String string2, Object object) {
        int n2;
        int n3;
        int n4 = this.fieldCnt.pop();
        if (n4 > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            n3 = this.inFieldType.pop();
            if (n3 != 2) {
                n2 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n3 == 0) {
                    this.indent();
                    --this.ilevel;
                    if (n2 == 0 && !this.lastIS) {
                        this.pw.print("[");
                    }
                    this.pw.println("]");
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
                this.pw.println("[]");
            }
        }
        this.fieldCnt.push(++n4);
        this.indent();
        switch (n) {
            case 2: {
                this.pw.print("initializeOnly ");
                break;
            }
            case 3: {
                this.pw.print("inputOutput ");
                break;
            }
            case 1: {
                this.pw.print("inputOnly ");
                break;
            }
            case 4: {
                this.pw.print("outputOnly ");
                break;
            }
            default: {
                System.out.println("Unknown field type in X3DClassicExporter: " + n);
            }
        }
        this.pw.print(string);
        this.pw.print(" ");
        this.pw.print(string2);
        this.pw.print(" ");
        n3 = string.equals("MFNode") ? 0 : (string.equals("SFNode") ? 1 : 2);
        this.inFieldType.push(n3);
        if (n3 != 2) {
            this.nodeCnt.push(0);
            this.currentField.push(new Integer(0));
        }
        if (object instanceof String) {
            this.pw.print("\"");
            this.pw.print(object);
            this.pw.print("\"");
        } else if (object instanceof String[]) {
            this.pw.print("[");
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                this.pw.print("\"");
                this.pw.print(((String[])object)[n2]);
                this.pw.print("\"");
            }
            this.pw.print("]");
        } else if (n == 2 || n == 3) {
            String string3 = (String)this.fieldDefaults.get(string);
            if (string3 != null) {
                this.pw.print(string3);
            } else if (string.equals("SFNode")) {
                this.needSFNodeDefault = true;
            }
        }
        this.pw.println();
        this.lastIS = false;
        this.gotFieldValue = true;
    }

    private boolean isMFField() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        if (vRMLFieldDeclaration == null) {
            System.out.println("No decl for: " + object + " idx: " + n);
        }
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    private boolean isMFNode() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        return vRMLFieldDeclaration.getFieldType() == 12;
    }

    private boolean isSFNode() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        return vRMLFieldDeclaration.getFieldType() == 11;
    }

    private boolean isSFField() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private boolean isField(int n) {
        Object object = this.currentNode.peek();
        int n2 = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n2) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n2) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n2));
        return n == vRMLFieldDeclaration.getFieldType();
    }
}

