# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendBaseParameters(Model):
    """Backend entity base Parameter set.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System.
     This url can be the Arm Resource Id of Logic Apps, Function Apps or Api
     Apps.
    :type resource_id: str
    :param properties: Backend Properties contract
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties
    :type credentials:
     ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
    }

    def __init__(self, *, title: str=None, description: str=None, resource_id: str=None, properties=None, credentials=None, proxy=None, tls=None, **kwargs) -> None:
        super(BackendBaseParameters, self).__init__(**kwargs)
        self.title = title
        self.description = description
        self.resource_id = resource_id
        self.properties = properties
        self.credentials = credentials
        self.proxy = proxy
        self.tls = tls
