# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .ssis_object_metadata_py3 import SsisObjectMetadata


class SsisProject(SsisObjectMetadata):
    """Ssis project.

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param folder_id: Folder id which contains project.
    :type folder_id: long
    :param version: Project version.
    :type version: long
    :param environment_refs: Environment reference in project
    :type environment_refs:
     list[~azure.mgmt.datafactory.models.SsisEnvironmentReference]
    :param parameters: Parameters in project
    :type parameters: list[~azure.mgmt.datafactory.models.SsisParameter]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'version': {'key': 'version', 'type': 'long'},
        'environment_refs': {'key': 'environmentRefs', 'type': '[SsisEnvironmentReference]'},
        'parameters': {'key': 'parameters', 'type': '[SsisParameter]'},
    }

    def __init__(self, *, id: int=None, name: str=None, description: str=None, folder_id: int=None, version: int=None, environment_refs=None, parameters=None, **kwargs) -> None:
        super(SsisProject, self).__init__(id=id, name=name, description=description, **kwargs)
        self.folder_id = folder_id
        self.version = version
        self.environment_refs = environment_refs
        self.parameters = parameters
        self.type = 'Project'
