# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ActionGroupList(msrest.serialization.Model):
    """A list of action groups.

    :param value: The list of action groups.
    :type value: list[~$(python-base-namespace).v2018_03_01.models.ActionGroupResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActionGroupResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionGroupList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ActionGroupPatchBody(msrest.serialization.Model):
    """An action group object for the body of patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its actions will be activated.
    :type enabled: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionGroupPatchBody, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.enabled = kwargs.get('enabled', True)


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class ActionGroupResource(Resource):
    """An action group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param group_short_name: The short name of the action group. This will be used in SMS messages.
    :type group_short_name: str
    :param enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its receivers will receive communications.
    :type enabled: bool
    :param email_receivers: The list of email receivers that are part of this action group.
    :type email_receivers: list[~$(python-base-namespace).v2018_03_01.models.EmailReceiver]
    :param sms_receivers: The list of SMS receivers that are part of this action group.
    :type sms_receivers: list[~$(python-base-namespace).v2018_03_01.models.SmsReceiver]
    :param webhook_receivers: The list of webhook receivers that are part of this action group.
    :type webhook_receivers: list[~$(python-base-namespace).v2018_03_01.models.WebhookReceiver]
    :param itsm_receivers: The list of ITSM receivers that are part of this action group.
    :type itsm_receivers: list[~$(python-base-namespace).v2018_03_01.models.ItsmReceiver]
    :param azure_app_push_receivers: The list of AzureAppPush receivers that are part of this
     action group.
    :type azure_app_push_receivers: list[~$(python-base-
     namespace).v2018_03_01.models.AzureAppPushReceiver]
    :param automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
     this action group.
    :type automation_runbook_receivers: list[~$(python-base-
     namespace).v2018_03_01.models.AutomationRunbookReceiver]
    :param voice_receivers: The list of voice receivers that are part of this action group.
    :type voice_receivers: list[~$(python-base-namespace).v2018_03_01.models.VoiceReceiver]
    :param logic_app_receivers: The list of logic app receivers that are part of this action group.
    :type logic_app_receivers: list[~$(python-base-namespace).v2018_03_01.models.LogicAppReceiver]
    :param azure_function_receivers: The list of azure function receivers that are part of this
     action group.
    :type azure_function_receivers: list[~$(python-base-
     namespace).v2018_03_01.models.AzureFunctionReceiver]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'group_short_name': {'max_length': 12, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'group_short_name': {'key': 'properties.groupShortName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'email_receivers': {'key': 'properties.emailReceivers', 'type': '[EmailReceiver]'},
        'sms_receivers': {'key': 'properties.smsReceivers', 'type': '[SmsReceiver]'},
        'webhook_receivers': {'key': 'properties.webhookReceivers', 'type': '[WebhookReceiver]'},
        'itsm_receivers': {'key': 'properties.itsmReceivers', 'type': '[ItsmReceiver]'},
        'azure_app_push_receivers': {'key': 'properties.azureAppPushReceivers', 'type': '[AzureAppPushReceiver]'},
        'automation_runbook_receivers': {'key': 'properties.automationRunbookReceivers', 'type': '[AutomationRunbookReceiver]'},
        'voice_receivers': {'key': 'properties.voiceReceivers', 'type': '[VoiceReceiver]'},
        'logic_app_receivers': {'key': 'properties.logicAppReceivers', 'type': '[LogicAppReceiver]'},
        'azure_function_receivers': {'key': 'properties.azureFunctionReceivers', 'type': '[AzureFunctionReceiver]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionGroupResource, self).__init__(**kwargs)
        self.group_short_name = kwargs.get('group_short_name', None)
        self.enabled = kwargs.get('enabled', True)
        self.email_receivers = kwargs.get('email_receivers', None)
        self.sms_receivers = kwargs.get('sms_receivers', None)
        self.webhook_receivers = kwargs.get('webhook_receivers', None)
        self.itsm_receivers = kwargs.get('itsm_receivers', None)
        self.azure_app_push_receivers = kwargs.get('azure_app_push_receivers', None)
        self.automation_runbook_receivers = kwargs.get('automation_runbook_receivers', None)
        self.voice_receivers = kwargs.get('voice_receivers', None)
        self.logic_app_receivers = kwargs.get('logic_app_receivers', None)
        self.azure_function_receivers = kwargs.get('azure_function_receivers', None)


class AutomationRunbookReceiver(msrest.serialization.Model):
    """The Azure Automation Runbook notification receiver.

    All required parameters must be populated in order to send to Azure.

    :param automation_account_id: Required. The Azure automation account Id which holds this
     runbook and authenticate to Azure resource.
    :type automation_account_id: str
    :param runbook_name: Required. The name for this runbook.
    :type runbook_name: str
    :param webhook_resource_id: Required. The resource id for webhook linked to this runbook.
    :type webhook_resource_id: str
    :param is_global_runbook: Required. Indicates whether this instance is global runbook.
    :type is_global_runbook: bool
    :param name: Indicates name of the webhook.
    :type name: str
    :param service_uri: The URI where webhooks should be sent.
    :type service_uri: str
    """

    _validation = {
        'automation_account_id': {'required': True},
        'runbook_name': {'required': True},
        'webhook_resource_id': {'required': True},
        'is_global_runbook': {'required': True},
    }

    _attribute_map = {
        'automation_account_id': {'key': 'automationAccountId', 'type': 'str'},
        'runbook_name': {'key': 'runbookName', 'type': 'str'},
        'webhook_resource_id': {'key': 'webhookResourceId', 'type': 'str'},
        'is_global_runbook': {'key': 'isGlobalRunbook', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutomationRunbookReceiver, self).__init__(**kwargs)
        self.automation_account_id = kwargs['automation_account_id']
        self.runbook_name = kwargs['runbook_name']
        self.webhook_resource_id = kwargs['webhook_resource_id']
        self.is_global_runbook = kwargs['is_global_runbook']
        self.name = kwargs.get('name', None)
        self.service_uri = kwargs.get('service_uri', None)


class AzureAppPushReceiver(msrest.serialization.Model):
    """The Azure mobile App push notification receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the Azure mobile app push receiver. Names must be unique
     across all receivers within an action group.
    :type name: str
    :param email_address: Required. The email address registered for the Azure mobile app.
    :type email_address: str
    """

    _validation = {
        'name': {'required': True},
        'email_address': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureAppPushReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.email_address = kwargs['email_address']


class AzureFunctionReceiver(msrest.serialization.Model):
    """An azure function receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the azure function receiver. Names must be unique across all
     receivers within an action group.
    :type name: str
    :param function_app_resource_id: Required. The azure resource id of the function app.
    :type function_app_resource_id: str
    :param function_name: Required. The function name in the function app.
    :type function_name: str
    :param http_trigger_url: Required. The http trigger url where http request sent to.
    :type http_trigger_url: str
    """

    _validation = {
        'name': {'required': True},
        'function_app_resource_id': {'required': True},
        'function_name': {'required': True},
        'http_trigger_url': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'function_app_resource_id': {'key': 'functionAppResourceId', 'type': 'str'},
        'function_name': {'key': 'functionName', 'type': 'str'},
        'http_trigger_url': {'key': 'httpTriggerUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFunctionReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.function_app_resource_id = kwargs['function_app_resource_id']
        self.function_name = kwargs['function_name']
        self.http_trigger_url = kwargs['http_trigger_url']


class MultiMetricCriteria(msrest.serialization.Model):
    """The types of conditions for a multi resource alert.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DynamicMetricCriteria, MetricCriteria.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param criterion_type: Required. Specifies the type of threshold criteria.Constant filled by
     server.  Possible values include: "StaticThresholdCriterion", "DynamicThresholdCriterion".
    :type criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :param name: Required. Name of the criteria.
    :type name: str
    :param metric_name: Required. Name of the metric.
    :type metric_name: str
    :param metric_namespace: Namespace of the metric.
    :type metric_namespace: str
    :param time_aggregation: Required. the criteria time aggregation types. Possible values
     include: "Average", "Count", "Minimum", "Maximum", "Total".
    :type time_aggregation: str or ~$(python-base-namespace).v2018_03_01.models.AggregationType
    :param dimensions: List of dimension conditions.
    :type dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :param skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :type skip_metric_validation: bool
    """

    _validation = {
        'criterion_type': {'required': True},
        'name': {'required': True},
        'metric_name': {'required': True},
        'time_aggregation': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'criterion_type': {'key': 'criterionType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'skip_metric_validation': {'key': 'skipMetricValidation', 'type': 'bool'},
    }

    _subtype_map = {
        'criterion_type': {'DynamicThresholdCriterion': 'DynamicMetricCriteria', 'StaticThresholdCriterion': 'MetricCriteria'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiMetricCriteria, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.criterion_type = 'MultiMetricCriteria'  # type: str
        self.name = kwargs['name']
        self.metric_name = kwargs['metric_name']
        self.metric_namespace = kwargs.get('metric_namespace', None)
        self.time_aggregation = kwargs['time_aggregation']
        self.dimensions = kwargs.get('dimensions', None)
        self.skip_metric_validation = kwargs.get('skip_metric_validation', None)


class DynamicMetricCriteria(MultiMetricCriteria):
    """Criterion for dynamic threshold.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param criterion_type: Required. Specifies the type of threshold criteria.Constant filled by
     server.  Possible values include: "StaticThresholdCriterion", "DynamicThresholdCriterion".
    :type criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :param name: Required. Name of the criteria.
    :type name: str
    :param metric_name: Required. Name of the metric.
    :type metric_name: str
    :param metric_namespace: Namespace of the metric.
    :type metric_namespace: str
    :param time_aggregation: Required. the criteria time aggregation types. Possible values
     include: "Average", "Count", "Minimum", "Maximum", "Total".
    :type time_aggregation: str or ~$(python-base-namespace).v2018_03_01.models.AggregationType
    :param dimensions: List of dimension conditions.
    :type dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :param skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :type skip_metric_validation: bool
    :param operator: Required. The operator used to compare the metric value against the threshold.
     Possible values include: "GreaterThan", "LessThan", "GreaterOrLessThan".
    :type operator: str or ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdOperator
    :param alert_sensitivity: Required. The extent of deviation required to trigger an alert. This
     will affect how tight the threshold is to the metric series pattern. Possible values include:
     "Low", "Medium", "High".
    :type alert_sensitivity: str or ~$(python-base-
     namespace).v2018_03_01.models.DynamicThresholdSensitivity
    :param failing_periods: Required. The minimum number of violations required within the selected
     lookback time window required to raise an alert.
    :type failing_periods: ~$(python-base-
     namespace).v2018_03_01.models.DynamicThresholdFailingPeriods
    :param ignore_data_before: Use this option to set the date from which to start learning the
     metric historical data and calculate the dynamic thresholds (in ISO8601 format).
    :type ignore_data_before: ~datetime.datetime
    """

    _validation = {
        'criterion_type': {'required': True},
        'name': {'required': True},
        'metric_name': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'alert_sensitivity': {'required': True},
        'failing_periods': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'criterion_type': {'key': 'criterionType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'skip_metric_validation': {'key': 'skipMetricValidation', 'type': 'bool'},
        'operator': {'key': 'operator', 'type': 'str'},
        'alert_sensitivity': {'key': 'alertSensitivity', 'type': 'str'},
        'failing_periods': {'key': 'failingPeriods', 'type': 'DynamicThresholdFailingPeriods'},
        'ignore_data_before': {'key': 'ignoreDataBefore', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicMetricCriteria, self).__init__(**kwargs)
        self.criterion_type = 'DynamicThresholdCriterion'  # type: str
        self.operator = kwargs['operator']
        self.alert_sensitivity = kwargs['alert_sensitivity']
        self.failing_periods = kwargs['failing_periods']
        self.ignore_data_before = kwargs.get('ignore_data_before', None)


class DynamicThresholdFailingPeriods(msrest.serialization.Model):
    """The minimum number of violations required within the selected lookback time window required to raise an alert.

    All required parameters must be populated in order to send to Azure.

    :param number_of_evaluation_periods: Required. The number of aggregated lookback points. The
     lookback time window is calculated based on the aggregation granularity (windowSize) and the
     selected number of aggregated points.
    :type number_of_evaluation_periods: float
    :param min_failing_periods_to_alert: Required. The number of violations to trigger an alert.
     Should be smaller or equal to numberOfEvaluationPeriods.
    :type min_failing_periods_to_alert: float
    """

    _validation = {
        'number_of_evaluation_periods': {'required': True},
        'min_failing_periods_to_alert': {'required': True},
    }

    _attribute_map = {
        'number_of_evaluation_periods': {'key': 'numberOfEvaluationPeriods', 'type': 'float'},
        'min_failing_periods_to_alert': {'key': 'minFailingPeriodsToAlert', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicThresholdFailingPeriods, self).__init__(**kwargs)
        self.number_of_evaluation_periods = kwargs['number_of_evaluation_periods']
        self.min_failing_periods_to_alert = kwargs['min_failing_periods_to_alert']


class EmailReceiver(msrest.serialization.Model):
    """An email receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the email receiver. Names must be unique across all
     receivers within an action group.
    :type name: str
    :param email_address: Required. The email address of this receiver.
    :type email_address: str
    :ivar status: The receiver status of the e-mail. Possible values include: "NotSpecified",
     "Enabled", "Disabled".
    :vartype status: str or ~$(python-base-namespace).v2018_03_01.models.ReceiverStatus
    """

    _validation = {
        'name': {'required': True},
        'email_address': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.email_address = kwargs['email_address']
        self.status = None


class EnableRequest(msrest.serialization.Model):
    """Describes a receiver that should be resubscribed.

    All required parameters must be populated in order to send to Azure.

    :param receiver_name: Required. The name of the receiver to resubscribe.
    :type receiver_name: str
    """

    _validation = {
        'receiver_name': {'required': True},
    }

    _attribute_map = {
        'receiver_name': {'key': 'receiverName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnableRequest, self).__init__(**kwargs)
        self.receiver_name = kwargs['receiver_name']


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ItsmReceiver(msrest.serialization.Model):
    """An Itsm receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the Itsm receiver. Names must be unique across all receivers
     within an action group.
    :type name: str
    :param workspace_id: Required. OMS LA instance identifier.
    :type workspace_id: str
    :param connection_id: Required. Unique identification of ITSM connection among multiple defined
     in above workspace.
    :type connection_id: str
    :param ticket_configuration: Required. JSON blob for the configurations of the ITSM action.
     CreateMultipleWorkItems option will be part of this blob as well.
    :type ticket_configuration: str
    :param region: Required. Region in which workspace resides. Supported
     values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
    :type region: str
    """

    _validation = {
        'name': {'required': True},
        'workspace_id': {'required': True},
        'connection_id': {'required': True},
        'ticket_configuration': {'required': True},
        'region': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'connection_id': {'key': 'connectionId', 'type': 'str'},
        'ticket_configuration': {'key': 'ticketConfiguration', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ItsmReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.workspace_id = kwargs['workspace_id']
        self.connection_id = kwargs['connection_id']
        self.ticket_configuration = kwargs['ticket_configuration']
        self.region = kwargs['region']


class LogicAppReceiver(msrest.serialization.Model):
    """A logic app receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the logic app receiver. Names must be unique across all
     receivers within an action group.
    :type name: str
    :param resource_id: Required. The azure resource id of the logic app receiver.
    :type resource_id: str
    :param callback_url: Required. The callback url where http request sent to.
    :type callback_url: str
    """

    _validation = {
        'name': {'required': True},
        'resource_id': {'required': True},
        'callback_url': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'callback_url': {'key': 'callbackUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogicAppReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.resource_id = kwargs['resource_id']
        self.callback_url = kwargs['callback_url']


class MetricAlertAction(msrest.serialization.Model):
    """An alert action.

    :param action_group_id: the id of the action group to use.
    :type action_group_id: str
    :param web_hook_properties: The properties of a webhook object.
    :type web_hook_properties: dict[str, str]
    """

    _attribute_map = {
        'action_group_id': {'key': 'actionGroupId', 'type': 'str'},
        'web_hook_properties': {'key': 'webHookProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertAction, self).__init__(**kwargs)
        self.action_group_id = kwargs.get('action_group_id', None)
        self.web_hook_properties = kwargs.get('web_hook_properties', None)


class MetricAlertCriteria(msrest.serialization.Model):
    """The rule criteria that defines the conditions of the alert rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MetricAlertMultipleResourceMultipleMetricCriteria, MetricAlertSingleResourceMultipleMetricCriteria, WebtestLocationAvailabilityCriteria.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param odata_type: Required. specifies the type of the alert criteria.Constant filled by
     server.  Possible values include:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :type odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria': 'MetricAlertMultipleResourceMultipleMetricCriteria', 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria': 'MetricAlertSingleResourceMultipleMetricCriteria', 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria': 'WebtestLocationAvailabilityCriteria'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertCriteria, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.odata_type = 'MetricAlertCriteria'  # type: str


class MetricAlertMultipleResourceMultipleMetricCriteria(MetricAlertCriteria):
    """Specifies the metric alert criteria for multiple resource that has multiple metric criteria.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param odata_type: Required. specifies the type of the alert criteria.Constant filled by
     server.  Possible values include:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :type odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :param all_of: the list of multiple metric criteria for this 'all of' operation.
    :type all_of: list[~$(python-base-namespace).v2018_03_01.models.MultiMetricCriteria]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'all_of': {'key': 'allOf', 'type': '[MultiMetricCriteria]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertMultipleResourceMultipleMetricCriteria, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'  # type: str
        self.all_of = kwargs.get('all_of', None)


class MetricAlertResource(Resource):
    """The metric alert resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: Required. the description of the metric alert that will be included in the
     alert email.
    :type description: str
    :param severity: Required. Alert severity {0, 1, 2, 3, 4}.
    :type severity: int
    :param enabled: Required. the flag that indicates whether the metric alert is enabled.
    :type enabled: bool
    :param scopes: the list of resource id's that this metric alert is scoped to.
    :type scopes: list[str]
    :param evaluation_frequency: Required. how often the metric alert is evaluated represented in
     ISO 8601 duration format.
    :type evaluation_frequency: ~datetime.timedelta
    :param window_size: Required. the period of time (in ISO 8601 duration format) that is used to
     monitor alert activity based on the threshold.
    :type window_size: ~datetime.timedelta
    :param target_resource_type: the resource type of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :type target_resource_type: str
    :param target_resource_region: the region of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :type target_resource_region: str
    :param criteria: Required. defines the specific alert criteria information.
    :type criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
    :param auto_mitigate: the flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :type auto_mitigate: bool
    :param actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :type actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'description': {'required': True},
        'severity': {'required': True},
        'enabled': {'required': True},
        'evaluation_frequency': {'required': True},
        'window_size': {'required': True},
        'criteria': {'required': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'scopes': {'key': 'properties.scopes', 'type': '[str]'},
        'evaluation_frequency': {'key': 'properties.evaluationFrequency', 'type': 'duration'},
        'window_size': {'key': 'properties.windowSize', 'type': 'duration'},
        'target_resource_type': {'key': 'properties.targetResourceType', 'type': 'str'},
        'target_resource_region': {'key': 'properties.targetResourceRegion', 'type': 'str'},
        'criteria': {'key': 'properties.criteria', 'type': 'MetricAlertCriteria'},
        'auto_mitigate': {'key': 'properties.autoMitigate', 'type': 'bool'},
        'actions': {'key': 'properties.actions', 'type': '[MetricAlertAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertResource, self).__init__(**kwargs)
        self.description = kwargs['description']
        self.severity = kwargs['severity']
        self.enabled = kwargs['enabled']
        self.scopes = kwargs.get('scopes', None)
        self.evaluation_frequency = kwargs['evaluation_frequency']
        self.window_size = kwargs['window_size']
        self.target_resource_type = kwargs.get('target_resource_type', None)
        self.target_resource_region = kwargs.get('target_resource_region', None)
        self.criteria = kwargs['criteria']
        self.auto_mitigate = kwargs.get('auto_mitigate', None)
        self.actions = kwargs.get('actions', None)
        self.last_updated_time = None


class MetricAlertResourceCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :param value: the values for the alert rule resources.
    :type value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricAlertResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class MetricAlertResourcePatch(msrest.serialization.Model):
    """The metric alert resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: the description of the metric alert that will be included in the alert
     email.
    :type description: str
    :param severity: Alert severity {0, 1, 2, 3, 4}.
    :type severity: int
    :param enabled: the flag that indicates whether the metric alert is enabled.
    :type enabled: bool
    :param scopes: the list of resource id's that this metric alert is scoped to.
    :type scopes: list[str]
    :param evaluation_frequency: how often the metric alert is evaluated represented in ISO 8601
     duration format.
    :type evaluation_frequency: ~datetime.timedelta
    :param window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold.
    :type window_size: ~datetime.timedelta
    :param target_resource_type: the resource type of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :type target_resource_type: str
    :param target_resource_region: the region of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :type target_resource_region: str
    :param criteria: defines the specific alert criteria information.
    :type criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
    :param auto_mitigate: the flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :type auto_mitigate: bool
    :param actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :type actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'scopes': {'key': 'properties.scopes', 'type': '[str]'},
        'evaluation_frequency': {'key': 'properties.evaluationFrequency', 'type': 'duration'},
        'window_size': {'key': 'properties.windowSize', 'type': 'duration'},
        'target_resource_type': {'key': 'properties.targetResourceType', 'type': 'str'},
        'target_resource_region': {'key': 'properties.targetResourceRegion', 'type': 'str'},
        'criteria': {'key': 'properties.criteria', 'type': 'MetricAlertCriteria'},
        'auto_mitigate': {'key': 'properties.autoMitigate', 'type': 'bool'},
        'actions': {'key': 'properties.actions', 'type': '[MetricAlertAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.severity = kwargs.get('severity', None)
        self.enabled = kwargs.get('enabled', None)
        self.scopes = kwargs.get('scopes', None)
        self.evaluation_frequency = kwargs.get('evaluation_frequency', None)
        self.window_size = kwargs.get('window_size', None)
        self.target_resource_type = kwargs.get('target_resource_type', None)
        self.target_resource_region = kwargs.get('target_resource_region', None)
        self.criteria = kwargs.get('criteria', None)
        self.auto_mitigate = kwargs.get('auto_mitigate', None)
        self.actions = kwargs.get('actions', None)
        self.last_updated_time = None


class MetricAlertSingleResourceMultipleMetricCriteria(MetricAlertCriteria):
    """Specifies the metric alert criteria for a single resource that has multiple metric criteria.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param odata_type: Required. specifies the type of the alert criteria.Constant filled by
     server.  Possible values include:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :type odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :param all_of: The list of metric criteria for this 'all of' operation.
    :type all_of: list[~$(python-base-namespace).v2018_03_01.models.MetricCriteria]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'all_of': {'key': 'allOf', 'type': '[MetricCriteria]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertSingleResourceMultipleMetricCriteria, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'  # type: str
        self.all_of = kwargs.get('all_of', None)


class MetricAlertStatus(msrest.serialization.Model):
    """An alert status.

    :param name: The status name.
    :type name: str
    :param id: The alert rule arm id.
    :type id: str
    :param type: The extended resource type name.
    :type type: str
    :param properties: The alert status properties of the metric alert status.
    :type properties: ~$(python-base-namespace).v2018_03_01.models.MetricAlertStatusProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricAlertStatusProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertStatus, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.properties = kwargs.get('properties', None)


class MetricAlertStatusCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :param value: the values for the alert rule resources.
    :type value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricAlertStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertStatusCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class MetricAlertStatusProperties(msrest.serialization.Model):
    """An alert status properties.

    :param dimensions: An object describing the type of the dimensions.
    :type dimensions: dict[str, str]
    :param status: status value.
    :type status: str
    :param timestamp: UTC time when the status was checked.
    :type timestamp: ~datetime.datetime
    """

    _attribute_map = {
        'dimensions': {'key': 'dimensions', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertStatusProperties, self).__init__(**kwargs)
        self.dimensions = kwargs.get('dimensions', None)
        self.status = kwargs.get('status', None)
        self.timestamp = kwargs.get('timestamp', None)


class MetricCriteria(MultiMetricCriteria):
    """Criterion to filter metrics.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param criterion_type: Required. Specifies the type of threshold criteria.Constant filled by
     server.  Possible values include: "StaticThresholdCriterion", "DynamicThresholdCriterion".
    :type criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :param name: Required. Name of the criteria.
    :type name: str
    :param metric_name: Required. Name of the metric.
    :type metric_name: str
    :param metric_namespace: Namespace of the metric.
    :type metric_namespace: str
    :param time_aggregation: Required. the criteria time aggregation types. Possible values
     include: "Average", "Count", "Minimum", "Maximum", "Total".
    :type time_aggregation: str or ~$(python-base-namespace).v2018_03_01.models.AggregationType
    :param dimensions: List of dimension conditions.
    :type dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :param skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :type skip_metric_validation: bool
    :param operator: Required. the criteria operator. Possible values include: "Equals",
     "NotEquals", "GreaterThan", "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
    :type operator: str or ~$(python-base-namespace).v2018_03_01.models.Operator
    :param threshold: Required. the criteria threshold value that activates the alert.
    :type threshold: float
    """

    _validation = {
        'criterion_type': {'required': True},
        'name': {'required': True},
        'metric_name': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'criterion_type': {'key': 'criterionType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'skip_metric_validation': {'key': 'skipMetricValidation', 'type': 'bool'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricCriteria, self).__init__(**kwargs)
        self.criterion_type = 'StaticThresholdCriterion'  # type: str
        self.operator = kwargs['operator']
        self.threshold = kwargs['threshold']


class MetricDimension(msrest.serialization.Model):
    """Specifies a metric dimension.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the dimension.
    :type name: str
    :param operator: Required. the dimension operator. Only 'Include' and 'Exclude' are supported.
    :type operator: str
    :param values: Required. list of dimension values.
    :type values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.operator = kwargs['operator']
        self.values = kwargs['values']


class SmsReceiver(msrest.serialization.Model):
    """An SMS receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SMS receiver. Names must be unique across all receivers
     within an action group.
    :type name: str
    :param country_code: Required. The country code of the SMS receiver.
    :type country_code: str
    :param phone_number: Required. The phone number of the SMS receiver.
    :type phone_number: str
    :ivar status: The status of the receiver. Possible values include: "NotSpecified", "Enabled",
     "Disabled".
    :vartype status: str or ~$(python-base-namespace).v2018_03_01.models.ReceiverStatus
    """

    _validation = {
        'name': {'required': True},
        'country_code': {'required': True},
        'phone_number': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'country_code': {'key': 'countryCode', 'type': 'str'},
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmsReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.country_code = kwargs['country_code']
        self.phone_number = kwargs['phone_number']
        self.status = None


class VoiceReceiver(msrest.serialization.Model):
    """A voice receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the voice receiver. Names must be unique across all
     receivers within an action group.
    :type name: str
    :param country_code: Required. The country code of the voice receiver.
    :type country_code: str
    :param phone_number: Required. The phone number of the voice receiver.
    :type phone_number: str
    """

    _validation = {
        'name': {'required': True},
        'country_code': {'required': True},
        'phone_number': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'country_code': {'key': 'countryCode', 'type': 'str'},
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VoiceReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.country_code = kwargs['country_code']
        self.phone_number = kwargs['phone_number']


class WebhookReceiver(msrest.serialization.Model):
    """A webhook receiver.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the webhook receiver. Names must be unique across all
     receivers within an action group.
    :type name: str
    :param service_uri: Required. The URI where webhooks should be sent.
    :type service_uri: str
    """

    _validation = {
        'name': {'required': True},
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookReceiver, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.service_uri = kwargs['service_uri']


class WebtestLocationAvailabilityCriteria(MetricAlertCriteria):
    """Specifies the metric alert rule criteria for a web test resource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param odata_type: Required. specifies the type of the alert criteria.Constant filled by
     server.  Possible values include:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :type odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :param web_test_id: Required. The Application Insights web test Id.
    :type web_test_id: str
    :param component_id: Required. The Application Insights resource Id.
    :type component_id: str
    :param failed_location_count: Required. The number of failed locations.
    :type failed_location_count: float
    """

    _validation = {
        'odata_type': {'required': True},
        'web_test_id': {'required': True},
        'component_id': {'required': True},
        'failed_location_count': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'web_test_id': {'key': 'webTestId', 'type': 'str'},
        'component_id': {'key': 'componentId', 'type': 'str'},
        'failed_location_count': {'key': 'failedLocationCount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebtestLocationAvailabilityCriteria, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'  # type: str
        self.web_test_id = kwargs['web_test_id']
        self.component_id = kwargs['component_id']
        self.failed_location_count = kwargs['failed_location_count']
