# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Iterable, Optional, TypeVar
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(
    report_name: str,
    *,
    skip_token: Optional[str] = None,
    top: Optional[int] = None,
    select: Optional[str] = None,
    report_creator_tenant_id: Optional[str] = None,
    offer_guid: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-11-16-preview")
    )  # type: Literal["2022-11-16-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots")
    path_format_arguments = {
        "reportName": _SERIALIZER.url("report_name", report_name, "str", pattern=r"^[-a-zA-Z0-9_]+$"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", maximum=100, minimum=1)
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str", min_length=1)
    if report_creator_tenant_id is not None:
        _params["reportCreatorTenantId"] = _SERIALIZER.query(
            "report_creator_tenant_id", report_creator_tenant_id, "str", min_length=1
        )
    if offer_guid is not None:
        _params["offerGuid"] = _SERIALIZER.query("offer_guid", offer_guid, "str", min_length=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class SnapshotsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.appcomplianceautomation.AppComplianceAutomationToolForMicrosoft365`'s
        :attr:`snapshots` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        report_name: str,
        skip_token: Optional[str] = None,
        top: Optional[int] = None,
        select: Optional[str] = None,
        report_creator_tenant_id: Optional[str] = None,
        offer_guid: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.SnapshotResource"]:
        """Get the AppComplianceAutomation snapshot list.

        :param report_name: Report Name. Required.
        :type report_name: str
        :param skip_token: Skip over when retrieving results. Default value is None.
        :type skip_token: str
        :param top: Number of elements to return when retrieving results. Default value is None.
        :type top: int
        :param select: OData Select statement. Limits the properties on each entry to just those
         requested, e.g. ?$select=reportName,id. Default value is None.
        :type select: str
        :param report_creator_tenant_id: The tenant id of the report creator. Default value is None.
        :type report_creator_tenant_id: str
        :param offer_guid: The offerGuid which mapping to the reports. Default value is None.
        :type offer_guid: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SnapshotResource or the result of cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.appcomplianceautomation.models.SnapshotResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-11-16-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SnapshotResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    report_name=report_name,
                    skip_token=skip_token,
                    top=top,
                    select=select,
                    report_creator_tenant_id=report_creator_tenant_id,
                    offer_guid=offer_guid,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("SnapshotResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list.metadata = {"url": "/providers/Microsoft.AppComplianceAutomation/reports/{reportName}/snapshots"}  # type: ignore
