# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ApplicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of application being monitored."""

    WEB = "web"
    OTHER = "other"


class CategoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CategoryType."""

    WORKBOOK = "workbook"
    TSG = "TSG"
    PERFORMANCE = "performance"
    RETENTION = "retention"


class FavoriteSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """FavoriteSourceType."""

    RETENTION = "retention"
    NOTEBOOK = "notebook"
    SESSIONS = "sessions"
    EVENTS = "events"
    USERFLOWS = "userflows"
    FUNNEL = "funnel"
    IMPACT = "impact"
    SEGMENTATION = "segmentation"


class FavoriteType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum indicating if this favorite definition is owned by a specific user or is shared between
    all users with access to the Application Insights component.
    """

    SHARED = "shared"
    USER = "user"


class FlowType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Used by the Application Insights system to determine what kind of flow this component was
    created by. This is to be set to 'Bluefield' when creating/updating a component via the REST
    API.
    """

    BLUEFIELD = "Bluefield"


class IngestionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the flow of the ingestion."""

    APPLICATION_INSIGHTS = "ApplicationInsights"
    APPLICATION_INSIGHTS_WITH_DIAGNOSTIC_SETTINGS = "ApplicationInsightsWithDiagnosticSettings"
    LOG_ANALYTICS = "LogAnalytics"


class ItemScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum indicating if this item definition is owned by a specific user or is shared between all
    users with access to the Application Insights component.
    """

    SHARED = "shared"
    USER = "user"


class ItemScopePath(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ItemScopePath."""

    ANALYTICS_ITEMS = "analyticsItems"
    MYANALYTICS_ITEMS = "myanalyticsItems"


class ItemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum indicating the type of the Analytics item."""

    NONE = "none"
    QUERY = "query"
    RECENT = "recent"
    FUNCTION = "function"


class ItemTypeParameter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ItemTypeParameter."""

    NONE = "none"
    QUERY = "query"
    FUNCTION = "function"
    FOLDER = "folder"
    RECENT = "recent"


class PurgeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the operation represented by the requested Id."""

    PENDING = "pending"
    COMPLETED = "completed"


class RequestSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes what tool created this Application Insights component. Customers using this API
    should set this to the default 'rest'.
    """

    REST = "rest"


class SharedTypeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of workbook. Choices are user and shared."""

    USER = "user"
    SHARED = "shared"


class WebTestKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of web test that this web test watches. Choices are ping and multistep."""

    PING = "ping"
    MULTISTEP = "multistep"
