# coding: utf-8

"""
    CLOUD API

     IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class DatacenterPropertiesPut(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'description': 'str',

        'location': 'str',

        'version': 'int',

        'features': 'list[str]',

        'sec_auth_protection': 'bool',

        'cpu_architecture': 'list[CpuArchitectureProperties]',

        'default_security_group_id': 'str',

        'create_default_security_group': 'bool',
    }

    attribute_map = {

        'name': 'name',

        'description': 'description',

        'location': 'location',

        'version': 'version',

        'features': 'features',

        'sec_auth_protection': 'secAuthProtection',

        'cpu_architecture': 'cpuArchitecture',

        'default_security_group_id': 'defaultSecurityGroupId',

        'create_default_security_group': 'createDefaultSecurityGroup',
    }

    def __init__(self, name=None, description=None, location=None, version=None, features=None, sec_auth_protection=None, cpu_architecture=None, default_security_group_id=None, create_default_security_group=None, local_vars_configuration=None):  # noqa: E501
        """DatacenterPropertiesPut - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._location = None
        self._version = None
        self._features = None
        self._sec_auth_protection = None
        self._cpu_architecture = None
        self._default_security_group_id = None
        self._create_default_security_group = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if location is not None:
            self.location = location
        if version is not None:
            self.version = version
        if features is not None:
            self.features = features
        if sec_auth_protection is not None:
            self.sec_auth_protection = sec_auth_protection
        if cpu_architecture is not None:
            self.cpu_architecture = cpu_architecture
        if default_security_group_id is not None:
            self.default_security_group_id = default_security_group_id
        if create_default_security_group is not None:
            self.create_default_security_group = create_default_security_group


    @property
    def name(self):
        """Gets the name of this DatacenterPropertiesPut.  # noqa: E501

        The name of the  resource.  # noqa: E501

        :return: The name of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatacenterPropertiesPut.

        The name of the  resource.  # noqa: E501

        :param name: The name of this DatacenterPropertiesPut.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this DatacenterPropertiesPut.  # noqa: E501

        A description for the datacenter, such as staging, production.  # noqa: E501

        :return: The description of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DatacenterPropertiesPut.

        A description for the datacenter, such as staging, production.  # noqa: E501

        :param description: The description of this DatacenterPropertiesPut.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def location(self):
        """Gets the location of this DatacenterPropertiesPut.  # noqa: E501

        The physical location where the datacenter will be created. This will be where all of your servers live. Property cannot be modified after datacenter creation (disallowed in update requests).  # noqa: E501

        :return: The location of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this DatacenterPropertiesPut.

        The physical location where the datacenter will be created. This will be where all of your servers live. Property cannot be modified after datacenter creation (disallowed in update requests).  # noqa: E501

        :param location: The location of this DatacenterPropertiesPut.  # noqa: E501
        :type location: str
        """

        self._location = location

    @property
    def version(self):
        """Gets the version of this DatacenterPropertiesPut.  # noqa: E501

        The version of the data center; incremented with every change.  # noqa: E501

        :return: The version of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DatacenterPropertiesPut.

        The version of the data center; incremented with every change.  # noqa: E501

        :param version: The version of this DatacenterPropertiesPut.  # noqa: E501
        :type version: int
        """

        self._version = version

    @property
    def features(self):
        """Gets the features of this DatacenterPropertiesPut.  # noqa: E501

        List of features supported by the location where this data center is provisioned.  # noqa: E501

        :return: The features of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: list[str]
        """
        return self._features

    @features.setter
    def features(self, features):
        """Sets the features of this DatacenterPropertiesPut.

        List of features supported by the location where this data center is provisioned.  # noqa: E501

        :param features: The features of this DatacenterPropertiesPut.  # noqa: E501
        :type features: list[str]
        """

        self._features = features

    @property
    def sec_auth_protection(self):
        """Gets the sec_auth_protection of this DatacenterPropertiesPut.  # noqa: E501

        Boolean value representing if the data center requires extra protection, such as two-step verification.  # noqa: E501

        :return: The sec_auth_protection of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._sec_auth_protection

    @sec_auth_protection.setter
    def sec_auth_protection(self, sec_auth_protection):
        """Sets the sec_auth_protection of this DatacenterPropertiesPut.

        Boolean value representing if the data center requires extra protection, such as two-step verification.  # noqa: E501

        :param sec_auth_protection: The sec_auth_protection of this DatacenterPropertiesPut.  # noqa: E501
        :type sec_auth_protection: bool
        """

        self._sec_auth_protection = sec_auth_protection

    @property
    def cpu_architecture(self):
        """Gets the cpu_architecture of this DatacenterPropertiesPut.  # noqa: E501

        Array of features and CPU families available in a location  # noqa: E501

        :return: The cpu_architecture of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: list[CpuArchitectureProperties]
        """
        return self._cpu_architecture

    @cpu_architecture.setter
    def cpu_architecture(self, cpu_architecture):
        """Sets the cpu_architecture of this DatacenterPropertiesPut.

        Array of features and CPU families available in a location  # noqa: E501

        :param cpu_architecture: The cpu_architecture of this DatacenterPropertiesPut.  # noqa: E501
        :type cpu_architecture: list[CpuArchitectureProperties]
        """

        self._cpu_architecture = cpu_architecture

    @property
    def default_security_group_id(self):
        """Gets the default_security_group_id of this DatacenterPropertiesPut.  # noqa: E501

        This will become the default security group for the datacenter, replacing the old one if already exists.  This security group must already exists prior to this request. Provide this field only if the `createDefaultSecurityGroup` field is missing. You cannot provide both of them  # noqa: E501

        :return: The default_security_group_id of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: str
        """
        return self._default_security_group_id

    @default_security_group_id.setter
    def default_security_group_id(self, default_security_group_id):
        """Sets the default_security_group_id of this DatacenterPropertiesPut.

        This will become the default security group for the datacenter, replacing the old one if already exists.  This security group must already exists prior to this request. Provide this field only if the `createDefaultSecurityGroup` field is missing. You cannot provide both of them  # noqa: E501

        :param default_security_group_id: The default_security_group_id of this DatacenterPropertiesPut.  # noqa: E501
        :type default_security_group_id: str
        """

        self._default_security_group_id = default_security_group_id

    @property
    def create_default_security_group(self):
        """Gets the create_default_security_group of this DatacenterPropertiesPut.  # noqa: E501

        If this field is set on true and this datacenter has no default security group then a default security group, with predefined rules, will be created for this datacenter. Default value is false.  Provide this field only if the `defaultSecurityGroupId` field is missing. You cannot provide both of them  # noqa: E501

        :return: The create_default_security_group of this DatacenterPropertiesPut.  # noqa: E501
        :rtype: bool
        """
        return self._create_default_security_group

    @create_default_security_group.setter
    def create_default_security_group(self, create_default_security_group):
        """Sets the create_default_security_group of this DatacenterPropertiesPut.

        If this field is set on true and this datacenter has no default security group then a default security group, with predefined rules, will be created for this datacenter. Default value is false.  Provide this field only if the `defaultSecurityGroupId` field is missing. You cannot provide both of them  # noqa: E501

        :param create_default_security_group: The create_default_security_group of this DatacenterPropertiesPut.  # noqa: E501
        :type create_default_security_group: bool
        """

        self._create_default_security_group = create_default_security_group
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatacenterPropertiesPut):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatacenterPropertiesPut):
            return True

        return self.to_dict() != other.to_dict()
