% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch64.R
\name{bit64S3}
\alias{bit64S3}
\alias{:}
\alias{:.default}
\alias{:.integer64}
\alias{is.double}
\alias{is.double.default}
\alias{is.double.integer64}
\alias{match}
\alias{match.default}
\alias{\%in\%}
\alias{\%in\%.default}
\alias{rank}
\alias{rank.default}
\alias{order}
\alias{order.default}
\alias{mtfrm.integer64}
\title{Turning base R functions into S3 generics for bit64}
\usage{
from:to
is.double(x)
match(x, table, ...)
x \%in\% table
rank(x, ...)
order(...)

\method{is.double}{default}(x)

\method{is.double}{integer64}(x)

\method{mtfrm}{integer64}(x)

\method{match}{default}(x, table, ...)

\method{\%in\%}{default}(x, table)

\method{rank}{default}(x, ...)

\method{order}{default}(...)
}
\arguments{
\item{x}{integer64 vector: the values to be matched, optionally carrying a
cache created with \code{\link[=hashcache]{hashcache()}}}

\item{table}{integer64 vector: the values to be matched against, optionally
carrying a cache created with \code{\link[=hashcache]{hashcache()}} or \code{\link[=sortordercache]{sortordercache()}}}

\item{...}{ignored}

\item{from}{scalar denoting first element of sequence}

\item{to}{scalar denoting last element of sequence}
}
\value{
\code{\link[=invisible]{invisible()}}
}
\description{
Turn those base functions S3 generic which are used in bit64
}
\details{
The following functions are turned into S3 generics in order to dispatch
methods for \code{\link[=integer64]{integer64()}}:
\itemize{
\item \code{\link{:}}
\item \code{\link[=is.double]{is.double()}}
\item \code{\link[=match]{match()}}
\item \code{\link{\%in\%}}
\item \code{\link[=rank]{rank()}}
\item \code{\link[=order]{order()}}
}
}
\note{
\itemize{
\item \code{\link[=is.double]{is.double()}} returns \code{FALSE} for \code{\link{integer64}}
\item \code{\link{:}} currently only dispatches at its first argument, thus
\code{as.integer64(1):9} works but \code{1:as.integer64(9)} doesn't
\item \code{\link[=match]{match()}} currently only dispatches at its first argument and expects
its second argument also to be integer64, otherwise throws an error.
Beware of something like \code{match(2, as.integer64(0:3))}
\item \code{\link{\%in\%}} currently only dispatches at its first argument and expects
its second argument also to be integer64, otherwise throws an error.
Beware of something like \code{2 \%in\% as.integer64(0:3)}
\item \code{\link[=order]{order()}} currently only orders a single argument, trying more than
one raises an error
}
}
\examples{
 is.double(as.integer64(1))
    as.integer64(1):9
 match(as.integer64(2), as.integer64(0:3))
 as.integer64(2) \%in\% as.integer64(0:3)

 unique(as.integer64(c(1,1,2)))
 rank(as.integer64(c(1,1,2)))


 order(as.integer64(c(1,NA,2)))
}
\seealso{
\code{\link[=bit64]{bit64()}}, \link{S3}
}
\keyword{methods}
