% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-atomic.R
\name{chk_atomic}
\alias{chk_atomic}
\alias{vld_atomic}
\title{Check Atomic}
\usage{
chk_atomic(x, x_name = NULL)

vld_atomic(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if atomic using

\code{is.atomic(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_atomic()}: Validate Atomic

}}
\examples{
# chk_atomic
chk_atomic(1)
try(chk_atomic(list(1)))
# vld_atomic
vld_atomic(1)
vld_atomic(matrix(1:3))
vld_atomic(character(0))
vld_atomic(list(1))
vld_atomic(NULL)
}
\seealso{
\code{\link[=is.atomic]{is.atomic()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_structure_checkers: 
\code{\link{chk_array}()},
\code{\link{chk_list}()},
\code{\link{chk_matrix}()},
\code{\link{chk_vector}()}
}
\concept{data_structure_checkers}
