% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-raw.R
\name{chk_raw}
\alias{chk_raw}
\alias{vld_raw}
\title{Check Raw}
\usage{
chk_raw(x, x_name = NULL)

vld_raw(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if raw using

\code{is.raw(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_raw()}: Validate Raw

}}
\examples{
# chk_raw
chk_raw(as.raw(1))
try(chk_raw(1))
# vld_raw
vld_raw(as.raw(1))
vld_raw(raw(0))
vld_raw(1)
vld_raw(TRUE)
}
\seealso{
\code{\link[=is.raw]{is.raw()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_type_checkers: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_complex}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_logical}()},
\code{\link{chk_numeric}()}
}
\concept{data_type_checkers}
