% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{basis}
\alias{basis}
\alias{basis_normal}
\alias{basis_lognormal}
\alias{basis_weibull}
\alias{basis_pooled_cv}
\alias{basis_pooled_sd}
\alias{basis_hk_ext}
\alias{basis_nonpara_large_sample}
\alias{basis_anova}
\title{Calculate basis values}
\usage{
basis_normal(
  data = NULL,
  x,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  override = c()
)

basis_lognormal(
  data = NULL,
  x,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  override = c()
)

basis_weibull(
  data = NULL,
  x,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  override = c()
)

basis_pooled_cv(
  data = NULL,
  x,
  groups,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  modcv = FALSE,
  override = c()
)

basis_pooled_sd(
  data = NULL,
  x,
  groups,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  modcv = FALSE,
  override = c()
)

basis_hk_ext(
  data = NULL,
  x,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  method = c("optimum-order", "woodward-frawley"),
  override = c()
)

basis_nonpara_large_sample(
  data = NULL,
  x,
  batch = NULL,
  p = 0.9,
  conf = 0.95,
  override = c()
)

basis_anova(data = NULL, x, groups, p = 0.9, conf = 0.95, override = c())
}
\arguments{
\item{data}{a data.frame}

\item{x}{the variable in the data.frame for which to find the basis value}

\item{batch}{the variable in the data.frame that contains the batches.}

\item{p}{the content of the tolerance bound. Should be 0.90 for B-Basis
and 0.99 for A-Basis}

\item{conf}{confidence level Should be 0.95 for both A- and B-Basis}

\item{override}{a list of names of diagnostic tests to override,
if desired. Specifying "all" will override all diagnostic
tests applicable to the current method.}

\item{groups}{the variable in the data.frame representing the groups}

\item{modcv}{a logical value indicating whether the modified CV approach
should be used. Only applicable to pooling methods.}

\item{method}{the method for Hanson--Koopmans nonparametric basis values.
should be "optimum-order" for B-Basis and "woodward-frawley"
for A-Basis.}
}
\value{
an object of class \code{basis}
This object has the following fields:
\itemize{
\item \code{call} the expression used to call this function
\item \code{distribution} the distribution used (normal, etc.)
\item \code{p} the value of \eqn{p} supplied
\item \code{conf} the value of \eqn{conf} supplied
\item \code{modcv} a logical value indicating whether the modified
CV approach was used. Only applicable to pooling methods.
\item \code{data} a copy of the data used in the calculation
\item \code{groups} a copy of the groups variable.
Only used for pooling and ANOVA methods.
\item \code{batch} a copy of the batch data used for diagnostic tests
\item \code{modcv_transformed_data} the data after the modified CV transformation
\item \code{override} a vector of the names of diagnostic tests that
were overridden. \code{NULL} if none were overridden
\item \code{diagnostic_results} a named character vector containing the
results of all the diagnostic tests. See the Details section for
additional information
\item \code{diagnostic_failures} a vector containing any diagnostic tests
that produced failures
\item \code{n} the number of observations
\item \code{r} the number of groups, if a pooling method was used.
Otherwise it is NULL.
\item \code{basis} the basis value computed. This is a number
except when pooling methods are used, in which case it is a data.frame.
}
}
\description{
Calculate the basis value for a given data set. There are various functions
to calculate the basis values for different distributions.
The basis value is the lower one-sided tolerance bound of a certain
proportion of the population. For more information on tolerance bounds,
see Meeker, et. al. (2017).
For B-Basis, set the content of tolerance bound to \eqn{p=0.90} and
the confidence level to \eqn{conf=0.95}; for A-Basis, set \eqn{p=0.99} and
\eqn{conf=0.95}. While other tolerance bound
contents and confidence levels may be computed, they are infrequently
needed in practice.

These functions also perform some automated diagnostic
tests of the data prior to calculating the basis values. These diagnostic
tests can be overridden if needed.
}
\details{
\code{data} is an optional argument. If \code{data} is given, it should
be a
\code{data.frame} (or similar object). When \code{data} is specified, the
value of \code{x} is expected to be a variable within \code{data}. If
\code{data} is not specified, \code{x} must be a vector.

When \code{modcv=TRUE} is set, which is only applicable to the
pooling methods,
the data is first modified according to the modified coefficient
of variation (CV)
rules. This modified data is then used when both calculating the
basis values and
also when performing the diagnostic tests. The modified CV approach
is a way of
adding extra variance to datasets with unexpectedly low variance.

\code{basis_normal} calculate the basis value by subtracting \eqn{k} times
the standard deviation from the mean. \eqn{k} is given by
the function \code{\link[=k_factor_normal]{k_factor_normal()}}. The equations in
Krishnamoorthy and Mathew (2008) are used.
\code{basis_normal} also
performs a diagnostic test for outliers (using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for normality (using
\code{\link[=anderson_darling_normal]{anderson_darling_normal()}}).
If the argument \code{batch} is given, this function also performs
a diagnostic test for outliers within
each batch (using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for between batch variability (using
\code{\link[=ad_ksample]{ad_ksample()}}). The argument \code{batch} is only used
for these diagnostic tests.

\code{basis_lognormal} calculates the basis value in the same way
that \code{basis_normal} does, except that the natural logarithm of the
data is taken.

\code{basis_lognormal} function also performs
a diagnostic test for outliers (using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for normality (using
\code{\link[=anderson_darling_lognormal]{anderson_darling_lognormal()}}).
If the argument \code{batch} is given, this function also performs
a diagnostic test for outliers within
each batch (using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for between batch variability (using
\code{\link[=ad_ksample]{ad_ksample()}}). The argument \code{batch} is only used
for these diagnostic tests.

\code{basis_weibull} calculates the basis value for data distributed
according to a Weibull distribution. The confidence level for the
content requested is calculated using the conditional method, as
described in Lawless (1982) Section 4.1.2b. This has good agreement
with tables published in CMH-17-1G. Results differ between this function
and STAT17 by approximately 0.5\\%.

\code{basis_weibull} function also performs
a diagnostic test for outliers (using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for normality (using
\code{\link[=anderson_darling_weibull]{anderson_darling_weibull()}}).
If the argument \code{batch} is given, this function also performs
a diagnostic test for outliers within
each batch (using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for between batch variability (using
\code{\link[=ad_ksample]{ad_ksample()}}). The argument \code{batch} is only used
for these diagnostic tests.

\code{basis_hk_ext} calculates the basis value using the Extended
Hanson--Koopmans method, as described in CMH-17-1G and Vangel (1994).
For nonparametric distributions, this function should be used for samples
up to n=28 for B-Basis and up to \eqn{n=299} for A-Basis.
This method uses a pair of order statistics to determine the basis value.
CMH-17-1G suggests that for A-Basis, the first and last order statistic
is used: this is called the "woodward-frawley" method in this package,
after the paper in which this approach is described (as referenced
by Vangel (1994)). For B-Basis, another approach is used whereby the
first and \code{j-th} order statistic are used to calculate the basis value.
In this approach, the \code{j-th} order statistic is selected to minimize
the difference between the tolerance limit (assuming that the order
statistics are equal to the expected values from a standard normal
distribution) and the population quantile for a standard normal
distribution. This approach is described in Vangel (1994). This second
method (for use when calculating B-Basis values) is called
"optimum-order" in this package.
The results of \code{basis_hk_ext} have been
verified against example results from the program STAT-17. Agreement is
typically well within 0.2\%.

Note that the implementation of \code{hk_ext_z_j_opt} changed after \code{cmstatr}
version 0.8.0. This function is used internally by \code{basis_hk_ext}
when \code{method = "optimum-order"}. This implementation change may mean
that basis values computed using this method may change slightly
after version 0.8.0. However, both implementations seem to be equally
valid. See the included vignette
for a discussion of the differences between the implementation before
and after version 0.8.0, as well as the factors given in CMH-17-1G.
To access this vignette, run: \code{vignette("hk_ext", package = "cmstatr")}

\code{basis_hk_ext} also performs
a diagnostic test for outliers (using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and performs a pair of tests that the sample size and method selected
follow the guidance described above.
If the argument \code{batch} is given, this function also performs
a diagnostic test for outliers within
each batch (using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for between batch variability (using
\code{\link[=ad_ksample]{ad_ksample()}}). The argument \code{batch} is only used
for these diagnostic tests.

\code{basis_nonpara_large_sample} calculates the basis value
using the large sample method described in CMH-17-1G. This method uses
a sum of binomials to determine the rank of the ordered statistic
corresponding with the desired tolerance limit (basis value). Results
of this function have been verified against results of the STAT-17
program.

\code{basis_nonpara_large_sample} also performs
a diagnostic test for outliers (using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and performs a test that the sample size is sufficiently large.
If the argument \code{batch} is given, this function also performs
a diagnostic test for outliers within
each batch (using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}})
and a diagnostic test for between batch variability (using
\code{\link[=ad_ksample]{ad_ksample()}}). The argument \code{batch} is only used
for these diagnostic tests.

\code{basis_anova} calculates basis values using the ANOVA method.
\code{x} specifies the data (normally strength) and \code{groups}
indicates the group corresponding to each observation. This method is
described in CMH-17-1G, but when the ratio of between-batch mean
square to the within-batch mean square is less than or equal
to one, the tolerance factor is calculated based on pooling the data
from all groups. This approach is recommended by Vangel (1992)
and by Krishnamoorthy and Mathew (2008), and is also implemented
by the software CMH17-STATS and STAT-17.
This function automatically performs a diagnostic
test for outliers within each group
(using \code{\link[=maximum_normed_residual]{maximum_normed_residual()}}) and a test for between
group variability (using \code{\link[=ad_ksample]{ad_ksample()}}) as well as checking
that the data contains at least 5 groups.
This function has been verified against the results of the STAT-17 program.

\code{basis_pooled_sd} calculates basis values by pooling the data from
several groups together. \code{x} specifies the data (normally strength)
and \code{group} indicates the group corresponding to each observation.
This method is described in CMH-17-1G and matches the pooling method
implemented in ASAP 2008.

\code{basis_pooled_cv} calculates basis values by pooling the data from
several groups together. \code{x} specifies the data (normally strength)
and \code{group} indicates the group corresponding to each observation.
This method is described in CMH-17-1G.

\code{basis_pooled_sd} and \code{basis_pooled_cv} both automatically
perform a number of diagnostic tests. Using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}}, they check that there are no
outliers within each group and batch (provided that \code{batch} is
specified). They check the between batch variability using
\code{\link[=ad_ksample]{ad_ksample()}}. They check that there are no outliers within
each group (pooling all batches) using
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}}. They check for the normality
of the pooled data using \code{\link[=anderson_darling_normal]{anderson_darling_normal()}}.
\code{basis_pooled_sd} checks for equality of variance of all
data using \code{\link[=levene_test]{levene_test()}} and \code{basis_pooled_cv}
checks for equality of variances of all data after transforming it
using \code{\link[=normalize_group_mean]{normalize_group_mean()}}
using \code{\link[=levene_test]{levene_test()}}.

The object returned by these functions includes the named vector
\code{diagnostic_results}. This contains all of the diagnostic tests
performed. The name of each element of the vector corresponds with the
name of the diagnostic test. The contents of each element will be
"P" if the diagnostic test passed, "F" if the diagnostic test failed,
"O" if the diagnostic test was overridden and \code{NA} if the
diagnostic test was skipped (typically because an optional
argument was not supplied).

The following list summarizes the diagnostic tests automatically
performed by each function.
\itemize{
\item \code{basis_normal}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_batch_variability}
\item \code{outliers}
\item \code{anderson_darling_normal}
}
\item \code{basis_lognormal}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_batch_variability}
\item \code{outliers}
\item \code{anderson_darling_lognormal}
}
\item \code{basis_weibull}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_batch_variability}
\item \code{outliers}
\item \code{anderson_darling_weibull}
}
\item \code{basis_pooled_cv}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_group_variability}
\item \code{outliers_within_group}
\item \code{pooled_data_normal}
\item \code{normalized_variance_equal}
}
\item \code{basis_pooled_sd}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_group_variability}
\item \code{outliers_within_group}
\item \code{pooled_data_normal}
\item \code{pooled_variance_equal}
}
\item \code{basis_hk_ext}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_batch_variability}
\item \code{outliers}
\item \code{sample_size}
}
\item \code{basis_nonpara_large_sample}
\itemize{
\item \code{outliers_within_batch}
\item \code{between_batch_variability}
\item \code{outliers}
\item \code{sample_size}
}
\item \code{basis_anova}
\itemize{
\item \code{outliers_within_group}
\item \code{equality_of_variance}
\item \code{number_of_groups}
}
}
}
\examples{
library(dplyr)

# A single-point basis value can be calculated as follows
# in this example, three failed diagnostic tests are
# overridden.

carbon.fabric \%>\%
  filter(test == "FC") \%>\%
  filter(condition == "RTD") \%>\%
  basis_normal(strength, batch,
               override = c("outliers",
                            "outliers_within_batch",
                            "anderson_darling_normal"))

## Call:
## basis_normal(data = ., x = strength, batch = batch,
##     override = c("outliers", "outliers_within_batch",
##    "anderson_darling_normal"))
##
## Distribution:  Normal 	( n = 18 )
## The following diagnostic tests were overridden:
##     `outliers`,
##     `outliers_within_batch`,
##     `anderson_darling_normal`
## B-Basis:   ( p = 0.9 , conf = 0.95 )
## 76.94656

# A set of pooled basis values can also be calculated
# using the pooled standard deviation method, as follows.
# In this example, one failed diagnostic test is overridden.
carbon.fabric \%>\%
  filter(test == "WT") \%>\%
  basis_pooled_sd(strength, condition, batch,
                  override = c("outliers_within_batch"))

## Call:
## basis_pooled_sd(data = ., x = strength, groups = condition,
##                 batch = batch, override = c("outliers_within_batch"))
##
## Distribution:  Normal - Pooled Standard Deviation 	( n = 54, r = 3 )
## The following diagnostic tests were overridden:
##     `outliers_within_batch`
## B-Basis:   ( p = 0.9 , conf = 0.95 )
## CTD  127.6914
## ETW  125.0698
## RTD  132.1457

}
\references{
J. F. Lawless, Statistical Models and Methods for Lifetime Data.
New York: John Wiley & Sons, 1982.

“Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,” SAE International,
CMH-17-1G, Mar. 2012.

M. Vangel, “One-Sided Nonparametric Tolerance Limits,”
Communications in Statistics - Simulation and Computation,
vol. 23, no. 4. pp. 1137–1154, 1994.

K. Krishnamoorthy and T. Mathew, Statistical Tolerance Regions: Theory,
Applications, and Computation. Hoboken: John Wiley & Sons, 2008.

W. Meeker, G. Hahn, and L. Escobar, Statistical Intervals: A Guide
for Practitioners and Researchers, Second Edition.
Hoboken: John Wiley & Sons, 2017.

M. Vangel, “New Methods for One-Sided Tolerance Limits for a One-Way
Balanced Random-Effects ANOVA Model,” Technometrics, vol. 34, no. 2.
Taylor & Francis, pp. 176–185, 1992.
}
\seealso{
\code{\link[=hk_ext_z_j_opt]{hk_ext_z_j_opt()}}

\code{\link[=k_factor_normal]{k_factor_normal()}}

\code{\link[=transform_mod_cv]{transform_mod_cv()}}

\code{\link[=maximum_normed_residual]{maximum_normed_residual()}}

\code{\link[=anderson_darling_normal]{anderson_darling_normal()}}

\code{\link[=anderson_darling_lognormal]{anderson_darling_lognormal()}}

\code{\link[=anderson_darling_weibull]{anderson_darling_weibull()}}

\code{\link[=ad_ksample]{ad_ksample()}}

\code{\link[=normalize_group_mean]{normalize_group_mean()}}
}
