% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greenhouse_gases.R
\docType{data}
\name{greenhouse_gases}
\alias{greenhouse_gases}
\title{Greenhouse gas concentrations over 2000 years}
\format{
An object of class \code{"data.frame"}.
}
\source{
MacFarling Meure et al. 2006 via \href{https://www.ncdc.noaa.gov/paleo-search/study/9959}{NOAA}.
}
\usage{
data(greenhouse_gases)
}
\description{
Concentrations of the three main greenhouse gases carbon dioxide, methane and nitrous oxide. Measurements are from the Law Dome Ice Core in Antarctica. Selected measurements are provided every 20 years from 1-2000 CE.
}
\details{
\itemize{
 \item year. Year (CE).
 \item gas. Gas being measured: carbon dioxide (`CO2`), methane (`CH4`) or nitrous oxide (`N2O`). 
 \item concentration. Gas concentration in ppm by volume (`CO2`) or ppb by volume (`CH4`, `N2O`).
}
}
\examples{
data(greenhouse_gases)
head(greenhouse_gases)
}
\keyword{datasets}
