% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{formattable.logical}
\alias{formattable.logical}
\title{Create a formattable logical vector}
\usage{
\method{formattable}{logical}(x, ..., formatter = "ifelse", preproc = NULL, postproc = NULL)
}
\arguments{
\item{x}{a logical vector.}

\item{...}{arguments to be passed to \code{formatter}.}

\item{formatter}{formatting function, \code{formattable::ifelse} in default.}

\item{preproc}{pre-processor function that prepares \code{x} for
formatting function.}

\item{postproc}{post-processor function that transforms formatted
output for printing.}
}
\value{
a \code{formattable} logical vector.
}
\description{
Create a formattable logical vector
}
\examples{
logi <- c(TRUE, TRUE, FALSE)
flogi <- formattable(logi, "yes", "no")
flogi
!flogi
any(flogi)
all(flogi)
}
