% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagonal.R
\name{geom_diagonal}
\alias{geom_diagonal}
\alias{stat_diagonal}
\alias{stat_diagonal2}
\alias{geom_diagonal2}
\alias{stat_diagonal0}
\alias{geom_diagonal0}
\title{Draw horizontal diagonals}
\usage{
stat_diagonal(mapping = NULL, data = NULL, geom = "path",
  position = "identity", n = 100, strength = 0.5, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, ...)

geom_diagonal(mapping = NULL, data = NULL, stat = "diagonal",
  position = "identity", n = 100, na.rm = FALSE, strength = 0.5,
  show.legend = NA, inherit.aes = TRUE, ...)

stat_diagonal2(mapping = NULL, data = NULL,
  geom = "path_interpolate", position = "identity", na.rm = FALSE,
  show.legend = NA, n = 100, strength = 0.5, inherit.aes = TRUE,
  ...)

geom_diagonal2(mapping = NULL, data = NULL, stat = "diagonal2",
  position = "identity", arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, n = 100,
  strength = 0.5, ...)

stat_diagonal0(mapping = NULL, data = NULL, geom = "bezier0",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, strength = 0.5, ...)

geom_diagonal0(mapping = NULL, data = NULL, stat = "diagonal0",
  position = "identity", arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  strength = 0.5, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{n}{The number of points to create for each segment}

\item{strength}{The proportion to move the control point along the x-axis
towards the other end of the bezier curve}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{lineend}{Line end style (round, butt, square).}
}
\description{
A diagonal is a bezier curve where the control points are moved
perpendicularly towards the center in either the x or y direction a fixed
amount. The versions provided here calculates horizontal diagonals meaning
that the x coordinate is moved to achieve the control point. The
\code{geom_diagonal()} and \code{stat_diagonal()} functions are simply helpers that
takes care of calculating the position of the control points and then
forwards the actual bezier calculations to \code{\link[=geom_bezier]{geom_bezier()}}.
}
\section{Aesthetics}{

geom_diagonal and geom_diagonal0 understand the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{xend}
\item \strong{yend}
\item color
\item size
\item linetype
\item alpha
\item lineend
}

geom_diagonal2 understand the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{group}
\item color
\item size
\item linetype
\item alpha
\item lineend
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The interpolated point coordinates}
\item{index}{The progression along the interpolation mapped between 0 and 1}
}
}

\examples{
data <- data.frame(
  x = rep(0, 10),
  y = 1:10,
  xend = 1:10,
  yend = 2:11
)

ggplot(data) +
  geom_diagonal(aes(x, y, xend = xend, yend = yend))

# The standard version provides an index to create gradients
ggplot(data) +
  geom_diagonal(aes(x, y, xend = xend, yend = yend, alpha = stat(index)))

# The 0 version uses bezierGrob under the hood for an approximation
ggplot(data) +
  geom_diagonal0(aes(x, y, xend = xend, yend = yend))

# The 2 version allows you to interpolate between endpoint aesthetics
data2 <- data.frame(
  x = c(data$x, data$xend),
  y = c(data$y, data$yend),
  group = rep(1:10, 2),
  colour = sample(letters[1:5], 20, TRUE)
)
ggplot(data2) +
  geom_diagonal2(aes(x, y, group = group, colour = colour))

# Use strength to control the steepness of the central region
ggplot(data, aes(x, y, xend = xend, yend = yend)) +
  geom_diagonal(strength = 0.75, colour = 'red') +
  geom_diagonal(strength = 0.25, colour = 'blue')

}
