% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_examples.R
\name{drive_examples}
\alias{drive_examples}
\alias{drive_examples_local}
\alias{drive_examples_remote}
\alias{drive_example_local}
\alias{drive_example_remote}
\title{Example files}
\usage{
drive_examples_local(matches)

drive_examples_remote(matches)

drive_example_local(matches)

drive_example_remote(matches)
}
\arguments{
\item{matches}{A regular expression that matches the name of the desired
example file(s). This argument is optional for the plural forms
(\code{drive_examples_local()} and \code{drive_examples_remote()}) and, if provided,
multiple matches are allowed. The single forms (\code{drive_example_local()} and
\code{drive_example_remote()}) require this argument and require that there is
exactly one match.}
}
\value{
\itemize{
\item For \code{drive_example_local()} and \code{drive_examples_local()}, one or more local
filepaths.
\item For \code{drive_example_remote()} and \code{drive_examples_remote()}, a \code{dribble}.
}
}
\description{
googledrive makes a variety of example files -- both local and remote --
available for use in examples and reprexes. These functions help you access
the example files. See \code{vignette("example-files", package = "googledrive")}
for more.
}
\examples{
drive_examples_local() \%>\% basename()
drive_examples_local("chicken") \%>\% basename()
drive_example_local("imdb")

\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
drive_examples_remote()
drive_examples_remote("chicken")
drive_example_remote("chicken_doc")
\dontshow{\}) # examplesIf}
}
