% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-status.r
\name{stop_for_status}
\alias{stop_for_status}
\alias{warn_for_status}
\alias{message_for_status}
\title{Take action on http error.}
\usage{
stop_for_status(x, task = NULL)

warn_for_status(x, task = NULL)

message_for_status(x, task = NULL)
}
\arguments{
\item{x}{a response, or numeric http code (or other object with
\code{status_code} method)}

\item{task}{The text of the message: either \code{NULL} or a
character vector. If non-\code{NULL}, the error message will finish with
"Failed to \code{task}".}
}
\value{
If request was successful, the response (invisibly). Otherwise,
raised a classed http error or warning, as generated by
\code{\link[=http_condition]{http_condition()}}
}
\description{
Converts http errors to R errors or warnings - these should always
be used whenever you're creating requests inside a function, so
that the user knows why a request has failed.
}
\examples{
x <- GET("http://httpbin.org/status/200")
stop_for_status(x) # nothing happens
warn_for_status(x)
message_for_status(x)

x <- GET("http://httpbin.org/status/300")
\dontrun{
stop_for_status(x)
}
warn_for_status(x)
message_for_status(x)

x <- GET("http://httpbin.org/status/404")
\dontrun{
stop_for_status(x)
}
warn_for_status(x)
message_for_status(x)

# You can provide more information with the task argument
warn_for_status(x, "download spreadsheet")
message_for_status(x, "download spreadsheet")
}
\seealso{
\code{\link[=http_status]{http_status()}} and
\code{http://en.wikipedia.org/wiki/Http_status_codes} for more information
on http status codes.

Other response methods: \code{\link{content}},
  \code{\link{http_error}}, \code{\link{http_status}},
  \code{\link{response}}
}
\concept{response methods}
