% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profvis.R
\name{profvis}
\alias{profvis}
\title{Profile an R expression and visualize profiling data}
\usage{
profvis(
  expr = NULL,
  interval = 0.01,
  prof_output = NULL,
  prof_input = NULL,
  width = NULL,
  height = NULL,
  split = c("h", "v"),
  torture = 0,
  simplify = TRUE,
  rerun = FALSE
)
}
\arguments{
\item{expr}{Expression to profile. Not compatible with \code{prof_input}.
The expression is repeatedly evaluated until `Rprof()` produces
an output. It can _be_ a quosure injected with [rlang::inject()] but
it cannot _contain_ injected quosures.}

\item{interval}{Interval for profiling samples, in seconds. Values less than
0.005 (5 ms) will probably not result in accurate timings}

\item{prof_output}{Name of an Rprof output file or directory in which to save
profiling data. If \code{NULL} (the default), a temporary file will be used
and automatically removed when the function exits. For a directory, a
random filename is used.}

\item{prof_input}{The path to an \code{\link{Rprof}} data file.  Not
compatible with \code{expr} or \code{prof_output}.}

\item{width}{Width of the htmlwidget.}

\item{height}{Height of the htmlwidget}

\item{split}{Direction of split. Either \code{"v"} (the default) for
vertical, or \code{"h"} for horizontal. This is the orientation of the
split bar.}

\item{torture}{Triggers garbage collection after every \code{torture} memory
  allocation call.

  Note that memory allocation is only approximate due to the nature of the
  sampling profiler and garbage collection: when garbage collection triggers,
  memory allocations will be attributed to different lines of code. Using
  \code{torture = steps} helps prevent this, by making R trigger garbage
  collection after every \code{torture} memory allocation step.}

\item{simplify}{Whether to simplify the profiles by removing
intervening frames caused by lazy evaluation. This only has an
effect on R 4.0. See the \code{filter.callframes} argument of
\code{\link{Rprof}()}.}

\item{rerun}{If `TRUE`, `Rprof()` is run again with `expr` until a
profile is actually produced. This is useful for the cases where
`expr` returns too quickly, before R had time to sample a
profile. Can also be a string containing a regexp to match
profiles. In this case, `profvis()` reruns `expr` until the
regexp matches the modal value of the profile stacks.}
}
\description{
This function will run an R expression with profiling, and then return an
htmlwidget for interactively exploring the profiling data.
}
\details{
An alternate way to use \code{profvis} is to separately capture the profiling
data to a file using \code{\link{Rprof}()}, and then pass the path to the
corresponding data file as the \code{prof_input} argument to
\code{profvis()}.
}
\examples{
# Only run these examples in interactive R sessions
if (interactive()) {

# Profile some code
profvis({
  dat <- data.frame(
    x = rnorm(5e4),
    y = rnorm(5e4)
  )

  plot(x ~ y, data = dat)
  m <- lm(x ~ y, data = dat)
  abline(m, col = "red")
})


# Save a profile to an HTML file
p <- profvis({
  dat <- data.frame(
    x = rnorm(5e4),
    y = rnorm(5e4)
  )

  plot(x ~ y, data = dat)
  m <- lm(x ~ y, data = dat)
  abline(m, col = "red")
})
htmlwidgets::saveWidget(p, "profile.html")

# Can open in browser from R
browseURL("profile.html")

}
}
\seealso{
\code{\link{print.profvis}} for printing options.

\code{\link{Rprof}} for more information about how the profiling
  data is collected.
}
