% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profvis.R
\name{profvis}
\alias{profvis}
\title{Profile an R expression and visualize profiling data}
\usage{
profvis(
  expr = NULL,
  interval = 0.01,
  prof_output = NULL,
  prof_input = NULL,
  timing = NULL,
  width = NULL,
  height = NULL,
  split = c("h", "v"),
  torture = 0,
  simplify = TRUE,
  rerun = FALSE
)
}
\arguments{
\item{expr}{Expression to profile. The expression will be turned into the
body of a zero-argument anonymous function which is then called repeatedly
as needed. This means that if you create variables inside of \code{expr} they
will not be available outside of it.

The expression is repeatedly evaluated until \code{Rprof()} produces
an output. It can \emph{be} a quosure injected with \code{\link[rlang:inject]{rlang::inject()}} but
it cannot \emph{contain} injected quosures.

Not compatible with \code{prof_input}.}

\item{interval}{Interval for profiling samples, in seconds. Values less than
0.005 (5 ms) will probably not result in accurate timings}

\item{prof_output}{Name of an Rprof output file or directory in which to save
profiling data. If \code{NULL} (the default), a temporary file will be used
and automatically removed when the function exits. For a directory, a
random filename is used.}

\item{prof_input}{The path to an \code{\link[=Rprof]{Rprof()}} data file.  Not
compatible with \code{expr} or \code{prof_output}.}

\item{timing}{The type of timing to use. Either \code{"elapsed"} (the
default) for wall clock time, or \code{"cpu"} for CPU time. Wall clock time
includes time spent waiting for other processes (e.g. waiting for a
web page to download) so is generally more useful.

If \code{NULL}, the default, will use elapsed time where possible, i.e.
on Windows or on R 4.4.0 or greater.}

\item{width}{Width of the htmlwidget.}

\item{height}{Height of the htmlwidget}

\item{split}{Orientation of the split bar: either \code{"h"} (the default) for
horizontal or \code{"v"} for vertical.}

\item{torture}{Triggers garbage collection after every \code{torture} memory
allocation call.

Note that memory allocation is only approximate due to the nature of the
sampling profiler and garbage collection: when garbage collection triggers,
memory allocations will be attributed to different lines of code. Using
\code{torture = steps} helps prevent this, by making R trigger garbage
collection after every \code{torture} memory allocation step.}

\item{simplify}{Whether to simplify the profiles by removing
intervening frames caused by lazy evaluation. Equivalent to the
\code{filter.callframes} argument to \code{\link[=Rprof]{Rprof()}}.}

\item{rerun}{If \code{TRUE}, \code{Rprof()} is run again with \code{expr} until a
profile is actually produced. This is useful for the cases where
\code{expr} returns too quickly, before R had time to sample a
profile. Can also be a string containing a regexp to match
profiles. In this case, \code{profvis()} reruns \code{expr} until the
regexp matches the modal value of the profile stacks.}
}
\description{
This function will run an R expression with profiling, and then return an
htmlwidget for interactively exploring the profiling data.
}
\details{
An alternate way to use \code{profvis} is to separately capture the profiling
data to a file using \code{\link[=Rprof]{Rprof()}}, and then pass the path to the
corresponding data file as the \code{prof_input} argument to
\code{profvis()}.
}
\examples{
# Only run these examples in interactive R sessions
if (interactive()) {

# Profile some code
profvis({
  dat <- data.frame(
    x = rnorm(5e4),
    y = rnorm(5e4)
  )

  plot(x ~ y, data = dat)
  m <- lm(x ~ y, data = dat)
  abline(m, col = "red")
})


# Save a profile to an HTML file
p <- profvis({
  dat <- data.frame(
    x = rnorm(5e4),
    y = rnorm(5e4)
  )

  plot(x ~ y, data = dat)
  m <- lm(x ~ y, data = dat)
  abline(m, col = "red")
})
htmlwidgets::saveWidget(p, "profile.html")

# Can open in browser from R
browseURL("profile.html")

}
}
\seealso{
\code{\link[=print.profvis]{print.profvis()}} for printing options.

\code{\link[=Rprof]{Rprof()}} for more information about how the profiling
data is collected.
}
