% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_multiarm_means.R
\name{getSimulationMultiArmMeans}
\alias{getSimulationMultiArmMeans}
\title{Get Simulation Multi-Arm Means}
\usage{
getSimulationMultiArmMeans(
  design = NULL,
  ...,
  activeArms = 3L,
  effectMatrix = NULL,
  typeOfShape = c("linear", "sigmoidEmax", "userDefined"),
  muMaxVector = seq(0, 1, 0.2),
  gED50 = NA_real_,
  slope = 1,
  intersectionTest = c("Dunnett", "Bonferroni", "Simes", "Sidak", "Hierarchical"),
  stDev = 1,
  adaptations = NA,
  typeOfSelection = c("best", "rBest", "epsilon", "all", "userDefined"),
  effectMeasure = c("effectEstimate", "testStatistic"),
  successCriterion = c("all", "atLeastOne"),
  epsilonValue = NA_real_,
  rValue = NA_real_,
  threshold = -Inf,
  plannedSubjects = NA_integer_,
  allocationRatioPlanned = NA_real_,
  minNumberOfSubjectsPerStage = NA_real_,
  maxNumberOfSubjectsPerStage = NA_real_,
  conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  stDevH1 = NA_real_,
  maxNumberOfIterations = 1000L,
  seed = NA_real_,
  calcSubjectsFunction = NULL,
  selectArmsFunction = NULL,
  showStatistics = FALSE
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower}, 
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{activeArms}{The number of active treatment arms to be compared with control, default is \code{3}.}

\item{effectMatrix}{Matrix of effect sizes with \code{activeArms} columns and number of rows 
reflecting the different situations to consider.}

\item{typeOfShape}{The shape of the dose-response relationship over the treatment groups. 
This can be either \code{"linear"}, \code{"sigmoidEmax"}, or \code{"userDefined"}.
If \code{"sigmoidEmax"} is selected, \code{"gED50"} and \code{"slope"} has to be entered 
to specify the ED50 and the slope of the sigmoid Emax model.
For \code{"linear"} and \code{"sigmoidEmax"}, \code{"muMaxVector"} specifies the range 
of effect sizes for the treatment group with highest response.    
If \code{"userDefined"} is selected, \code{"effectMatrix"} has to be entered.}

\item{muMaxVector}{Range of effect sizes for the treatment group with highest response
for \code{"linear"} and \code{"sigmoidEmax"} model, default is \code{seq(0, 1, 0.2)}.}

\item{gED50}{If \code{typeOfShape = "sigmoidEmax"} is selected, \code{"gED50"} has to be entered 
to specify the ED50 of the sigmoid Emax model.}

\item{slope}{If \code{typeOfShape = "sigmoidEmax"} is selected, \code{"slope"} can be entered 
to specify the slope of the sigmoid Emax model, default is 1.}

\item{intersectionTest}{Defines the multiple test for the intersection 
hypotheses in the closed system of hypotheses. 
Five options are available in multi-arm designs: \code{"Dunnett"}, \code{"Bonferroni"}, \code{"Simes"}, 
\code{"Sidak"}, and \code{"Hierarchical"}, default is \code{"Dunnett"}.}

\item{stDev}{The standard deviation under which the data is simulated, 
default is \code{1}. 
If \code{meanRatio = TRUE} is specified, \code{stDev} defines 
the coefficient of variation \code{sigma / mu2}.}

\item{adaptations}{A vector of length \code{kMax - 1} indicating whether or not an adaptation takes 
place at interim k, default is \code{rep(TRUE, kMax - 1)}.}

\item{typeOfSelection}{The way the treatment arms or populations are selected at interim. 
Five options are available: \code{"best"}, \code{"rbest"}, \code{"epsilon"}, \code{"all"}, and \code{"userDefined"},
default is \code{"best"}.\cr
For \code{"rbest"} (select the \code{rValue} best treatment arms/populations), the parameter \code{rValue} has to be specified,
for \code{"epsilon"} (select treatment arm/population not worse than epsilon compared to the best), the parameter
\code{epsilonValue} has to be specified.
If \code{"userDefined"} is selected, \code{"selectArmsFunction"} or \code{"selectPopulationsFunction"} has to be specified.}

\item{effectMeasure}{Criterion for treatment arm/population selection, either based on test statistic 
(\code{"testStatistic"}) or effect estimate (difference for means and rates or ratio for survival) (\code{"effectEstimate"}), 
default is \code{"effectEstimate"}.}

\item{successCriterion}{Defines when the study is stopped for efficacy at interim. 
Two options are available: \code{"all"} stops the trial 
if the efficacy criterion is fulfilled for all selected treatment arms/populations, 
\code{"atLeastOne"} stops if at least one of the selected treatment arms/populations is shown to be 
superior to control at interim, default is \code{"all"}.}

\item{epsilonValue}{For \code{typeOfSelection = "epsilon"} (select treatment arm / population not worse than 
epsilon compared to the best), the parameter \code{epsilonValue} has to be specified.}

\item{rValue}{For \code{typeOfSelection = "rbest"} (select the \code{rValue} best treatment arms / populations), 
the parameter \code{rValue} has to be specified.}

\item{threshold}{Selection criterion: treatment arm / population is selected only if \code{effectMeasure} 
exceeds \code{threshold}, default is \code{-Inf}. 
\code{threshold} can also be a vector of length \code{activeArms} referring to 
a separate threshold condition over the treatment arms.}

\item{plannedSubjects}{\code{plannedSubjects} is a vector of length \code{kMax} (the number of stages of the design) 
that determines the number of cumulated (overall) subjects when the interim stages are planned.
For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs, \code{plannedSubjects} refers to the number of subjects per selected active arm.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups 
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.}

\item{minNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
the vector \code{minNumberOfSubjectsPerStage} with length kMax determines the 
minimum number of subjects per stage (i.e., not cumulated), the first element 
is not taken into account. For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs \code{minNumberOfSubjectsPerStage} refers
to the minimum number of subjects per selected active arm.}

\item{maxNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
the vector \code{maxNumberOfSubjectsPerStage} with length kMax determines the maximum number 
of subjects per stage (i.e., not cumulated), the first element is not taken into account.
For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs \code{maxNumberOfSubjectsPerStage} refers
to the maximum number of subjects per selected active arm.}

\item{conditionalPower}{If \code{conditionalPower} together with \code{minNumberOfSubjectsPerStage} and 
\code{maxNumberOfSubjectsPerStage} (or \code{minNumberOfEventsPerStage} and \code{maxNumberOfEventsPerStage}
for survival designs) is specified, a sample size recalculation based on the specified conditional power is performed.
It is defined as the power for the subsequent stage given the current data. By default, 
the conditional power will be calculated under the observed effect size. Optionally, you can also specify \code{thetaH1} and
\code{stDevH1} (for simulating means), \code{pi1H1} and \code{pi2H1} (for simulating rates), or \code{thetaH1} (for simulating
hazard ratios) as parameters under which it is calculated and the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the alternative under which 
the conditional power or sample size recalculation calculation is performed.}

\item{stDevH1}{If specified, the value of the standard deviation under which 
the conditional power or sample size recalculation calculation is performed,
default is the value of \code{stDev}.}

\item{maxNumberOfIterations}{The number of simulation iterations, default is \code{1000}.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcSubjectsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalculation is performed with conditional power with specified
\code{minNumberOfSubjectsPerStage} and \code{maxNumberOfSubjectsPerStage} (see details and examples).}

\item{selectArmsFunction}{Optionally, a function can be entered that defines the way of how treatment arms
are selected. This function is allowed to depend on \code{effectVector} with length \code{activeArms}
and \code{stage} (see examples).}

\item{showStatistics}{If \code{TRUE}, summary statistics of the simulated data
are displayed for the \code{print} command, otherwise the output is suppressed, default
is \code{FALSE}.}
}
\value{
Returns a \code{\link{SimulationResults}} object.
The following generics (R generic functions) are available for this object:
\itemize{
  \item \code{\link[=names.FieldSet]{names}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary}} to display a summary of the object,
  \item \code{\link[=plot.SimulationResults]{plot}} to plot the object,
  \item \code{\link[=as.data.frame.ParameterSet]{as.data.frame}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the simulated power, stopping and selection probabilities, conditional power,
and expected sample size for testing means in a multi-arm treatment groups testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, selection probabilities,
and expected sample size at given number of subjects, parameter configuration, and treatment arm
selection rule in the multi-arm situation.
An allocation ratio can be specified referring to the ratio of number of subjects in the active
treatment groups as compared to the control group.

The definition of \code{thetaH1} and/or \code{stDevH1} makes only sense if \code{kMax} > 1
and if \code{conditionalPower}, \code{minNumberOfSubjectsPerStage}, and
\code{maxNumberOfSubjectsPerStage} (or \code{calcSubjectsFunction}) are defined.

\code{calcSubjectsFunction}\cr
This function returns the number of subjects at given conditional power and conditional
critical value for specified testing situation. The function might depend on the variables
\code{stage},
\code{selectedArms},
\code{plannedSubjects},
\code{allocationRatioPlanned},
\code{minNumberOfSubjectsPerStage},
\code{maxNumberOfSubjectsPerStage},
\code{conditionalPower},
\code{conditionalCriticalValue},
\code{overallEffects}, and
\code{stDevH1}.
The function has to contain the three-dots argument '...' (see examples).
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\donttest{
# Assess a treatment-arm selection strategy with three active arms, 
# if the better of the arms is selected for the second stage, and 
# compare it with the no-selection case. 
# Assume a linear dose-response relationship 
maxNumberOfIterations <- 100
designIN <- getDesignInverseNormal(typeOfDesign = "OF", kMax = 2)
sim <- getSimulationMultiArmMeans(design = designIN,
    activeArms = 3, typeOfShape = "linear",
    muMaxVector = seq(0,0.8,0.2),
    intersectionTest = "Simes",
    typeOfSelection = "best",
    plannedSubjects = c(30,60),
    maxNumberOfIterations = maxNumberOfIterations)

sim0 <- getSimulationMultiArmMeans(design = designIN,
    activeArms = 3, typeOfShape = "linear",
    muMaxVector = seq(0,0.8,0.2),
    intersectionTest = "Simes",
    typeOfSelection = "all",
    plannedSubjects = c(30,60),
    maxNumberOfIterations = maxNumberOfIterations)

sim$rejectAtLeastOne
sim$expectedNumberOfSubjects

sim0$rejectAtLeastOne
sim0$expectedNumberOfSubjects

# Compare the power of the conditional Dunnett test with the power of the 
# combination test using Dunnett's intersection tests if no treatment arm 
# selection takes place. Asseume a linear dose-response relationship.
maxNumberOfIterations <- 100
designIN <- getDesignInverseNormal(typeOfDesign = "asUser", 
    userAlphaSpending = c(0, 0.025))
designCD <- getDesignConditionalDunnett(secondStageConditioning = TRUE)

index <- 1
for (design in c(designIN, designCD)) {
    results <- getSimulationMultiArmMeans(design, activeArms = 3, 
        muMaxVector = seq(0, 1, 0.2), typeOfShape = "linear", 
        plannedSubjects = cumsum(rep(20, 2)), 
        intersectionTest = "Dunnett", 
        typeOfSelection = "all", maxNumberOfIterations = maxNumberOfIterations)
    if (index == 1) {
        drift <- results$effectMatrix[nrow(results$effectMatrix), ]
        plot(drift,results$rejectAtLeastOne, type = "l", lty = 1, 
            lwd = 3, col = "black", ylab = "Power")
    } else {
        lines(drift,results$rejectAtLeastOne, type = "l", 
            lty = index, lwd = 3, col = "red")
    }
    index <- index + 1
}
legend("topleft", legend=c("Combination Dunnett", "Conditional Dunnett"),
    col=c("black", "red"), lty = (1:2), cex = 0.8)

# Assess the design characteristics of a user defined selection
# strategy in a two-stage design using the inverse normal method
# with constant bounds. Stopping for futility due to
# de-selection of all treatment arms.
designIN <- getDesignInverseNormal(typeOfDesign = "P", kMax = 2)

mySelection <- function(effectVector) {
    selectedArms <- (effectVector >= c(0, 0.1, 0.3))
    return(selectedArms)
}

results <- getSimulationMultiArmMeans(designIN, activeArms = 3, 
    muMaxVector = seq(0, 1, 0.2), 
    typeOfShape = "linear", 
    plannedSubjects = c(30,60), 
    intersectionTest = "Dunnett", 
    typeOfSelection = "userDefined",
    selectArmsFunction = mySelection,
    maxNumberOfIterations = 100)

options(rpact.summary.output.size = "medium")         
summary(results)
plot(results, type = c(5,3,9), grid = 4)
}

}
