---
layout: post
title: Polyglot 1.2.0
lang: zh-CN
---

Polyglot 的全新版本现已推出。去试试吧！

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

此外，还请把 `jekyll-polyglot` 添加到你的网站的 `_config.yml` 的 gem 列表中。

本版本主要是为接下来的新特性以及更好的多语言内容管理提供基础准备。此外，本版本还包括了一些新特性：

## {% raw %} {% I18n_Headers %} {% endraw %}

请把这些标签和[你的网站的 url](https://github.com/untra/polyglot/blob/site/_includes/head.html#L6) 一同放入你的 `includes` 文件夹下的 `head.html` 文件中，以此获得最大化的多语言站点 SEO 。其效果与如下 Liquid 代码等同：

{% highlight html %}{% raw %}
<meta http-equiv="Content-Language" content="{{site.active_lang}}">
<link rel="alternate"
      hreflang="{{site.default_lang}}"
      href="http://yoursite.com{{page.permalink}}" />
{% for lang in site.languages %}
{% if lang == site.default_lang %}
  {% continue %}
{% endif %}
<link rel="alternate"
    hreflang="{{lang}}"
    href="http://yoursite.com/{{lang}}{{page.permalink}}" />
{% endfor %}
{% endraw %}
{% endhighlight %}

同样是要放在你的网页 header 中，但是 Polyglot 的方案更加快捷清晰！若需更多详情，请参照 [SEO 页面](/seo)。
