//! Darcs prober.
//!
//! This module provides a prober for Darcs repositories. It can detect
//! darcs repositories but does not provide any additional functionality.
use crate::controldir::Prober;
use pyo3::exceptions::PyModuleNotFoundError;
use pyo3::prelude::*;

pub struct DarcsProber(PyObject);

impl DarcsProber {
    pub fn new() -> Option<Self> {
        Python::with_gil(|py| {
            let m = match py.import_bound("breezy.plugins.darcs") {
                Ok(m) => m,
                Err(e) => {
                    if e.is_instance_of::<PyModuleNotFoundError>(py) {
                        return None;
                    } else {
                        e.print_and_set_sys_last_vars(py);
                        panic!("Failed to import breezy.plugins.darcs");
                    }
                }
            };
            let prober = m.getattr("DarcsProber").expect("Failed to get DarcsProber");
            Some(Self(prober.to_object(py)))
        })
    }
}

impl FromPyObject<'_> for DarcsProber {
    fn extract_bound(obj: &Bound<PyAny>) -> PyResult<Self> {
        Ok(Self(obj.to_object(obj.py())))
    }
}

impl ToPyObject for DarcsProber {
    fn to_object(&self, py: Python) -> PyObject {
        self.0.to_object(py)
    }
}

impl Prober for DarcsProber {}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_new() {
        let _ = DarcsProber::new();
    }
}
