//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384_scalar 32 '2^384 - 1388124618062372383947042015309946732620727252194336364173' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: p384_scalar
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 (from "2^384 - 1388124618062372383947042015309946732620727252194336364173")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in
//!                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_p384_scalar_u1 = u8;
pub type fiat_p384_scalar_i1 = i8;
pub type fiat_p384_scalar_u2 = u8;
pub type fiat_p384_scalar_i2 = i8;

/** The type fiat_p384_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p384_scalar_montgomery_domain_field_element(pub [u32; 12]);

impl core::ops::Index<usize> for fiat_p384_scalar_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p384_scalar_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_p384_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p384_scalar_non_montgomery_domain_field_element(pub [u32; 12]);

impl core::ops::Index<usize> for fiat_p384_scalar_non_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p384_scalar_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_p384_scalar_addcarryx_u32 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_scalar_addcarryx_u32(out1: &mut u32, out2: &mut fiat_p384_scalar_u1, arg1: fiat_p384_scalar_u1, arg2: u32, arg3: u32) {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_p384_scalar_u1 = ((x1 >> 32) as fiat_p384_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_scalar_subborrowx_u32 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_scalar_subborrowx_u32(out1: &mut u32, out2: &mut fiat_p384_scalar_u1, arg1: fiat_p384_scalar_u1, arg2: u32, arg3: u32) {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_p384_scalar_i1 = ((x1 >> 32) as fiat_p384_scalar_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p384_scalar_i2) - (x2 as fiat_p384_scalar_i2)) as fiat_p384_scalar_u1);
}

/// The function fiat_p384_scalar_mulx_u32 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_scalar_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_scalar_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_scalar_cmovznz_u32(out1: &mut u32, arg1: fiat_p384_scalar_u1, arg2: u32, arg3: u32) {
  let x1: fiat_p384_scalar_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_p384_scalar_i2) - (x1 as fiat_p384_scalar_i2)) as fiat_p384_scalar_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p384_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_mul(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x13, &mut x14, x12, (arg2[11]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x15, &mut x16, x12, (arg2[10]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x17, &mut x18, x12, (arg2[9]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x19, &mut x20, x12, (arg2[8]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x21, &mut x22, x12, (arg2[7]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x23, &mut x24, x12, (arg2[6]));
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x25, &mut x26, x12, (arg2[5]));
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x27, &mut x28, x12, (arg2[4]));
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x29, &mut x30, x12, (arg2[3]));
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x31, &mut x32, x12, (arg2[2]));
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x33, &mut x34, x12, (arg2[1]));
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x35, &mut x36, x12, (arg2[0]));
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x37, &mut x38, 0x0, x36, x33);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x39, &mut x40, x38, x34, x31);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x41, &mut x42, x40, x32, x29);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x43, &mut x44, x42, x30, x27);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x45, &mut x46, x44, x28, x25);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x47, &mut x48, x46, x26, x23);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x49, &mut x50, x48, x24, x21);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x51, &mut x52, x50, x22, x19);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x20, x17);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x18, x15);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x57, &mut x58, x56, x16, x13);
  let x59: u32 = ((x58 as u32) + x14);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x60, &mut x61, x35, 0xe88fdc45);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x62, &mut x63, x60, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x64, &mut x65, x60, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x66, &mut x67, x60, 0xffffffff);
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x68, &mut x69, x60, 0xffffffff);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x70, &mut x71, x60, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x72, &mut x73, x60, 0xffffffff);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x74, &mut x75, x60, 0xc7634d81);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x76, &mut x77, x60, 0xf4372ddf);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x78, &mut x79, x60, 0x581a0db2);
  let mut x80: u32 = 0;
  let mut x81: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x80, &mut x81, x60, 0x48b0a77a);
  let mut x82: u32 = 0;
  let mut x83: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x82, &mut x83, x60, 0xecec196a);
  let mut x84: u32 = 0;
  let mut x85: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x84, &mut x85, x60, 0xccc52973);
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x86, &mut x87, 0x0, x85, x82);
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x88, &mut x89, x87, x83, x80);
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x90, &mut x91, x89, x81, x78);
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x92, &mut x93, x91, x79, x76);
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x94, &mut x95, x93, x77, x74);
  let mut x96: u32 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x96, &mut x97, x95, x75, x72);
  let mut x98: u32 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x98, &mut x99, x97, x73, x70);
  let mut x100: u32 = 0;
  let mut x101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x100, &mut x101, x99, x71, x68);
  let mut x102: u32 = 0;
  let mut x103: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x102, &mut x103, x101, x69, x66);
  let mut x104: u32 = 0;
  let mut x105: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x104, &mut x105, x103, x67, x64);
  let mut x106: u32 = 0;
  let mut x107: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x106, &mut x107, x105, x65, x62);
  let x108: u32 = ((x107 as u32) + x63);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x109, &mut x110, 0x0, x35, x84);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x37, x86);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x39, x88);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x41, x90);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x43, x92);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x119, &mut x120, x118, x45, x94);
  let mut x121: u32 = 0;
  let mut x122: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x121, &mut x122, x120, x47, x96);
  let mut x123: u32 = 0;
  let mut x124: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x123, &mut x124, x122, x49, x98);
  let mut x125: u32 = 0;
  let mut x126: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x125, &mut x126, x124, x51, x100);
  let mut x127: u32 = 0;
  let mut x128: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x127, &mut x128, x126, x53, x102);
  let mut x129: u32 = 0;
  let mut x130: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x129, &mut x130, x128, x55, x104);
  let mut x131: u32 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x131, &mut x132, x130, x57, x106);
  let mut x133: u32 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x133, &mut x134, x132, x59, x108);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x135, &mut x136, x1, (arg2[11]));
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x137, &mut x138, x1, (arg2[10]));
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x139, &mut x140, x1, (arg2[9]));
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x141, &mut x142, x1, (arg2[8]));
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x143, &mut x144, x1, (arg2[7]));
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x145, &mut x146, x1, (arg2[6]));
  let mut x147: u32 = 0;
  let mut x148: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x147, &mut x148, x1, (arg2[5]));
  let mut x149: u32 = 0;
  let mut x150: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x149, &mut x150, x1, (arg2[4]));
  let mut x151: u32 = 0;
  let mut x152: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x151, &mut x152, x1, (arg2[3]));
  let mut x153: u32 = 0;
  let mut x154: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x153, &mut x154, x1, (arg2[2]));
  let mut x155: u32 = 0;
  let mut x156: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x155, &mut x156, x1, (arg2[1]));
  let mut x157: u32 = 0;
  let mut x158: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x157, &mut x158, x1, (arg2[0]));
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x159, &mut x160, 0x0, x158, x155);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x156, x153);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x163, &mut x164, x162, x154, x151);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x165, &mut x166, x164, x152, x149);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x167, &mut x168, x166, x150, x147);
  let mut x169: u32 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x169, &mut x170, x168, x148, x145);
  let mut x171: u32 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x171, &mut x172, x170, x146, x143);
  let mut x173: u32 = 0;
  let mut x174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x173, &mut x174, x172, x144, x141);
  let mut x175: u32 = 0;
  let mut x176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x142, x139);
  let mut x177: u32 = 0;
  let mut x178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x140, x137);
  let mut x179: u32 = 0;
  let mut x180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x138, x135);
  let x181: u32 = ((x180 as u32) + x136);
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x182, &mut x183, 0x0, x111, x157);
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x113, x159);
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x115, x161);
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x117, x163);
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x119, x165);
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x121, x167);
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x194, &mut x195, x193, x123, x169);
  let mut x196: u32 = 0;
  let mut x197: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x196, &mut x197, x195, x125, x171);
  let mut x198: u32 = 0;
  let mut x199: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x198, &mut x199, x197, x127, x173);
  let mut x200: u32 = 0;
  let mut x201: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x200, &mut x201, x199, x129, x175);
  let mut x202: u32 = 0;
  let mut x203: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x202, &mut x203, x201, x131, x177);
  let mut x204: u32 = 0;
  let mut x205: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x204, &mut x205, x203, x133, x179);
  let mut x206: u32 = 0;
  let mut x207: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x206, &mut x207, x205, (x134 as u32), x181);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x208, &mut x209, x182, 0xe88fdc45);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x210, &mut x211, x208, 0xffffffff);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x212, &mut x213, x208, 0xffffffff);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x214, &mut x215, x208, 0xffffffff);
  let mut x216: u32 = 0;
  let mut x217: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x216, &mut x217, x208, 0xffffffff);
  let mut x218: u32 = 0;
  let mut x219: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x218, &mut x219, x208, 0xffffffff);
  let mut x220: u32 = 0;
  let mut x221: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x220, &mut x221, x208, 0xffffffff);
  let mut x222: u32 = 0;
  let mut x223: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x222, &mut x223, x208, 0xc7634d81);
  let mut x224: u32 = 0;
  let mut x225: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x224, &mut x225, x208, 0xf4372ddf);
  let mut x226: u32 = 0;
  let mut x227: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x226, &mut x227, x208, 0x581a0db2);
  let mut x228: u32 = 0;
  let mut x229: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x228, &mut x229, x208, 0x48b0a77a);
  let mut x230: u32 = 0;
  let mut x231: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x230, &mut x231, x208, 0xecec196a);
  let mut x232: u32 = 0;
  let mut x233: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x232, &mut x233, x208, 0xccc52973);
  let mut x234: u32 = 0;
  let mut x235: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x234, &mut x235, 0x0, x233, x230);
  let mut x236: u32 = 0;
  let mut x237: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x231, x228);
  let mut x238: u32 = 0;
  let mut x239: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x229, x226);
  let mut x240: u32 = 0;
  let mut x241: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x227, x224);
  let mut x242: u32 = 0;
  let mut x243: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x225, x222);
  let mut x244: u32 = 0;
  let mut x245: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x223, x220);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x246, &mut x247, x245, x221, x218);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x219, x216);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x250, &mut x251, x249, x217, x214);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x252, &mut x253, x251, x215, x212);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x254, &mut x255, x253, x213, x210);
  let x256: u32 = ((x255 as u32) + x211);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x257, &mut x258, 0x0, x182, x232);
  let mut x259: u32 = 0;
  let mut x260: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x259, &mut x260, x258, x184, x234);
  let mut x261: u32 = 0;
  let mut x262: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x186, x236);
  let mut x263: u32 = 0;
  let mut x264: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x263, &mut x264, x262, x188, x238);
  let mut x265: u32 = 0;
  let mut x266: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x190, x240);
  let mut x267: u32 = 0;
  let mut x268: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x192, x242);
  let mut x269: u32 = 0;
  let mut x270: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x194, x244);
  let mut x271: u32 = 0;
  let mut x272: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x196, x246);
  let mut x273: u32 = 0;
  let mut x274: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x198, x248);
  let mut x275: u32 = 0;
  let mut x276: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x200, x250);
  let mut x277: u32 = 0;
  let mut x278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x277, &mut x278, x276, x202, x252);
  let mut x279: u32 = 0;
  let mut x280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x279, &mut x280, x278, x204, x254);
  let mut x281: u32 = 0;
  let mut x282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x281, &mut x282, x280, x206, x256);
  let x283: u32 = ((x282 as u32) + (x207 as u32));
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x284, &mut x285, x2, (arg2[11]));
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x286, &mut x287, x2, (arg2[10]));
  let mut x288: u32 = 0;
  let mut x289: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x288, &mut x289, x2, (arg2[9]));
  let mut x290: u32 = 0;
  let mut x291: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x290, &mut x291, x2, (arg2[8]));
  let mut x292: u32 = 0;
  let mut x293: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x292, &mut x293, x2, (arg2[7]));
  let mut x294: u32 = 0;
  let mut x295: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x294, &mut x295, x2, (arg2[6]));
  let mut x296: u32 = 0;
  let mut x297: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x296, &mut x297, x2, (arg2[5]));
  let mut x298: u32 = 0;
  let mut x299: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x298, &mut x299, x2, (arg2[4]));
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x300, &mut x301, x2, (arg2[3]));
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x302, &mut x303, x2, (arg2[2]));
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x304, &mut x305, x2, (arg2[1]));
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x306, &mut x307, x2, (arg2[0]));
  let mut x308: u32 = 0;
  let mut x309: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x308, &mut x309, 0x0, x307, x304);
  let mut x310: u32 = 0;
  let mut x311: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x310, &mut x311, x309, x305, x302);
  let mut x312: u32 = 0;
  let mut x313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x312, &mut x313, x311, x303, x300);
  let mut x314: u32 = 0;
  let mut x315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x314, &mut x315, x313, x301, x298);
  let mut x316: u32 = 0;
  let mut x317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x316, &mut x317, x315, x299, x296);
  let mut x318: u32 = 0;
  let mut x319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x318, &mut x319, x317, x297, x294);
  let mut x320: u32 = 0;
  let mut x321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x320, &mut x321, x319, x295, x292);
  let mut x322: u32 = 0;
  let mut x323: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x322, &mut x323, x321, x293, x290);
  let mut x324: u32 = 0;
  let mut x325: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x324, &mut x325, x323, x291, x288);
  let mut x326: u32 = 0;
  let mut x327: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x289, x286);
  let mut x328: u32 = 0;
  let mut x329: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x287, x284);
  let x330: u32 = ((x329 as u32) + x285);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x331, &mut x332, 0x0, x259, x306);
  let mut x333: u32 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x261, x308);
  let mut x335: u32 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x263, x310);
  let mut x337: u32 = 0;
  let mut x338: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x337, &mut x338, x336, x265, x312);
  let mut x339: u32 = 0;
  let mut x340: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x339, &mut x340, x338, x267, x314);
  let mut x341: u32 = 0;
  let mut x342: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x341, &mut x342, x340, x269, x316);
  let mut x343: u32 = 0;
  let mut x344: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x343, &mut x344, x342, x271, x318);
  let mut x345: u32 = 0;
  let mut x346: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x345, &mut x346, x344, x273, x320);
  let mut x347: u32 = 0;
  let mut x348: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x347, &mut x348, x346, x275, x322);
  let mut x349: u32 = 0;
  let mut x350: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x349, &mut x350, x348, x277, x324);
  let mut x351: u32 = 0;
  let mut x352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x351, &mut x352, x350, x279, x326);
  let mut x353: u32 = 0;
  let mut x354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x353, &mut x354, x352, x281, x328);
  let mut x355: u32 = 0;
  let mut x356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x355, &mut x356, x354, x283, x330);
  let mut x357: u32 = 0;
  let mut x358: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x357, &mut x358, x331, 0xe88fdc45);
  let mut x359: u32 = 0;
  let mut x360: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x359, &mut x360, x357, 0xffffffff);
  let mut x361: u32 = 0;
  let mut x362: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x361, &mut x362, x357, 0xffffffff);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x363, &mut x364, x357, 0xffffffff);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x365, &mut x366, x357, 0xffffffff);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x367, &mut x368, x357, 0xffffffff);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x369, &mut x370, x357, 0xffffffff);
  let mut x371: u32 = 0;
  let mut x372: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x371, &mut x372, x357, 0xc7634d81);
  let mut x373: u32 = 0;
  let mut x374: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x373, &mut x374, x357, 0xf4372ddf);
  let mut x375: u32 = 0;
  let mut x376: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x375, &mut x376, x357, 0x581a0db2);
  let mut x377: u32 = 0;
  let mut x378: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x377, &mut x378, x357, 0x48b0a77a);
  let mut x379: u32 = 0;
  let mut x380: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x379, &mut x380, x357, 0xecec196a);
  let mut x381: u32 = 0;
  let mut x382: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x381, &mut x382, x357, 0xccc52973);
  let mut x383: u32 = 0;
  let mut x384: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x383, &mut x384, 0x0, x382, x379);
  let mut x385: u32 = 0;
  let mut x386: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x380, x377);
  let mut x387: u32 = 0;
  let mut x388: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x378, x375);
  let mut x389: u32 = 0;
  let mut x390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x376, x373);
  let mut x391: u32 = 0;
  let mut x392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x374, x371);
  let mut x393: u32 = 0;
  let mut x394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x393, &mut x394, x392, x372, x369);
  let mut x395: u32 = 0;
  let mut x396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x395, &mut x396, x394, x370, x367);
  let mut x397: u32 = 0;
  let mut x398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x397, &mut x398, x396, x368, x365);
  let mut x399: u32 = 0;
  let mut x400: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x399, &mut x400, x398, x366, x363);
  let mut x401: u32 = 0;
  let mut x402: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x364, x361);
  let mut x403: u32 = 0;
  let mut x404: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x362, x359);
  let x405: u32 = ((x404 as u32) + x360);
  let mut x406: u32 = 0;
  let mut x407: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x406, &mut x407, 0x0, x331, x381);
  let mut x408: u32 = 0;
  let mut x409: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x408, &mut x409, x407, x333, x383);
  let mut x410: u32 = 0;
  let mut x411: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x410, &mut x411, x409, x335, x385);
  let mut x412: u32 = 0;
  let mut x413: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x337, x387);
  let mut x414: u32 = 0;
  let mut x415: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x339, x389);
  let mut x416: u32 = 0;
  let mut x417: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x341, x391);
  let mut x418: u32 = 0;
  let mut x419: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x343, x393);
  let mut x420: u32 = 0;
  let mut x421: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x345, x395);
  let mut x422: u32 = 0;
  let mut x423: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x347, x397);
  let mut x424: u32 = 0;
  let mut x425: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x424, &mut x425, x423, x349, x399);
  let mut x426: u32 = 0;
  let mut x427: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x426, &mut x427, x425, x351, x401);
  let mut x428: u32 = 0;
  let mut x429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x428, &mut x429, x427, x353, x403);
  let mut x430: u32 = 0;
  let mut x431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x430, &mut x431, x429, x355, x405);
  let x432: u32 = ((x431 as u32) + (x356 as u32));
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x433, &mut x434, x3, (arg2[11]));
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x435, &mut x436, x3, (arg2[10]));
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x437, &mut x438, x3, (arg2[9]));
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x439, &mut x440, x3, (arg2[8]));
  let mut x441: u32 = 0;
  let mut x442: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x441, &mut x442, x3, (arg2[7]));
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x443, &mut x444, x3, (arg2[6]));
  let mut x445: u32 = 0;
  let mut x446: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x445, &mut x446, x3, (arg2[5]));
  let mut x447: u32 = 0;
  let mut x448: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x447, &mut x448, x3, (arg2[4]));
  let mut x449: u32 = 0;
  let mut x450: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x449, &mut x450, x3, (arg2[3]));
  let mut x451: u32 = 0;
  let mut x452: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x451, &mut x452, x3, (arg2[2]));
  let mut x453: u32 = 0;
  let mut x454: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x453, &mut x454, x3, (arg2[1]));
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x455, &mut x456, x3, (arg2[0]));
  let mut x457: u32 = 0;
  let mut x458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x457, &mut x458, 0x0, x456, x453);
  let mut x459: u32 = 0;
  let mut x460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x459, &mut x460, x458, x454, x451);
  let mut x461: u32 = 0;
  let mut x462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x461, &mut x462, x460, x452, x449);
  let mut x463: u32 = 0;
  let mut x464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x450, x447);
  let mut x465: u32 = 0;
  let mut x466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x448, x445);
  let mut x467: u32 = 0;
  let mut x468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x446, x443);
  let mut x469: u32 = 0;
  let mut x470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x444, x441);
  let mut x471: u32 = 0;
  let mut x472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x442, x439);
  let mut x473: u32 = 0;
  let mut x474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x473, &mut x474, x472, x440, x437);
  let mut x475: u32 = 0;
  let mut x476: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x475, &mut x476, x474, x438, x435);
  let mut x477: u32 = 0;
  let mut x478: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x477, &mut x478, x476, x436, x433);
  let x479: u32 = ((x478 as u32) + x434);
  let mut x480: u32 = 0;
  let mut x481: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x480, &mut x481, 0x0, x408, x455);
  let mut x482: u32 = 0;
  let mut x483: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x482, &mut x483, x481, x410, x457);
  let mut x484: u32 = 0;
  let mut x485: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x412, x459);
  let mut x486: u32 = 0;
  let mut x487: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x414, x461);
  let mut x488: u32 = 0;
  let mut x489: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x416, x463);
  let mut x490: u32 = 0;
  let mut x491: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x418, x465);
  let mut x492: u32 = 0;
  let mut x493: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x492, &mut x493, x491, x420, x467);
  let mut x494: u32 = 0;
  let mut x495: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x494, &mut x495, x493, x422, x469);
  let mut x496: u32 = 0;
  let mut x497: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x496, &mut x497, x495, x424, x471);
  let mut x498: u32 = 0;
  let mut x499: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x498, &mut x499, x497, x426, x473);
  let mut x500: u32 = 0;
  let mut x501: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x500, &mut x501, x499, x428, x475);
  let mut x502: u32 = 0;
  let mut x503: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x502, &mut x503, x501, x430, x477);
  let mut x504: u32 = 0;
  let mut x505: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x504, &mut x505, x503, x432, x479);
  let mut x506: u32 = 0;
  let mut x507: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x506, &mut x507, x480, 0xe88fdc45);
  let mut x508: u32 = 0;
  let mut x509: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x508, &mut x509, x506, 0xffffffff);
  let mut x510: u32 = 0;
  let mut x511: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x510, &mut x511, x506, 0xffffffff);
  let mut x512: u32 = 0;
  let mut x513: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x512, &mut x513, x506, 0xffffffff);
  let mut x514: u32 = 0;
  let mut x515: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x514, &mut x515, x506, 0xffffffff);
  let mut x516: u32 = 0;
  let mut x517: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x516, &mut x517, x506, 0xffffffff);
  let mut x518: u32 = 0;
  let mut x519: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x518, &mut x519, x506, 0xffffffff);
  let mut x520: u32 = 0;
  let mut x521: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x520, &mut x521, x506, 0xc7634d81);
  let mut x522: u32 = 0;
  let mut x523: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x522, &mut x523, x506, 0xf4372ddf);
  let mut x524: u32 = 0;
  let mut x525: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x524, &mut x525, x506, 0x581a0db2);
  let mut x526: u32 = 0;
  let mut x527: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x526, &mut x527, x506, 0x48b0a77a);
  let mut x528: u32 = 0;
  let mut x529: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x528, &mut x529, x506, 0xecec196a);
  let mut x530: u32 = 0;
  let mut x531: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x530, &mut x531, x506, 0xccc52973);
  let mut x532: u32 = 0;
  let mut x533: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x532, &mut x533, 0x0, x531, x528);
  let mut x534: u32 = 0;
  let mut x535: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x529, x526);
  let mut x536: u32 = 0;
  let mut x537: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x527, x524);
  let mut x538: u32 = 0;
  let mut x539: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x525, x522);
  let mut x540: u32 = 0;
  let mut x541: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x523, x520);
  let mut x542: u32 = 0;
  let mut x543: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x542, &mut x543, x541, x521, x518);
  let mut x544: u32 = 0;
  let mut x545: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x544, &mut x545, x543, x519, x516);
  let mut x546: u32 = 0;
  let mut x547: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x546, &mut x547, x545, x517, x514);
  let mut x548: u32 = 0;
  let mut x549: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x548, &mut x549, x547, x515, x512);
  let mut x550: u32 = 0;
  let mut x551: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x550, &mut x551, x549, x513, x510);
  let mut x552: u32 = 0;
  let mut x553: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x552, &mut x553, x551, x511, x508);
  let x554: u32 = ((x553 as u32) + x509);
  let mut x555: u32 = 0;
  let mut x556: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x555, &mut x556, 0x0, x480, x530);
  let mut x557: u32 = 0;
  let mut x558: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x482, x532);
  let mut x559: u32 = 0;
  let mut x560: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x484, x534);
  let mut x561: u32 = 0;
  let mut x562: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x561, &mut x562, x560, x486, x536);
  let mut x563: u32 = 0;
  let mut x564: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x563, &mut x564, x562, x488, x538);
  let mut x565: u32 = 0;
  let mut x566: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x565, &mut x566, x564, x490, x540);
  let mut x567: u32 = 0;
  let mut x568: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x567, &mut x568, x566, x492, x542);
  let mut x569: u32 = 0;
  let mut x570: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x569, &mut x570, x568, x494, x544);
  let mut x571: u32 = 0;
  let mut x572: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x571, &mut x572, x570, x496, x546);
  let mut x573: u32 = 0;
  let mut x574: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x573, &mut x574, x572, x498, x548);
  let mut x575: u32 = 0;
  let mut x576: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x575, &mut x576, x574, x500, x550);
  let mut x577: u32 = 0;
  let mut x578: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x577, &mut x578, x576, x502, x552);
  let mut x579: u32 = 0;
  let mut x580: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x579, &mut x580, x578, x504, x554);
  let x581: u32 = ((x580 as u32) + (x505 as u32));
  let mut x582: u32 = 0;
  let mut x583: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x582, &mut x583, x4, (arg2[11]));
  let mut x584: u32 = 0;
  let mut x585: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x584, &mut x585, x4, (arg2[10]));
  let mut x586: u32 = 0;
  let mut x587: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x586, &mut x587, x4, (arg2[9]));
  let mut x588: u32 = 0;
  let mut x589: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x588, &mut x589, x4, (arg2[8]));
  let mut x590: u32 = 0;
  let mut x591: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x590, &mut x591, x4, (arg2[7]));
  let mut x592: u32 = 0;
  let mut x593: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x592, &mut x593, x4, (arg2[6]));
  let mut x594: u32 = 0;
  let mut x595: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x594, &mut x595, x4, (arg2[5]));
  let mut x596: u32 = 0;
  let mut x597: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x596, &mut x597, x4, (arg2[4]));
  let mut x598: u32 = 0;
  let mut x599: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x598, &mut x599, x4, (arg2[3]));
  let mut x600: u32 = 0;
  let mut x601: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x600, &mut x601, x4, (arg2[2]));
  let mut x602: u32 = 0;
  let mut x603: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x602, &mut x603, x4, (arg2[1]));
  let mut x604: u32 = 0;
  let mut x605: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x604, &mut x605, x4, (arg2[0]));
  let mut x606: u32 = 0;
  let mut x607: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x606, &mut x607, 0x0, x605, x602);
  let mut x608: u32 = 0;
  let mut x609: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x608, &mut x609, x607, x603, x600);
  let mut x610: u32 = 0;
  let mut x611: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x610, &mut x611, x609, x601, x598);
  let mut x612: u32 = 0;
  let mut x613: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x612, &mut x613, x611, x599, x596);
  let mut x614: u32 = 0;
  let mut x615: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x614, &mut x615, x613, x597, x594);
  let mut x616: u32 = 0;
  let mut x617: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x616, &mut x617, x615, x595, x592);
  let mut x618: u32 = 0;
  let mut x619: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x618, &mut x619, x617, x593, x590);
  let mut x620: u32 = 0;
  let mut x621: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x620, &mut x621, x619, x591, x588);
  let mut x622: u32 = 0;
  let mut x623: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x622, &mut x623, x621, x589, x586);
  let mut x624: u32 = 0;
  let mut x625: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x624, &mut x625, x623, x587, x584);
  let mut x626: u32 = 0;
  let mut x627: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x626, &mut x627, x625, x585, x582);
  let x628: u32 = ((x627 as u32) + x583);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x629, &mut x630, 0x0, x557, x604);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x559, x606);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x633, &mut x634, x632, x561, x608);
  let mut x635: u32 = 0;
  let mut x636: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x635, &mut x636, x634, x563, x610);
  let mut x637: u32 = 0;
  let mut x638: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x637, &mut x638, x636, x565, x612);
  let mut x639: u32 = 0;
  let mut x640: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x639, &mut x640, x638, x567, x614);
  let mut x641: u32 = 0;
  let mut x642: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x641, &mut x642, x640, x569, x616);
  let mut x643: u32 = 0;
  let mut x644: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x643, &mut x644, x642, x571, x618);
  let mut x645: u32 = 0;
  let mut x646: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x645, &mut x646, x644, x573, x620);
  let mut x647: u32 = 0;
  let mut x648: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x647, &mut x648, x646, x575, x622);
  let mut x649: u32 = 0;
  let mut x650: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x649, &mut x650, x648, x577, x624);
  let mut x651: u32 = 0;
  let mut x652: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x651, &mut x652, x650, x579, x626);
  let mut x653: u32 = 0;
  let mut x654: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x653, &mut x654, x652, x581, x628);
  let mut x655: u32 = 0;
  let mut x656: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x655, &mut x656, x629, 0xe88fdc45);
  let mut x657: u32 = 0;
  let mut x658: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x657, &mut x658, x655, 0xffffffff);
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x659, &mut x660, x655, 0xffffffff);
  let mut x661: u32 = 0;
  let mut x662: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x661, &mut x662, x655, 0xffffffff);
  let mut x663: u32 = 0;
  let mut x664: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x663, &mut x664, x655, 0xffffffff);
  let mut x665: u32 = 0;
  let mut x666: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x665, &mut x666, x655, 0xffffffff);
  let mut x667: u32 = 0;
  let mut x668: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x667, &mut x668, x655, 0xffffffff);
  let mut x669: u32 = 0;
  let mut x670: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x669, &mut x670, x655, 0xc7634d81);
  let mut x671: u32 = 0;
  let mut x672: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x671, &mut x672, x655, 0xf4372ddf);
  let mut x673: u32 = 0;
  let mut x674: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x673, &mut x674, x655, 0x581a0db2);
  let mut x675: u32 = 0;
  let mut x676: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x675, &mut x676, x655, 0x48b0a77a);
  let mut x677: u32 = 0;
  let mut x678: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x677, &mut x678, x655, 0xecec196a);
  let mut x679: u32 = 0;
  let mut x680: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x679, &mut x680, x655, 0xccc52973);
  let mut x681: u32 = 0;
  let mut x682: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x681, &mut x682, 0x0, x680, x677);
  let mut x683: u32 = 0;
  let mut x684: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x683, &mut x684, x682, x678, x675);
  let mut x685: u32 = 0;
  let mut x686: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x685, &mut x686, x684, x676, x673);
  let mut x687: u32 = 0;
  let mut x688: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x687, &mut x688, x686, x674, x671);
  let mut x689: u32 = 0;
  let mut x690: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x689, &mut x690, x688, x672, x669);
  let mut x691: u32 = 0;
  let mut x692: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x691, &mut x692, x690, x670, x667);
  let mut x693: u32 = 0;
  let mut x694: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x693, &mut x694, x692, x668, x665);
  let mut x695: u32 = 0;
  let mut x696: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x695, &mut x696, x694, x666, x663);
  let mut x697: u32 = 0;
  let mut x698: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x697, &mut x698, x696, x664, x661);
  let mut x699: u32 = 0;
  let mut x700: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x699, &mut x700, x698, x662, x659);
  let mut x701: u32 = 0;
  let mut x702: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x701, &mut x702, x700, x660, x657);
  let x703: u32 = ((x702 as u32) + x658);
  let mut x704: u32 = 0;
  let mut x705: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x704, &mut x705, 0x0, x629, x679);
  let mut x706: u32 = 0;
  let mut x707: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x706, &mut x707, x705, x631, x681);
  let mut x708: u32 = 0;
  let mut x709: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x708, &mut x709, x707, x633, x683);
  let mut x710: u32 = 0;
  let mut x711: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x710, &mut x711, x709, x635, x685);
  let mut x712: u32 = 0;
  let mut x713: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x712, &mut x713, x711, x637, x687);
  let mut x714: u32 = 0;
  let mut x715: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x714, &mut x715, x713, x639, x689);
  let mut x716: u32 = 0;
  let mut x717: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x716, &mut x717, x715, x641, x691);
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x718, &mut x719, x717, x643, x693);
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x720, &mut x721, x719, x645, x695);
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x722, &mut x723, x721, x647, x697);
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x724, &mut x725, x723, x649, x699);
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x726, &mut x727, x725, x651, x701);
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x728, &mut x729, x727, x653, x703);
  let x730: u32 = ((x729 as u32) + (x654 as u32));
  let mut x731: u32 = 0;
  let mut x732: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x731, &mut x732, x5, (arg2[11]));
  let mut x733: u32 = 0;
  let mut x734: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x733, &mut x734, x5, (arg2[10]));
  let mut x735: u32 = 0;
  let mut x736: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x735, &mut x736, x5, (arg2[9]));
  let mut x737: u32 = 0;
  let mut x738: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x737, &mut x738, x5, (arg2[8]));
  let mut x739: u32 = 0;
  let mut x740: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x739, &mut x740, x5, (arg2[7]));
  let mut x741: u32 = 0;
  let mut x742: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x741, &mut x742, x5, (arg2[6]));
  let mut x743: u32 = 0;
  let mut x744: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x743, &mut x744, x5, (arg2[5]));
  let mut x745: u32 = 0;
  let mut x746: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x745, &mut x746, x5, (arg2[4]));
  let mut x747: u32 = 0;
  let mut x748: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x747, &mut x748, x5, (arg2[3]));
  let mut x749: u32 = 0;
  let mut x750: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x749, &mut x750, x5, (arg2[2]));
  let mut x751: u32 = 0;
  let mut x752: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x751, &mut x752, x5, (arg2[1]));
  let mut x753: u32 = 0;
  let mut x754: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x753, &mut x754, x5, (arg2[0]));
  let mut x755: u32 = 0;
  let mut x756: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x755, &mut x756, 0x0, x754, x751);
  let mut x757: u32 = 0;
  let mut x758: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x757, &mut x758, x756, x752, x749);
  let mut x759: u32 = 0;
  let mut x760: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x759, &mut x760, x758, x750, x747);
  let mut x761: u32 = 0;
  let mut x762: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x761, &mut x762, x760, x748, x745);
  let mut x763: u32 = 0;
  let mut x764: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x763, &mut x764, x762, x746, x743);
  let mut x765: u32 = 0;
  let mut x766: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x765, &mut x766, x764, x744, x741);
  let mut x767: u32 = 0;
  let mut x768: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x767, &mut x768, x766, x742, x739);
  let mut x769: u32 = 0;
  let mut x770: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x769, &mut x770, x768, x740, x737);
  let mut x771: u32 = 0;
  let mut x772: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x771, &mut x772, x770, x738, x735);
  let mut x773: u32 = 0;
  let mut x774: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x773, &mut x774, x772, x736, x733);
  let mut x775: u32 = 0;
  let mut x776: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x775, &mut x776, x774, x734, x731);
  let x777: u32 = ((x776 as u32) + x732);
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x778, &mut x779, 0x0, x706, x753);
  let mut x780: u32 = 0;
  let mut x781: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x780, &mut x781, x779, x708, x755);
  let mut x782: u32 = 0;
  let mut x783: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x782, &mut x783, x781, x710, x757);
  let mut x784: u32 = 0;
  let mut x785: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x784, &mut x785, x783, x712, x759);
  let mut x786: u32 = 0;
  let mut x787: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x786, &mut x787, x785, x714, x761);
  let mut x788: u32 = 0;
  let mut x789: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x788, &mut x789, x787, x716, x763);
  let mut x790: u32 = 0;
  let mut x791: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x790, &mut x791, x789, x718, x765);
  let mut x792: u32 = 0;
  let mut x793: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x792, &mut x793, x791, x720, x767);
  let mut x794: u32 = 0;
  let mut x795: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x794, &mut x795, x793, x722, x769);
  let mut x796: u32 = 0;
  let mut x797: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x796, &mut x797, x795, x724, x771);
  let mut x798: u32 = 0;
  let mut x799: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x798, &mut x799, x797, x726, x773);
  let mut x800: u32 = 0;
  let mut x801: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x800, &mut x801, x799, x728, x775);
  let mut x802: u32 = 0;
  let mut x803: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x802, &mut x803, x801, x730, x777);
  let mut x804: u32 = 0;
  let mut x805: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x804, &mut x805, x778, 0xe88fdc45);
  let mut x806: u32 = 0;
  let mut x807: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x806, &mut x807, x804, 0xffffffff);
  let mut x808: u32 = 0;
  let mut x809: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x808, &mut x809, x804, 0xffffffff);
  let mut x810: u32 = 0;
  let mut x811: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x810, &mut x811, x804, 0xffffffff);
  let mut x812: u32 = 0;
  let mut x813: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x812, &mut x813, x804, 0xffffffff);
  let mut x814: u32 = 0;
  let mut x815: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x814, &mut x815, x804, 0xffffffff);
  let mut x816: u32 = 0;
  let mut x817: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x816, &mut x817, x804, 0xffffffff);
  let mut x818: u32 = 0;
  let mut x819: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x818, &mut x819, x804, 0xc7634d81);
  let mut x820: u32 = 0;
  let mut x821: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x820, &mut x821, x804, 0xf4372ddf);
  let mut x822: u32 = 0;
  let mut x823: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x822, &mut x823, x804, 0x581a0db2);
  let mut x824: u32 = 0;
  let mut x825: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x824, &mut x825, x804, 0x48b0a77a);
  let mut x826: u32 = 0;
  let mut x827: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x826, &mut x827, x804, 0xecec196a);
  let mut x828: u32 = 0;
  let mut x829: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x828, &mut x829, x804, 0xccc52973);
  let mut x830: u32 = 0;
  let mut x831: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x830, &mut x831, 0x0, x829, x826);
  let mut x832: u32 = 0;
  let mut x833: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x832, &mut x833, x831, x827, x824);
  let mut x834: u32 = 0;
  let mut x835: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x834, &mut x835, x833, x825, x822);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x836, &mut x837, x835, x823, x820);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x838, &mut x839, x837, x821, x818);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x840, &mut x841, x839, x819, x816);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x842, &mut x843, x841, x817, x814);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x844, &mut x845, x843, x815, x812);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x846, &mut x847, x845, x813, x810);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x848, &mut x849, x847, x811, x808);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x850, &mut x851, x849, x809, x806);
  let x852: u32 = ((x851 as u32) + x807);
  let mut x853: u32 = 0;
  let mut x854: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x853, &mut x854, 0x0, x778, x828);
  let mut x855: u32 = 0;
  let mut x856: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x855, &mut x856, x854, x780, x830);
  let mut x857: u32 = 0;
  let mut x858: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x857, &mut x858, x856, x782, x832);
  let mut x859: u32 = 0;
  let mut x860: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x859, &mut x860, x858, x784, x834);
  let mut x861: u32 = 0;
  let mut x862: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x861, &mut x862, x860, x786, x836);
  let mut x863: u32 = 0;
  let mut x864: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x863, &mut x864, x862, x788, x838);
  let mut x865: u32 = 0;
  let mut x866: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x865, &mut x866, x864, x790, x840);
  let mut x867: u32 = 0;
  let mut x868: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x867, &mut x868, x866, x792, x842);
  let mut x869: u32 = 0;
  let mut x870: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x869, &mut x870, x868, x794, x844);
  let mut x871: u32 = 0;
  let mut x872: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x871, &mut x872, x870, x796, x846);
  let mut x873: u32 = 0;
  let mut x874: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x873, &mut x874, x872, x798, x848);
  let mut x875: u32 = 0;
  let mut x876: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x875, &mut x876, x874, x800, x850);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x877, &mut x878, x876, x802, x852);
  let x879: u32 = ((x878 as u32) + (x803 as u32));
  let mut x880: u32 = 0;
  let mut x881: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x880, &mut x881, x6, (arg2[11]));
  let mut x882: u32 = 0;
  let mut x883: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x882, &mut x883, x6, (arg2[10]));
  let mut x884: u32 = 0;
  let mut x885: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x884, &mut x885, x6, (arg2[9]));
  let mut x886: u32 = 0;
  let mut x887: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x886, &mut x887, x6, (arg2[8]));
  let mut x888: u32 = 0;
  let mut x889: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x888, &mut x889, x6, (arg2[7]));
  let mut x890: u32 = 0;
  let mut x891: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x890, &mut x891, x6, (arg2[6]));
  let mut x892: u32 = 0;
  let mut x893: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x892, &mut x893, x6, (arg2[5]));
  let mut x894: u32 = 0;
  let mut x895: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x894, &mut x895, x6, (arg2[4]));
  let mut x896: u32 = 0;
  let mut x897: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x896, &mut x897, x6, (arg2[3]));
  let mut x898: u32 = 0;
  let mut x899: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x898, &mut x899, x6, (arg2[2]));
  let mut x900: u32 = 0;
  let mut x901: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x900, &mut x901, x6, (arg2[1]));
  let mut x902: u32 = 0;
  let mut x903: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x902, &mut x903, x6, (arg2[0]));
  let mut x904: u32 = 0;
  let mut x905: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x904, &mut x905, 0x0, x903, x900);
  let mut x906: u32 = 0;
  let mut x907: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x906, &mut x907, x905, x901, x898);
  let mut x908: u32 = 0;
  let mut x909: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x908, &mut x909, x907, x899, x896);
  let mut x910: u32 = 0;
  let mut x911: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x910, &mut x911, x909, x897, x894);
  let mut x912: u32 = 0;
  let mut x913: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x912, &mut x913, x911, x895, x892);
  let mut x914: u32 = 0;
  let mut x915: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x914, &mut x915, x913, x893, x890);
  let mut x916: u32 = 0;
  let mut x917: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x916, &mut x917, x915, x891, x888);
  let mut x918: u32 = 0;
  let mut x919: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x918, &mut x919, x917, x889, x886);
  let mut x920: u32 = 0;
  let mut x921: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x920, &mut x921, x919, x887, x884);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x922, &mut x923, x921, x885, x882);
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x924, &mut x925, x923, x883, x880);
  let x926: u32 = ((x925 as u32) + x881);
  let mut x927: u32 = 0;
  let mut x928: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x927, &mut x928, 0x0, x855, x902);
  let mut x929: u32 = 0;
  let mut x930: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x929, &mut x930, x928, x857, x904);
  let mut x931: u32 = 0;
  let mut x932: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x931, &mut x932, x930, x859, x906);
  let mut x933: u32 = 0;
  let mut x934: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x933, &mut x934, x932, x861, x908);
  let mut x935: u32 = 0;
  let mut x936: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x935, &mut x936, x934, x863, x910);
  let mut x937: u32 = 0;
  let mut x938: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x937, &mut x938, x936, x865, x912);
  let mut x939: u32 = 0;
  let mut x940: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x939, &mut x940, x938, x867, x914);
  let mut x941: u32 = 0;
  let mut x942: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x941, &mut x942, x940, x869, x916);
  let mut x943: u32 = 0;
  let mut x944: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x943, &mut x944, x942, x871, x918);
  let mut x945: u32 = 0;
  let mut x946: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x945, &mut x946, x944, x873, x920);
  let mut x947: u32 = 0;
  let mut x948: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x947, &mut x948, x946, x875, x922);
  let mut x949: u32 = 0;
  let mut x950: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x949, &mut x950, x948, x877, x924);
  let mut x951: u32 = 0;
  let mut x952: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x951, &mut x952, x950, x879, x926);
  let mut x953: u32 = 0;
  let mut x954: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x953, &mut x954, x927, 0xe88fdc45);
  let mut x955: u32 = 0;
  let mut x956: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x955, &mut x956, x953, 0xffffffff);
  let mut x957: u32 = 0;
  let mut x958: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x957, &mut x958, x953, 0xffffffff);
  let mut x959: u32 = 0;
  let mut x960: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x959, &mut x960, x953, 0xffffffff);
  let mut x961: u32 = 0;
  let mut x962: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x961, &mut x962, x953, 0xffffffff);
  let mut x963: u32 = 0;
  let mut x964: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x963, &mut x964, x953, 0xffffffff);
  let mut x965: u32 = 0;
  let mut x966: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x965, &mut x966, x953, 0xffffffff);
  let mut x967: u32 = 0;
  let mut x968: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x967, &mut x968, x953, 0xc7634d81);
  let mut x969: u32 = 0;
  let mut x970: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x969, &mut x970, x953, 0xf4372ddf);
  let mut x971: u32 = 0;
  let mut x972: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x971, &mut x972, x953, 0x581a0db2);
  let mut x973: u32 = 0;
  let mut x974: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x973, &mut x974, x953, 0x48b0a77a);
  let mut x975: u32 = 0;
  let mut x976: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x975, &mut x976, x953, 0xecec196a);
  let mut x977: u32 = 0;
  let mut x978: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x977, &mut x978, x953, 0xccc52973);
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x979, &mut x980, 0x0, x978, x975);
  let mut x981: u32 = 0;
  let mut x982: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x981, &mut x982, x980, x976, x973);
  let mut x983: u32 = 0;
  let mut x984: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x983, &mut x984, x982, x974, x971);
  let mut x985: u32 = 0;
  let mut x986: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x985, &mut x986, x984, x972, x969);
  let mut x987: u32 = 0;
  let mut x988: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x987, &mut x988, x986, x970, x967);
  let mut x989: u32 = 0;
  let mut x990: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x989, &mut x990, x988, x968, x965);
  let mut x991: u32 = 0;
  let mut x992: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x991, &mut x992, x990, x966, x963);
  let mut x993: u32 = 0;
  let mut x994: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x993, &mut x994, x992, x964, x961);
  let mut x995: u32 = 0;
  let mut x996: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x995, &mut x996, x994, x962, x959);
  let mut x997: u32 = 0;
  let mut x998: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x997, &mut x998, x996, x960, x957);
  let mut x999: u32 = 0;
  let mut x1000: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x999, &mut x1000, x998, x958, x955);
  let x1001: u32 = ((x1000 as u32) + x956);
  let mut x1002: u32 = 0;
  let mut x1003: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1002, &mut x1003, 0x0, x927, x977);
  let mut x1004: u32 = 0;
  let mut x1005: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1004, &mut x1005, x1003, x929, x979);
  let mut x1006: u32 = 0;
  let mut x1007: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1006, &mut x1007, x1005, x931, x981);
  let mut x1008: u32 = 0;
  let mut x1009: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1008, &mut x1009, x1007, x933, x983);
  let mut x1010: u32 = 0;
  let mut x1011: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1010, &mut x1011, x1009, x935, x985);
  let mut x1012: u32 = 0;
  let mut x1013: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1012, &mut x1013, x1011, x937, x987);
  let mut x1014: u32 = 0;
  let mut x1015: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1014, &mut x1015, x1013, x939, x989);
  let mut x1016: u32 = 0;
  let mut x1017: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1016, &mut x1017, x1015, x941, x991);
  let mut x1018: u32 = 0;
  let mut x1019: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1018, &mut x1019, x1017, x943, x993);
  let mut x1020: u32 = 0;
  let mut x1021: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1020, &mut x1021, x1019, x945, x995);
  let mut x1022: u32 = 0;
  let mut x1023: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1022, &mut x1023, x1021, x947, x997);
  let mut x1024: u32 = 0;
  let mut x1025: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1024, &mut x1025, x1023, x949, x999);
  let mut x1026: u32 = 0;
  let mut x1027: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1026, &mut x1027, x1025, x951, x1001);
  let x1028: u32 = ((x1027 as u32) + (x952 as u32));
  let mut x1029: u32 = 0;
  let mut x1030: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1029, &mut x1030, x7, (arg2[11]));
  let mut x1031: u32 = 0;
  let mut x1032: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1031, &mut x1032, x7, (arg2[10]));
  let mut x1033: u32 = 0;
  let mut x1034: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1033, &mut x1034, x7, (arg2[9]));
  let mut x1035: u32 = 0;
  let mut x1036: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1035, &mut x1036, x7, (arg2[8]));
  let mut x1037: u32 = 0;
  let mut x1038: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1037, &mut x1038, x7, (arg2[7]));
  let mut x1039: u32 = 0;
  let mut x1040: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1039, &mut x1040, x7, (arg2[6]));
  let mut x1041: u32 = 0;
  let mut x1042: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1041, &mut x1042, x7, (arg2[5]));
  let mut x1043: u32 = 0;
  let mut x1044: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1043, &mut x1044, x7, (arg2[4]));
  let mut x1045: u32 = 0;
  let mut x1046: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1045, &mut x1046, x7, (arg2[3]));
  let mut x1047: u32 = 0;
  let mut x1048: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1047, &mut x1048, x7, (arg2[2]));
  let mut x1049: u32 = 0;
  let mut x1050: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1049, &mut x1050, x7, (arg2[1]));
  let mut x1051: u32 = 0;
  let mut x1052: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1051, &mut x1052, x7, (arg2[0]));
  let mut x1053: u32 = 0;
  let mut x1054: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1053, &mut x1054, 0x0, x1052, x1049);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1055, &mut x1056, x1054, x1050, x1047);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1057, &mut x1058, x1056, x1048, x1045);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1059, &mut x1060, x1058, x1046, x1043);
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1061, &mut x1062, x1060, x1044, x1041);
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1063, &mut x1064, x1062, x1042, x1039);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1065, &mut x1066, x1064, x1040, x1037);
  let mut x1067: u32 = 0;
  let mut x1068: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1067, &mut x1068, x1066, x1038, x1035);
  let mut x1069: u32 = 0;
  let mut x1070: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1069, &mut x1070, x1068, x1036, x1033);
  let mut x1071: u32 = 0;
  let mut x1072: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1071, &mut x1072, x1070, x1034, x1031);
  let mut x1073: u32 = 0;
  let mut x1074: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1073, &mut x1074, x1072, x1032, x1029);
  let x1075: u32 = ((x1074 as u32) + x1030);
  let mut x1076: u32 = 0;
  let mut x1077: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1076, &mut x1077, 0x0, x1004, x1051);
  let mut x1078: u32 = 0;
  let mut x1079: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1078, &mut x1079, x1077, x1006, x1053);
  let mut x1080: u32 = 0;
  let mut x1081: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1080, &mut x1081, x1079, x1008, x1055);
  let mut x1082: u32 = 0;
  let mut x1083: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1082, &mut x1083, x1081, x1010, x1057);
  let mut x1084: u32 = 0;
  let mut x1085: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1084, &mut x1085, x1083, x1012, x1059);
  let mut x1086: u32 = 0;
  let mut x1087: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1086, &mut x1087, x1085, x1014, x1061);
  let mut x1088: u32 = 0;
  let mut x1089: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1088, &mut x1089, x1087, x1016, x1063);
  let mut x1090: u32 = 0;
  let mut x1091: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1090, &mut x1091, x1089, x1018, x1065);
  let mut x1092: u32 = 0;
  let mut x1093: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1092, &mut x1093, x1091, x1020, x1067);
  let mut x1094: u32 = 0;
  let mut x1095: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1094, &mut x1095, x1093, x1022, x1069);
  let mut x1096: u32 = 0;
  let mut x1097: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1096, &mut x1097, x1095, x1024, x1071);
  let mut x1098: u32 = 0;
  let mut x1099: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1098, &mut x1099, x1097, x1026, x1073);
  let mut x1100: u32 = 0;
  let mut x1101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1100, &mut x1101, x1099, x1028, x1075);
  let mut x1102: u32 = 0;
  let mut x1103: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1102, &mut x1103, x1076, 0xe88fdc45);
  let mut x1104: u32 = 0;
  let mut x1105: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1104, &mut x1105, x1102, 0xffffffff);
  let mut x1106: u32 = 0;
  let mut x1107: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1106, &mut x1107, x1102, 0xffffffff);
  let mut x1108: u32 = 0;
  let mut x1109: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1108, &mut x1109, x1102, 0xffffffff);
  let mut x1110: u32 = 0;
  let mut x1111: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1110, &mut x1111, x1102, 0xffffffff);
  let mut x1112: u32 = 0;
  let mut x1113: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1112, &mut x1113, x1102, 0xffffffff);
  let mut x1114: u32 = 0;
  let mut x1115: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1114, &mut x1115, x1102, 0xffffffff);
  let mut x1116: u32 = 0;
  let mut x1117: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1116, &mut x1117, x1102, 0xc7634d81);
  let mut x1118: u32 = 0;
  let mut x1119: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1118, &mut x1119, x1102, 0xf4372ddf);
  let mut x1120: u32 = 0;
  let mut x1121: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1120, &mut x1121, x1102, 0x581a0db2);
  let mut x1122: u32 = 0;
  let mut x1123: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1122, &mut x1123, x1102, 0x48b0a77a);
  let mut x1124: u32 = 0;
  let mut x1125: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1124, &mut x1125, x1102, 0xecec196a);
  let mut x1126: u32 = 0;
  let mut x1127: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1126, &mut x1127, x1102, 0xccc52973);
  let mut x1128: u32 = 0;
  let mut x1129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1128, &mut x1129, 0x0, x1127, x1124);
  let mut x1130: u32 = 0;
  let mut x1131: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1130, &mut x1131, x1129, x1125, x1122);
  let mut x1132: u32 = 0;
  let mut x1133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1132, &mut x1133, x1131, x1123, x1120);
  let mut x1134: u32 = 0;
  let mut x1135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1134, &mut x1135, x1133, x1121, x1118);
  let mut x1136: u32 = 0;
  let mut x1137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1136, &mut x1137, x1135, x1119, x1116);
  let mut x1138: u32 = 0;
  let mut x1139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1138, &mut x1139, x1137, x1117, x1114);
  let mut x1140: u32 = 0;
  let mut x1141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1140, &mut x1141, x1139, x1115, x1112);
  let mut x1142: u32 = 0;
  let mut x1143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1142, &mut x1143, x1141, x1113, x1110);
  let mut x1144: u32 = 0;
  let mut x1145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1144, &mut x1145, x1143, x1111, x1108);
  let mut x1146: u32 = 0;
  let mut x1147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1146, &mut x1147, x1145, x1109, x1106);
  let mut x1148: u32 = 0;
  let mut x1149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1148, &mut x1149, x1147, x1107, x1104);
  let x1150: u32 = ((x1149 as u32) + x1105);
  let mut x1151: u32 = 0;
  let mut x1152: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1151, &mut x1152, 0x0, x1076, x1126);
  let mut x1153: u32 = 0;
  let mut x1154: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1153, &mut x1154, x1152, x1078, x1128);
  let mut x1155: u32 = 0;
  let mut x1156: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1155, &mut x1156, x1154, x1080, x1130);
  let mut x1157: u32 = 0;
  let mut x1158: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1157, &mut x1158, x1156, x1082, x1132);
  let mut x1159: u32 = 0;
  let mut x1160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1159, &mut x1160, x1158, x1084, x1134);
  let mut x1161: u32 = 0;
  let mut x1162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1161, &mut x1162, x1160, x1086, x1136);
  let mut x1163: u32 = 0;
  let mut x1164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1163, &mut x1164, x1162, x1088, x1138);
  let mut x1165: u32 = 0;
  let mut x1166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1165, &mut x1166, x1164, x1090, x1140);
  let mut x1167: u32 = 0;
  let mut x1168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1167, &mut x1168, x1166, x1092, x1142);
  let mut x1169: u32 = 0;
  let mut x1170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1169, &mut x1170, x1168, x1094, x1144);
  let mut x1171: u32 = 0;
  let mut x1172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1171, &mut x1172, x1170, x1096, x1146);
  let mut x1173: u32 = 0;
  let mut x1174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1173, &mut x1174, x1172, x1098, x1148);
  let mut x1175: u32 = 0;
  let mut x1176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1175, &mut x1176, x1174, x1100, x1150);
  let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
  let mut x1178: u32 = 0;
  let mut x1179: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1178, &mut x1179, x8, (arg2[11]));
  let mut x1180: u32 = 0;
  let mut x1181: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1180, &mut x1181, x8, (arg2[10]));
  let mut x1182: u32 = 0;
  let mut x1183: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1182, &mut x1183, x8, (arg2[9]));
  let mut x1184: u32 = 0;
  let mut x1185: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1184, &mut x1185, x8, (arg2[8]));
  let mut x1186: u32 = 0;
  let mut x1187: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1186, &mut x1187, x8, (arg2[7]));
  let mut x1188: u32 = 0;
  let mut x1189: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1188, &mut x1189, x8, (arg2[6]));
  let mut x1190: u32 = 0;
  let mut x1191: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1190, &mut x1191, x8, (arg2[5]));
  let mut x1192: u32 = 0;
  let mut x1193: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1192, &mut x1193, x8, (arg2[4]));
  let mut x1194: u32 = 0;
  let mut x1195: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1194, &mut x1195, x8, (arg2[3]));
  let mut x1196: u32 = 0;
  let mut x1197: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1196, &mut x1197, x8, (arg2[2]));
  let mut x1198: u32 = 0;
  let mut x1199: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1198, &mut x1199, x8, (arg2[1]));
  let mut x1200: u32 = 0;
  let mut x1201: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1200, &mut x1201, x8, (arg2[0]));
  let mut x1202: u32 = 0;
  let mut x1203: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1202, &mut x1203, 0x0, x1201, x1198);
  let mut x1204: u32 = 0;
  let mut x1205: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1204, &mut x1205, x1203, x1199, x1196);
  let mut x1206: u32 = 0;
  let mut x1207: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1206, &mut x1207, x1205, x1197, x1194);
  let mut x1208: u32 = 0;
  let mut x1209: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1208, &mut x1209, x1207, x1195, x1192);
  let mut x1210: u32 = 0;
  let mut x1211: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1210, &mut x1211, x1209, x1193, x1190);
  let mut x1212: u32 = 0;
  let mut x1213: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1212, &mut x1213, x1211, x1191, x1188);
  let mut x1214: u32 = 0;
  let mut x1215: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1214, &mut x1215, x1213, x1189, x1186);
  let mut x1216: u32 = 0;
  let mut x1217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1216, &mut x1217, x1215, x1187, x1184);
  let mut x1218: u32 = 0;
  let mut x1219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1218, &mut x1219, x1217, x1185, x1182);
  let mut x1220: u32 = 0;
  let mut x1221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1220, &mut x1221, x1219, x1183, x1180);
  let mut x1222: u32 = 0;
  let mut x1223: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1222, &mut x1223, x1221, x1181, x1178);
  let x1224: u32 = ((x1223 as u32) + x1179);
  let mut x1225: u32 = 0;
  let mut x1226: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1225, &mut x1226, 0x0, x1153, x1200);
  let mut x1227: u32 = 0;
  let mut x1228: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1227, &mut x1228, x1226, x1155, x1202);
  let mut x1229: u32 = 0;
  let mut x1230: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1229, &mut x1230, x1228, x1157, x1204);
  let mut x1231: u32 = 0;
  let mut x1232: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1231, &mut x1232, x1230, x1159, x1206);
  let mut x1233: u32 = 0;
  let mut x1234: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1233, &mut x1234, x1232, x1161, x1208);
  let mut x1235: u32 = 0;
  let mut x1236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1235, &mut x1236, x1234, x1163, x1210);
  let mut x1237: u32 = 0;
  let mut x1238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1237, &mut x1238, x1236, x1165, x1212);
  let mut x1239: u32 = 0;
  let mut x1240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1239, &mut x1240, x1238, x1167, x1214);
  let mut x1241: u32 = 0;
  let mut x1242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1241, &mut x1242, x1240, x1169, x1216);
  let mut x1243: u32 = 0;
  let mut x1244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1243, &mut x1244, x1242, x1171, x1218);
  let mut x1245: u32 = 0;
  let mut x1246: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1245, &mut x1246, x1244, x1173, x1220);
  let mut x1247: u32 = 0;
  let mut x1248: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1247, &mut x1248, x1246, x1175, x1222);
  let mut x1249: u32 = 0;
  let mut x1250: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1249, &mut x1250, x1248, x1177, x1224);
  let mut x1251: u32 = 0;
  let mut x1252: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1251, &mut x1252, x1225, 0xe88fdc45);
  let mut x1253: u32 = 0;
  let mut x1254: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1253, &mut x1254, x1251, 0xffffffff);
  let mut x1255: u32 = 0;
  let mut x1256: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1255, &mut x1256, x1251, 0xffffffff);
  let mut x1257: u32 = 0;
  let mut x1258: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1257, &mut x1258, x1251, 0xffffffff);
  let mut x1259: u32 = 0;
  let mut x1260: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1259, &mut x1260, x1251, 0xffffffff);
  let mut x1261: u32 = 0;
  let mut x1262: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1261, &mut x1262, x1251, 0xffffffff);
  let mut x1263: u32 = 0;
  let mut x1264: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1263, &mut x1264, x1251, 0xffffffff);
  let mut x1265: u32 = 0;
  let mut x1266: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1265, &mut x1266, x1251, 0xc7634d81);
  let mut x1267: u32 = 0;
  let mut x1268: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1267, &mut x1268, x1251, 0xf4372ddf);
  let mut x1269: u32 = 0;
  let mut x1270: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1269, &mut x1270, x1251, 0x581a0db2);
  let mut x1271: u32 = 0;
  let mut x1272: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1271, &mut x1272, x1251, 0x48b0a77a);
  let mut x1273: u32 = 0;
  let mut x1274: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1273, &mut x1274, x1251, 0xecec196a);
  let mut x1275: u32 = 0;
  let mut x1276: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1275, &mut x1276, x1251, 0xccc52973);
  let mut x1277: u32 = 0;
  let mut x1278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1277, &mut x1278, 0x0, x1276, x1273);
  let mut x1279: u32 = 0;
  let mut x1280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1279, &mut x1280, x1278, x1274, x1271);
  let mut x1281: u32 = 0;
  let mut x1282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1281, &mut x1282, x1280, x1272, x1269);
  let mut x1283: u32 = 0;
  let mut x1284: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1283, &mut x1284, x1282, x1270, x1267);
  let mut x1285: u32 = 0;
  let mut x1286: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1285, &mut x1286, x1284, x1268, x1265);
  let mut x1287: u32 = 0;
  let mut x1288: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1287, &mut x1288, x1286, x1266, x1263);
  let mut x1289: u32 = 0;
  let mut x1290: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1289, &mut x1290, x1288, x1264, x1261);
  let mut x1291: u32 = 0;
  let mut x1292: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1291, &mut x1292, x1290, x1262, x1259);
  let mut x1293: u32 = 0;
  let mut x1294: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1293, &mut x1294, x1292, x1260, x1257);
  let mut x1295: u32 = 0;
  let mut x1296: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1295, &mut x1296, x1294, x1258, x1255);
  let mut x1297: u32 = 0;
  let mut x1298: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1297, &mut x1298, x1296, x1256, x1253);
  let x1299: u32 = ((x1298 as u32) + x1254);
  let mut x1300: u32 = 0;
  let mut x1301: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1300, &mut x1301, 0x0, x1225, x1275);
  let mut x1302: u32 = 0;
  let mut x1303: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1302, &mut x1303, x1301, x1227, x1277);
  let mut x1304: u32 = 0;
  let mut x1305: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1304, &mut x1305, x1303, x1229, x1279);
  let mut x1306: u32 = 0;
  let mut x1307: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1306, &mut x1307, x1305, x1231, x1281);
  let mut x1308: u32 = 0;
  let mut x1309: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1308, &mut x1309, x1307, x1233, x1283);
  let mut x1310: u32 = 0;
  let mut x1311: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1310, &mut x1311, x1309, x1235, x1285);
  let mut x1312: u32 = 0;
  let mut x1313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1312, &mut x1313, x1311, x1237, x1287);
  let mut x1314: u32 = 0;
  let mut x1315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1314, &mut x1315, x1313, x1239, x1289);
  let mut x1316: u32 = 0;
  let mut x1317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1316, &mut x1317, x1315, x1241, x1291);
  let mut x1318: u32 = 0;
  let mut x1319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1318, &mut x1319, x1317, x1243, x1293);
  let mut x1320: u32 = 0;
  let mut x1321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1320, &mut x1321, x1319, x1245, x1295);
  let mut x1322: u32 = 0;
  let mut x1323: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1322, &mut x1323, x1321, x1247, x1297);
  let mut x1324: u32 = 0;
  let mut x1325: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1324, &mut x1325, x1323, x1249, x1299);
  let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
  let mut x1327: u32 = 0;
  let mut x1328: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1327, &mut x1328, x9, (arg2[11]));
  let mut x1329: u32 = 0;
  let mut x1330: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1329, &mut x1330, x9, (arg2[10]));
  let mut x1331: u32 = 0;
  let mut x1332: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1331, &mut x1332, x9, (arg2[9]));
  let mut x1333: u32 = 0;
  let mut x1334: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1333, &mut x1334, x9, (arg2[8]));
  let mut x1335: u32 = 0;
  let mut x1336: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1335, &mut x1336, x9, (arg2[7]));
  let mut x1337: u32 = 0;
  let mut x1338: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1337, &mut x1338, x9, (arg2[6]));
  let mut x1339: u32 = 0;
  let mut x1340: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1339, &mut x1340, x9, (arg2[5]));
  let mut x1341: u32 = 0;
  let mut x1342: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1341, &mut x1342, x9, (arg2[4]));
  let mut x1343: u32 = 0;
  let mut x1344: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1343, &mut x1344, x9, (arg2[3]));
  let mut x1345: u32 = 0;
  let mut x1346: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1345, &mut x1346, x9, (arg2[2]));
  let mut x1347: u32 = 0;
  let mut x1348: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1347, &mut x1348, x9, (arg2[1]));
  let mut x1349: u32 = 0;
  let mut x1350: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1349, &mut x1350, x9, (arg2[0]));
  let mut x1351: u32 = 0;
  let mut x1352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1351, &mut x1352, 0x0, x1350, x1347);
  let mut x1353: u32 = 0;
  let mut x1354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1353, &mut x1354, x1352, x1348, x1345);
  let mut x1355: u32 = 0;
  let mut x1356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1355, &mut x1356, x1354, x1346, x1343);
  let mut x1357: u32 = 0;
  let mut x1358: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1357, &mut x1358, x1356, x1344, x1341);
  let mut x1359: u32 = 0;
  let mut x1360: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1359, &mut x1360, x1358, x1342, x1339);
  let mut x1361: u32 = 0;
  let mut x1362: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1361, &mut x1362, x1360, x1340, x1337);
  let mut x1363: u32 = 0;
  let mut x1364: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1363, &mut x1364, x1362, x1338, x1335);
  let mut x1365: u32 = 0;
  let mut x1366: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1365, &mut x1366, x1364, x1336, x1333);
  let mut x1367: u32 = 0;
  let mut x1368: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1367, &mut x1368, x1366, x1334, x1331);
  let mut x1369: u32 = 0;
  let mut x1370: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1369, &mut x1370, x1368, x1332, x1329);
  let mut x1371: u32 = 0;
  let mut x1372: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1371, &mut x1372, x1370, x1330, x1327);
  let x1373: u32 = ((x1372 as u32) + x1328);
  let mut x1374: u32 = 0;
  let mut x1375: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1374, &mut x1375, 0x0, x1302, x1349);
  let mut x1376: u32 = 0;
  let mut x1377: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1376, &mut x1377, x1375, x1304, x1351);
  let mut x1378: u32 = 0;
  let mut x1379: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1378, &mut x1379, x1377, x1306, x1353);
  let mut x1380: u32 = 0;
  let mut x1381: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1380, &mut x1381, x1379, x1308, x1355);
  let mut x1382: u32 = 0;
  let mut x1383: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1382, &mut x1383, x1381, x1310, x1357);
  let mut x1384: u32 = 0;
  let mut x1385: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1384, &mut x1385, x1383, x1312, x1359);
  let mut x1386: u32 = 0;
  let mut x1387: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1386, &mut x1387, x1385, x1314, x1361);
  let mut x1388: u32 = 0;
  let mut x1389: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1388, &mut x1389, x1387, x1316, x1363);
  let mut x1390: u32 = 0;
  let mut x1391: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1390, &mut x1391, x1389, x1318, x1365);
  let mut x1392: u32 = 0;
  let mut x1393: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1392, &mut x1393, x1391, x1320, x1367);
  let mut x1394: u32 = 0;
  let mut x1395: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1394, &mut x1395, x1393, x1322, x1369);
  let mut x1396: u32 = 0;
  let mut x1397: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1396, &mut x1397, x1395, x1324, x1371);
  let mut x1398: u32 = 0;
  let mut x1399: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1398, &mut x1399, x1397, x1326, x1373);
  let mut x1400: u32 = 0;
  let mut x1401: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1400, &mut x1401, x1374, 0xe88fdc45);
  let mut x1402: u32 = 0;
  let mut x1403: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1402, &mut x1403, x1400, 0xffffffff);
  let mut x1404: u32 = 0;
  let mut x1405: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1404, &mut x1405, x1400, 0xffffffff);
  let mut x1406: u32 = 0;
  let mut x1407: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1406, &mut x1407, x1400, 0xffffffff);
  let mut x1408: u32 = 0;
  let mut x1409: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1408, &mut x1409, x1400, 0xffffffff);
  let mut x1410: u32 = 0;
  let mut x1411: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1410, &mut x1411, x1400, 0xffffffff);
  let mut x1412: u32 = 0;
  let mut x1413: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1412, &mut x1413, x1400, 0xffffffff);
  let mut x1414: u32 = 0;
  let mut x1415: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1414, &mut x1415, x1400, 0xc7634d81);
  let mut x1416: u32 = 0;
  let mut x1417: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1416, &mut x1417, x1400, 0xf4372ddf);
  let mut x1418: u32 = 0;
  let mut x1419: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1418, &mut x1419, x1400, 0x581a0db2);
  let mut x1420: u32 = 0;
  let mut x1421: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1420, &mut x1421, x1400, 0x48b0a77a);
  let mut x1422: u32 = 0;
  let mut x1423: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1422, &mut x1423, x1400, 0xecec196a);
  let mut x1424: u32 = 0;
  let mut x1425: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1424, &mut x1425, x1400, 0xccc52973);
  let mut x1426: u32 = 0;
  let mut x1427: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1426, &mut x1427, 0x0, x1425, x1422);
  let mut x1428: u32 = 0;
  let mut x1429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1428, &mut x1429, x1427, x1423, x1420);
  let mut x1430: u32 = 0;
  let mut x1431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1430, &mut x1431, x1429, x1421, x1418);
  let mut x1432: u32 = 0;
  let mut x1433: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1432, &mut x1433, x1431, x1419, x1416);
  let mut x1434: u32 = 0;
  let mut x1435: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1434, &mut x1435, x1433, x1417, x1414);
  let mut x1436: u32 = 0;
  let mut x1437: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1436, &mut x1437, x1435, x1415, x1412);
  let mut x1438: u32 = 0;
  let mut x1439: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1438, &mut x1439, x1437, x1413, x1410);
  let mut x1440: u32 = 0;
  let mut x1441: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1440, &mut x1441, x1439, x1411, x1408);
  let mut x1442: u32 = 0;
  let mut x1443: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1442, &mut x1443, x1441, x1409, x1406);
  let mut x1444: u32 = 0;
  let mut x1445: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1444, &mut x1445, x1443, x1407, x1404);
  let mut x1446: u32 = 0;
  let mut x1447: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1446, &mut x1447, x1445, x1405, x1402);
  let x1448: u32 = ((x1447 as u32) + x1403);
  let mut x1449: u32 = 0;
  let mut x1450: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1449, &mut x1450, 0x0, x1374, x1424);
  let mut x1451: u32 = 0;
  let mut x1452: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1451, &mut x1452, x1450, x1376, x1426);
  let mut x1453: u32 = 0;
  let mut x1454: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1453, &mut x1454, x1452, x1378, x1428);
  let mut x1455: u32 = 0;
  let mut x1456: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1455, &mut x1456, x1454, x1380, x1430);
  let mut x1457: u32 = 0;
  let mut x1458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1457, &mut x1458, x1456, x1382, x1432);
  let mut x1459: u32 = 0;
  let mut x1460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1459, &mut x1460, x1458, x1384, x1434);
  let mut x1461: u32 = 0;
  let mut x1462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1461, &mut x1462, x1460, x1386, x1436);
  let mut x1463: u32 = 0;
  let mut x1464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1463, &mut x1464, x1462, x1388, x1438);
  let mut x1465: u32 = 0;
  let mut x1466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1465, &mut x1466, x1464, x1390, x1440);
  let mut x1467: u32 = 0;
  let mut x1468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1467, &mut x1468, x1466, x1392, x1442);
  let mut x1469: u32 = 0;
  let mut x1470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1469, &mut x1470, x1468, x1394, x1444);
  let mut x1471: u32 = 0;
  let mut x1472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1471, &mut x1472, x1470, x1396, x1446);
  let mut x1473: u32 = 0;
  let mut x1474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1473, &mut x1474, x1472, x1398, x1448);
  let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
  let mut x1476: u32 = 0;
  let mut x1477: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1476, &mut x1477, x10, (arg2[11]));
  let mut x1478: u32 = 0;
  let mut x1479: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1478, &mut x1479, x10, (arg2[10]));
  let mut x1480: u32 = 0;
  let mut x1481: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1480, &mut x1481, x10, (arg2[9]));
  let mut x1482: u32 = 0;
  let mut x1483: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1482, &mut x1483, x10, (arg2[8]));
  let mut x1484: u32 = 0;
  let mut x1485: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1484, &mut x1485, x10, (arg2[7]));
  let mut x1486: u32 = 0;
  let mut x1487: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1486, &mut x1487, x10, (arg2[6]));
  let mut x1488: u32 = 0;
  let mut x1489: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1488, &mut x1489, x10, (arg2[5]));
  let mut x1490: u32 = 0;
  let mut x1491: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1490, &mut x1491, x10, (arg2[4]));
  let mut x1492: u32 = 0;
  let mut x1493: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1492, &mut x1493, x10, (arg2[3]));
  let mut x1494: u32 = 0;
  let mut x1495: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1494, &mut x1495, x10, (arg2[2]));
  let mut x1496: u32 = 0;
  let mut x1497: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1496, &mut x1497, x10, (arg2[1]));
  let mut x1498: u32 = 0;
  let mut x1499: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1498, &mut x1499, x10, (arg2[0]));
  let mut x1500: u32 = 0;
  let mut x1501: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1500, &mut x1501, 0x0, x1499, x1496);
  let mut x1502: u32 = 0;
  let mut x1503: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1502, &mut x1503, x1501, x1497, x1494);
  let mut x1504: u32 = 0;
  let mut x1505: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1504, &mut x1505, x1503, x1495, x1492);
  let mut x1506: u32 = 0;
  let mut x1507: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1506, &mut x1507, x1505, x1493, x1490);
  let mut x1508: u32 = 0;
  let mut x1509: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1508, &mut x1509, x1507, x1491, x1488);
  let mut x1510: u32 = 0;
  let mut x1511: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1510, &mut x1511, x1509, x1489, x1486);
  let mut x1512: u32 = 0;
  let mut x1513: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1512, &mut x1513, x1511, x1487, x1484);
  let mut x1514: u32 = 0;
  let mut x1515: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1514, &mut x1515, x1513, x1485, x1482);
  let mut x1516: u32 = 0;
  let mut x1517: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1516, &mut x1517, x1515, x1483, x1480);
  let mut x1518: u32 = 0;
  let mut x1519: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1518, &mut x1519, x1517, x1481, x1478);
  let mut x1520: u32 = 0;
  let mut x1521: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1520, &mut x1521, x1519, x1479, x1476);
  let x1522: u32 = ((x1521 as u32) + x1477);
  let mut x1523: u32 = 0;
  let mut x1524: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1523, &mut x1524, 0x0, x1451, x1498);
  let mut x1525: u32 = 0;
  let mut x1526: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1525, &mut x1526, x1524, x1453, x1500);
  let mut x1527: u32 = 0;
  let mut x1528: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1527, &mut x1528, x1526, x1455, x1502);
  let mut x1529: u32 = 0;
  let mut x1530: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1529, &mut x1530, x1528, x1457, x1504);
  let mut x1531: u32 = 0;
  let mut x1532: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1531, &mut x1532, x1530, x1459, x1506);
  let mut x1533: u32 = 0;
  let mut x1534: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1533, &mut x1534, x1532, x1461, x1508);
  let mut x1535: u32 = 0;
  let mut x1536: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1535, &mut x1536, x1534, x1463, x1510);
  let mut x1537: u32 = 0;
  let mut x1538: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1537, &mut x1538, x1536, x1465, x1512);
  let mut x1539: u32 = 0;
  let mut x1540: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1539, &mut x1540, x1538, x1467, x1514);
  let mut x1541: u32 = 0;
  let mut x1542: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1541, &mut x1542, x1540, x1469, x1516);
  let mut x1543: u32 = 0;
  let mut x1544: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1543, &mut x1544, x1542, x1471, x1518);
  let mut x1545: u32 = 0;
  let mut x1546: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1545, &mut x1546, x1544, x1473, x1520);
  let mut x1547: u32 = 0;
  let mut x1548: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1547, &mut x1548, x1546, x1475, x1522);
  let mut x1549: u32 = 0;
  let mut x1550: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1549, &mut x1550, x1523, 0xe88fdc45);
  let mut x1551: u32 = 0;
  let mut x1552: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1551, &mut x1552, x1549, 0xffffffff);
  let mut x1553: u32 = 0;
  let mut x1554: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1553, &mut x1554, x1549, 0xffffffff);
  let mut x1555: u32 = 0;
  let mut x1556: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1555, &mut x1556, x1549, 0xffffffff);
  let mut x1557: u32 = 0;
  let mut x1558: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1557, &mut x1558, x1549, 0xffffffff);
  let mut x1559: u32 = 0;
  let mut x1560: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1559, &mut x1560, x1549, 0xffffffff);
  let mut x1561: u32 = 0;
  let mut x1562: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1561, &mut x1562, x1549, 0xffffffff);
  let mut x1563: u32 = 0;
  let mut x1564: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1563, &mut x1564, x1549, 0xc7634d81);
  let mut x1565: u32 = 0;
  let mut x1566: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1565, &mut x1566, x1549, 0xf4372ddf);
  let mut x1567: u32 = 0;
  let mut x1568: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1567, &mut x1568, x1549, 0x581a0db2);
  let mut x1569: u32 = 0;
  let mut x1570: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1569, &mut x1570, x1549, 0x48b0a77a);
  let mut x1571: u32 = 0;
  let mut x1572: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1571, &mut x1572, x1549, 0xecec196a);
  let mut x1573: u32 = 0;
  let mut x1574: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1573, &mut x1574, x1549, 0xccc52973);
  let mut x1575: u32 = 0;
  let mut x1576: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1575, &mut x1576, 0x0, x1574, x1571);
  let mut x1577: u32 = 0;
  let mut x1578: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1577, &mut x1578, x1576, x1572, x1569);
  let mut x1579: u32 = 0;
  let mut x1580: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1579, &mut x1580, x1578, x1570, x1567);
  let mut x1581: u32 = 0;
  let mut x1582: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1581, &mut x1582, x1580, x1568, x1565);
  let mut x1583: u32 = 0;
  let mut x1584: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1583, &mut x1584, x1582, x1566, x1563);
  let mut x1585: u32 = 0;
  let mut x1586: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1585, &mut x1586, x1584, x1564, x1561);
  let mut x1587: u32 = 0;
  let mut x1588: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1587, &mut x1588, x1586, x1562, x1559);
  let mut x1589: u32 = 0;
  let mut x1590: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1589, &mut x1590, x1588, x1560, x1557);
  let mut x1591: u32 = 0;
  let mut x1592: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1591, &mut x1592, x1590, x1558, x1555);
  let mut x1593: u32 = 0;
  let mut x1594: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1593, &mut x1594, x1592, x1556, x1553);
  let mut x1595: u32 = 0;
  let mut x1596: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1595, &mut x1596, x1594, x1554, x1551);
  let x1597: u32 = ((x1596 as u32) + x1552);
  let mut x1598: u32 = 0;
  let mut x1599: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1598, &mut x1599, 0x0, x1523, x1573);
  let mut x1600: u32 = 0;
  let mut x1601: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1600, &mut x1601, x1599, x1525, x1575);
  let mut x1602: u32 = 0;
  let mut x1603: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1602, &mut x1603, x1601, x1527, x1577);
  let mut x1604: u32 = 0;
  let mut x1605: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1604, &mut x1605, x1603, x1529, x1579);
  let mut x1606: u32 = 0;
  let mut x1607: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1606, &mut x1607, x1605, x1531, x1581);
  let mut x1608: u32 = 0;
  let mut x1609: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1608, &mut x1609, x1607, x1533, x1583);
  let mut x1610: u32 = 0;
  let mut x1611: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1610, &mut x1611, x1609, x1535, x1585);
  let mut x1612: u32 = 0;
  let mut x1613: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1612, &mut x1613, x1611, x1537, x1587);
  let mut x1614: u32 = 0;
  let mut x1615: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1614, &mut x1615, x1613, x1539, x1589);
  let mut x1616: u32 = 0;
  let mut x1617: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1616, &mut x1617, x1615, x1541, x1591);
  let mut x1618: u32 = 0;
  let mut x1619: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1618, &mut x1619, x1617, x1543, x1593);
  let mut x1620: u32 = 0;
  let mut x1621: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1620, &mut x1621, x1619, x1545, x1595);
  let mut x1622: u32 = 0;
  let mut x1623: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1622, &mut x1623, x1621, x1547, x1597);
  let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
  let mut x1625: u32 = 0;
  let mut x1626: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1625, &mut x1626, x11, (arg2[11]));
  let mut x1627: u32 = 0;
  let mut x1628: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1627, &mut x1628, x11, (arg2[10]));
  let mut x1629: u32 = 0;
  let mut x1630: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1629, &mut x1630, x11, (arg2[9]));
  let mut x1631: u32 = 0;
  let mut x1632: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1631, &mut x1632, x11, (arg2[8]));
  let mut x1633: u32 = 0;
  let mut x1634: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1633, &mut x1634, x11, (arg2[7]));
  let mut x1635: u32 = 0;
  let mut x1636: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1635, &mut x1636, x11, (arg2[6]));
  let mut x1637: u32 = 0;
  let mut x1638: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1637, &mut x1638, x11, (arg2[5]));
  let mut x1639: u32 = 0;
  let mut x1640: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1639, &mut x1640, x11, (arg2[4]));
  let mut x1641: u32 = 0;
  let mut x1642: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1641, &mut x1642, x11, (arg2[3]));
  let mut x1643: u32 = 0;
  let mut x1644: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1643, &mut x1644, x11, (arg2[2]));
  let mut x1645: u32 = 0;
  let mut x1646: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1645, &mut x1646, x11, (arg2[1]));
  let mut x1647: u32 = 0;
  let mut x1648: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1647, &mut x1648, x11, (arg2[0]));
  let mut x1649: u32 = 0;
  let mut x1650: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1649, &mut x1650, 0x0, x1648, x1645);
  let mut x1651: u32 = 0;
  let mut x1652: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1651, &mut x1652, x1650, x1646, x1643);
  let mut x1653: u32 = 0;
  let mut x1654: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1653, &mut x1654, x1652, x1644, x1641);
  let mut x1655: u32 = 0;
  let mut x1656: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1655, &mut x1656, x1654, x1642, x1639);
  let mut x1657: u32 = 0;
  let mut x1658: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1657, &mut x1658, x1656, x1640, x1637);
  let mut x1659: u32 = 0;
  let mut x1660: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1659, &mut x1660, x1658, x1638, x1635);
  let mut x1661: u32 = 0;
  let mut x1662: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1661, &mut x1662, x1660, x1636, x1633);
  let mut x1663: u32 = 0;
  let mut x1664: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1663, &mut x1664, x1662, x1634, x1631);
  let mut x1665: u32 = 0;
  let mut x1666: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1665, &mut x1666, x1664, x1632, x1629);
  let mut x1667: u32 = 0;
  let mut x1668: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1667, &mut x1668, x1666, x1630, x1627);
  let mut x1669: u32 = 0;
  let mut x1670: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1669, &mut x1670, x1668, x1628, x1625);
  let x1671: u32 = ((x1670 as u32) + x1626);
  let mut x1672: u32 = 0;
  let mut x1673: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1672, &mut x1673, 0x0, x1600, x1647);
  let mut x1674: u32 = 0;
  let mut x1675: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1674, &mut x1675, x1673, x1602, x1649);
  let mut x1676: u32 = 0;
  let mut x1677: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1676, &mut x1677, x1675, x1604, x1651);
  let mut x1678: u32 = 0;
  let mut x1679: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1678, &mut x1679, x1677, x1606, x1653);
  let mut x1680: u32 = 0;
  let mut x1681: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1680, &mut x1681, x1679, x1608, x1655);
  let mut x1682: u32 = 0;
  let mut x1683: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1682, &mut x1683, x1681, x1610, x1657);
  let mut x1684: u32 = 0;
  let mut x1685: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1684, &mut x1685, x1683, x1612, x1659);
  let mut x1686: u32 = 0;
  let mut x1687: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1686, &mut x1687, x1685, x1614, x1661);
  let mut x1688: u32 = 0;
  let mut x1689: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1688, &mut x1689, x1687, x1616, x1663);
  let mut x1690: u32 = 0;
  let mut x1691: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1690, &mut x1691, x1689, x1618, x1665);
  let mut x1692: u32 = 0;
  let mut x1693: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1692, &mut x1693, x1691, x1620, x1667);
  let mut x1694: u32 = 0;
  let mut x1695: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1694, &mut x1695, x1693, x1622, x1669);
  let mut x1696: u32 = 0;
  let mut x1697: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1696, &mut x1697, x1695, x1624, x1671);
  let mut x1698: u32 = 0;
  let mut x1699: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1698, &mut x1699, x1672, 0xe88fdc45);
  let mut x1700: u32 = 0;
  let mut x1701: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1700, &mut x1701, x1698, 0xffffffff);
  let mut x1702: u32 = 0;
  let mut x1703: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1702, &mut x1703, x1698, 0xffffffff);
  let mut x1704: u32 = 0;
  let mut x1705: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1704, &mut x1705, x1698, 0xffffffff);
  let mut x1706: u32 = 0;
  let mut x1707: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1706, &mut x1707, x1698, 0xffffffff);
  let mut x1708: u32 = 0;
  let mut x1709: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1708, &mut x1709, x1698, 0xffffffff);
  let mut x1710: u32 = 0;
  let mut x1711: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1710, &mut x1711, x1698, 0xffffffff);
  let mut x1712: u32 = 0;
  let mut x1713: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1712, &mut x1713, x1698, 0xc7634d81);
  let mut x1714: u32 = 0;
  let mut x1715: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1714, &mut x1715, x1698, 0xf4372ddf);
  let mut x1716: u32 = 0;
  let mut x1717: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1716, &mut x1717, x1698, 0x581a0db2);
  let mut x1718: u32 = 0;
  let mut x1719: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1718, &mut x1719, x1698, 0x48b0a77a);
  let mut x1720: u32 = 0;
  let mut x1721: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1720, &mut x1721, x1698, 0xecec196a);
  let mut x1722: u32 = 0;
  let mut x1723: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1722, &mut x1723, x1698, 0xccc52973);
  let mut x1724: u32 = 0;
  let mut x1725: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1724, &mut x1725, 0x0, x1723, x1720);
  let mut x1726: u32 = 0;
  let mut x1727: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1726, &mut x1727, x1725, x1721, x1718);
  let mut x1728: u32 = 0;
  let mut x1729: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1728, &mut x1729, x1727, x1719, x1716);
  let mut x1730: u32 = 0;
  let mut x1731: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1730, &mut x1731, x1729, x1717, x1714);
  let mut x1732: u32 = 0;
  let mut x1733: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1732, &mut x1733, x1731, x1715, x1712);
  let mut x1734: u32 = 0;
  let mut x1735: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1734, &mut x1735, x1733, x1713, x1710);
  let mut x1736: u32 = 0;
  let mut x1737: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1736, &mut x1737, x1735, x1711, x1708);
  let mut x1738: u32 = 0;
  let mut x1739: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1738, &mut x1739, x1737, x1709, x1706);
  let mut x1740: u32 = 0;
  let mut x1741: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1740, &mut x1741, x1739, x1707, x1704);
  let mut x1742: u32 = 0;
  let mut x1743: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1742, &mut x1743, x1741, x1705, x1702);
  let mut x1744: u32 = 0;
  let mut x1745: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1744, &mut x1745, x1743, x1703, x1700);
  let x1746: u32 = ((x1745 as u32) + x1701);
  let mut x1747: u32 = 0;
  let mut x1748: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1747, &mut x1748, 0x0, x1672, x1722);
  let mut x1749: u32 = 0;
  let mut x1750: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1749, &mut x1750, x1748, x1674, x1724);
  let mut x1751: u32 = 0;
  let mut x1752: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1751, &mut x1752, x1750, x1676, x1726);
  let mut x1753: u32 = 0;
  let mut x1754: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1753, &mut x1754, x1752, x1678, x1728);
  let mut x1755: u32 = 0;
  let mut x1756: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1755, &mut x1756, x1754, x1680, x1730);
  let mut x1757: u32 = 0;
  let mut x1758: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1757, &mut x1758, x1756, x1682, x1732);
  let mut x1759: u32 = 0;
  let mut x1760: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1759, &mut x1760, x1758, x1684, x1734);
  let mut x1761: u32 = 0;
  let mut x1762: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1761, &mut x1762, x1760, x1686, x1736);
  let mut x1763: u32 = 0;
  let mut x1764: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1763, &mut x1764, x1762, x1688, x1738);
  let mut x1765: u32 = 0;
  let mut x1766: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1765, &mut x1766, x1764, x1690, x1740);
  let mut x1767: u32 = 0;
  let mut x1768: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1767, &mut x1768, x1766, x1692, x1742);
  let mut x1769: u32 = 0;
  let mut x1770: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1769, &mut x1770, x1768, x1694, x1744);
  let mut x1771: u32 = 0;
  let mut x1772: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1771, &mut x1772, x1770, x1696, x1746);
  let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
  let mut x1774: u32 = 0;
  let mut x1775: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1774, &mut x1775, 0x0, x1749, 0xccc52973);
  let mut x1776: u32 = 0;
  let mut x1777: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1776, &mut x1777, x1775, x1751, 0xecec196a);
  let mut x1778: u32 = 0;
  let mut x1779: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1778, &mut x1779, x1777, x1753, 0x48b0a77a);
  let mut x1780: u32 = 0;
  let mut x1781: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1780, &mut x1781, x1779, x1755, 0x581a0db2);
  let mut x1782: u32 = 0;
  let mut x1783: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1782, &mut x1783, x1781, x1757, 0xf4372ddf);
  let mut x1784: u32 = 0;
  let mut x1785: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1784, &mut x1785, x1783, x1759, 0xc7634d81);
  let mut x1786: u32 = 0;
  let mut x1787: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1786, &mut x1787, x1785, x1761, 0xffffffff);
  let mut x1788: u32 = 0;
  let mut x1789: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1788, &mut x1789, x1787, x1763, 0xffffffff);
  let mut x1790: u32 = 0;
  let mut x1791: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1790, &mut x1791, x1789, x1765, 0xffffffff);
  let mut x1792: u32 = 0;
  let mut x1793: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1792, &mut x1793, x1791, x1767, 0xffffffff);
  let mut x1794: u32 = 0;
  let mut x1795: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1794, &mut x1795, x1793, x1769, 0xffffffff);
  let mut x1796: u32 = 0;
  let mut x1797: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1796, &mut x1797, x1795, x1771, 0xffffffff);
  let mut x1798: u32 = 0;
  let mut x1799: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1798, &mut x1799, x1797, x1773, (0x0 as u32));
  let mut x1800: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1800, x1799, x1774, x1749);
  let mut x1801: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1801, x1799, x1776, x1751);
  let mut x1802: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1802, x1799, x1778, x1753);
  let mut x1803: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1803, x1799, x1780, x1755);
  let mut x1804: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1804, x1799, x1782, x1757);
  let mut x1805: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1805, x1799, x1784, x1759);
  let mut x1806: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1806, x1799, x1786, x1761);
  let mut x1807: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1807, x1799, x1788, x1763);
  let mut x1808: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1808, x1799, x1790, x1765);
  let mut x1809: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1809, x1799, x1792, x1767);
  let mut x1810: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1810, x1799, x1794, x1769);
  let mut x1811: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1811, x1799, x1796, x1771);
  out1[0] = x1800;
  out1[1] = x1801;
  out1[2] = x1802;
  out1[3] = x1803;
  out1[4] = x1804;
  out1[5] = x1805;
  out1[6] = x1806;
  out1[7] = x1807;
  out1[8] = x1808;
  out1[9] = x1809;
  out1[10] = x1810;
  out1[11] = x1811;
}

/// The function fiat_p384_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_square(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x13, &mut x14, x12, (arg1[11]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x15, &mut x16, x12, (arg1[10]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x17, &mut x18, x12, (arg1[9]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x19, &mut x20, x12, (arg1[8]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x21, &mut x22, x12, (arg1[7]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x23, &mut x24, x12, (arg1[6]));
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x25, &mut x26, x12, (arg1[5]));
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x27, &mut x28, x12, (arg1[4]));
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x29, &mut x30, x12, (arg1[3]));
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x31, &mut x32, x12, (arg1[2]));
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x33, &mut x34, x12, (arg1[1]));
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x35, &mut x36, x12, (arg1[0]));
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x37, &mut x38, 0x0, x36, x33);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x39, &mut x40, x38, x34, x31);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x41, &mut x42, x40, x32, x29);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x43, &mut x44, x42, x30, x27);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x45, &mut x46, x44, x28, x25);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x47, &mut x48, x46, x26, x23);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x49, &mut x50, x48, x24, x21);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x51, &mut x52, x50, x22, x19);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x20, x17);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x18, x15);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x57, &mut x58, x56, x16, x13);
  let x59: u32 = ((x58 as u32) + x14);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x60, &mut x61, x35, 0xe88fdc45);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x62, &mut x63, x60, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x64, &mut x65, x60, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x66, &mut x67, x60, 0xffffffff);
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x68, &mut x69, x60, 0xffffffff);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x70, &mut x71, x60, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x72, &mut x73, x60, 0xffffffff);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x74, &mut x75, x60, 0xc7634d81);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x76, &mut x77, x60, 0xf4372ddf);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x78, &mut x79, x60, 0x581a0db2);
  let mut x80: u32 = 0;
  let mut x81: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x80, &mut x81, x60, 0x48b0a77a);
  let mut x82: u32 = 0;
  let mut x83: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x82, &mut x83, x60, 0xecec196a);
  let mut x84: u32 = 0;
  let mut x85: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x84, &mut x85, x60, 0xccc52973);
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x86, &mut x87, 0x0, x85, x82);
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x88, &mut x89, x87, x83, x80);
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x90, &mut x91, x89, x81, x78);
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x92, &mut x93, x91, x79, x76);
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x94, &mut x95, x93, x77, x74);
  let mut x96: u32 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x96, &mut x97, x95, x75, x72);
  let mut x98: u32 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x98, &mut x99, x97, x73, x70);
  let mut x100: u32 = 0;
  let mut x101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x100, &mut x101, x99, x71, x68);
  let mut x102: u32 = 0;
  let mut x103: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x102, &mut x103, x101, x69, x66);
  let mut x104: u32 = 0;
  let mut x105: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x104, &mut x105, x103, x67, x64);
  let mut x106: u32 = 0;
  let mut x107: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x106, &mut x107, x105, x65, x62);
  let x108: u32 = ((x107 as u32) + x63);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x109, &mut x110, 0x0, x35, x84);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x37, x86);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x39, x88);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x41, x90);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x43, x92);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x119, &mut x120, x118, x45, x94);
  let mut x121: u32 = 0;
  let mut x122: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x121, &mut x122, x120, x47, x96);
  let mut x123: u32 = 0;
  let mut x124: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x123, &mut x124, x122, x49, x98);
  let mut x125: u32 = 0;
  let mut x126: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x125, &mut x126, x124, x51, x100);
  let mut x127: u32 = 0;
  let mut x128: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x127, &mut x128, x126, x53, x102);
  let mut x129: u32 = 0;
  let mut x130: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x129, &mut x130, x128, x55, x104);
  let mut x131: u32 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x131, &mut x132, x130, x57, x106);
  let mut x133: u32 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x133, &mut x134, x132, x59, x108);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x135, &mut x136, x1, (arg1[11]));
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x137, &mut x138, x1, (arg1[10]));
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x139, &mut x140, x1, (arg1[9]));
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x141, &mut x142, x1, (arg1[8]));
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x143, &mut x144, x1, (arg1[7]));
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x145, &mut x146, x1, (arg1[6]));
  let mut x147: u32 = 0;
  let mut x148: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x147, &mut x148, x1, (arg1[5]));
  let mut x149: u32 = 0;
  let mut x150: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x149, &mut x150, x1, (arg1[4]));
  let mut x151: u32 = 0;
  let mut x152: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x151, &mut x152, x1, (arg1[3]));
  let mut x153: u32 = 0;
  let mut x154: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x153, &mut x154, x1, (arg1[2]));
  let mut x155: u32 = 0;
  let mut x156: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x155, &mut x156, x1, (arg1[1]));
  let mut x157: u32 = 0;
  let mut x158: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x157, &mut x158, x1, (arg1[0]));
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x159, &mut x160, 0x0, x158, x155);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x156, x153);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x163, &mut x164, x162, x154, x151);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x165, &mut x166, x164, x152, x149);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x167, &mut x168, x166, x150, x147);
  let mut x169: u32 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x169, &mut x170, x168, x148, x145);
  let mut x171: u32 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x171, &mut x172, x170, x146, x143);
  let mut x173: u32 = 0;
  let mut x174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x173, &mut x174, x172, x144, x141);
  let mut x175: u32 = 0;
  let mut x176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x142, x139);
  let mut x177: u32 = 0;
  let mut x178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x140, x137);
  let mut x179: u32 = 0;
  let mut x180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x138, x135);
  let x181: u32 = ((x180 as u32) + x136);
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x182, &mut x183, 0x0, x111, x157);
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x113, x159);
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x115, x161);
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x117, x163);
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x119, x165);
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x121, x167);
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x194, &mut x195, x193, x123, x169);
  let mut x196: u32 = 0;
  let mut x197: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x196, &mut x197, x195, x125, x171);
  let mut x198: u32 = 0;
  let mut x199: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x198, &mut x199, x197, x127, x173);
  let mut x200: u32 = 0;
  let mut x201: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x200, &mut x201, x199, x129, x175);
  let mut x202: u32 = 0;
  let mut x203: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x202, &mut x203, x201, x131, x177);
  let mut x204: u32 = 0;
  let mut x205: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x204, &mut x205, x203, x133, x179);
  let mut x206: u32 = 0;
  let mut x207: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x206, &mut x207, x205, (x134 as u32), x181);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x208, &mut x209, x182, 0xe88fdc45);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x210, &mut x211, x208, 0xffffffff);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x212, &mut x213, x208, 0xffffffff);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x214, &mut x215, x208, 0xffffffff);
  let mut x216: u32 = 0;
  let mut x217: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x216, &mut x217, x208, 0xffffffff);
  let mut x218: u32 = 0;
  let mut x219: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x218, &mut x219, x208, 0xffffffff);
  let mut x220: u32 = 0;
  let mut x221: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x220, &mut x221, x208, 0xffffffff);
  let mut x222: u32 = 0;
  let mut x223: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x222, &mut x223, x208, 0xc7634d81);
  let mut x224: u32 = 0;
  let mut x225: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x224, &mut x225, x208, 0xf4372ddf);
  let mut x226: u32 = 0;
  let mut x227: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x226, &mut x227, x208, 0x581a0db2);
  let mut x228: u32 = 0;
  let mut x229: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x228, &mut x229, x208, 0x48b0a77a);
  let mut x230: u32 = 0;
  let mut x231: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x230, &mut x231, x208, 0xecec196a);
  let mut x232: u32 = 0;
  let mut x233: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x232, &mut x233, x208, 0xccc52973);
  let mut x234: u32 = 0;
  let mut x235: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x234, &mut x235, 0x0, x233, x230);
  let mut x236: u32 = 0;
  let mut x237: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x231, x228);
  let mut x238: u32 = 0;
  let mut x239: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x229, x226);
  let mut x240: u32 = 0;
  let mut x241: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x227, x224);
  let mut x242: u32 = 0;
  let mut x243: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x225, x222);
  let mut x244: u32 = 0;
  let mut x245: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x223, x220);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x246, &mut x247, x245, x221, x218);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x219, x216);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x250, &mut x251, x249, x217, x214);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x252, &mut x253, x251, x215, x212);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x254, &mut x255, x253, x213, x210);
  let x256: u32 = ((x255 as u32) + x211);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x257, &mut x258, 0x0, x182, x232);
  let mut x259: u32 = 0;
  let mut x260: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x259, &mut x260, x258, x184, x234);
  let mut x261: u32 = 0;
  let mut x262: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x186, x236);
  let mut x263: u32 = 0;
  let mut x264: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x263, &mut x264, x262, x188, x238);
  let mut x265: u32 = 0;
  let mut x266: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x190, x240);
  let mut x267: u32 = 0;
  let mut x268: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x192, x242);
  let mut x269: u32 = 0;
  let mut x270: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x194, x244);
  let mut x271: u32 = 0;
  let mut x272: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x196, x246);
  let mut x273: u32 = 0;
  let mut x274: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x198, x248);
  let mut x275: u32 = 0;
  let mut x276: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x200, x250);
  let mut x277: u32 = 0;
  let mut x278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x277, &mut x278, x276, x202, x252);
  let mut x279: u32 = 0;
  let mut x280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x279, &mut x280, x278, x204, x254);
  let mut x281: u32 = 0;
  let mut x282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x281, &mut x282, x280, x206, x256);
  let x283: u32 = ((x282 as u32) + (x207 as u32));
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x284, &mut x285, x2, (arg1[11]));
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x286, &mut x287, x2, (arg1[10]));
  let mut x288: u32 = 0;
  let mut x289: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x288, &mut x289, x2, (arg1[9]));
  let mut x290: u32 = 0;
  let mut x291: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x290, &mut x291, x2, (arg1[8]));
  let mut x292: u32 = 0;
  let mut x293: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x292, &mut x293, x2, (arg1[7]));
  let mut x294: u32 = 0;
  let mut x295: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x294, &mut x295, x2, (arg1[6]));
  let mut x296: u32 = 0;
  let mut x297: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x296, &mut x297, x2, (arg1[5]));
  let mut x298: u32 = 0;
  let mut x299: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x298, &mut x299, x2, (arg1[4]));
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x300, &mut x301, x2, (arg1[3]));
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x302, &mut x303, x2, (arg1[2]));
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x304, &mut x305, x2, (arg1[1]));
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x306, &mut x307, x2, (arg1[0]));
  let mut x308: u32 = 0;
  let mut x309: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x308, &mut x309, 0x0, x307, x304);
  let mut x310: u32 = 0;
  let mut x311: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x310, &mut x311, x309, x305, x302);
  let mut x312: u32 = 0;
  let mut x313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x312, &mut x313, x311, x303, x300);
  let mut x314: u32 = 0;
  let mut x315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x314, &mut x315, x313, x301, x298);
  let mut x316: u32 = 0;
  let mut x317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x316, &mut x317, x315, x299, x296);
  let mut x318: u32 = 0;
  let mut x319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x318, &mut x319, x317, x297, x294);
  let mut x320: u32 = 0;
  let mut x321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x320, &mut x321, x319, x295, x292);
  let mut x322: u32 = 0;
  let mut x323: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x322, &mut x323, x321, x293, x290);
  let mut x324: u32 = 0;
  let mut x325: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x324, &mut x325, x323, x291, x288);
  let mut x326: u32 = 0;
  let mut x327: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x289, x286);
  let mut x328: u32 = 0;
  let mut x329: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x287, x284);
  let x330: u32 = ((x329 as u32) + x285);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x331, &mut x332, 0x0, x259, x306);
  let mut x333: u32 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x261, x308);
  let mut x335: u32 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x263, x310);
  let mut x337: u32 = 0;
  let mut x338: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x337, &mut x338, x336, x265, x312);
  let mut x339: u32 = 0;
  let mut x340: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x339, &mut x340, x338, x267, x314);
  let mut x341: u32 = 0;
  let mut x342: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x341, &mut x342, x340, x269, x316);
  let mut x343: u32 = 0;
  let mut x344: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x343, &mut x344, x342, x271, x318);
  let mut x345: u32 = 0;
  let mut x346: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x345, &mut x346, x344, x273, x320);
  let mut x347: u32 = 0;
  let mut x348: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x347, &mut x348, x346, x275, x322);
  let mut x349: u32 = 0;
  let mut x350: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x349, &mut x350, x348, x277, x324);
  let mut x351: u32 = 0;
  let mut x352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x351, &mut x352, x350, x279, x326);
  let mut x353: u32 = 0;
  let mut x354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x353, &mut x354, x352, x281, x328);
  let mut x355: u32 = 0;
  let mut x356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x355, &mut x356, x354, x283, x330);
  let mut x357: u32 = 0;
  let mut x358: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x357, &mut x358, x331, 0xe88fdc45);
  let mut x359: u32 = 0;
  let mut x360: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x359, &mut x360, x357, 0xffffffff);
  let mut x361: u32 = 0;
  let mut x362: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x361, &mut x362, x357, 0xffffffff);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x363, &mut x364, x357, 0xffffffff);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x365, &mut x366, x357, 0xffffffff);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x367, &mut x368, x357, 0xffffffff);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x369, &mut x370, x357, 0xffffffff);
  let mut x371: u32 = 0;
  let mut x372: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x371, &mut x372, x357, 0xc7634d81);
  let mut x373: u32 = 0;
  let mut x374: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x373, &mut x374, x357, 0xf4372ddf);
  let mut x375: u32 = 0;
  let mut x376: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x375, &mut x376, x357, 0x581a0db2);
  let mut x377: u32 = 0;
  let mut x378: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x377, &mut x378, x357, 0x48b0a77a);
  let mut x379: u32 = 0;
  let mut x380: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x379, &mut x380, x357, 0xecec196a);
  let mut x381: u32 = 0;
  let mut x382: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x381, &mut x382, x357, 0xccc52973);
  let mut x383: u32 = 0;
  let mut x384: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x383, &mut x384, 0x0, x382, x379);
  let mut x385: u32 = 0;
  let mut x386: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x380, x377);
  let mut x387: u32 = 0;
  let mut x388: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x378, x375);
  let mut x389: u32 = 0;
  let mut x390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x376, x373);
  let mut x391: u32 = 0;
  let mut x392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x374, x371);
  let mut x393: u32 = 0;
  let mut x394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x393, &mut x394, x392, x372, x369);
  let mut x395: u32 = 0;
  let mut x396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x395, &mut x396, x394, x370, x367);
  let mut x397: u32 = 0;
  let mut x398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x397, &mut x398, x396, x368, x365);
  let mut x399: u32 = 0;
  let mut x400: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x399, &mut x400, x398, x366, x363);
  let mut x401: u32 = 0;
  let mut x402: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x364, x361);
  let mut x403: u32 = 0;
  let mut x404: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x362, x359);
  let x405: u32 = ((x404 as u32) + x360);
  let mut x406: u32 = 0;
  let mut x407: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x406, &mut x407, 0x0, x331, x381);
  let mut x408: u32 = 0;
  let mut x409: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x408, &mut x409, x407, x333, x383);
  let mut x410: u32 = 0;
  let mut x411: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x410, &mut x411, x409, x335, x385);
  let mut x412: u32 = 0;
  let mut x413: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x337, x387);
  let mut x414: u32 = 0;
  let mut x415: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x339, x389);
  let mut x416: u32 = 0;
  let mut x417: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x341, x391);
  let mut x418: u32 = 0;
  let mut x419: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x343, x393);
  let mut x420: u32 = 0;
  let mut x421: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x345, x395);
  let mut x422: u32 = 0;
  let mut x423: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x347, x397);
  let mut x424: u32 = 0;
  let mut x425: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x424, &mut x425, x423, x349, x399);
  let mut x426: u32 = 0;
  let mut x427: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x426, &mut x427, x425, x351, x401);
  let mut x428: u32 = 0;
  let mut x429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x428, &mut x429, x427, x353, x403);
  let mut x430: u32 = 0;
  let mut x431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x430, &mut x431, x429, x355, x405);
  let x432: u32 = ((x431 as u32) + (x356 as u32));
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x433, &mut x434, x3, (arg1[11]));
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x435, &mut x436, x3, (arg1[10]));
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x437, &mut x438, x3, (arg1[9]));
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x439, &mut x440, x3, (arg1[8]));
  let mut x441: u32 = 0;
  let mut x442: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x441, &mut x442, x3, (arg1[7]));
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x443, &mut x444, x3, (arg1[6]));
  let mut x445: u32 = 0;
  let mut x446: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x445, &mut x446, x3, (arg1[5]));
  let mut x447: u32 = 0;
  let mut x448: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x447, &mut x448, x3, (arg1[4]));
  let mut x449: u32 = 0;
  let mut x450: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x449, &mut x450, x3, (arg1[3]));
  let mut x451: u32 = 0;
  let mut x452: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x451, &mut x452, x3, (arg1[2]));
  let mut x453: u32 = 0;
  let mut x454: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x453, &mut x454, x3, (arg1[1]));
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x455, &mut x456, x3, (arg1[0]));
  let mut x457: u32 = 0;
  let mut x458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x457, &mut x458, 0x0, x456, x453);
  let mut x459: u32 = 0;
  let mut x460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x459, &mut x460, x458, x454, x451);
  let mut x461: u32 = 0;
  let mut x462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x461, &mut x462, x460, x452, x449);
  let mut x463: u32 = 0;
  let mut x464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x450, x447);
  let mut x465: u32 = 0;
  let mut x466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x448, x445);
  let mut x467: u32 = 0;
  let mut x468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x446, x443);
  let mut x469: u32 = 0;
  let mut x470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x444, x441);
  let mut x471: u32 = 0;
  let mut x472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x442, x439);
  let mut x473: u32 = 0;
  let mut x474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x473, &mut x474, x472, x440, x437);
  let mut x475: u32 = 0;
  let mut x476: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x475, &mut x476, x474, x438, x435);
  let mut x477: u32 = 0;
  let mut x478: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x477, &mut x478, x476, x436, x433);
  let x479: u32 = ((x478 as u32) + x434);
  let mut x480: u32 = 0;
  let mut x481: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x480, &mut x481, 0x0, x408, x455);
  let mut x482: u32 = 0;
  let mut x483: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x482, &mut x483, x481, x410, x457);
  let mut x484: u32 = 0;
  let mut x485: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x412, x459);
  let mut x486: u32 = 0;
  let mut x487: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x414, x461);
  let mut x488: u32 = 0;
  let mut x489: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x416, x463);
  let mut x490: u32 = 0;
  let mut x491: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x418, x465);
  let mut x492: u32 = 0;
  let mut x493: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x492, &mut x493, x491, x420, x467);
  let mut x494: u32 = 0;
  let mut x495: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x494, &mut x495, x493, x422, x469);
  let mut x496: u32 = 0;
  let mut x497: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x496, &mut x497, x495, x424, x471);
  let mut x498: u32 = 0;
  let mut x499: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x498, &mut x499, x497, x426, x473);
  let mut x500: u32 = 0;
  let mut x501: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x500, &mut x501, x499, x428, x475);
  let mut x502: u32 = 0;
  let mut x503: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x502, &mut x503, x501, x430, x477);
  let mut x504: u32 = 0;
  let mut x505: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x504, &mut x505, x503, x432, x479);
  let mut x506: u32 = 0;
  let mut x507: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x506, &mut x507, x480, 0xe88fdc45);
  let mut x508: u32 = 0;
  let mut x509: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x508, &mut x509, x506, 0xffffffff);
  let mut x510: u32 = 0;
  let mut x511: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x510, &mut x511, x506, 0xffffffff);
  let mut x512: u32 = 0;
  let mut x513: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x512, &mut x513, x506, 0xffffffff);
  let mut x514: u32 = 0;
  let mut x515: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x514, &mut x515, x506, 0xffffffff);
  let mut x516: u32 = 0;
  let mut x517: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x516, &mut x517, x506, 0xffffffff);
  let mut x518: u32 = 0;
  let mut x519: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x518, &mut x519, x506, 0xffffffff);
  let mut x520: u32 = 0;
  let mut x521: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x520, &mut x521, x506, 0xc7634d81);
  let mut x522: u32 = 0;
  let mut x523: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x522, &mut x523, x506, 0xf4372ddf);
  let mut x524: u32 = 0;
  let mut x525: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x524, &mut x525, x506, 0x581a0db2);
  let mut x526: u32 = 0;
  let mut x527: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x526, &mut x527, x506, 0x48b0a77a);
  let mut x528: u32 = 0;
  let mut x529: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x528, &mut x529, x506, 0xecec196a);
  let mut x530: u32 = 0;
  let mut x531: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x530, &mut x531, x506, 0xccc52973);
  let mut x532: u32 = 0;
  let mut x533: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x532, &mut x533, 0x0, x531, x528);
  let mut x534: u32 = 0;
  let mut x535: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x529, x526);
  let mut x536: u32 = 0;
  let mut x537: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x527, x524);
  let mut x538: u32 = 0;
  let mut x539: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x525, x522);
  let mut x540: u32 = 0;
  let mut x541: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x523, x520);
  let mut x542: u32 = 0;
  let mut x543: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x542, &mut x543, x541, x521, x518);
  let mut x544: u32 = 0;
  let mut x545: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x544, &mut x545, x543, x519, x516);
  let mut x546: u32 = 0;
  let mut x547: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x546, &mut x547, x545, x517, x514);
  let mut x548: u32 = 0;
  let mut x549: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x548, &mut x549, x547, x515, x512);
  let mut x550: u32 = 0;
  let mut x551: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x550, &mut x551, x549, x513, x510);
  let mut x552: u32 = 0;
  let mut x553: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x552, &mut x553, x551, x511, x508);
  let x554: u32 = ((x553 as u32) + x509);
  let mut x555: u32 = 0;
  let mut x556: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x555, &mut x556, 0x0, x480, x530);
  let mut x557: u32 = 0;
  let mut x558: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x482, x532);
  let mut x559: u32 = 0;
  let mut x560: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x484, x534);
  let mut x561: u32 = 0;
  let mut x562: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x561, &mut x562, x560, x486, x536);
  let mut x563: u32 = 0;
  let mut x564: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x563, &mut x564, x562, x488, x538);
  let mut x565: u32 = 0;
  let mut x566: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x565, &mut x566, x564, x490, x540);
  let mut x567: u32 = 0;
  let mut x568: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x567, &mut x568, x566, x492, x542);
  let mut x569: u32 = 0;
  let mut x570: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x569, &mut x570, x568, x494, x544);
  let mut x571: u32 = 0;
  let mut x572: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x571, &mut x572, x570, x496, x546);
  let mut x573: u32 = 0;
  let mut x574: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x573, &mut x574, x572, x498, x548);
  let mut x575: u32 = 0;
  let mut x576: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x575, &mut x576, x574, x500, x550);
  let mut x577: u32 = 0;
  let mut x578: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x577, &mut x578, x576, x502, x552);
  let mut x579: u32 = 0;
  let mut x580: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x579, &mut x580, x578, x504, x554);
  let x581: u32 = ((x580 as u32) + (x505 as u32));
  let mut x582: u32 = 0;
  let mut x583: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x582, &mut x583, x4, (arg1[11]));
  let mut x584: u32 = 0;
  let mut x585: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x584, &mut x585, x4, (arg1[10]));
  let mut x586: u32 = 0;
  let mut x587: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x586, &mut x587, x4, (arg1[9]));
  let mut x588: u32 = 0;
  let mut x589: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x588, &mut x589, x4, (arg1[8]));
  let mut x590: u32 = 0;
  let mut x591: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x590, &mut x591, x4, (arg1[7]));
  let mut x592: u32 = 0;
  let mut x593: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x592, &mut x593, x4, (arg1[6]));
  let mut x594: u32 = 0;
  let mut x595: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x594, &mut x595, x4, (arg1[5]));
  let mut x596: u32 = 0;
  let mut x597: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x596, &mut x597, x4, (arg1[4]));
  let mut x598: u32 = 0;
  let mut x599: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x598, &mut x599, x4, (arg1[3]));
  let mut x600: u32 = 0;
  let mut x601: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x600, &mut x601, x4, (arg1[2]));
  let mut x602: u32 = 0;
  let mut x603: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x602, &mut x603, x4, (arg1[1]));
  let mut x604: u32 = 0;
  let mut x605: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x604, &mut x605, x4, (arg1[0]));
  let mut x606: u32 = 0;
  let mut x607: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x606, &mut x607, 0x0, x605, x602);
  let mut x608: u32 = 0;
  let mut x609: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x608, &mut x609, x607, x603, x600);
  let mut x610: u32 = 0;
  let mut x611: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x610, &mut x611, x609, x601, x598);
  let mut x612: u32 = 0;
  let mut x613: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x612, &mut x613, x611, x599, x596);
  let mut x614: u32 = 0;
  let mut x615: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x614, &mut x615, x613, x597, x594);
  let mut x616: u32 = 0;
  let mut x617: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x616, &mut x617, x615, x595, x592);
  let mut x618: u32 = 0;
  let mut x619: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x618, &mut x619, x617, x593, x590);
  let mut x620: u32 = 0;
  let mut x621: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x620, &mut x621, x619, x591, x588);
  let mut x622: u32 = 0;
  let mut x623: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x622, &mut x623, x621, x589, x586);
  let mut x624: u32 = 0;
  let mut x625: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x624, &mut x625, x623, x587, x584);
  let mut x626: u32 = 0;
  let mut x627: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x626, &mut x627, x625, x585, x582);
  let x628: u32 = ((x627 as u32) + x583);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x629, &mut x630, 0x0, x557, x604);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x559, x606);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x633, &mut x634, x632, x561, x608);
  let mut x635: u32 = 0;
  let mut x636: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x635, &mut x636, x634, x563, x610);
  let mut x637: u32 = 0;
  let mut x638: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x637, &mut x638, x636, x565, x612);
  let mut x639: u32 = 0;
  let mut x640: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x639, &mut x640, x638, x567, x614);
  let mut x641: u32 = 0;
  let mut x642: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x641, &mut x642, x640, x569, x616);
  let mut x643: u32 = 0;
  let mut x644: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x643, &mut x644, x642, x571, x618);
  let mut x645: u32 = 0;
  let mut x646: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x645, &mut x646, x644, x573, x620);
  let mut x647: u32 = 0;
  let mut x648: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x647, &mut x648, x646, x575, x622);
  let mut x649: u32 = 0;
  let mut x650: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x649, &mut x650, x648, x577, x624);
  let mut x651: u32 = 0;
  let mut x652: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x651, &mut x652, x650, x579, x626);
  let mut x653: u32 = 0;
  let mut x654: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x653, &mut x654, x652, x581, x628);
  let mut x655: u32 = 0;
  let mut x656: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x655, &mut x656, x629, 0xe88fdc45);
  let mut x657: u32 = 0;
  let mut x658: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x657, &mut x658, x655, 0xffffffff);
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x659, &mut x660, x655, 0xffffffff);
  let mut x661: u32 = 0;
  let mut x662: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x661, &mut x662, x655, 0xffffffff);
  let mut x663: u32 = 0;
  let mut x664: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x663, &mut x664, x655, 0xffffffff);
  let mut x665: u32 = 0;
  let mut x666: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x665, &mut x666, x655, 0xffffffff);
  let mut x667: u32 = 0;
  let mut x668: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x667, &mut x668, x655, 0xffffffff);
  let mut x669: u32 = 0;
  let mut x670: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x669, &mut x670, x655, 0xc7634d81);
  let mut x671: u32 = 0;
  let mut x672: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x671, &mut x672, x655, 0xf4372ddf);
  let mut x673: u32 = 0;
  let mut x674: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x673, &mut x674, x655, 0x581a0db2);
  let mut x675: u32 = 0;
  let mut x676: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x675, &mut x676, x655, 0x48b0a77a);
  let mut x677: u32 = 0;
  let mut x678: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x677, &mut x678, x655, 0xecec196a);
  let mut x679: u32 = 0;
  let mut x680: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x679, &mut x680, x655, 0xccc52973);
  let mut x681: u32 = 0;
  let mut x682: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x681, &mut x682, 0x0, x680, x677);
  let mut x683: u32 = 0;
  let mut x684: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x683, &mut x684, x682, x678, x675);
  let mut x685: u32 = 0;
  let mut x686: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x685, &mut x686, x684, x676, x673);
  let mut x687: u32 = 0;
  let mut x688: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x687, &mut x688, x686, x674, x671);
  let mut x689: u32 = 0;
  let mut x690: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x689, &mut x690, x688, x672, x669);
  let mut x691: u32 = 0;
  let mut x692: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x691, &mut x692, x690, x670, x667);
  let mut x693: u32 = 0;
  let mut x694: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x693, &mut x694, x692, x668, x665);
  let mut x695: u32 = 0;
  let mut x696: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x695, &mut x696, x694, x666, x663);
  let mut x697: u32 = 0;
  let mut x698: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x697, &mut x698, x696, x664, x661);
  let mut x699: u32 = 0;
  let mut x700: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x699, &mut x700, x698, x662, x659);
  let mut x701: u32 = 0;
  let mut x702: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x701, &mut x702, x700, x660, x657);
  let x703: u32 = ((x702 as u32) + x658);
  let mut x704: u32 = 0;
  let mut x705: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x704, &mut x705, 0x0, x629, x679);
  let mut x706: u32 = 0;
  let mut x707: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x706, &mut x707, x705, x631, x681);
  let mut x708: u32 = 0;
  let mut x709: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x708, &mut x709, x707, x633, x683);
  let mut x710: u32 = 0;
  let mut x711: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x710, &mut x711, x709, x635, x685);
  let mut x712: u32 = 0;
  let mut x713: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x712, &mut x713, x711, x637, x687);
  let mut x714: u32 = 0;
  let mut x715: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x714, &mut x715, x713, x639, x689);
  let mut x716: u32 = 0;
  let mut x717: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x716, &mut x717, x715, x641, x691);
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x718, &mut x719, x717, x643, x693);
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x720, &mut x721, x719, x645, x695);
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x722, &mut x723, x721, x647, x697);
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x724, &mut x725, x723, x649, x699);
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x726, &mut x727, x725, x651, x701);
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x728, &mut x729, x727, x653, x703);
  let x730: u32 = ((x729 as u32) + (x654 as u32));
  let mut x731: u32 = 0;
  let mut x732: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x731, &mut x732, x5, (arg1[11]));
  let mut x733: u32 = 0;
  let mut x734: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x733, &mut x734, x5, (arg1[10]));
  let mut x735: u32 = 0;
  let mut x736: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x735, &mut x736, x5, (arg1[9]));
  let mut x737: u32 = 0;
  let mut x738: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x737, &mut x738, x5, (arg1[8]));
  let mut x739: u32 = 0;
  let mut x740: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x739, &mut x740, x5, (arg1[7]));
  let mut x741: u32 = 0;
  let mut x742: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x741, &mut x742, x5, (arg1[6]));
  let mut x743: u32 = 0;
  let mut x744: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x743, &mut x744, x5, (arg1[5]));
  let mut x745: u32 = 0;
  let mut x746: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x745, &mut x746, x5, (arg1[4]));
  let mut x747: u32 = 0;
  let mut x748: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x747, &mut x748, x5, (arg1[3]));
  let mut x749: u32 = 0;
  let mut x750: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x749, &mut x750, x5, (arg1[2]));
  let mut x751: u32 = 0;
  let mut x752: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x751, &mut x752, x5, (arg1[1]));
  let mut x753: u32 = 0;
  let mut x754: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x753, &mut x754, x5, (arg1[0]));
  let mut x755: u32 = 0;
  let mut x756: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x755, &mut x756, 0x0, x754, x751);
  let mut x757: u32 = 0;
  let mut x758: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x757, &mut x758, x756, x752, x749);
  let mut x759: u32 = 0;
  let mut x760: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x759, &mut x760, x758, x750, x747);
  let mut x761: u32 = 0;
  let mut x762: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x761, &mut x762, x760, x748, x745);
  let mut x763: u32 = 0;
  let mut x764: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x763, &mut x764, x762, x746, x743);
  let mut x765: u32 = 0;
  let mut x766: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x765, &mut x766, x764, x744, x741);
  let mut x767: u32 = 0;
  let mut x768: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x767, &mut x768, x766, x742, x739);
  let mut x769: u32 = 0;
  let mut x770: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x769, &mut x770, x768, x740, x737);
  let mut x771: u32 = 0;
  let mut x772: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x771, &mut x772, x770, x738, x735);
  let mut x773: u32 = 0;
  let mut x774: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x773, &mut x774, x772, x736, x733);
  let mut x775: u32 = 0;
  let mut x776: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x775, &mut x776, x774, x734, x731);
  let x777: u32 = ((x776 as u32) + x732);
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x778, &mut x779, 0x0, x706, x753);
  let mut x780: u32 = 0;
  let mut x781: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x780, &mut x781, x779, x708, x755);
  let mut x782: u32 = 0;
  let mut x783: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x782, &mut x783, x781, x710, x757);
  let mut x784: u32 = 0;
  let mut x785: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x784, &mut x785, x783, x712, x759);
  let mut x786: u32 = 0;
  let mut x787: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x786, &mut x787, x785, x714, x761);
  let mut x788: u32 = 0;
  let mut x789: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x788, &mut x789, x787, x716, x763);
  let mut x790: u32 = 0;
  let mut x791: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x790, &mut x791, x789, x718, x765);
  let mut x792: u32 = 0;
  let mut x793: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x792, &mut x793, x791, x720, x767);
  let mut x794: u32 = 0;
  let mut x795: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x794, &mut x795, x793, x722, x769);
  let mut x796: u32 = 0;
  let mut x797: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x796, &mut x797, x795, x724, x771);
  let mut x798: u32 = 0;
  let mut x799: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x798, &mut x799, x797, x726, x773);
  let mut x800: u32 = 0;
  let mut x801: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x800, &mut x801, x799, x728, x775);
  let mut x802: u32 = 0;
  let mut x803: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x802, &mut x803, x801, x730, x777);
  let mut x804: u32 = 0;
  let mut x805: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x804, &mut x805, x778, 0xe88fdc45);
  let mut x806: u32 = 0;
  let mut x807: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x806, &mut x807, x804, 0xffffffff);
  let mut x808: u32 = 0;
  let mut x809: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x808, &mut x809, x804, 0xffffffff);
  let mut x810: u32 = 0;
  let mut x811: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x810, &mut x811, x804, 0xffffffff);
  let mut x812: u32 = 0;
  let mut x813: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x812, &mut x813, x804, 0xffffffff);
  let mut x814: u32 = 0;
  let mut x815: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x814, &mut x815, x804, 0xffffffff);
  let mut x816: u32 = 0;
  let mut x817: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x816, &mut x817, x804, 0xffffffff);
  let mut x818: u32 = 0;
  let mut x819: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x818, &mut x819, x804, 0xc7634d81);
  let mut x820: u32 = 0;
  let mut x821: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x820, &mut x821, x804, 0xf4372ddf);
  let mut x822: u32 = 0;
  let mut x823: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x822, &mut x823, x804, 0x581a0db2);
  let mut x824: u32 = 0;
  let mut x825: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x824, &mut x825, x804, 0x48b0a77a);
  let mut x826: u32 = 0;
  let mut x827: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x826, &mut x827, x804, 0xecec196a);
  let mut x828: u32 = 0;
  let mut x829: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x828, &mut x829, x804, 0xccc52973);
  let mut x830: u32 = 0;
  let mut x831: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x830, &mut x831, 0x0, x829, x826);
  let mut x832: u32 = 0;
  let mut x833: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x832, &mut x833, x831, x827, x824);
  let mut x834: u32 = 0;
  let mut x835: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x834, &mut x835, x833, x825, x822);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x836, &mut x837, x835, x823, x820);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x838, &mut x839, x837, x821, x818);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x840, &mut x841, x839, x819, x816);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x842, &mut x843, x841, x817, x814);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x844, &mut x845, x843, x815, x812);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x846, &mut x847, x845, x813, x810);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x848, &mut x849, x847, x811, x808);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x850, &mut x851, x849, x809, x806);
  let x852: u32 = ((x851 as u32) + x807);
  let mut x853: u32 = 0;
  let mut x854: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x853, &mut x854, 0x0, x778, x828);
  let mut x855: u32 = 0;
  let mut x856: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x855, &mut x856, x854, x780, x830);
  let mut x857: u32 = 0;
  let mut x858: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x857, &mut x858, x856, x782, x832);
  let mut x859: u32 = 0;
  let mut x860: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x859, &mut x860, x858, x784, x834);
  let mut x861: u32 = 0;
  let mut x862: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x861, &mut x862, x860, x786, x836);
  let mut x863: u32 = 0;
  let mut x864: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x863, &mut x864, x862, x788, x838);
  let mut x865: u32 = 0;
  let mut x866: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x865, &mut x866, x864, x790, x840);
  let mut x867: u32 = 0;
  let mut x868: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x867, &mut x868, x866, x792, x842);
  let mut x869: u32 = 0;
  let mut x870: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x869, &mut x870, x868, x794, x844);
  let mut x871: u32 = 0;
  let mut x872: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x871, &mut x872, x870, x796, x846);
  let mut x873: u32 = 0;
  let mut x874: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x873, &mut x874, x872, x798, x848);
  let mut x875: u32 = 0;
  let mut x876: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x875, &mut x876, x874, x800, x850);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x877, &mut x878, x876, x802, x852);
  let x879: u32 = ((x878 as u32) + (x803 as u32));
  let mut x880: u32 = 0;
  let mut x881: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x880, &mut x881, x6, (arg1[11]));
  let mut x882: u32 = 0;
  let mut x883: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x882, &mut x883, x6, (arg1[10]));
  let mut x884: u32 = 0;
  let mut x885: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x884, &mut x885, x6, (arg1[9]));
  let mut x886: u32 = 0;
  let mut x887: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x886, &mut x887, x6, (arg1[8]));
  let mut x888: u32 = 0;
  let mut x889: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x888, &mut x889, x6, (arg1[7]));
  let mut x890: u32 = 0;
  let mut x891: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x890, &mut x891, x6, (arg1[6]));
  let mut x892: u32 = 0;
  let mut x893: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x892, &mut x893, x6, (arg1[5]));
  let mut x894: u32 = 0;
  let mut x895: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x894, &mut x895, x6, (arg1[4]));
  let mut x896: u32 = 0;
  let mut x897: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x896, &mut x897, x6, (arg1[3]));
  let mut x898: u32 = 0;
  let mut x899: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x898, &mut x899, x6, (arg1[2]));
  let mut x900: u32 = 0;
  let mut x901: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x900, &mut x901, x6, (arg1[1]));
  let mut x902: u32 = 0;
  let mut x903: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x902, &mut x903, x6, (arg1[0]));
  let mut x904: u32 = 0;
  let mut x905: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x904, &mut x905, 0x0, x903, x900);
  let mut x906: u32 = 0;
  let mut x907: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x906, &mut x907, x905, x901, x898);
  let mut x908: u32 = 0;
  let mut x909: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x908, &mut x909, x907, x899, x896);
  let mut x910: u32 = 0;
  let mut x911: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x910, &mut x911, x909, x897, x894);
  let mut x912: u32 = 0;
  let mut x913: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x912, &mut x913, x911, x895, x892);
  let mut x914: u32 = 0;
  let mut x915: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x914, &mut x915, x913, x893, x890);
  let mut x916: u32 = 0;
  let mut x917: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x916, &mut x917, x915, x891, x888);
  let mut x918: u32 = 0;
  let mut x919: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x918, &mut x919, x917, x889, x886);
  let mut x920: u32 = 0;
  let mut x921: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x920, &mut x921, x919, x887, x884);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x922, &mut x923, x921, x885, x882);
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x924, &mut x925, x923, x883, x880);
  let x926: u32 = ((x925 as u32) + x881);
  let mut x927: u32 = 0;
  let mut x928: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x927, &mut x928, 0x0, x855, x902);
  let mut x929: u32 = 0;
  let mut x930: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x929, &mut x930, x928, x857, x904);
  let mut x931: u32 = 0;
  let mut x932: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x931, &mut x932, x930, x859, x906);
  let mut x933: u32 = 0;
  let mut x934: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x933, &mut x934, x932, x861, x908);
  let mut x935: u32 = 0;
  let mut x936: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x935, &mut x936, x934, x863, x910);
  let mut x937: u32 = 0;
  let mut x938: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x937, &mut x938, x936, x865, x912);
  let mut x939: u32 = 0;
  let mut x940: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x939, &mut x940, x938, x867, x914);
  let mut x941: u32 = 0;
  let mut x942: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x941, &mut x942, x940, x869, x916);
  let mut x943: u32 = 0;
  let mut x944: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x943, &mut x944, x942, x871, x918);
  let mut x945: u32 = 0;
  let mut x946: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x945, &mut x946, x944, x873, x920);
  let mut x947: u32 = 0;
  let mut x948: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x947, &mut x948, x946, x875, x922);
  let mut x949: u32 = 0;
  let mut x950: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x949, &mut x950, x948, x877, x924);
  let mut x951: u32 = 0;
  let mut x952: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x951, &mut x952, x950, x879, x926);
  let mut x953: u32 = 0;
  let mut x954: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x953, &mut x954, x927, 0xe88fdc45);
  let mut x955: u32 = 0;
  let mut x956: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x955, &mut x956, x953, 0xffffffff);
  let mut x957: u32 = 0;
  let mut x958: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x957, &mut x958, x953, 0xffffffff);
  let mut x959: u32 = 0;
  let mut x960: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x959, &mut x960, x953, 0xffffffff);
  let mut x961: u32 = 0;
  let mut x962: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x961, &mut x962, x953, 0xffffffff);
  let mut x963: u32 = 0;
  let mut x964: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x963, &mut x964, x953, 0xffffffff);
  let mut x965: u32 = 0;
  let mut x966: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x965, &mut x966, x953, 0xffffffff);
  let mut x967: u32 = 0;
  let mut x968: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x967, &mut x968, x953, 0xc7634d81);
  let mut x969: u32 = 0;
  let mut x970: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x969, &mut x970, x953, 0xf4372ddf);
  let mut x971: u32 = 0;
  let mut x972: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x971, &mut x972, x953, 0x581a0db2);
  let mut x973: u32 = 0;
  let mut x974: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x973, &mut x974, x953, 0x48b0a77a);
  let mut x975: u32 = 0;
  let mut x976: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x975, &mut x976, x953, 0xecec196a);
  let mut x977: u32 = 0;
  let mut x978: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x977, &mut x978, x953, 0xccc52973);
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x979, &mut x980, 0x0, x978, x975);
  let mut x981: u32 = 0;
  let mut x982: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x981, &mut x982, x980, x976, x973);
  let mut x983: u32 = 0;
  let mut x984: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x983, &mut x984, x982, x974, x971);
  let mut x985: u32 = 0;
  let mut x986: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x985, &mut x986, x984, x972, x969);
  let mut x987: u32 = 0;
  let mut x988: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x987, &mut x988, x986, x970, x967);
  let mut x989: u32 = 0;
  let mut x990: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x989, &mut x990, x988, x968, x965);
  let mut x991: u32 = 0;
  let mut x992: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x991, &mut x992, x990, x966, x963);
  let mut x993: u32 = 0;
  let mut x994: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x993, &mut x994, x992, x964, x961);
  let mut x995: u32 = 0;
  let mut x996: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x995, &mut x996, x994, x962, x959);
  let mut x997: u32 = 0;
  let mut x998: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x997, &mut x998, x996, x960, x957);
  let mut x999: u32 = 0;
  let mut x1000: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x999, &mut x1000, x998, x958, x955);
  let x1001: u32 = ((x1000 as u32) + x956);
  let mut x1002: u32 = 0;
  let mut x1003: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1002, &mut x1003, 0x0, x927, x977);
  let mut x1004: u32 = 0;
  let mut x1005: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1004, &mut x1005, x1003, x929, x979);
  let mut x1006: u32 = 0;
  let mut x1007: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1006, &mut x1007, x1005, x931, x981);
  let mut x1008: u32 = 0;
  let mut x1009: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1008, &mut x1009, x1007, x933, x983);
  let mut x1010: u32 = 0;
  let mut x1011: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1010, &mut x1011, x1009, x935, x985);
  let mut x1012: u32 = 0;
  let mut x1013: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1012, &mut x1013, x1011, x937, x987);
  let mut x1014: u32 = 0;
  let mut x1015: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1014, &mut x1015, x1013, x939, x989);
  let mut x1016: u32 = 0;
  let mut x1017: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1016, &mut x1017, x1015, x941, x991);
  let mut x1018: u32 = 0;
  let mut x1019: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1018, &mut x1019, x1017, x943, x993);
  let mut x1020: u32 = 0;
  let mut x1021: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1020, &mut x1021, x1019, x945, x995);
  let mut x1022: u32 = 0;
  let mut x1023: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1022, &mut x1023, x1021, x947, x997);
  let mut x1024: u32 = 0;
  let mut x1025: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1024, &mut x1025, x1023, x949, x999);
  let mut x1026: u32 = 0;
  let mut x1027: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1026, &mut x1027, x1025, x951, x1001);
  let x1028: u32 = ((x1027 as u32) + (x952 as u32));
  let mut x1029: u32 = 0;
  let mut x1030: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1029, &mut x1030, x7, (arg1[11]));
  let mut x1031: u32 = 0;
  let mut x1032: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1031, &mut x1032, x7, (arg1[10]));
  let mut x1033: u32 = 0;
  let mut x1034: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1033, &mut x1034, x7, (arg1[9]));
  let mut x1035: u32 = 0;
  let mut x1036: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1035, &mut x1036, x7, (arg1[8]));
  let mut x1037: u32 = 0;
  let mut x1038: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1037, &mut x1038, x7, (arg1[7]));
  let mut x1039: u32 = 0;
  let mut x1040: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1039, &mut x1040, x7, (arg1[6]));
  let mut x1041: u32 = 0;
  let mut x1042: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1041, &mut x1042, x7, (arg1[5]));
  let mut x1043: u32 = 0;
  let mut x1044: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1043, &mut x1044, x7, (arg1[4]));
  let mut x1045: u32 = 0;
  let mut x1046: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1045, &mut x1046, x7, (arg1[3]));
  let mut x1047: u32 = 0;
  let mut x1048: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1047, &mut x1048, x7, (arg1[2]));
  let mut x1049: u32 = 0;
  let mut x1050: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1049, &mut x1050, x7, (arg1[1]));
  let mut x1051: u32 = 0;
  let mut x1052: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1051, &mut x1052, x7, (arg1[0]));
  let mut x1053: u32 = 0;
  let mut x1054: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1053, &mut x1054, 0x0, x1052, x1049);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1055, &mut x1056, x1054, x1050, x1047);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1057, &mut x1058, x1056, x1048, x1045);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1059, &mut x1060, x1058, x1046, x1043);
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1061, &mut x1062, x1060, x1044, x1041);
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1063, &mut x1064, x1062, x1042, x1039);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1065, &mut x1066, x1064, x1040, x1037);
  let mut x1067: u32 = 0;
  let mut x1068: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1067, &mut x1068, x1066, x1038, x1035);
  let mut x1069: u32 = 0;
  let mut x1070: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1069, &mut x1070, x1068, x1036, x1033);
  let mut x1071: u32 = 0;
  let mut x1072: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1071, &mut x1072, x1070, x1034, x1031);
  let mut x1073: u32 = 0;
  let mut x1074: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1073, &mut x1074, x1072, x1032, x1029);
  let x1075: u32 = ((x1074 as u32) + x1030);
  let mut x1076: u32 = 0;
  let mut x1077: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1076, &mut x1077, 0x0, x1004, x1051);
  let mut x1078: u32 = 0;
  let mut x1079: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1078, &mut x1079, x1077, x1006, x1053);
  let mut x1080: u32 = 0;
  let mut x1081: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1080, &mut x1081, x1079, x1008, x1055);
  let mut x1082: u32 = 0;
  let mut x1083: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1082, &mut x1083, x1081, x1010, x1057);
  let mut x1084: u32 = 0;
  let mut x1085: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1084, &mut x1085, x1083, x1012, x1059);
  let mut x1086: u32 = 0;
  let mut x1087: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1086, &mut x1087, x1085, x1014, x1061);
  let mut x1088: u32 = 0;
  let mut x1089: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1088, &mut x1089, x1087, x1016, x1063);
  let mut x1090: u32 = 0;
  let mut x1091: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1090, &mut x1091, x1089, x1018, x1065);
  let mut x1092: u32 = 0;
  let mut x1093: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1092, &mut x1093, x1091, x1020, x1067);
  let mut x1094: u32 = 0;
  let mut x1095: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1094, &mut x1095, x1093, x1022, x1069);
  let mut x1096: u32 = 0;
  let mut x1097: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1096, &mut x1097, x1095, x1024, x1071);
  let mut x1098: u32 = 0;
  let mut x1099: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1098, &mut x1099, x1097, x1026, x1073);
  let mut x1100: u32 = 0;
  let mut x1101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1100, &mut x1101, x1099, x1028, x1075);
  let mut x1102: u32 = 0;
  let mut x1103: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1102, &mut x1103, x1076, 0xe88fdc45);
  let mut x1104: u32 = 0;
  let mut x1105: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1104, &mut x1105, x1102, 0xffffffff);
  let mut x1106: u32 = 0;
  let mut x1107: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1106, &mut x1107, x1102, 0xffffffff);
  let mut x1108: u32 = 0;
  let mut x1109: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1108, &mut x1109, x1102, 0xffffffff);
  let mut x1110: u32 = 0;
  let mut x1111: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1110, &mut x1111, x1102, 0xffffffff);
  let mut x1112: u32 = 0;
  let mut x1113: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1112, &mut x1113, x1102, 0xffffffff);
  let mut x1114: u32 = 0;
  let mut x1115: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1114, &mut x1115, x1102, 0xffffffff);
  let mut x1116: u32 = 0;
  let mut x1117: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1116, &mut x1117, x1102, 0xc7634d81);
  let mut x1118: u32 = 0;
  let mut x1119: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1118, &mut x1119, x1102, 0xf4372ddf);
  let mut x1120: u32 = 0;
  let mut x1121: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1120, &mut x1121, x1102, 0x581a0db2);
  let mut x1122: u32 = 0;
  let mut x1123: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1122, &mut x1123, x1102, 0x48b0a77a);
  let mut x1124: u32 = 0;
  let mut x1125: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1124, &mut x1125, x1102, 0xecec196a);
  let mut x1126: u32 = 0;
  let mut x1127: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1126, &mut x1127, x1102, 0xccc52973);
  let mut x1128: u32 = 0;
  let mut x1129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1128, &mut x1129, 0x0, x1127, x1124);
  let mut x1130: u32 = 0;
  let mut x1131: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1130, &mut x1131, x1129, x1125, x1122);
  let mut x1132: u32 = 0;
  let mut x1133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1132, &mut x1133, x1131, x1123, x1120);
  let mut x1134: u32 = 0;
  let mut x1135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1134, &mut x1135, x1133, x1121, x1118);
  let mut x1136: u32 = 0;
  let mut x1137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1136, &mut x1137, x1135, x1119, x1116);
  let mut x1138: u32 = 0;
  let mut x1139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1138, &mut x1139, x1137, x1117, x1114);
  let mut x1140: u32 = 0;
  let mut x1141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1140, &mut x1141, x1139, x1115, x1112);
  let mut x1142: u32 = 0;
  let mut x1143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1142, &mut x1143, x1141, x1113, x1110);
  let mut x1144: u32 = 0;
  let mut x1145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1144, &mut x1145, x1143, x1111, x1108);
  let mut x1146: u32 = 0;
  let mut x1147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1146, &mut x1147, x1145, x1109, x1106);
  let mut x1148: u32 = 0;
  let mut x1149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1148, &mut x1149, x1147, x1107, x1104);
  let x1150: u32 = ((x1149 as u32) + x1105);
  let mut x1151: u32 = 0;
  let mut x1152: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1151, &mut x1152, 0x0, x1076, x1126);
  let mut x1153: u32 = 0;
  let mut x1154: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1153, &mut x1154, x1152, x1078, x1128);
  let mut x1155: u32 = 0;
  let mut x1156: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1155, &mut x1156, x1154, x1080, x1130);
  let mut x1157: u32 = 0;
  let mut x1158: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1157, &mut x1158, x1156, x1082, x1132);
  let mut x1159: u32 = 0;
  let mut x1160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1159, &mut x1160, x1158, x1084, x1134);
  let mut x1161: u32 = 0;
  let mut x1162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1161, &mut x1162, x1160, x1086, x1136);
  let mut x1163: u32 = 0;
  let mut x1164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1163, &mut x1164, x1162, x1088, x1138);
  let mut x1165: u32 = 0;
  let mut x1166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1165, &mut x1166, x1164, x1090, x1140);
  let mut x1167: u32 = 0;
  let mut x1168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1167, &mut x1168, x1166, x1092, x1142);
  let mut x1169: u32 = 0;
  let mut x1170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1169, &mut x1170, x1168, x1094, x1144);
  let mut x1171: u32 = 0;
  let mut x1172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1171, &mut x1172, x1170, x1096, x1146);
  let mut x1173: u32 = 0;
  let mut x1174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1173, &mut x1174, x1172, x1098, x1148);
  let mut x1175: u32 = 0;
  let mut x1176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1175, &mut x1176, x1174, x1100, x1150);
  let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
  let mut x1178: u32 = 0;
  let mut x1179: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1178, &mut x1179, x8, (arg1[11]));
  let mut x1180: u32 = 0;
  let mut x1181: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1180, &mut x1181, x8, (arg1[10]));
  let mut x1182: u32 = 0;
  let mut x1183: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1182, &mut x1183, x8, (arg1[9]));
  let mut x1184: u32 = 0;
  let mut x1185: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1184, &mut x1185, x8, (arg1[8]));
  let mut x1186: u32 = 0;
  let mut x1187: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1186, &mut x1187, x8, (arg1[7]));
  let mut x1188: u32 = 0;
  let mut x1189: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1188, &mut x1189, x8, (arg1[6]));
  let mut x1190: u32 = 0;
  let mut x1191: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1190, &mut x1191, x8, (arg1[5]));
  let mut x1192: u32 = 0;
  let mut x1193: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1192, &mut x1193, x8, (arg1[4]));
  let mut x1194: u32 = 0;
  let mut x1195: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1194, &mut x1195, x8, (arg1[3]));
  let mut x1196: u32 = 0;
  let mut x1197: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1196, &mut x1197, x8, (arg1[2]));
  let mut x1198: u32 = 0;
  let mut x1199: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1198, &mut x1199, x8, (arg1[1]));
  let mut x1200: u32 = 0;
  let mut x1201: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1200, &mut x1201, x8, (arg1[0]));
  let mut x1202: u32 = 0;
  let mut x1203: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1202, &mut x1203, 0x0, x1201, x1198);
  let mut x1204: u32 = 0;
  let mut x1205: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1204, &mut x1205, x1203, x1199, x1196);
  let mut x1206: u32 = 0;
  let mut x1207: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1206, &mut x1207, x1205, x1197, x1194);
  let mut x1208: u32 = 0;
  let mut x1209: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1208, &mut x1209, x1207, x1195, x1192);
  let mut x1210: u32 = 0;
  let mut x1211: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1210, &mut x1211, x1209, x1193, x1190);
  let mut x1212: u32 = 0;
  let mut x1213: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1212, &mut x1213, x1211, x1191, x1188);
  let mut x1214: u32 = 0;
  let mut x1215: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1214, &mut x1215, x1213, x1189, x1186);
  let mut x1216: u32 = 0;
  let mut x1217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1216, &mut x1217, x1215, x1187, x1184);
  let mut x1218: u32 = 0;
  let mut x1219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1218, &mut x1219, x1217, x1185, x1182);
  let mut x1220: u32 = 0;
  let mut x1221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1220, &mut x1221, x1219, x1183, x1180);
  let mut x1222: u32 = 0;
  let mut x1223: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1222, &mut x1223, x1221, x1181, x1178);
  let x1224: u32 = ((x1223 as u32) + x1179);
  let mut x1225: u32 = 0;
  let mut x1226: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1225, &mut x1226, 0x0, x1153, x1200);
  let mut x1227: u32 = 0;
  let mut x1228: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1227, &mut x1228, x1226, x1155, x1202);
  let mut x1229: u32 = 0;
  let mut x1230: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1229, &mut x1230, x1228, x1157, x1204);
  let mut x1231: u32 = 0;
  let mut x1232: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1231, &mut x1232, x1230, x1159, x1206);
  let mut x1233: u32 = 0;
  let mut x1234: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1233, &mut x1234, x1232, x1161, x1208);
  let mut x1235: u32 = 0;
  let mut x1236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1235, &mut x1236, x1234, x1163, x1210);
  let mut x1237: u32 = 0;
  let mut x1238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1237, &mut x1238, x1236, x1165, x1212);
  let mut x1239: u32 = 0;
  let mut x1240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1239, &mut x1240, x1238, x1167, x1214);
  let mut x1241: u32 = 0;
  let mut x1242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1241, &mut x1242, x1240, x1169, x1216);
  let mut x1243: u32 = 0;
  let mut x1244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1243, &mut x1244, x1242, x1171, x1218);
  let mut x1245: u32 = 0;
  let mut x1246: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1245, &mut x1246, x1244, x1173, x1220);
  let mut x1247: u32 = 0;
  let mut x1248: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1247, &mut x1248, x1246, x1175, x1222);
  let mut x1249: u32 = 0;
  let mut x1250: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1249, &mut x1250, x1248, x1177, x1224);
  let mut x1251: u32 = 0;
  let mut x1252: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1251, &mut x1252, x1225, 0xe88fdc45);
  let mut x1253: u32 = 0;
  let mut x1254: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1253, &mut x1254, x1251, 0xffffffff);
  let mut x1255: u32 = 0;
  let mut x1256: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1255, &mut x1256, x1251, 0xffffffff);
  let mut x1257: u32 = 0;
  let mut x1258: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1257, &mut x1258, x1251, 0xffffffff);
  let mut x1259: u32 = 0;
  let mut x1260: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1259, &mut x1260, x1251, 0xffffffff);
  let mut x1261: u32 = 0;
  let mut x1262: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1261, &mut x1262, x1251, 0xffffffff);
  let mut x1263: u32 = 0;
  let mut x1264: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1263, &mut x1264, x1251, 0xffffffff);
  let mut x1265: u32 = 0;
  let mut x1266: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1265, &mut x1266, x1251, 0xc7634d81);
  let mut x1267: u32 = 0;
  let mut x1268: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1267, &mut x1268, x1251, 0xf4372ddf);
  let mut x1269: u32 = 0;
  let mut x1270: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1269, &mut x1270, x1251, 0x581a0db2);
  let mut x1271: u32 = 0;
  let mut x1272: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1271, &mut x1272, x1251, 0x48b0a77a);
  let mut x1273: u32 = 0;
  let mut x1274: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1273, &mut x1274, x1251, 0xecec196a);
  let mut x1275: u32 = 0;
  let mut x1276: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1275, &mut x1276, x1251, 0xccc52973);
  let mut x1277: u32 = 0;
  let mut x1278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1277, &mut x1278, 0x0, x1276, x1273);
  let mut x1279: u32 = 0;
  let mut x1280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1279, &mut x1280, x1278, x1274, x1271);
  let mut x1281: u32 = 0;
  let mut x1282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1281, &mut x1282, x1280, x1272, x1269);
  let mut x1283: u32 = 0;
  let mut x1284: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1283, &mut x1284, x1282, x1270, x1267);
  let mut x1285: u32 = 0;
  let mut x1286: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1285, &mut x1286, x1284, x1268, x1265);
  let mut x1287: u32 = 0;
  let mut x1288: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1287, &mut x1288, x1286, x1266, x1263);
  let mut x1289: u32 = 0;
  let mut x1290: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1289, &mut x1290, x1288, x1264, x1261);
  let mut x1291: u32 = 0;
  let mut x1292: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1291, &mut x1292, x1290, x1262, x1259);
  let mut x1293: u32 = 0;
  let mut x1294: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1293, &mut x1294, x1292, x1260, x1257);
  let mut x1295: u32 = 0;
  let mut x1296: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1295, &mut x1296, x1294, x1258, x1255);
  let mut x1297: u32 = 0;
  let mut x1298: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1297, &mut x1298, x1296, x1256, x1253);
  let x1299: u32 = ((x1298 as u32) + x1254);
  let mut x1300: u32 = 0;
  let mut x1301: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1300, &mut x1301, 0x0, x1225, x1275);
  let mut x1302: u32 = 0;
  let mut x1303: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1302, &mut x1303, x1301, x1227, x1277);
  let mut x1304: u32 = 0;
  let mut x1305: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1304, &mut x1305, x1303, x1229, x1279);
  let mut x1306: u32 = 0;
  let mut x1307: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1306, &mut x1307, x1305, x1231, x1281);
  let mut x1308: u32 = 0;
  let mut x1309: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1308, &mut x1309, x1307, x1233, x1283);
  let mut x1310: u32 = 0;
  let mut x1311: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1310, &mut x1311, x1309, x1235, x1285);
  let mut x1312: u32 = 0;
  let mut x1313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1312, &mut x1313, x1311, x1237, x1287);
  let mut x1314: u32 = 0;
  let mut x1315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1314, &mut x1315, x1313, x1239, x1289);
  let mut x1316: u32 = 0;
  let mut x1317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1316, &mut x1317, x1315, x1241, x1291);
  let mut x1318: u32 = 0;
  let mut x1319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1318, &mut x1319, x1317, x1243, x1293);
  let mut x1320: u32 = 0;
  let mut x1321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1320, &mut x1321, x1319, x1245, x1295);
  let mut x1322: u32 = 0;
  let mut x1323: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1322, &mut x1323, x1321, x1247, x1297);
  let mut x1324: u32 = 0;
  let mut x1325: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1324, &mut x1325, x1323, x1249, x1299);
  let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
  let mut x1327: u32 = 0;
  let mut x1328: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1327, &mut x1328, x9, (arg1[11]));
  let mut x1329: u32 = 0;
  let mut x1330: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1329, &mut x1330, x9, (arg1[10]));
  let mut x1331: u32 = 0;
  let mut x1332: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1331, &mut x1332, x9, (arg1[9]));
  let mut x1333: u32 = 0;
  let mut x1334: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1333, &mut x1334, x9, (arg1[8]));
  let mut x1335: u32 = 0;
  let mut x1336: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1335, &mut x1336, x9, (arg1[7]));
  let mut x1337: u32 = 0;
  let mut x1338: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1337, &mut x1338, x9, (arg1[6]));
  let mut x1339: u32 = 0;
  let mut x1340: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1339, &mut x1340, x9, (arg1[5]));
  let mut x1341: u32 = 0;
  let mut x1342: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1341, &mut x1342, x9, (arg1[4]));
  let mut x1343: u32 = 0;
  let mut x1344: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1343, &mut x1344, x9, (arg1[3]));
  let mut x1345: u32 = 0;
  let mut x1346: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1345, &mut x1346, x9, (arg1[2]));
  let mut x1347: u32 = 0;
  let mut x1348: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1347, &mut x1348, x9, (arg1[1]));
  let mut x1349: u32 = 0;
  let mut x1350: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1349, &mut x1350, x9, (arg1[0]));
  let mut x1351: u32 = 0;
  let mut x1352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1351, &mut x1352, 0x0, x1350, x1347);
  let mut x1353: u32 = 0;
  let mut x1354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1353, &mut x1354, x1352, x1348, x1345);
  let mut x1355: u32 = 0;
  let mut x1356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1355, &mut x1356, x1354, x1346, x1343);
  let mut x1357: u32 = 0;
  let mut x1358: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1357, &mut x1358, x1356, x1344, x1341);
  let mut x1359: u32 = 0;
  let mut x1360: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1359, &mut x1360, x1358, x1342, x1339);
  let mut x1361: u32 = 0;
  let mut x1362: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1361, &mut x1362, x1360, x1340, x1337);
  let mut x1363: u32 = 0;
  let mut x1364: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1363, &mut x1364, x1362, x1338, x1335);
  let mut x1365: u32 = 0;
  let mut x1366: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1365, &mut x1366, x1364, x1336, x1333);
  let mut x1367: u32 = 0;
  let mut x1368: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1367, &mut x1368, x1366, x1334, x1331);
  let mut x1369: u32 = 0;
  let mut x1370: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1369, &mut x1370, x1368, x1332, x1329);
  let mut x1371: u32 = 0;
  let mut x1372: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1371, &mut x1372, x1370, x1330, x1327);
  let x1373: u32 = ((x1372 as u32) + x1328);
  let mut x1374: u32 = 0;
  let mut x1375: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1374, &mut x1375, 0x0, x1302, x1349);
  let mut x1376: u32 = 0;
  let mut x1377: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1376, &mut x1377, x1375, x1304, x1351);
  let mut x1378: u32 = 0;
  let mut x1379: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1378, &mut x1379, x1377, x1306, x1353);
  let mut x1380: u32 = 0;
  let mut x1381: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1380, &mut x1381, x1379, x1308, x1355);
  let mut x1382: u32 = 0;
  let mut x1383: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1382, &mut x1383, x1381, x1310, x1357);
  let mut x1384: u32 = 0;
  let mut x1385: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1384, &mut x1385, x1383, x1312, x1359);
  let mut x1386: u32 = 0;
  let mut x1387: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1386, &mut x1387, x1385, x1314, x1361);
  let mut x1388: u32 = 0;
  let mut x1389: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1388, &mut x1389, x1387, x1316, x1363);
  let mut x1390: u32 = 0;
  let mut x1391: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1390, &mut x1391, x1389, x1318, x1365);
  let mut x1392: u32 = 0;
  let mut x1393: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1392, &mut x1393, x1391, x1320, x1367);
  let mut x1394: u32 = 0;
  let mut x1395: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1394, &mut x1395, x1393, x1322, x1369);
  let mut x1396: u32 = 0;
  let mut x1397: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1396, &mut x1397, x1395, x1324, x1371);
  let mut x1398: u32 = 0;
  let mut x1399: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1398, &mut x1399, x1397, x1326, x1373);
  let mut x1400: u32 = 0;
  let mut x1401: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1400, &mut x1401, x1374, 0xe88fdc45);
  let mut x1402: u32 = 0;
  let mut x1403: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1402, &mut x1403, x1400, 0xffffffff);
  let mut x1404: u32 = 0;
  let mut x1405: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1404, &mut x1405, x1400, 0xffffffff);
  let mut x1406: u32 = 0;
  let mut x1407: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1406, &mut x1407, x1400, 0xffffffff);
  let mut x1408: u32 = 0;
  let mut x1409: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1408, &mut x1409, x1400, 0xffffffff);
  let mut x1410: u32 = 0;
  let mut x1411: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1410, &mut x1411, x1400, 0xffffffff);
  let mut x1412: u32 = 0;
  let mut x1413: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1412, &mut x1413, x1400, 0xffffffff);
  let mut x1414: u32 = 0;
  let mut x1415: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1414, &mut x1415, x1400, 0xc7634d81);
  let mut x1416: u32 = 0;
  let mut x1417: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1416, &mut x1417, x1400, 0xf4372ddf);
  let mut x1418: u32 = 0;
  let mut x1419: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1418, &mut x1419, x1400, 0x581a0db2);
  let mut x1420: u32 = 0;
  let mut x1421: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1420, &mut x1421, x1400, 0x48b0a77a);
  let mut x1422: u32 = 0;
  let mut x1423: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1422, &mut x1423, x1400, 0xecec196a);
  let mut x1424: u32 = 0;
  let mut x1425: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1424, &mut x1425, x1400, 0xccc52973);
  let mut x1426: u32 = 0;
  let mut x1427: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1426, &mut x1427, 0x0, x1425, x1422);
  let mut x1428: u32 = 0;
  let mut x1429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1428, &mut x1429, x1427, x1423, x1420);
  let mut x1430: u32 = 0;
  let mut x1431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1430, &mut x1431, x1429, x1421, x1418);
  let mut x1432: u32 = 0;
  let mut x1433: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1432, &mut x1433, x1431, x1419, x1416);
  let mut x1434: u32 = 0;
  let mut x1435: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1434, &mut x1435, x1433, x1417, x1414);
  let mut x1436: u32 = 0;
  let mut x1437: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1436, &mut x1437, x1435, x1415, x1412);
  let mut x1438: u32 = 0;
  let mut x1439: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1438, &mut x1439, x1437, x1413, x1410);
  let mut x1440: u32 = 0;
  let mut x1441: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1440, &mut x1441, x1439, x1411, x1408);
  let mut x1442: u32 = 0;
  let mut x1443: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1442, &mut x1443, x1441, x1409, x1406);
  let mut x1444: u32 = 0;
  let mut x1445: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1444, &mut x1445, x1443, x1407, x1404);
  let mut x1446: u32 = 0;
  let mut x1447: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1446, &mut x1447, x1445, x1405, x1402);
  let x1448: u32 = ((x1447 as u32) + x1403);
  let mut x1449: u32 = 0;
  let mut x1450: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1449, &mut x1450, 0x0, x1374, x1424);
  let mut x1451: u32 = 0;
  let mut x1452: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1451, &mut x1452, x1450, x1376, x1426);
  let mut x1453: u32 = 0;
  let mut x1454: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1453, &mut x1454, x1452, x1378, x1428);
  let mut x1455: u32 = 0;
  let mut x1456: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1455, &mut x1456, x1454, x1380, x1430);
  let mut x1457: u32 = 0;
  let mut x1458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1457, &mut x1458, x1456, x1382, x1432);
  let mut x1459: u32 = 0;
  let mut x1460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1459, &mut x1460, x1458, x1384, x1434);
  let mut x1461: u32 = 0;
  let mut x1462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1461, &mut x1462, x1460, x1386, x1436);
  let mut x1463: u32 = 0;
  let mut x1464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1463, &mut x1464, x1462, x1388, x1438);
  let mut x1465: u32 = 0;
  let mut x1466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1465, &mut x1466, x1464, x1390, x1440);
  let mut x1467: u32 = 0;
  let mut x1468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1467, &mut x1468, x1466, x1392, x1442);
  let mut x1469: u32 = 0;
  let mut x1470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1469, &mut x1470, x1468, x1394, x1444);
  let mut x1471: u32 = 0;
  let mut x1472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1471, &mut x1472, x1470, x1396, x1446);
  let mut x1473: u32 = 0;
  let mut x1474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1473, &mut x1474, x1472, x1398, x1448);
  let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
  let mut x1476: u32 = 0;
  let mut x1477: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1476, &mut x1477, x10, (arg1[11]));
  let mut x1478: u32 = 0;
  let mut x1479: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1478, &mut x1479, x10, (arg1[10]));
  let mut x1480: u32 = 0;
  let mut x1481: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1480, &mut x1481, x10, (arg1[9]));
  let mut x1482: u32 = 0;
  let mut x1483: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1482, &mut x1483, x10, (arg1[8]));
  let mut x1484: u32 = 0;
  let mut x1485: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1484, &mut x1485, x10, (arg1[7]));
  let mut x1486: u32 = 0;
  let mut x1487: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1486, &mut x1487, x10, (arg1[6]));
  let mut x1488: u32 = 0;
  let mut x1489: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1488, &mut x1489, x10, (arg1[5]));
  let mut x1490: u32 = 0;
  let mut x1491: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1490, &mut x1491, x10, (arg1[4]));
  let mut x1492: u32 = 0;
  let mut x1493: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1492, &mut x1493, x10, (arg1[3]));
  let mut x1494: u32 = 0;
  let mut x1495: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1494, &mut x1495, x10, (arg1[2]));
  let mut x1496: u32 = 0;
  let mut x1497: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1496, &mut x1497, x10, (arg1[1]));
  let mut x1498: u32 = 0;
  let mut x1499: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1498, &mut x1499, x10, (arg1[0]));
  let mut x1500: u32 = 0;
  let mut x1501: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1500, &mut x1501, 0x0, x1499, x1496);
  let mut x1502: u32 = 0;
  let mut x1503: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1502, &mut x1503, x1501, x1497, x1494);
  let mut x1504: u32 = 0;
  let mut x1505: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1504, &mut x1505, x1503, x1495, x1492);
  let mut x1506: u32 = 0;
  let mut x1507: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1506, &mut x1507, x1505, x1493, x1490);
  let mut x1508: u32 = 0;
  let mut x1509: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1508, &mut x1509, x1507, x1491, x1488);
  let mut x1510: u32 = 0;
  let mut x1511: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1510, &mut x1511, x1509, x1489, x1486);
  let mut x1512: u32 = 0;
  let mut x1513: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1512, &mut x1513, x1511, x1487, x1484);
  let mut x1514: u32 = 0;
  let mut x1515: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1514, &mut x1515, x1513, x1485, x1482);
  let mut x1516: u32 = 0;
  let mut x1517: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1516, &mut x1517, x1515, x1483, x1480);
  let mut x1518: u32 = 0;
  let mut x1519: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1518, &mut x1519, x1517, x1481, x1478);
  let mut x1520: u32 = 0;
  let mut x1521: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1520, &mut x1521, x1519, x1479, x1476);
  let x1522: u32 = ((x1521 as u32) + x1477);
  let mut x1523: u32 = 0;
  let mut x1524: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1523, &mut x1524, 0x0, x1451, x1498);
  let mut x1525: u32 = 0;
  let mut x1526: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1525, &mut x1526, x1524, x1453, x1500);
  let mut x1527: u32 = 0;
  let mut x1528: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1527, &mut x1528, x1526, x1455, x1502);
  let mut x1529: u32 = 0;
  let mut x1530: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1529, &mut x1530, x1528, x1457, x1504);
  let mut x1531: u32 = 0;
  let mut x1532: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1531, &mut x1532, x1530, x1459, x1506);
  let mut x1533: u32 = 0;
  let mut x1534: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1533, &mut x1534, x1532, x1461, x1508);
  let mut x1535: u32 = 0;
  let mut x1536: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1535, &mut x1536, x1534, x1463, x1510);
  let mut x1537: u32 = 0;
  let mut x1538: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1537, &mut x1538, x1536, x1465, x1512);
  let mut x1539: u32 = 0;
  let mut x1540: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1539, &mut x1540, x1538, x1467, x1514);
  let mut x1541: u32 = 0;
  let mut x1542: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1541, &mut x1542, x1540, x1469, x1516);
  let mut x1543: u32 = 0;
  let mut x1544: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1543, &mut x1544, x1542, x1471, x1518);
  let mut x1545: u32 = 0;
  let mut x1546: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1545, &mut x1546, x1544, x1473, x1520);
  let mut x1547: u32 = 0;
  let mut x1548: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1547, &mut x1548, x1546, x1475, x1522);
  let mut x1549: u32 = 0;
  let mut x1550: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1549, &mut x1550, x1523, 0xe88fdc45);
  let mut x1551: u32 = 0;
  let mut x1552: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1551, &mut x1552, x1549, 0xffffffff);
  let mut x1553: u32 = 0;
  let mut x1554: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1553, &mut x1554, x1549, 0xffffffff);
  let mut x1555: u32 = 0;
  let mut x1556: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1555, &mut x1556, x1549, 0xffffffff);
  let mut x1557: u32 = 0;
  let mut x1558: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1557, &mut x1558, x1549, 0xffffffff);
  let mut x1559: u32 = 0;
  let mut x1560: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1559, &mut x1560, x1549, 0xffffffff);
  let mut x1561: u32 = 0;
  let mut x1562: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1561, &mut x1562, x1549, 0xffffffff);
  let mut x1563: u32 = 0;
  let mut x1564: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1563, &mut x1564, x1549, 0xc7634d81);
  let mut x1565: u32 = 0;
  let mut x1566: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1565, &mut x1566, x1549, 0xf4372ddf);
  let mut x1567: u32 = 0;
  let mut x1568: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1567, &mut x1568, x1549, 0x581a0db2);
  let mut x1569: u32 = 0;
  let mut x1570: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1569, &mut x1570, x1549, 0x48b0a77a);
  let mut x1571: u32 = 0;
  let mut x1572: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1571, &mut x1572, x1549, 0xecec196a);
  let mut x1573: u32 = 0;
  let mut x1574: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1573, &mut x1574, x1549, 0xccc52973);
  let mut x1575: u32 = 0;
  let mut x1576: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1575, &mut x1576, 0x0, x1574, x1571);
  let mut x1577: u32 = 0;
  let mut x1578: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1577, &mut x1578, x1576, x1572, x1569);
  let mut x1579: u32 = 0;
  let mut x1580: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1579, &mut x1580, x1578, x1570, x1567);
  let mut x1581: u32 = 0;
  let mut x1582: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1581, &mut x1582, x1580, x1568, x1565);
  let mut x1583: u32 = 0;
  let mut x1584: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1583, &mut x1584, x1582, x1566, x1563);
  let mut x1585: u32 = 0;
  let mut x1586: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1585, &mut x1586, x1584, x1564, x1561);
  let mut x1587: u32 = 0;
  let mut x1588: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1587, &mut x1588, x1586, x1562, x1559);
  let mut x1589: u32 = 0;
  let mut x1590: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1589, &mut x1590, x1588, x1560, x1557);
  let mut x1591: u32 = 0;
  let mut x1592: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1591, &mut x1592, x1590, x1558, x1555);
  let mut x1593: u32 = 0;
  let mut x1594: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1593, &mut x1594, x1592, x1556, x1553);
  let mut x1595: u32 = 0;
  let mut x1596: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1595, &mut x1596, x1594, x1554, x1551);
  let x1597: u32 = ((x1596 as u32) + x1552);
  let mut x1598: u32 = 0;
  let mut x1599: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1598, &mut x1599, 0x0, x1523, x1573);
  let mut x1600: u32 = 0;
  let mut x1601: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1600, &mut x1601, x1599, x1525, x1575);
  let mut x1602: u32 = 0;
  let mut x1603: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1602, &mut x1603, x1601, x1527, x1577);
  let mut x1604: u32 = 0;
  let mut x1605: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1604, &mut x1605, x1603, x1529, x1579);
  let mut x1606: u32 = 0;
  let mut x1607: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1606, &mut x1607, x1605, x1531, x1581);
  let mut x1608: u32 = 0;
  let mut x1609: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1608, &mut x1609, x1607, x1533, x1583);
  let mut x1610: u32 = 0;
  let mut x1611: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1610, &mut x1611, x1609, x1535, x1585);
  let mut x1612: u32 = 0;
  let mut x1613: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1612, &mut x1613, x1611, x1537, x1587);
  let mut x1614: u32 = 0;
  let mut x1615: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1614, &mut x1615, x1613, x1539, x1589);
  let mut x1616: u32 = 0;
  let mut x1617: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1616, &mut x1617, x1615, x1541, x1591);
  let mut x1618: u32 = 0;
  let mut x1619: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1618, &mut x1619, x1617, x1543, x1593);
  let mut x1620: u32 = 0;
  let mut x1621: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1620, &mut x1621, x1619, x1545, x1595);
  let mut x1622: u32 = 0;
  let mut x1623: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1622, &mut x1623, x1621, x1547, x1597);
  let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
  let mut x1625: u32 = 0;
  let mut x1626: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1625, &mut x1626, x11, (arg1[11]));
  let mut x1627: u32 = 0;
  let mut x1628: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1627, &mut x1628, x11, (arg1[10]));
  let mut x1629: u32 = 0;
  let mut x1630: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1629, &mut x1630, x11, (arg1[9]));
  let mut x1631: u32 = 0;
  let mut x1632: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1631, &mut x1632, x11, (arg1[8]));
  let mut x1633: u32 = 0;
  let mut x1634: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1633, &mut x1634, x11, (arg1[7]));
  let mut x1635: u32 = 0;
  let mut x1636: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1635, &mut x1636, x11, (arg1[6]));
  let mut x1637: u32 = 0;
  let mut x1638: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1637, &mut x1638, x11, (arg1[5]));
  let mut x1639: u32 = 0;
  let mut x1640: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1639, &mut x1640, x11, (arg1[4]));
  let mut x1641: u32 = 0;
  let mut x1642: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1641, &mut x1642, x11, (arg1[3]));
  let mut x1643: u32 = 0;
  let mut x1644: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1643, &mut x1644, x11, (arg1[2]));
  let mut x1645: u32 = 0;
  let mut x1646: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1645, &mut x1646, x11, (arg1[1]));
  let mut x1647: u32 = 0;
  let mut x1648: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1647, &mut x1648, x11, (arg1[0]));
  let mut x1649: u32 = 0;
  let mut x1650: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1649, &mut x1650, 0x0, x1648, x1645);
  let mut x1651: u32 = 0;
  let mut x1652: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1651, &mut x1652, x1650, x1646, x1643);
  let mut x1653: u32 = 0;
  let mut x1654: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1653, &mut x1654, x1652, x1644, x1641);
  let mut x1655: u32 = 0;
  let mut x1656: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1655, &mut x1656, x1654, x1642, x1639);
  let mut x1657: u32 = 0;
  let mut x1658: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1657, &mut x1658, x1656, x1640, x1637);
  let mut x1659: u32 = 0;
  let mut x1660: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1659, &mut x1660, x1658, x1638, x1635);
  let mut x1661: u32 = 0;
  let mut x1662: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1661, &mut x1662, x1660, x1636, x1633);
  let mut x1663: u32 = 0;
  let mut x1664: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1663, &mut x1664, x1662, x1634, x1631);
  let mut x1665: u32 = 0;
  let mut x1666: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1665, &mut x1666, x1664, x1632, x1629);
  let mut x1667: u32 = 0;
  let mut x1668: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1667, &mut x1668, x1666, x1630, x1627);
  let mut x1669: u32 = 0;
  let mut x1670: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1669, &mut x1670, x1668, x1628, x1625);
  let x1671: u32 = ((x1670 as u32) + x1626);
  let mut x1672: u32 = 0;
  let mut x1673: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1672, &mut x1673, 0x0, x1600, x1647);
  let mut x1674: u32 = 0;
  let mut x1675: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1674, &mut x1675, x1673, x1602, x1649);
  let mut x1676: u32 = 0;
  let mut x1677: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1676, &mut x1677, x1675, x1604, x1651);
  let mut x1678: u32 = 0;
  let mut x1679: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1678, &mut x1679, x1677, x1606, x1653);
  let mut x1680: u32 = 0;
  let mut x1681: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1680, &mut x1681, x1679, x1608, x1655);
  let mut x1682: u32 = 0;
  let mut x1683: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1682, &mut x1683, x1681, x1610, x1657);
  let mut x1684: u32 = 0;
  let mut x1685: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1684, &mut x1685, x1683, x1612, x1659);
  let mut x1686: u32 = 0;
  let mut x1687: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1686, &mut x1687, x1685, x1614, x1661);
  let mut x1688: u32 = 0;
  let mut x1689: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1688, &mut x1689, x1687, x1616, x1663);
  let mut x1690: u32 = 0;
  let mut x1691: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1690, &mut x1691, x1689, x1618, x1665);
  let mut x1692: u32 = 0;
  let mut x1693: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1692, &mut x1693, x1691, x1620, x1667);
  let mut x1694: u32 = 0;
  let mut x1695: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1694, &mut x1695, x1693, x1622, x1669);
  let mut x1696: u32 = 0;
  let mut x1697: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1696, &mut x1697, x1695, x1624, x1671);
  let mut x1698: u32 = 0;
  let mut x1699: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1698, &mut x1699, x1672, 0xe88fdc45);
  let mut x1700: u32 = 0;
  let mut x1701: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1700, &mut x1701, x1698, 0xffffffff);
  let mut x1702: u32 = 0;
  let mut x1703: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1702, &mut x1703, x1698, 0xffffffff);
  let mut x1704: u32 = 0;
  let mut x1705: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1704, &mut x1705, x1698, 0xffffffff);
  let mut x1706: u32 = 0;
  let mut x1707: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1706, &mut x1707, x1698, 0xffffffff);
  let mut x1708: u32 = 0;
  let mut x1709: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1708, &mut x1709, x1698, 0xffffffff);
  let mut x1710: u32 = 0;
  let mut x1711: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1710, &mut x1711, x1698, 0xffffffff);
  let mut x1712: u32 = 0;
  let mut x1713: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1712, &mut x1713, x1698, 0xc7634d81);
  let mut x1714: u32 = 0;
  let mut x1715: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1714, &mut x1715, x1698, 0xf4372ddf);
  let mut x1716: u32 = 0;
  let mut x1717: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1716, &mut x1717, x1698, 0x581a0db2);
  let mut x1718: u32 = 0;
  let mut x1719: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1718, &mut x1719, x1698, 0x48b0a77a);
  let mut x1720: u32 = 0;
  let mut x1721: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1720, &mut x1721, x1698, 0xecec196a);
  let mut x1722: u32 = 0;
  let mut x1723: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1722, &mut x1723, x1698, 0xccc52973);
  let mut x1724: u32 = 0;
  let mut x1725: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1724, &mut x1725, 0x0, x1723, x1720);
  let mut x1726: u32 = 0;
  let mut x1727: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1726, &mut x1727, x1725, x1721, x1718);
  let mut x1728: u32 = 0;
  let mut x1729: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1728, &mut x1729, x1727, x1719, x1716);
  let mut x1730: u32 = 0;
  let mut x1731: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1730, &mut x1731, x1729, x1717, x1714);
  let mut x1732: u32 = 0;
  let mut x1733: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1732, &mut x1733, x1731, x1715, x1712);
  let mut x1734: u32 = 0;
  let mut x1735: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1734, &mut x1735, x1733, x1713, x1710);
  let mut x1736: u32 = 0;
  let mut x1737: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1736, &mut x1737, x1735, x1711, x1708);
  let mut x1738: u32 = 0;
  let mut x1739: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1738, &mut x1739, x1737, x1709, x1706);
  let mut x1740: u32 = 0;
  let mut x1741: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1740, &mut x1741, x1739, x1707, x1704);
  let mut x1742: u32 = 0;
  let mut x1743: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1742, &mut x1743, x1741, x1705, x1702);
  let mut x1744: u32 = 0;
  let mut x1745: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1744, &mut x1745, x1743, x1703, x1700);
  let x1746: u32 = ((x1745 as u32) + x1701);
  let mut x1747: u32 = 0;
  let mut x1748: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1747, &mut x1748, 0x0, x1672, x1722);
  let mut x1749: u32 = 0;
  let mut x1750: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1749, &mut x1750, x1748, x1674, x1724);
  let mut x1751: u32 = 0;
  let mut x1752: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1751, &mut x1752, x1750, x1676, x1726);
  let mut x1753: u32 = 0;
  let mut x1754: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1753, &mut x1754, x1752, x1678, x1728);
  let mut x1755: u32 = 0;
  let mut x1756: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1755, &mut x1756, x1754, x1680, x1730);
  let mut x1757: u32 = 0;
  let mut x1758: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1757, &mut x1758, x1756, x1682, x1732);
  let mut x1759: u32 = 0;
  let mut x1760: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1759, &mut x1760, x1758, x1684, x1734);
  let mut x1761: u32 = 0;
  let mut x1762: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1761, &mut x1762, x1760, x1686, x1736);
  let mut x1763: u32 = 0;
  let mut x1764: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1763, &mut x1764, x1762, x1688, x1738);
  let mut x1765: u32 = 0;
  let mut x1766: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1765, &mut x1766, x1764, x1690, x1740);
  let mut x1767: u32 = 0;
  let mut x1768: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1767, &mut x1768, x1766, x1692, x1742);
  let mut x1769: u32 = 0;
  let mut x1770: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1769, &mut x1770, x1768, x1694, x1744);
  let mut x1771: u32 = 0;
  let mut x1772: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1771, &mut x1772, x1770, x1696, x1746);
  let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
  let mut x1774: u32 = 0;
  let mut x1775: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1774, &mut x1775, 0x0, x1749, 0xccc52973);
  let mut x1776: u32 = 0;
  let mut x1777: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1776, &mut x1777, x1775, x1751, 0xecec196a);
  let mut x1778: u32 = 0;
  let mut x1779: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1778, &mut x1779, x1777, x1753, 0x48b0a77a);
  let mut x1780: u32 = 0;
  let mut x1781: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1780, &mut x1781, x1779, x1755, 0x581a0db2);
  let mut x1782: u32 = 0;
  let mut x1783: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1782, &mut x1783, x1781, x1757, 0xf4372ddf);
  let mut x1784: u32 = 0;
  let mut x1785: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1784, &mut x1785, x1783, x1759, 0xc7634d81);
  let mut x1786: u32 = 0;
  let mut x1787: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1786, &mut x1787, x1785, x1761, 0xffffffff);
  let mut x1788: u32 = 0;
  let mut x1789: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1788, &mut x1789, x1787, x1763, 0xffffffff);
  let mut x1790: u32 = 0;
  let mut x1791: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1790, &mut x1791, x1789, x1765, 0xffffffff);
  let mut x1792: u32 = 0;
  let mut x1793: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1792, &mut x1793, x1791, x1767, 0xffffffff);
  let mut x1794: u32 = 0;
  let mut x1795: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1794, &mut x1795, x1793, x1769, 0xffffffff);
  let mut x1796: u32 = 0;
  let mut x1797: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1796, &mut x1797, x1795, x1771, 0xffffffff);
  let mut x1798: u32 = 0;
  let mut x1799: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1798, &mut x1799, x1797, x1773, (0x0 as u32));
  let mut x1800: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1800, x1799, x1774, x1749);
  let mut x1801: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1801, x1799, x1776, x1751);
  let mut x1802: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1802, x1799, x1778, x1753);
  let mut x1803: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1803, x1799, x1780, x1755);
  let mut x1804: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1804, x1799, x1782, x1757);
  let mut x1805: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1805, x1799, x1784, x1759);
  let mut x1806: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1806, x1799, x1786, x1761);
  let mut x1807: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1807, x1799, x1788, x1763);
  let mut x1808: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1808, x1799, x1790, x1765);
  let mut x1809: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1809, x1799, x1792, x1767);
  let mut x1810: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1810, x1799, x1794, x1769);
  let mut x1811: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1811, x1799, x1796, x1771);
  out1[0] = x1800;
  out1[1] = x1801;
  out1[2] = x1802;
  out1[3] = x1803;
  out1[4] = x1804;
  out1[5] = x1805;
  out1[6] = x1806;
  out1[7] = x1807;
  out1[8] = x1808;
  out1[9] = x1809;
  out1[10] = x1810;
  out1[11] = x1811;
}

/// The function fiat_p384_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_add(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x17, &mut x18, x16, (arg1[8]), (arg2[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x19, &mut x20, x18, (arg1[9]), (arg2[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x21, &mut x22, x20, (arg1[10]), (arg2[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x23, &mut x24, x22, (arg1[11]), (arg2[11]));
  let mut x25: u32 = 0;
  let mut x26: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x25, &mut x26, 0x0, x1, 0xccc52973);
  let mut x27: u32 = 0;
  let mut x28: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x27, &mut x28, x26, x3, 0xecec196a);
  let mut x29: u32 = 0;
  let mut x30: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x29, &mut x30, x28, x5, 0x48b0a77a);
  let mut x31: u32 = 0;
  let mut x32: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x31, &mut x32, x30, x7, 0x581a0db2);
  let mut x33: u32 = 0;
  let mut x34: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x33, &mut x34, x32, x9, 0xf4372ddf);
  let mut x35: u32 = 0;
  let mut x36: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x35, &mut x36, x34, x11, 0xc7634d81);
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x37, &mut x38, x36, x13, 0xffffffff);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x39, &mut x40, x38, x15, 0xffffffff);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x41, &mut x42, x40, x17, 0xffffffff);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x43, &mut x44, x42, x19, 0xffffffff);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x45, &mut x46, x44, x21, 0xffffffff);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x47, &mut x48, x46, x23, 0xffffffff);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x49, &mut x50, x48, (x24 as u32), (0x0 as u32));
  let mut x51: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x51, x50, x25, x1);
  let mut x52: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x52, x50, x27, x3);
  let mut x53: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x53, x50, x29, x5);
  let mut x54: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x54, x50, x31, x7);
  let mut x55: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x55, x50, x33, x9);
  let mut x56: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x56, x50, x35, x11);
  let mut x57: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x57, x50, x37, x13);
  let mut x58: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x58, x50, x39, x15);
  let mut x59: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x59, x50, x41, x17);
  let mut x60: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x60, x50, x43, x19);
  let mut x61: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x61, x50, x45, x21);
  let mut x62: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x62, x50, x47, x23);
  out1[0] = x51;
  out1[1] = x52;
  out1[2] = x53;
  out1[3] = x54;
  out1[4] = x55;
  out1[5] = x56;
  out1[6] = x57;
  out1[7] = x58;
  out1[8] = x59;
  out1[9] = x60;
  out1[10] = x61;
  out1[11] = x62;
}

/// The function fiat_p384_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_sub(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x17, &mut x18, x16, (arg1[8]), (arg2[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x19, &mut x20, x18, (arg1[9]), (arg2[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x21, &mut x22, x20, (arg1[10]), (arg2[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x23, &mut x24, x22, (arg1[11]), (arg2[11]));
  let mut x25: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x25, x24, (0x0 as u32), 0xffffffff);
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x26, &mut x27, 0x0, x1, (x25 & 0xccc52973));
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x3, (x25 & 0xecec196a));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x5, (x25 & 0x48b0a77a));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x7, (x25 & 0x581a0db2));
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x34, &mut x35, x33, x9, (x25 & 0xf4372ddf));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x36, &mut x37, x35, x11, (x25 & 0xc7634d81));
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x38, &mut x39, x37, x13, x25);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x40, &mut x41, x39, x15, x25);
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x42, &mut x43, x41, x17, x25);
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x44, &mut x45, x43, x19, x25);
  let mut x46: u32 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x46, &mut x47, x45, x21, x25);
  let mut x48: u32 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x48, &mut x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/// The function fiat_p384_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_opp(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (arg1[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (arg1[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (arg1[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (arg1[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (arg1[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (arg1[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (arg1[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (arg1[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x17, &mut x18, x16, (0x0 as u32), (arg1[8]));
  let mut x19: u32 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x19, &mut x20, x18, (0x0 as u32), (arg1[9]));
  let mut x21: u32 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x21, &mut x22, x20, (0x0 as u32), (arg1[10]));
  let mut x23: u32 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x23, &mut x24, x22, (0x0 as u32), (arg1[11]));
  let mut x25: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x25, x24, (0x0 as u32), 0xffffffff);
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x26, &mut x27, 0x0, x1, (x25 & 0xccc52973));
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x3, (x25 & 0xecec196a));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x5, (x25 & 0x48b0a77a));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x7, (x25 & 0x581a0db2));
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x34, &mut x35, x33, x9, (x25 & 0xf4372ddf));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x36, &mut x37, x35, x11, (x25 & 0xc7634d81));
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x38, &mut x39, x37, x13, x25);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x40, &mut x41, x39, x15, x25);
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x42, &mut x43, x41, x17, x25);
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x44, &mut x45, x43, x19, x25);
  let mut x46: u32 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x46, &mut x47, x45, x21, x25);
  let mut x48: u32 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x48, &mut x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/// The function fiat_p384_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_from_montgomery(out1: &mut fiat_p384_scalar_non_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[0]);
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x2, &mut x3, x1, 0xe88fdc45);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x4, &mut x5, x2, 0xffffffff);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x6, &mut x7, x2, 0xffffffff);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x8, &mut x9, x2, 0xffffffff);
  let mut x10: u32 = 0;
  let mut x11: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x10, &mut x11, x2, 0xffffffff);
  let mut x12: u32 = 0;
  let mut x13: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x12, &mut x13, x2, 0xffffffff);
  let mut x14: u32 = 0;
  let mut x15: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x14, &mut x15, x2, 0xffffffff);
  let mut x16: u32 = 0;
  let mut x17: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x16, &mut x17, x2, 0xc7634d81);
  let mut x18: u32 = 0;
  let mut x19: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x18, &mut x19, x2, 0xf4372ddf);
  let mut x20: u32 = 0;
  let mut x21: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x20, &mut x21, x2, 0x581a0db2);
  let mut x22: u32 = 0;
  let mut x23: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x22, &mut x23, x2, 0x48b0a77a);
  let mut x24: u32 = 0;
  let mut x25: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x24, &mut x25, x2, 0xecec196a);
  let mut x26: u32 = 0;
  let mut x27: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x26, &mut x27, x2, 0xccc52973);
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x28, &mut x29, 0x0, x27, x24);
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x25, x22);
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x23, x20);
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x34, &mut x35, x33, x21, x18);
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x36, &mut x37, x35, x19, x16);
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x38, &mut x39, x37, x17, x14);
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x40, &mut x41, x39, x15, x12);
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x42, &mut x43, x41, x13, x10);
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x44, &mut x45, x43, x11, x8);
  let mut x46: u32 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x46, &mut x47, x45, x9, x6);
  let mut x48: u32 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x48, &mut x49, x47, x7, x4);
  let mut x50: u32 = 0;
  let mut x51: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x50, &mut x51, 0x0, x1, x26);
  let mut x52: u32 = 0;
  let mut x53: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x52, &mut x53, x51, (0x0 as u32), x28);
  let mut x54: u32 = 0;
  let mut x55: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x54, &mut x55, x53, (0x0 as u32), x30);
  let mut x56: u32 = 0;
  let mut x57: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x56, &mut x57, x55, (0x0 as u32), x32);
  let mut x58: u32 = 0;
  let mut x59: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x58, &mut x59, x57, (0x0 as u32), x34);
  let mut x60: u32 = 0;
  let mut x61: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x60, &mut x61, x59, (0x0 as u32), x36);
  let mut x62: u32 = 0;
  let mut x63: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x62, &mut x63, x61, (0x0 as u32), x38);
  let mut x64: u32 = 0;
  let mut x65: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x64, &mut x65, x63, (0x0 as u32), x40);
  let mut x66: u32 = 0;
  let mut x67: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x66, &mut x67, x65, (0x0 as u32), x42);
  let mut x68: u32 = 0;
  let mut x69: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x68, &mut x69, x67, (0x0 as u32), x44);
  let mut x70: u32 = 0;
  let mut x71: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x70, &mut x71, x69, (0x0 as u32), x46);
  let mut x72: u32 = 0;
  let mut x73: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x72, &mut x73, x71, (0x0 as u32), x48);
  let mut x74: u32 = 0;
  let mut x75: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x74, &mut x75, x73, (0x0 as u32), ((x49 as u32) + x5));
  let mut x76: u32 = 0;
  let mut x77: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x76, &mut x77, 0x0, x52, (arg1[1]));
  let mut x78: u32 = 0;
  let mut x79: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x78, &mut x79, x77, x54, (0x0 as u32));
  let mut x80: u32 = 0;
  let mut x81: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x80, &mut x81, x79, x56, (0x0 as u32));
  let mut x82: u32 = 0;
  let mut x83: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x82, &mut x83, x81, x58, (0x0 as u32));
  let mut x84: u32 = 0;
  let mut x85: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x84, &mut x85, x83, x60, (0x0 as u32));
  let mut x86: u32 = 0;
  let mut x87: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x86, &mut x87, x85, x62, (0x0 as u32));
  let mut x88: u32 = 0;
  let mut x89: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x88, &mut x89, x87, x64, (0x0 as u32));
  let mut x90: u32 = 0;
  let mut x91: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x90, &mut x91, x89, x66, (0x0 as u32));
  let mut x92: u32 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x92, &mut x93, x91, x68, (0x0 as u32));
  let mut x94: u32 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x94, &mut x95, x93, x70, (0x0 as u32));
  let mut x96: u32 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x96, &mut x97, x95, x72, (0x0 as u32));
  let mut x98: u32 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x98, &mut x99, x97, x74, (0x0 as u32));
  let mut x100: u32 = 0;
  let mut x101: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x100, &mut x101, x76, 0xe88fdc45);
  let mut x102: u32 = 0;
  let mut x103: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x102, &mut x103, x100, 0xffffffff);
  let mut x104: u32 = 0;
  let mut x105: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x104, &mut x105, x100, 0xffffffff);
  let mut x106: u32 = 0;
  let mut x107: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x106, &mut x107, x100, 0xffffffff);
  let mut x108: u32 = 0;
  let mut x109: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x108, &mut x109, x100, 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x110, &mut x111, x100, 0xffffffff);
  let mut x112: u32 = 0;
  let mut x113: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x112, &mut x113, x100, 0xffffffff);
  let mut x114: u32 = 0;
  let mut x115: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x114, &mut x115, x100, 0xc7634d81);
  let mut x116: u32 = 0;
  let mut x117: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x116, &mut x117, x100, 0xf4372ddf);
  let mut x118: u32 = 0;
  let mut x119: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x118, &mut x119, x100, 0x581a0db2);
  let mut x120: u32 = 0;
  let mut x121: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x120, &mut x121, x100, 0x48b0a77a);
  let mut x122: u32 = 0;
  let mut x123: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x122, &mut x123, x100, 0xecec196a);
  let mut x124: u32 = 0;
  let mut x125: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x124, &mut x125, x100, 0xccc52973);
  let mut x126: u32 = 0;
  let mut x127: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x126, &mut x127, 0x0, x125, x122);
  let mut x128: u32 = 0;
  let mut x129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x128, &mut x129, x127, x123, x120);
  let mut x130: u32 = 0;
  let mut x131: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x130, &mut x131, x129, x121, x118);
  let mut x132: u32 = 0;
  let mut x133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x132, &mut x133, x131, x119, x116);
  let mut x134: u32 = 0;
  let mut x135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x134, &mut x135, x133, x117, x114);
  let mut x136: u32 = 0;
  let mut x137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x136, &mut x137, x135, x115, x112);
  let mut x138: u32 = 0;
  let mut x139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x138, &mut x139, x137, x113, x110);
  let mut x140: u32 = 0;
  let mut x141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x140, &mut x141, x139, x111, x108);
  let mut x142: u32 = 0;
  let mut x143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x142, &mut x143, x141, x109, x106);
  let mut x144: u32 = 0;
  let mut x145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x144, &mut x145, x143, x107, x104);
  let mut x146: u32 = 0;
  let mut x147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x146, &mut x147, x145, x105, x102);
  let mut x148: u32 = 0;
  let mut x149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x148, &mut x149, 0x0, x76, x124);
  let mut x150: u32 = 0;
  let mut x151: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x150, &mut x151, x149, x78, x126);
  let mut x152: u32 = 0;
  let mut x153: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x152, &mut x153, x151, x80, x128);
  let mut x154: u32 = 0;
  let mut x155: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x154, &mut x155, x153, x82, x130);
  let mut x156: u32 = 0;
  let mut x157: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x156, &mut x157, x155, x84, x132);
  let mut x158: u32 = 0;
  let mut x159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x158, &mut x159, x157, x86, x134);
  let mut x160: u32 = 0;
  let mut x161: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x88, x136);
  let mut x162: u32 = 0;
  let mut x163: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x162, &mut x163, x161, x90, x138);
  let mut x164: u32 = 0;
  let mut x165: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x92, x140);
  let mut x166: u32 = 0;
  let mut x167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x166, &mut x167, x165, x94, x142);
  let mut x168: u32 = 0;
  let mut x169: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x168, &mut x169, x167, x96, x144);
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x98, x146);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x172, &mut x173, x171, ((x99 as u32) + (x75 as u32)), ((x147 as u32) + x103));
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x174, &mut x175, 0x0, x150, (arg1[2]));
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x152, (0x0 as u32));
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x154, (0x0 as u32));
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x156, (0x0 as u32));
  let mut x182: u32 = 0;
  let mut x183: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x182, &mut x183, x181, x158, (0x0 as u32));
  let mut x184: u32 = 0;
  let mut x185: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x160, (0x0 as u32));
  let mut x186: u32 = 0;
  let mut x187: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x162, (0x0 as u32));
  let mut x188: u32 = 0;
  let mut x189: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x164, (0x0 as u32));
  let mut x190: u32 = 0;
  let mut x191: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x166, (0x0 as u32));
  let mut x192: u32 = 0;
  let mut x193: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x168, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x194, &mut x195, x193, x170, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x196, &mut x197, x195, x172, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x198, &mut x199, x174, 0xe88fdc45);
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x200, &mut x201, x198, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x202, &mut x203, x198, 0xffffffff);
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x204, &mut x205, x198, 0xffffffff);
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x206, &mut x207, x198, 0xffffffff);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x208, &mut x209, x198, 0xffffffff);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x210, &mut x211, x198, 0xffffffff);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x212, &mut x213, x198, 0xc7634d81);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x214, &mut x215, x198, 0xf4372ddf);
  let mut x216: u32 = 0;
  let mut x217: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x216, &mut x217, x198, 0x581a0db2);
  let mut x218: u32 = 0;
  let mut x219: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x218, &mut x219, x198, 0x48b0a77a);
  let mut x220: u32 = 0;
  let mut x221: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x220, &mut x221, x198, 0xecec196a);
  let mut x222: u32 = 0;
  let mut x223: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x222, &mut x223, x198, 0xccc52973);
  let mut x224: u32 = 0;
  let mut x225: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x224, &mut x225, 0x0, x223, x220);
  let mut x226: u32 = 0;
  let mut x227: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x226, &mut x227, x225, x221, x218);
  let mut x228: u32 = 0;
  let mut x229: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x228, &mut x229, x227, x219, x216);
  let mut x230: u32 = 0;
  let mut x231: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x230, &mut x231, x229, x217, x214);
  let mut x232: u32 = 0;
  let mut x233: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x232, &mut x233, x231, x215, x212);
  let mut x234: u32 = 0;
  let mut x235: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x234, &mut x235, x233, x213, x210);
  let mut x236: u32 = 0;
  let mut x237: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x211, x208);
  let mut x238: u32 = 0;
  let mut x239: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x209, x206);
  let mut x240: u32 = 0;
  let mut x241: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x207, x204);
  let mut x242: u32 = 0;
  let mut x243: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x205, x202);
  let mut x244: u32 = 0;
  let mut x245: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x203, x200);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x246, &mut x247, 0x0, x174, x222);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x176, x224);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x250, &mut x251, x249, x178, x226);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x252, &mut x253, x251, x180, x228);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x254, &mut x255, x253, x182, x230);
  let mut x256: u32 = 0;
  let mut x257: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x256, &mut x257, x255, x184, x232);
  let mut x258: u32 = 0;
  let mut x259: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x258, &mut x259, x257, x186, x234);
  let mut x260: u32 = 0;
  let mut x261: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x260, &mut x261, x259, x188, x236);
  let mut x262: u32 = 0;
  let mut x263: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x262, &mut x263, x261, x190, x238);
  let mut x264: u32 = 0;
  let mut x265: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x264, &mut x265, x263, x192, x240);
  let mut x266: u32 = 0;
  let mut x267: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x266, &mut x267, x265, x194, x242);
  let mut x268: u32 = 0;
  let mut x269: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x268, &mut x269, x267, x196, x244);
  let mut x270: u32 = 0;
  let mut x271: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x270, &mut x271, x269, ((x197 as u32) + (x173 as u32)), ((x245 as u32) + x201));
  let mut x272: u32 = 0;
  let mut x273: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x272, &mut x273, 0x0, x248, (arg1[3]));
  let mut x274: u32 = 0;
  let mut x275: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x274, &mut x275, x273, x250, (0x0 as u32));
  let mut x276: u32 = 0;
  let mut x277: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x276, &mut x277, x275, x252, (0x0 as u32));
  let mut x278: u32 = 0;
  let mut x279: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x278, &mut x279, x277, x254, (0x0 as u32));
  let mut x280: u32 = 0;
  let mut x281: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x280, &mut x281, x279, x256, (0x0 as u32));
  let mut x282: u32 = 0;
  let mut x283: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x282, &mut x283, x281, x258, (0x0 as u32));
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x260, (0x0 as u32));
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x262, (0x0 as u32));
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x264, (0x0 as u32));
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x266, (0x0 as u32));
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x292, &mut x293, x291, x268, (0x0 as u32));
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x294, &mut x295, x293, x270, (0x0 as u32));
  let mut x296: u32 = 0;
  let mut x297: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x296, &mut x297, x272, 0xe88fdc45);
  let mut x298: u32 = 0;
  let mut x299: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x298, &mut x299, x296, 0xffffffff);
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x300, &mut x301, x296, 0xffffffff);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x302, &mut x303, x296, 0xffffffff);
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x304, &mut x305, x296, 0xffffffff);
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x306, &mut x307, x296, 0xffffffff);
  let mut x308: u32 = 0;
  let mut x309: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x308, &mut x309, x296, 0xffffffff);
  let mut x310: u32 = 0;
  let mut x311: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x310, &mut x311, x296, 0xc7634d81);
  let mut x312: u32 = 0;
  let mut x313: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x312, &mut x313, x296, 0xf4372ddf);
  let mut x314: u32 = 0;
  let mut x315: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x314, &mut x315, x296, 0x581a0db2);
  let mut x316: u32 = 0;
  let mut x317: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x316, &mut x317, x296, 0x48b0a77a);
  let mut x318: u32 = 0;
  let mut x319: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x318, &mut x319, x296, 0xecec196a);
  let mut x320: u32 = 0;
  let mut x321: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x320, &mut x321, x296, 0xccc52973);
  let mut x322: u32 = 0;
  let mut x323: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x322, &mut x323, 0x0, x321, x318);
  let mut x324: u32 = 0;
  let mut x325: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x324, &mut x325, x323, x319, x316);
  let mut x326: u32 = 0;
  let mut x327: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x317, x314);
  let mut x328: u32 = 0;
  let mut x329: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x315, x312);
  let mut x330: u32 = 0;
  let mut x331: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x330, &mut x331, x329, x313, x310);
  let mut x332: u32 = 0;
  let mut x333: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x332, &mut x333, x331, x311, x308);
  let mut x334: u32 = 0;
  let mut x335: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x334, &mut x335, x333, x309, x306);
  let mut x336: u32 = 0;
  let mut x337: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x336, &mut x337, x335, x307, x304);
  let mut x338: u32 = 0;
  let mut x339: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x338, &mut x339, x337, x305, x302);
  let mut x340: u32 = 0;
  let mut x341: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x340, &mut x341, x339, x303, x300);
  let mut x342: u32 = 0;
  let mut x343: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x342, &mut x343, x341, x301, x298);
  let mut x344: u32 = 0;
  let mut x345: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x344, &mut x345, 0x0, x272, x320);
  let mut x346: u32 = 0;
  let mut x347: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x346, &mut x347, x345, x274, x322);
  let mut x348: u32 = 0;
  let mut x349: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x348, &mut x349, x347, x276, x324);
  let mut x350: u32 = 0;
  let mut x351: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x350, &mut x351, x349, x278, x326);
  let mut x352: u32 = 0;
  let mut x353: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x352, &mut x353, x351, x280, x328);
  let mut x354: u32 = 0;
  let mut x355: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x354, &mut x355, x353, x282, x330);
  let mut x356: u32 = 0;
  let mut x357: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x356, &mut x357, x355, x284, x332);
  let mut x358: u32 = 0;
  let mut x359: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x358, &mut x359, x357, x286, x334);
  let mut x360: u32 = 0;
  let mut x361: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x360, &mut x361, x359, x288, x336);
  let mut x362: u32 = 0;
  let mut x363: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x290, x338);
  let mut x364: u32 = 0;
  let mut x365: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x364, &mut x365, x363, x292, x340);
  let mut x366: u32 = 0;
  let mut x367: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x294, x342);
  let mut x368: u32 = 0;
  let mut x369: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x368, &mut x369, x367, ((x295 as u32) + (x271 as u32)), ((x343 as u32) + x299));
  let mut x370: u32 = 0;
  let mut x371: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x370, &mut x371, 0x0, x346, (arg1[4]));
  let mut x372: u32 = 0;
  let mut x373: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x372, &mut x373, x371, x348, (0x0 as u32));
  let mut x374: u32 = 0;
  let mut x375: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x374, &mut x375, x373, x350, (0x0 as u32));
  let mut x376: u32 = 0;
  let mut x377: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x376, &mut x377, x375, x352, (0x0 as u32));
  let mut x378: u32 = 0;
  let mut x379: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x378, &mut x379, x377, x354, (0x0 as u32));
  let mut x380: u32 = 0;
  let mut x381: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x380, &mut x381, x379, x356, (0x0 as u32));
  let mut x382: u32 = 0;
  let mut x383: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x382, &mut x383, x381, x358, (0x0 as u32));
  let mut x384: u32 = 0;
  let mut x385: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x384, &mut x385, x383, x360, (0x0 as u32));
  let mut x386: u32 = 0;
  let mut x387: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x386, &mut x387, x385, x362, (0x0 as u32));
  let mut x388: u32 = 0;
  let mut x389: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x388, &mut x389, x387, x364, (0x0 as u32));
  let mut x390: u32 = 0;
  let mut x391: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x390, &mut x391, x389, x366, (0x0 as u32));
  let mut x392: u32 = 0;
  let mut x393: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x392, &mut x393, x391, x368, (0x0 as u32));
  let mut x394: u32 = 0;
  let mut x395: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x394, &mut x395, x370, 0xe88fdc45);
  let mut x396: u32 = 0;
  let mut x397: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x396, &mut x397, x394, 0xffffffff);
  let mut x398: u32 = 0;
  let mut x399: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x398, &mut x399, x394, 0xffffffff);
  let mut x400: u32 = 0;
  let mut x401: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x400, &mut x401, x394, 0xffffffff);
  let mut x402: u32 = 0;
  let mut x403: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x402, &mut x403, x394, 0xffffffff);
  let mut x404: u32 = 0;
  let mut x405: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x404, &mut x405, x394, 0xffffffff);
  let mut x406: u32 = 0;
  let mut x407: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x406, &mut x407, x394, 0xffffffff);
  let mut x408: u32 = 0;
  let mut x409: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x408, &mut x409, x394, 0xc7634d81);
  let mut x410: u32 = 0;
  let mut x411: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x410, &mut x411, x394, 0xf4372ddf);
  let mut x412: u32 = 0;
  let mut x413: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x412, &mut x413, x394, 0x581a0db2);
  let mut x414: u32 = 0;
  let mut x415: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x414, &mut x415, x394, 0x48b0a77a);
  let mut x416: u32 = 0;
  let mut x417: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x416, &mut x417, x394, 0xecec196a);
  let mut x418: u32 = 0;
  let mut x419: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x418, &mut x419, x394, 0xccc52973);
  let mut x420: u32 = 0;
  let mut x421: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x420, &mut x421, 0x0, x419, x416);
  let mut x422: u32 = 0;
  let mut x423: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x417, x414);
  let mut x424: u32 = 0;
  let mut x425: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x424, &mut x425, x423, x415, x412);
  let mut x426: u32 = 0;
  let mut x427: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x426, &mut x427, x425, x413, x410);
  let mut x428: u32 = 0;
  let mut x429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x428, &mut x429, x427, x411, x408);
  let mut x430: u32 = 0;
  let mut x431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x430, &mut x431, x429, x409, x406);
  let mut x432: u32 = 0;
  let mut x433: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x432, &mut x433, x431, x407, x404);
  let mut x434: u32 = 0;
  let mut x435: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x434, &mut x435, x433, x405, x402);
  let mut x436: u32 = 0;
  let mut x437: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x436, &mut x437, x435, x403, x400);
  let mut x438: u32 = 0;
  let mut x439: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x438, &mut x439, x437, x401, x398);
  let mut x440: u32 = 0;
  let mut x441: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x440, &mut x441, x439, x399, x396);
  let mut x442: u32 = 0;
  let mut x443: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x442, &mut x443, 0x0, x370, x418);
  let mut x444: u32 = 0;
  let mut x445: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x444, &mut x445, x443, x372, x420);
  let mut x446: u32 = 0;
  let mut x447: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x446, &mut x447, x445, x374, x422);
  let mut x448: u32 = 0;
  let mut x449: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x448, &mut x449, x447, x376, x424);
  let mut x450: u32 = 0;
  let mut x451: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x450, &mut x451, x449, x378, x426);
  let mut x452: u32 = 0;
  let mut x453: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x452, &mut x453, x451, x380, x428);
  let mut x454: u32 = 0;
  let mut x455: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x454, &mut x455, x453, x382, x430);
  let mut x456: u32 = 0;
  let mut x457: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x456, &mut x457, x455, x384, x432);
  let mut x458: u32 = 0;
  let mut x459: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x458, &mut x459, x457, x386, x434);
  let mut x460: u32 = 0;
  let mut x461: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x460, &mut x461, x459, x388, x436);
  let mut x462: u32 = 0;
  let mut x463: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x462, &mut x463, x461, x390, x438);
  let mut x464: u32 = 0;
  let mut x465: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x464, &mut x465, x463, x392, x440);
  let mut x466: u32 = 0;
  let mut x467: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x466, &mut x467, x465, ((x393 as u32) + (x369 as u32)), ((x441 as u32) + x397));
  let mut x468: u32 = 0;
  let mut x469: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x468, &mut x469, 0x0, x444, (arg1[5]));
  let mut x470: u32 = 0;
  let mut x471: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x470, &mut x471, x469, x446, (0x0 as u32));
  let mut x472: u32 = 0;
  let mut x473: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x472, &mut x473, x471, x448, (0x0 as u32));
  let mut x474: u32 = 0;
  let mut x475: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x474, &mut x475, x473, x450, (0x0 as u32));
  let mut x476: u32 = 0;
  let mut x477: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x476, &mut x477, x475, x452, (0x0 as u32));
  let mut x478: u32 = 0;
  let mut x479: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x478, &mut x479, x477, x454, (0x0 as u32));
  let mut x480: u32 = 0;
  let mut x481: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x480, &mut x481, x479, x456, (0x0 as u32));
  let mut x482: u32 = 0;
  let mut x483: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x482, &mut x483, x481, x458, (0x0 as u32));
  let mut x484: u32 = 0;
  let mut x485: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x460, (0x0 as u32));
  let mut x486: u32 = 0;
  let mut x487: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x462, (0x0 as u32));
  let mut x488: u32 = 0;
  let mut x489: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x464, (0x0 as u32));
  let mut x490: u32 = 0;
  let mut x491: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x466, (0x0 as u32));
  let mut x492: u32 = 0;
  let mut x493: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x492, &mut x493, x468, 0xe88fdc45);
  let mut x494: u32 = 0;
  let mut x495: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x494, &mut x495, x492, 0xffffffff);
  let mut x496: u32 = 0;
  let mut x497: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x496, &mut x497, x492, 0xffffffff);
  let mut x498: u32 = 0;
  let mut x499: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x498, &mut x499, x492, 0xffffffff);
  let mut x500: u32 = 0;
  let mut x501: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x500, &mut x501, x492, 0xffffffff);
  let mut x502: u32 = 0;
  let mut x503: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x502, &mut x503, x492, 0xffffffff);
  let mut x504: u32 = 0;
  let mut x505: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x504, &mut x505, x492, 0xffffffff);
  let mut x506: u32 = 0;
  let mut x507: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x506, &mut x507, x492, 0xc7634d81);
  let mut x508: u32 = 0;
  let mut x509: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x508, &mut x509, x492, 0xf4372ddf);
  let mut x510: u32 = 0;
  let mut x511: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x510, &mut x511, x492, 0x581a0db2);
  let mut x512: u32 = 0;
  let mut x513: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x512, &mut x513, x492, 0x48b0a77a);
  let mut x514: u32 = 0;
  let mut x515: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x514, &mut x515, x492, 0xecec196a);
  let mut x516: u32 = 0;
  let mut x517: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x516, &mut x517, x492, 0xccc52973);
  let mut x518: u32 = 0;
  let mut x519: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x518, &mut x519, 0x0, x517, x514);
  let mut x520: u32 = 0;
  let mut x521: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x520, &mut x521, x519, x515, x512);
  let mut x522: u32 = 0;
  let mut x523: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x522, &mut x523, x521, x513, x510);
  let mut x524: u32 = 0;
  let mut x525: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x524, &mut x525, x523, x511, x508);
  let mut x526: u32 = 0;
  let mut x527: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x526, &mut x527, x525, x509, x506);
  let mut x528: u32 = 0;
  let mut x529: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x528, &mut x529, x527, x507, x504);
  let mut x530: u32 = 0;
  let mut x531: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x530, &mut x531, x529, x505, x502);
  let mut x532: u32 = 0;
  let mut x533: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x532, &mut x533, x531, x503, x500);
  let mut x534: u32 = 0;
  let mut x535: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x501, x498);
  let mut x536: u32 = 0;
  let mut x537: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x499, x496);
  let mut x538: u32 = 0;
  let mut x539: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x497, x494);
  let mut x540: u32 = 0;
  let mut x541: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x540, &mut x541, 0x0, x468, x516);
  let mut x542: u32 = 0;
  let mut x543: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x542, &mut x543, x541, x470, x518);
  let mut x544: u32 = 0;
  let mut x545: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x544, &mut x545, x543, x472, x520);
  let mut x546: u32 = 0;
  let mut x547: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x546, &mut x547, x545, x474, x522);
  let mut x548: u32 = 0;
  let mut x549: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x548, &mut x549, x547, x476, x524);
  let mut x550: u32 = 0;
  let mut x551: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x550, &mut x551, x549, x478, x526);
  let mut x552: u32 = 0;
  let mut x553: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x552, &mut x553, x551, x480, x528);
  let mut x554: u32 = 0;
  let mut x555: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x554, &mut x555, x553, x482, x530);
  let mut x556: u32 = 0;
  let mut x557: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x556, &mut x557, x555, x484, x532);
  let mut x558: u32 = 0;
  let mut x559: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x558, &mut x559, x557, x486, x534);
  let mut x560: u32 = 0;
  let mut x561: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x560, &mut x561, x559, x488, x536);
  let mut x562: u32 = 0;
  let mut x563: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x562, &mut x563, x561, x490, x538);
  let mut x564: u32 = 0;
  let mut x565: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x564, &mut x565, x563, ((x491 as u32) + (x467 as u32)), ((x539 as u32) + x495));
  let mut x566: u32 = 0;
  let mut x567: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x566, &mut x567, 0x0, x542, (arg1[6]));
  let mut x568: u32 = 0;
  let mut x569: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x568, &mut x569, x567, x544, (0x0 as u32));
  let mut x570: u32 = 0;
  let mut x571: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x570, &mut x571, x569, x546, (0x0 as u32));
  let mut x572: u32 = 0;
  let mut x573: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x572, &mut x573, x571, x548, (0x0 as u32));
  let mut x574: u32 = 0;
  let mut x575: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x574, &mut x575, x573, x550, (0x0 as u32));
  let mut x576: u32 = 0;
  let mut x577: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x576, &mut x577, x575, x552, (0x0 as u32));
  let mut x578: u32 = 0;
  let mut x579: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x578, &mut x579, x577, x554, (0x0 as u32));
  let mut x580: u32 = 0;
  let mut x581: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x580, &mut x581, x579, x556, (0x0 as u32));
  let mut x582: u32 = 0;
  let mut x583: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x582, &mut x583, x581, x558, (0x0 as u32));
  let mut x584: u32 = 0;
  let mut x585: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x584, &mut x585, x583, x560, (0x0 as u32));
  let mut x586: u32 = 0;
  let mut x587: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x586, &mut x587, x585, x562, (0x0 as u32));
  let mut x588: u32 = 0;
  let mut x589: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x588, &mut x589, x587, x564, (0x0 as u32));
  let mut x590: u32 = 0;
  let mut x591: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x590, &mut x591, x566, 0xe88fdc45);
  let mut x592: u32 = 0;
  let mut x593: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x592, &mut x593, x590, 0xffffffff);
  let mut x594: u32 = 0;
  let mut x595: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x594, &mut x595, x590, 0xffffffff);
  let mut x596: u32 = 0;
  let mut x597: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x596, &mut x597, x590, 0xffffffff);
  let mut x598: u32 = 0;
  let mut x599: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x598, &mut x599, x590, 0xffffffff);
  let mut x600: u32 = 0;
  let mut x601: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x600, &mut x601, x590, 0xffffffff);
  let mut x602: u32 = 0;
  let mut x603: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x602, &mut x603, x590, 0xffffffff);
  let mut x604: u32 = 0;
  let mut x605: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x604, &mut x605, x590, 0xc7634d81);
  let mut x606: u32 = 0;
  let mut x607: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x606, &mut x607, x590, 0xf4372ddf);
  let mut x608: u32 = 0;
  let mut x609: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x608, &mut x609, x590, 0x581a0db2);
  let mut x610: u32 = 0;
  let mut x611: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x610, &mut x611, x590, 0x48b0a77a);
  let mut x612: u32 = 0;
  let mut x613: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x612, &mut x613, x590, 0xecec196a);
  let mut x614: u32 = 0;
  let mut x615: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x614, &mut x615, x590, 0xccc52973);
  let mut x616: u32 = 0;
  let mut x617: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x616, &mut x617, 0x0, x615, x612);
  let mut x618: u32 = 0;
  let mut x619: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x618, &mut x619, x617, x613, x610);
  let mut x620: u32 = 0;
  let mut x621: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x620, &mut x621, x619, x611, x608);
  let mut x622: u32 = 0;
  let mut x623: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x622, &mut x623, x621, x609, x606);
  let mut x624: u32 = 0;
  let mut x625: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x624, &mut x625, x623, x607, x604);
  let mut x626: u32 = 0;
  let mut x627: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x626, &mut x627, x625, x605, x602);
  let mut x628: u32 = 0;
  let mut x629: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x628, &mut x629, x627, x603, x600);
  let mut x630: u32 = 0;
  let mut x631: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x630, &mut x631, x629, x601, x598);
  let mut x632: u32 = 0;
  let mut x633: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x632, &mut x633, x631, x599, x596);
  let mut x634: u32 = 0;
  let mut x635: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x634, &mut x635, x633, x597, x594);
  let mut x636: u32 = 0;
  let mut x637: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x636, &mut x637, x635, x595, x592);
  let mut x638: u32 = 0;
  let mut x639: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x638, &mut x639, 0x0, x566, x614);
  let mut x640: u32 = 0;
  let mut x641: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x640, &mut x641, x639, x568, x616);
  let mut x642: u32 = 0;
  let mut x643: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x642, &mut x643, x641, x570, x618);
  let mut x644: u32 = 0;
  let mut x645: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x644, &mut x645, x643, x572, x620);
  let mut x646: u32 = 0;
  let mut x647: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x646, &mut x647, x645, x574, x622);
  let mut x648: u32 = 0;
  let mut x649: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x648, &mut x649, x647, x576, x624);
  let mut x650: u32 = 0;
  let mut x651: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x650, &mut x651, x649, x578, x626);
  let mut x652: u32 = 0;
  let mut x653: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x652, &mut x653, x651, x580, x628);
  let mut x654: u32 = 0;
  let mut x655: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x654, &mut x655, x653, x582, x630);
  let mut x656: u32 = 0;
  let mut x657: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x656, &mut x657, x655, x584, x632);
  let mut x658: u32 = 0;
  let mut x659: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x658, &mut x659, x657, x586, x634);
  let mut x660: u32 = 0;
  let mut x661: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x660, &mut x661, x659, x588, x636);
  let mut x662: u32 = 0;
  let mut x663: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x662, &mut x663, x661, ((x589 as u32) + (x565 as u32)), ((x637 as u32) + x593));
  let mut x664: u32 = 0;
  let mut x665: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x664, &mut x665, 0x0, x640, (arg1[7]));
  let mut x666: u32 = 0;
  let mut x667: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x666, &mut x667, x665, x642, (0x0 as u32));
  let mut x668: u32 = 0;
  let mut x669: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x668, &mut x669, x667, x644, (0x0 as u32));
  let mut x670: u32 = 0;
  let mut x671: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x670, &mut x671, x669, x646, (0x0 as u32));
  let mut x672: u32 = 0;
  let mut x673: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x672, &mut x673, x671, x648, (0x0 as u32));
  let mut x674: u32 = 0;
  let mut x675: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x674, &mut x675, x673, x650, (0x0 as u32));
  let mut x676: u32 = 0;
  let mut x677: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x676, &mut x677, x675, x652, (0x0 as u32));
  let mut x678: u32 = 0;
  let mut x679: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x678, &mut x679, x677, x654, (0x0 as u32));
  let mut x680: u32 = 0;
  let mut x681: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x680, &mut x681, x679, x656, (0x0 as u32));
  let mut x682: u32 = 0;
  let mut x683: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x682, &mut x683, x681, x658, (0x0 as u32));
  let mut x684: u32 = 0;
  let mut x685: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x684, &mut x685, x683, x660, (0x0 as u32));
  let mut x686: u32 = 0;
  let mut x687: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x686, &mut x687, x685, x662, (0x0 as u32));
  let mut x688: u32 = 0;
  let mut x689: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x688, &mut x689, x664, 0xe88fdc45);
  let mut x690: u32 = 0;
  let mut x691: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x690, &mut x691, x688, 0xffffffff);
  let mut x692: u32 = 0;
  let mut x693: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x692, &mut x693, x688, 0xffffffff);
  let mut x694: u32 = 0;
  let mut x695: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x694, &mut x695, x688, 0xffffffff);
  let mut x696: u32 = 0;
  let mut x697: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x696, &mut x697, x688, 0xffffffff);
  let mut x698: u32 = 0;
  let mut x699: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x698, &mut x699, x688, 0xffffffff);
  let mut x700: u32 = 0;
  let mut x701: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x700, &mut x701, x688, 0xffffffff);
  let mut x702: u32 = 0;
  let mut x703: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x702, &mut x703, x688, 0xc7634d81);
  let mut x704: u32 = 0;
  let mut x705: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x704, &mut x705, x688, 0xf4372ddf);
  let mut x706: u32 = 0;
  let mut x707: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x706, &mut x707, x688, 0x581a0db2);
  let mut x708: u32 = 0;
  let mut x709: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x708, &mut x709, x688, 0x48b0a77a);
  let mut x710: u32 = 0;
  let mut x711: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x710, &mut x711, x688, 0xecec196a);
  let mut x712: u32 = 0;
  let mut x713: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x712, &mut x713, x688, 0xccc52973);
  let mut x714: u32 = 0;
  let mut x715: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x714, &mut x715, 0x0, x713, x710);
  let mut x716: u32 = 0;
  let mut x717: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x716, &mut x717, x715, x711, x708);
  let mut x718: u32 = 0;
  let mut x719: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x718, &mut x719, x717, x709, x706);
  let mut x720: u32 = 0;
  let mut x721: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x720, &mut x721, x719, x707, x704);
  let mut x722: u32 = 0;
  let mut x723: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x722, &mut x723, x721, x705, x702);
  let mut x724: u32 = 0;
  let mut x725: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x724, &mut x725, x723, x703, x700);
  let mut x726: u32 = 0;
  let mut x727: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x726, &mut x727, x725, x701, x698);
  let mut x728: u32 = 0;
  let mut x729: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x728, &mut x729, x727, x699, x696);
  let mut x730: u32 = 0;
  let mut x731: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x730, &mut x731, x729, x697, x694);
  let mut x732: u32 = 0;
  let mut x733: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x732, &mut x733, x731, x695, x692);
  let mut x734: u32 = 0;
  let mut x735: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x734, &mut x735, x733, x693, x690);
  let mut x736: u32 = 0;
  let mut x737: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x736, &mut x737, 0x0, x664, x712);
  let mut x738: u32 = 0;
  let mut x739: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x738, &mut x739, x737, x666, x714);
  let mut x740: u32 = 0;
  let mut x741: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x740, &mut x741, x739, x668, x716);
  let mut x742: u32 = 0;
  let mut x743: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x742, &mut x743, x741, x670, x718);
  let mut x744: u32 = 0;
  let mut x745: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x744, &mut x745, x743, x672, x720);
  let mut x746: u32 = 0;
  let mut x747: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x746, &mut x747, x745, x674, x722);
  let mut x748: u32 = 0;
  let mut x749: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x748, &mut x749, x747, x676, x724);
  let mut x750: u32 = 0;
  let mut x751: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x750, &mut x751, x749, x678, x726);
  let mut x752: u32 = 0;
  let mut x753: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x752, &mut x753, x751, x680, x728);
  let mut x754: u32 = 0;
  let mut x755: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x754, &mut x755, x753, x682, x730);
  let mut x756: u32 = 0;
  let mut x757: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x756, &mut x757, x755, x684, x732);
  let mut x758: u32 = 0;
  let mut x759: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x758, &mut x759, x757, x686, x734);
  let mut x760: u32 = 0;
  let mut x761: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x760, &mut x761, x759, ((x687 as u32) + (x663 as u32)), ((x735 as u32) + x691));
  let mut x762: u32 = 0;
  let mut x763: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x762, &mut x763, 0x0, x738, (arg1[8]));
  let mut x764: u32 = 0;
  let mut x765: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x764, &mut x765, x763, x740, (0x0 as u32));
  let mut x766: u32 = 0;
  let mut x767: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x766, &mut x767, x765, x742, (0x0 as u32));
  let mut x768: u32 = 0;
  let mut x769: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x768, &mut x769, x767, x744, (0x0 as u32));
  let mut x770: u32 = 0;
  let mut x771: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x770, &mut x771, x769, x746, (0x0 as u32));
  let mut x772: u32 = 0;
  let mut x773: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x772, &mut x773, x771, x748, (0x0 as u32));
  let mut x774: u32 = 0;
  let mut x775: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x774, &mut x775, x773, x750, (0x0 as u32));
  let mut x776: u32 = 0;
  let mut x777: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x776, &mut x777, x775, x752, (0x0 as u32));
  let mut x778: u32 = 0;
  let mut x779: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x778, &mut x779, x777, x754, (0x0 as u32));
  let mut x780: u32 = 0;
  let mut x781: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x780, &mut x781, x779, x756, (0x0 as u32));
  let mut x782: u32 = 0;
  let mut x783: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x782, &mut x783, x781, x758, (0x0 as u32));
  let mut x784: u32 = 0;
  let mut x785: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x784, &mut x785, x783, x760, (0x0 as u32));
  let mut x786: u32 = 0;
  let mut x787: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x786, &mut x787, x762, 0xe88fdc45);
  let mut x788: u32 = 0;
  let mut x789: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x788, &mut x789, x786, 0xffffffff);
  let mut x790: u32 = 0;
  let mut x791: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x790, &mut x791, x786, 0xffffffff);
  let mut x792: u32 = 0;
  let mut x793: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x792, &mut x793, x786, 0xffffffff);
  let mut x794: u32 = 0;
  let mut x795: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x794, &mut x795, x786, 0xffffffff);
  let mut x796: u32 = 0;
  let mut x797: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x796, &mut x797, x786, 0xffffffff);
  let mut x798: u32 = 0;
  let mut x799: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x798, &mut x799, x786, 0xffffffff);
  let mut x800: u32 = 0;
  let mut x801: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x800, &mut x801, x786, 0xc7634d81);
  let mut x802: u32 = 0;
  let mut x803: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x802, &mut x803, x786, 0xf4372ddf);
  let mut x804: u32 = 0;
  let mut x805: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x804, &mut x805, x786, 0x581a0db2);
  let mut x806: u32 = 0;
  let mut x807: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x806, &mut x807, x786, 0x48b0a77a);
  let mut x808: u32 = 0;
  let mut x809: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x808, &mut x809, x786, 0xecec196a);
  let mut x810: u32 = 0;
  let mut x811: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x810, &mut x811, x786, 0xccc52973);
  let mut x812: u32 = 0;
  let mut x813: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x812, &mut x813, 0x0, x811, x808);
  let mut x814: u32 = 0;
  let mut x815: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x814, &mut x815, x813, x809, x806);
  let mut x816: u32 = 0;
  let mut x817: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x816, &mut x817, x815, x807, x804);
  let mut x818: u32 = 0;
  let mut x819: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x818, &mut x819, x817, x805, x802);
  let mut x820: u32 = 0;
  let mut x821: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x820, &mut x821, x819, x803, x800);
  let mut x822: u32 = 0;
  let mut x823: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x822, &mut x823, x821, x801, x798);
  let mut x824: u32 = 0;
  let mut x825: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x824, &mut x825, x823, x799, x796);
  let mut x826: u32 = 0;
  let mut x827: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x826, &mut x827, x825, x797, x794);
  let mut x828: u32 = 0;
  let mut x829: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x828, &mut x829, x827, x795, x792);
  let mut x830: u32 = 0;
  let mut x831: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x830, &mut x831, x829, x793, x790);
  let mut x832: u32 = 0;
  let mut x833: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x832, &mut x833, x831, x791, x788);
  let mut x834: u32 = 0;
  let mut x835: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x834, &mut x835, 0x0, x762, x810);
  let mut x836: u32 = 0;
  let mut x837: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x836, &mut x837, x835, x764, x812);
  let mut x838: u32 = 0;
  let mut x839: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x838, &mut x839, x837, x766, x814);
  let mut x840: u32 = 0;
  let mut x841: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x840, &mut x841, x839, x768, x816);
  let mut x842: u32 = 0;
  let mut x843: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x842, &mut x843, x841, x770, x818);
  let mut x844: u32 = 0;
  let mut x845: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x844, &mut x845, x843, x772, x820);
  let mut x846: u32 = 0;
  let mut x847: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x846, &mut x847, x845, x774, x822);
  let mut x848: u32 = 0;
  let mut x849: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x848, &mut x849, x847, x776, x824);
  let mut x850: u32 = 0;
  let mut x851: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x850, &mut x851, x849, x778, x826);
  let mut x852: u32 = 0;
  let mut x853: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x852, &mut x853, x851, x780, x828);
  let mut x854: u32 = 0;
  let mut x855: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x854, &mut x855, x853, x782, x830);
  let mut x856: u32 = 0;
  let mut x857: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x856, &mut x857, x855, x784, x832);
  let mut x858: u32 = 0;
  let mut x859: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x858, &mut x859, x857, ((x785 as u32) + (x761 as u32)), ((x833 as u32) + x789));
  let mut x860: u32 = 0;
  let mut x861: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x860, &mut x861, 0x0, x836, (arg1[9]));
  let mut x862: u32 = 0;
  let mut x863: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x862, &mut x863, x861, x838, (0x0 as u32));
  let mut x864: u32 = 0;
  let mut x865: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x864, &mut x865, x863, x840, (0x0 as u32));
  let mut x866: u32 = 0;
  let mut x867: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x866, &mut x867, x865, x842, (0x0 as u32));
  let mut x868: u32 = 0;
  let mut x869: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x868, &mut x869, x867, x844, (0x0 as u32));
  let mut x870: u32 = 0;
  let mut x871: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x870, &mut x871, x869, x846, (0x0 as u32));
  let mut x872: u32 = 0;
  let mut x873: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x872, &mut x873, x871, x848, (0x0 as u32));
  let mut x874: u32 = 0;
  let mut x875: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x874, &mut x875, x873, x850, (0x0 as u32));
  let mut x876: u32 = 0;
  let mut x877: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x876, &mut x877, x875, x852, (0x0 as u32));
  let mut x878: u32 = 0;
  let mut x879: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x878, &mut x879, x877, x854, (0x0 as u32));
  let mut x880: u32 = 0;
  let mut x881: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x880, &mut x881, x879, x856, (0x0 as u32));
  let mut x882: u32 = 0;
  let mut x883: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x882, &mut x883, x881, x858, (0x0 as u32));
  let mut x884: u32 = 0;
  let mut x885: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x884, &mut x885, x860, 0xe88fdc45);
  let mut x886: u32 = 0;
  let mut x887: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x886, &mut x887, x884, 0xffffffff);
  let mut x888: u32 = 0;
  let mut x889: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x888, &mut x889, x884, 0xffffffff);
  let mut x890: u32 = 0;
  let mut x891: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x890, &mut x891, x884, 0xffffffff);
  let mut x892: u32 = 0;
  let mut x893: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x892, &mut x893, x884, 0xffffffff);
  let mut x894: u32 = 0;
  let mut x895: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x894, &mut x895, x884, 0xffffffff);
  let mut x896: u32 = 0;
  let mut x897: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x896, &mut x897, x884, 0xffffffff);
  let mut x898: u32 = 0;
  let mut x899: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x898, &mut x899, x884, 0xc7634d81);
  let mut x900: u32 = 0;
  let mut x901: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x900, &mut x901, x884, 0xf4372ddf);
  let mut x902: u32 = 0;
  let mut x903: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x902, &mut x903, x884, 0x581a0db2);
  let mut x904: u32 = 0;
  let mut x905: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x904, &mut x905, x884, 0x48b0a77a);
  let mut x906: u32 = 0;
  let mut x907: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x906, &mut x907, x884, 0xecec196a);
  let mut x908: u32 = 0;
  let mut x909: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x908, &mut x909, x884, 0xccc52973);
  let mut x910: u32 = 0;
  let mut x911: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x910, &mut x911, 0x0, x909, x906);
  let mut x912: u32 = 0;
  let mut x913: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x912, &mut x913, x911, x907, x904);
  let mut x914: u32 = 0;
  let mut x915: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x914, &mut x915, x913, x905, x902);
  let mut x916: u32 = 0;
  let mut x917: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x916, &mut x917, x915, x903, x900);
  let mut x918: u32 = 0;
  let mut x919: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x918, &mut x919, x917, x901, x898);
  let mut x920: u32 = 0;
  let mut x921: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x920, &mut x921, x919, x899, x896);
  let mut x922: u32 = 0;
  let mut x923: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x922, &mut x923, x921, x897, x894);
  let mut x924: u32 = 0;
  let mut x925: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x924, &mut x925, x923, x895, x892);
  let mut x926: u32 = 0;
  let mut x927: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x926, &mut x927, x925, x893, x890);
  let mut x928: u32 = 0;
  let mut x929: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x928, &mut x929, x927, x891, x888);
  let mut x930: u32 = 0;
  let mut x931: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x930, &mut x931, x929, x889, x886);
  let mut x932: u32 = 0;
  let mut x933: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x932, &mut x933, 0x0, x860, x908);
  let mut x934: u32 = 0;
  let mut x935: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x934, &mut x935, x933, x862, x910);
  let mut x936: u32 = 0;
  let mut x937: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x936, &mut x937, x935, x864, x912);
  let mut x938: u32 = 0;
  let mut x939: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x938, &mut x939, x937, x866, x914);
  let mut x940: u32 = 0;
  let mut x941: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x940, &mut x941, x939, x868, x916);
  let mut x942: u32 = 0;
  let mut x943: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x942, &mut x943, x941, x870, x918);
  let mut x944: u32 = 0;
  let mut x945: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x944, &mut x945, x943, x872, x920);
  let mut x946: u32 = 0;
  let mut x947: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x946, &mut x947, x945, x874, x922);
  let mut x948: u32 = 0;
  let mut x949: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x948, &mut x949, x947, x876, x924);
  let mut x950: u32 = 0;
  let mut x951: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x950, &mut x951, x949, x878, x926);
  let mut x952: u32 = 0;
  let mut x953: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x952, &mut x953, x951, x880, x928);
  let mut x954: u32 = 0;
  let mut x955: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x954, &mut x955, x953, x882, x930);
  let mut x956: u32 = 0;
  let mut x957: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x956, &mut x957, x955, ((x883 as u32) + (x859 as u32)), ((x931 as u32) + x887));
  let mut x958: u32 = 0;
  let mut x959: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x958, &mut x959, 0x0, x934, (arg1[10]));
  let mut x960: u32 = 0;
  let mut x961: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x960, &mut x961, x959, x936, (0x0 as u32));
  let mut x962: u32 = 0;
  let mut x963: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x962, &mut x963, x961, x938, (0x0 as u32));
  let mut x964: u32 = 0;
  let mut x965: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x964, &mut x965, x963, x940, (0x0 as u32));
  let mut x966: u32 = 0;
  let mut x967: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x966, &mut x967, x965, x942, (0x0 as u32));
  let mut x968: u32 = 0;
  let mut x969: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x968, &mut x969, x967, x944, (0x0 as u32));
  let mut x970: u32 = 0;
  let mut x971: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x970, &mut x971, x969, x946, (0x0 as u32));
  let mut x972: u32 = 0;
  let mut x973: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x972, &mut x973, x971, x948, (0x0 as u32));
  let mut x974: u32 = 0;
  let mut x975: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x974, &mut x975, x973, x950, (0x0 as u32));
  let mut x976: u32 = 0;
  let mut x977: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x976, &mut x977, x975, x952, (0x0 as u32));
  let mut x978: u32 = 0;
  let mut x979: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x978, &mut x979, x977, x954, (0x0 as u32));
  let mut x980: u32 = 0;
  let mut x981: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x980, &mut x981, x979, x956, (0x0 as u32));
  let mut x982: u32 = 0;
  let mut x983: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x982, &mut x983, x958, 0xe88fdc45);
  let mut x984: u32 = 0;
  let mut x985: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x984, &mut x985, x982, 0xffffffff);
  let mut x986: u32 = 0;
  let mut x987: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x986, &mut x987, x982, 0xffffffff);
  let mut x988: u32 = 0;
  let mut x989: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x988, &mut x989, x982, 0xffffffff);
  let mut x990: u32 = 0;
  let mut x991: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x990, &mut x991, x982, 0xffffffff);
  let mut x992: u32 = 0;
  let mut x993: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x992, &mut x993, x982, 0xffffffff);
  let mut x994: u32 = 0;
  let mut x995: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x994, &mut x995, x982, 0xffffffff);
  let mut x996: u32 = 0;
  let mut x997: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x996, &mut x997, x982, 0xc7634d81);
  let mut x998: u32 = 0;
  let mut x999: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x998, &mut x999, x982, 0xf4372ddf);
  let mut x1000: u32 = 0;
  let mut x1001: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1000, &mut x1001, x982, 0x581a0db2);
  let mut x1002: u32 = 0;
  let mut x1003: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1002, &mut x1003, x982, 0x48b0a77a);
  let mut x1004: u32 = 0;
  let mut x1005: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1004, &mut x1005, x982, 0xecec196a);
  let mut x1006: u32 = 0;
  let mut x1007: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1006, &mut x1007, x982, 0xccc52973);
  let mut x1008: u32 = 0;
  let mut x1009: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1008, &mut x1009, 0x0, x1007, x1004);
  let mut x1010: u32 = 0;
  let mut x1011: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1010, &mut x1011, x1009, x1005, x1002);
  let mut x1012: u32 = 0;
  let mut x1013: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1012, &mut x1013, x1011, x1003, x1000);
  let mut x1014: u32 = 0;
  let mut x1015: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1014, &mut x1015, x1013, x1001, x998);
  let mut x1016: u32 = 0;
  let mut x1017: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1016, &mut x1017, x1015, x999, x996);
  let mut x1018: u32 = 0;
  let mut x1019: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1018, &mut x1019, x1017, x997, x994);
  let mut x1020: u32 = 0;
  let mut x1021: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1020, &mut x1021, x1019, x995, x992);
  let mut x1022: u32 = 0;
  let mut x1023: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1022, &mut x1023, x1021, x993, x990);
  let mut x1024: u32 = 0;
  let mut x1025: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1024, &mut x1025, x1023, x991, x988);
  let mut x1026: u32 = 0;
  let mut x1027: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1026, &mut x1027, x1025, x989, x986);
  let mut x1028: u32 = 0;
  let mut x1029: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1028, &mut x1029, x1027, x987, x984);
  let mut x1030: u32 = 0;
  let mut x1031: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1030, &mut x1031, 0x0, x958, x1006);
  let mut x1032: u32 = 0;
  let mut x1033: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1032, &mut x1033, x1031, x960, x1008);
  let mut x1034: u32 = 0;
  let mut x1035: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1034, &mut x1035, x1033, x962, x1010);
  let mut x1036: u32 = 0;
  let mut x1037: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1036, &mut x1037, x1035, x964, x1012);
  let mut x1038: u32 = 0;
  let mut x1039: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1038, &mut x1039, x1037, x966, x1014);
  let mut x1040: u32 = 0;
  let mut x1041: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1040, &mut x1041, x1039, x968, x1016);
  let mut x1042: u32 = 0;
  let mut x1043: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1042, &mut x1043, x1041, x970, x1018);
  let mut x1044: u32 = 0;
  let mut x1045: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1044, &mut x1045, x1043, x972, x1020);
  let mut x1046: u32 = 0;
  let mut x1047: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1046, &mut x1047, x1045, x974, x1022);
  let mut x1048: u32 = 0;
  let mut x1049: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1048, &mut x1049, x1047, x976, x1024);
  let mut x1050: u32 = 0;
  let mut x1051: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1050, &mut x1051, x1049, x978, x1026);
  let mut x1052: u32 = 0;
  let mut x1053: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1052, &mut x1053, x1051, x980, x1028);
  let mut x1054: u32 = 0;
  let mut x1055: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1054, &mut x1055, x1053, ((x981 as u32) + (x957 as u32)), ((x1029 as u32) + x985));
  let mut x1056: u32 = 0;
  let mut x1057: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1056, &mut x1057, 0x0, x1032, (arg1[11]));
  let mut x1058: u32 = 0;
  let mut x1059: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1058, &mut x1059, x1057, x1034, (0x0 as u32));
  let mut x1060: u32 = 0;
  let mut x1061: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1060, &mut x1061, x1059, x1036, (0x0 as u32));
  let mut x1062: u32 = 0;
  let mut x1063: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1062, &mut x1063, x1061, x1038, (0x0 as u32));
  let mut x1064: u32 = 0;
  let mut x1065: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1064, &mut x1065, x1063, x1040, (0x0 as u32));
  let mut x1066: u32 = 0;
  let mut x1067: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1066, &mut x1067, x1065, x1042, (0x0 as u32));
  let mut x1068: u32 = 0;
  let mut x1069: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1068, &mut x1069, x1067, x1044, (0x0 as u32));
  let mut x1070: u32 = 0;
  let mut x1071: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1070, &mut x1071, x1069, x1046, (0x0 as u32));
  let mut x1072: u32 = 0;
  let mut x1073: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1072, &mut x1073, x1071, x1048, (0x0 as u32));
  let mut x1074: u32 = 0;
  let mut x1075: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1074, &mut x1075, x1073, x1050, (0x0 as u32));
  let mut x1076: u32 = 0;
  let mut x1077: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1076, &mut x1077, x1075, x1052, (0x0 as u32));
  let mut x1078: u32 = 0;
  let mut x1079: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1078, &mut x1079, x1077, x1054, (0x0 as u32));
  let mut x1080: u32 = 0;
  let mut x1081: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1080, &mut x1081, x1056, 0xe88fdc45);
  let mut x1082: u32 = 0;
  let mut x1083: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1082, &mut x1083, x1080, 0xffffffff);
  let mut x1084: u32 = 0;
  let mut x1085: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1084, &mut x1085, x1080, 0xffffffff);
  let mut x1086: u32 = 0;
  let mut x1087: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1086, &mut x1087, x1080, 0xffffffff);
  let mut x1088: u32 = 0;
  let mut x1089: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1088, &mut x1089, x1080, 0xffffffff);
  let mut x1090: u32 = 0;
  let mut x1091: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1090, &mut x1091, x1080, 0xffffffff);
  let mut x1092: u32 = 0;
  let mut x1093: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1092, &mut x1093, x1080, 0xffffffff);
  let mut x1094: u32 = 0;
  let mut x1095: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1094, &mut x1095, x1080, 0xc7634d81);
  let mut x1096: u32 = 0;
  let mut x1097: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1096, &mut x1097, x1080, 0xf4372ddf);
  let mut x1098: u32 = 0;
  let mut x1099: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1098, &mut x1099, x1080, 0x581a0db2);
  let mut x1100: u32 = 0;
  let mut x1101: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1100, &mut x1101, x1080, 0x48b0a77a);
  let mut x1102: u32 = 0;
  let mut x1103: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1102, &mut x1103, x1080, 0xecec196a);
  let mut x1104: u32 = 0;
  let mut x1105: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1104, &mut x1105, x1080, 0xccc52973);
  let mut x1106: u32 = 0;
  let mut x1107: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1106, &mut x1107, 0x0, x1105, x1102);
  let mut x1108: u32 = 0;
  let mut x1109: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1108, &mut x1109, x1107, x1103, x1100);
  let mut x1110: u32 = 0;
  let mut x1111: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1110, &mut x1111, x1109, x1101, x1098);
  let mut x1112: u32 = 0;
  let mut x1113: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1112, &mut x1113, x1111, x1099, x1096);
  let mut x1114: u32 = 0;
  let mut x1115: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1114, &mut x1115, x1113, x1097, x1094);
  let mut x1116: u32 = 0;
  let mut x1117: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1116, &mut x1117, x1115, x1095, x1092);
  let mut x1118: u32 = 0;
  let mut x1119: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1118, &mut x1119, x1117, x1093, x1090);
  let mut x1120: u32 = 0;
  let mut x1121: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1120, &mut x1121, x1119, x1091, x1088);
  let mut x1122: u32 = 0;
  let mut x1123: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1122, &mut x1123, x1121, x1089, x1086);
  let mut x1124: u32 = 0;
  let mut x1125: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1124, &mut x1125, x1123, x1087, x1084);
  let mut x1126: u32 = 0;
  let mut x1127: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1126, &mut x1127, x1125, x1085, x1082);
  let mut x1128: u32 = 0;
  let mut x1129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1128, &mut x1129, 0x0, x1056, x1104);
  let mut x1130: u32 = 0;
  let mut x1131: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1130, &mut x1131, x1129, x1058, x1106);
  let mut x1132: u32 = 0;
  let mut x1133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1132, &mut x1133, x1131, x1060, x1108);
  let mut x1134: u32 = 0;
  let mut x1135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1134, &mut x1135, x1133, x1062, x1110);
  let mut x1136: u32 = 0;
  let mut x1137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1136, &mut x1137, x1135, x1064, x1112);
  let mut x1138: u32 = 0;
  let mut x1139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1138, &mut x1139, x1137, x1066, x1114);
  let mut x1140: u32 = 0;
  let mut x1141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1140, &mut x1141, x1139, x1068, x1116);
  let mut x1142: u32 = 0;
  let mut x1143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1142, &mut x1143, x1141, x1070, x1118);
  let mut x1144: u32 = 0;
  let mut x1145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1144, &mut x1145, x1143, x1072, x1120);
  let mut x1146: u32 = 0;
  let mut x1147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1146, &mut x1147, x1145, x1074, x1122);
  let mut x1148: u32 = 0;
  let mut x1149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1148, &mut x1149, x1147, x1076, x1124);
  let mut x1150: u32 = 0;
  let mut x1151: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1150, &mut x1151, x1149, x1078, x1126);
  let mut x1152: u32 = 0;
  let mut x1153: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1152, &mut x1153, x1151, ((x1079 as u32) + (x1055 as u32)), ((x1127 as u32) + x1083));
  let mut x1154: u32 = 0;
  let mut x1155: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1154, &mut x1155, 0x0, x1130, 0xccc52973);
  let mut x1156: u32 = 0;
  let mut x1157: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1156, &mut x1157, x1155, x1132, 0xecec196a);
  let mut x1158: u32 = 0;
  let mut x1159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1158, &mut x1159, x1157, x1134, 0x48b0a77a);
  let mut x1160: u32 = 0;
  let mut x1161: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1160, &mut x1161, x1159, x1136, 0x581a0db2);
  let mut x1162: u32 = 0;
  let mut x1163: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1162, &mut x1163, x1161, x1138, 0xf4372ddf);
  let mut x1164: u32 = 0;
  let mut x1165: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1164, &mut x1165, x1163, x1140, 0xc7634d81);
  let mut x1166: u32 = 0;
  let mut x1167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1166, &mut x1167, x1165, x1142, 0xffffffff);
  let mut x1168: u32 = 0;
  let mut x1169: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1168, &mut x1169, x1167, x1144, 0xffffffff);
  let mut x1170: u32 = 0;
  let mut x1171: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1170, &mut x1171, x1169, x1146, 0xffffffff);
  let mut x1172: u32 = 0;
  let mut x1173: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1172, &mut x1173, x1171, x1148, 0xffffffff);
  let mut x1174: u32 = 0;
  let mut x1175: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1174, &mut x1175, x1173, x1150, 0xffffffff);
  let mut x1176: u32 = 0;
  let mut x1177: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1176, &mut x1177, x1175, x1152, 0xffffffff);
  let mut x1178: u32 = 0;
  let mut x1179: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1178, &mut x1179, x1177, (x1153 as u32), (0x0 as u32));
  let mut x1180: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1180, x1179, x1154, x1130);
  let mut x1181: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1181, x1179, x1156, x1132);
  let mut x1182: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1182, x1179, x1158, x1134);
  let mut x1183: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1183, x1179, x1160, x1136);
  let mut x1184: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1184, x1179, x1162, x1138);
  let mut x1185: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1185, x1179, x1164, x1140);
  let mut x1186: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1186, x1179, x1166, x1142);
  let mut x1187: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1187, x1179, x1168, x1144);
  let mut x1188: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1188, x1179, x1170, x1146);
  let mut x1189: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1189, x1179, x1172, x1148);
  let mut x1190: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1190, x1179, x1174, x1150);
  let mut x1191: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1191, x1179, x1176, x1152);
  out1[0] = x1180;
  out1[1] = x1181;
  out1[2] = x1182;
  out1[3] = x1183;
  out1[4] = x1184;
  out1[5] = x1185;
  out1[6] = x1186;
  out1[7] = x1187;
  out1[8] = x1188;
  out1[9] = x1189;
  out1[10] = x1190;
  out1[11] = x1191;
}

/// The function fiat_p384_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_to_montgomery(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_non_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[8]);
  let x9: u32 = (arg1[9]);
  let x10: u32 = (arg1[10]);
  let x11: u32 = (arg1[11]);
  let x12: u32 = (arg1[0]);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x13, &mut x14, x12, 0xc84ee01);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x15, &mut x16, x12, 0x2b39bf21);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x17, &mut x18, x12, 0x3fb05b7a);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x19, &mut x20, x12, 0x28266895);
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x21, &mut x22, x12, 0xd40d4917);
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x23, &mut x24, x12, 0x4aab1cc5);
  let mut x25: u32 = 0;
  let mut x26: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x25, &mut x26, x12, 0xbc3e483a);
  let mut x27: u32 = 0;
  let mut x28: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x27, &mut x28, x12, 0xfcb82947);
  let mut x29: u32 = 0;
  let mut x30: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x29, &mut x30, x12, 0xff3d81e5);
  let mut x31: u32 = 0;
  let mut x32: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x31, &mut x32, x12, 0xdf1aa419);
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x33, &mut x34, x12, 0x2d319b24);
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x35, &mut x36, x12, 0x19b409a9);
  let mut x37: u32 = 0;
  let mut x38: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x37, &mut x38, 0x0, x36, x33);
  let mut x39: u32 = 0;
  let mut x40: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x39, &mut x40, x38, x34, x31);
  let mut x41: u32 = 0;
  let mut x42: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x41, &mut x42, x40, x32, x29);
  let mut x43: u32 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x43, &mut x44, x42, x30, x27);
  let mut x45: u32 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x45, &mut x46, x44, x28, x25);
  let mut x47: u32 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x47, &mut x48, x46, x26, x23);
  let mut x49: u32 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x49, &mut x50, x48, x24, x21);
  let mut x51: u32 = 0;
  let mut x52: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x51, &mut x52, x50, x22, x19);
  let mut x53: u32 = 0;
  let mut x54: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x20, x17);
  let mut x55: u32 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x18, x15);
  let mut x57: u32 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x57, &mut x58, x56, x16, x13);
  let mut x59: u32 = 0;
  let mut x60: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x59, &mut x60, x35, 0xe88fdc45);
  let mut x61: u32 = 0;
  let mut x62: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x61, &mut x62, x59, 0xffffffff);
  let mut x63: u32 = 0;
  let mut x64: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x63, &mut x64, x59, 0xffffffff);
  let mut x65: u32 = 0;
  let mut x66: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x65, &mut x66, x59, 0xffffffff);
  let mut x67: u32 = 0;
  let mut x68: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x67, &mut x68, x59, 0xffffffff);
  let mut x69: u32 = 0;
  let mut x70: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x69, &mut x70, x59, 0xffffffff);
  let mut x71: u32 = 0;
  let mut x72: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x71, &mut x72, x59, 0xffffffff);
  let mut x73: u32 = 0;
  let mut x74: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x73, &mut x74, x59, 0xc7634d81);
  let mut x75: u32 = 0;
  let mut x76: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x75, &mut x76, x59, 0xf4372ddf);
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x77, &mut x78, x59, 0x581a0db2);
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x79, &mut x80, x59, 0x48b0a77a);
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x81, &mut x82, x59, 0xecec196a);
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x83, &mut x84, x59, 0xccc52973);
  let mut x85: u32 = 0;
  let mut x86: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x85, &mut x86, 0x0, x84, x81);
  let mut x87: u32 = 0;
  let mut x88: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x87, &mut x88, x86, x82, x79);
  let mut x89: u32 = 0;
  let mut x90: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x89, &mut x90, x88, x80, x77);
  let mut x91: u32 = 0;
  let mut x92: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x91, &mut x92, x90, x78, x75);
  let mut x93: u32 = 0;
  let mut x94: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x93, &mut x94, x92, x76, x73);
  let mut x95: u32 = 0;
  let mut x96: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x95, &mut x96, x94, x74, x71);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x97, &mut x98, x96, x72, x69);
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x99, &mut x100, x98, x70, x67);
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x101, &mut x102, x100, x68, x65);
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x103, &mut x104, x102, x66, x63);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x105, &mut x106, x104, x64, x61);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x107, &mut x108, 0x0, x35, x83);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x109, &mut x110, x108, x37, x85);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x39, x87);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x41, x89);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x43, x91);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x45, x93);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x119, &mut x120, x118, x47, x95);
  let mut x121: u32 = 0;
  let mut x122: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x121, &mut x122, x120, x49, x97);
  let mut x123: u32 = 0;
  let mut x124: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x123, &mut x124, x122, x51, x99);
  let mut x125: u32 = 0;
  let mut x126: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x125, &mut x126, x124, x53, x101);
  let mut x127: u32 = 0;
  let mut x128: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x127, &mut x128, x126, x55, x103);
  let mut x129: u32 = 0;
  let mut x130: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x129, &mut x130, x128, x57, x105);
  let mut x131: u32 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x131, &mut x132, x130, ((x58 as u32) + x14), ((x106 as u32) + x62));
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x133, &mut x134, x1, 0xc84ee01);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x135, &mut x136, x1, 0x2b39bf21);
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x137, &mut x138, x1, 0x3fb05b7a);
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x139, &mut x140, x1, 0x28266895);
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x141, &mut x142, x1, 0xd40d4917);
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x143, &mut x144, x1, 0x4aab1cc5);
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x145, &mut x146, x1, 0xbc3e483a);
  let mut x147: u32 = 0;
  let mut x148: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x147, &mut x148, x1, 0xfcb82947);
  let mut x149: u32 = 0;
  let mut x150: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x149, &mut x150, x1, 0xff3d81e5);
  let mut x151: u32 = 0;
  let mut x152: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x151, &mut x152, x1, 0xdf1aa419);
  let mut x153: u32 = 0;
  let mut x154: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x153, &mut x154, x1, 0x2d319b24);
  let mut x155: u32 = 0;
  let mut x156: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x155, &mut x156, x1, 0x19b409a9);
  let mut x157: u32 = 0;
  let mut x158: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x157, &mut x158, 0x0, x156, x153);
  let mut x159: u32 = 0;
  let mut x160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x159, &mut x160, x158, x154, x151);
  let mut x161: u32 = 0;
  let mut x162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x152, x149);
  let mut x163: u32 = 0;
  let mut x164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x163, &mut x164, x162, x150, x147);
  let mut x165: u32 = 0;
  let mut x166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x165, &mut x166, x164, x148, x145);
  let mut x167: u32 = 0;
  let mut x168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x167, &mut x168, x166, x146, x143);
  let mut x169: u32 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x169, &mut x170, x168, x144, x141);
  let mut x171: u32 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x171, &mut x172, x170, x142, x139);
  let mut x173: u32 = 0;
  let mut x174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x173, &mut x174, x172, x140, x137);
  let mut x175: u32 = 0;
  let mut x176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x138, x135);
  let mut x177: u32 = 0;
  let mut x178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x136, x133);
  let mut x179: u32 = 0;
  let mut x180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x179, &mut x180, 0x0, x109, x155);
  let mut x181: u32 = 0;
  let mut x182: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x181, &mut x182, x180, x111, x157);
  let mut x183: u32 = 0;
  let mut x184: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x183, &mut x184, x182, x113, x159);
  let mut x185: u32 = 0;
  let mut x186: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x185, &mut x186, x184, x115, x161);
  let mut x187: u32 = 0;
  let mut x188: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x187, &mut x188, x186, x117, x163);
  let mut x189: u32 = 0;
  let mut x190: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x189, &mut x190, x188, x119, x165);
  let mut x191: u32 = 0;
  let mut x192: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x191, &mut x192, x190, x121, x167);
  let mut x193: u32 = 0;
  let mut x194: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x193, &mut x194, x192, x123, x169);
  let mut x195: u32 = 0;
  let mut x196: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x195, &mut x196, x194, x125, x171);
  let mut x197: u32 = 0;
  let mut x198: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x197, &mut x198, x196, x127, x173);
  let mut x199: u32 = 0;
  let mut x200: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x199, &mut x200, x198, x129, x175);
  let mut x201: u32 = 0;
  let mut x202: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x201, &mut x202, x200, x131, x177);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x203, &mut x204, x179, 0xe88fdc45);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x205, &mut x206, x203, 0xffffffff);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x207, &mut x208, x203, 0xffffffff);
  let mut x209: u32 = 0;
  let mut x210: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x209, &mut x210, x203, 0xffffffff);
  let mut x211: u32 = 0;
  let mut x212: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x211, &mut x212, x203, 0xffffffff);
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x213, &mut x214, x203, 0xffffffff);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x215, &mut x216, x203, 0xffffffff);
  let mut x217: u32 = 0;
  let mut x218: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x217, &mut x218, x203, 0xc7634d81);
  let mut x219: u32 = 0;
  let mut x220: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x219, &mut x220, x203, 0xf4372ddf);
  let mut x221: u32 = 0;
  let mut x222: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x221, &mut x222, x203, 0x581a0db2);
  let mut x223: u32 = 0;
  let mut x224: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x223, &mut x224, x203, 0x48b0a77a);
  let mut x225: u32 = 0;
  let mut x226: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x225, &mut x226, x203, 0xecec196a);
  let mut x227: u32 = 0;
  let mut x228: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x227, &mut x228, x203, 0xccc52973);
  let mut x229: u32 = 0;
  let mut x230: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x229, &mut x230, 0x0, x228, x225);
  let mut x231: u32 = 0;
  let mut x232: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x231, &mut x232, x230, x226, x223);
  let mut x233: u32 = 0;
  let mut x234: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x233, &mut x234, x232, x224, x221);
  let mut x235: u32 = 0;
  let mut x236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x235, &mut x236, x234, x222, x219);
  let mut x237: u32 = 0;
  let mut x238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x237, &mut x238, x236, x220, x217);
  let mut x239: u32 = 0;
  let mut x240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x239, &mut x240, x238, x218, x215);
  let mut x241: u32 = 0;
  let mut x242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x241, &mut x242, x240, x216, x213);
  let mut x243: u32 = 0;
  let mut x244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x243, &mut x244, x242, x214, x211);
  let mut x245: u32 = 0;
  let mut x246: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x245, &mut x246, x244, x212, x209);
  let mut x247: u32 = 0;
  let mut x248: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x247, &mut x248, x246, x210, x207);
  let mut x249: u32 = 0;
  let mut x250: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x249, &mut x250, x248, x208, x205);
  let mut x251: u32 = 0;
  let mut x252: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x251, &mut x252, 0x0, x179, x227);
  let mut x253: u32 = 0;
  let mut x254: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x253, &mut x254, x252, x181, x229);
  let mut x255: u32 = 0;
  let mut x256: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x255, &mut x256, x254, x183, x231);
  let mut x257: u32 = 0;
  let mut x258: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x257, &mut x258, x256, x185, x233);
  let mut x259: u32 = 0;
  let mut x260: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x259, &mut x260, x258, x187, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x189, x237);
  let mut x263: u32 = 0;
  let mut x264: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x263, &mut x264, x262, x191, x239);
  let mut x265: u32 = 0;
  let mut x266: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x193, x241);
  let mut x267: u32 = 0;
  let mut x268: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x195, x243);
  let mut x269: u32 = 0;
  let mut x270: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x197, x245);
  let mut x271: u32 = 0;
  let mut x272: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x199, x247);
  let mut x273: u32 = 0;
  let mut x274: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x201, x249);
  let mut x275: u32 = 0;
  let mut x276: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x275, &mut x276, x274, (((x202 as u32) + (x132 as u32)) + ((x178 as u32) + x134)), ((x250 as u32) + x206));
  let mut x277: u32 = 0;
  let mut x278: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x277, &mut x278, x2, 0xc84ee01);
  let mut x279: u32 = 0;
  let mut x280: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x279, &mut x280, x2, 0x2b39bf21);
  let mut x281: u32 = 0;
  let mut x282: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x281, &mut x282, x2, 0x3fb05b7a);
  let mut x283: u32 = 0;
  let mut x284: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x283, &mut x284, x2, 0x28266895);
  let mut x285: u32 = 0;
  let mut x286: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x285, &mut x286, x2, 0xd40d4917);
  let mut x287: u32 = 0;
  let mut x288: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x287, &mut x288, x2, 0x4aab1cc5);
  let mut x289: u32 = 0;
  let mut x290: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x289, &mut x290, x2, 0xbc3e483a);
  let mut x291: u32 = 0;
  let mut x292: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x291, &mut x292, x2, 0xfcb82947);
  let mut x293: u32 = 0;
  let mut x294: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x293, &mut x294, x2, 0xff3d81e5);
  let mut x295: u32 = 0;
  let mut x296: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x295, &mut x296, x2, 0xdf1aa419);
  let mut x297: u32 = 0;
  let mut x298: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x297, &mut x298, x2, 0x2d319b24);
  let mut x299: u32 = 0;
  let mut x300: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x299, &mut x300, x2, 0x19b409a9);
  let mut x301: u32 = 0;
  let mut x302: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x301, &mut x302, 0x0, x300, x297);
  let mut x303: u32 = 0;
  let mut x304: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x303, &mut x304, x302, x298, x295);
  let mut x305: u32 = 0;
  let mut x306: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x305, &mut x306, x304, x296, x293);
  let mut x307: u32 = 0;
  let mut x308: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x307, &mut x308, x306, x294, x291);
  let mut x309: u32 = 0;
  let mut x310: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x309, &mut x310, x308, x292, x289);
  let mut x311: u32 = 0;
  let mut x312: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x311, &mut x312, x310, x290, x287);
  let mut x313: u32 = 0;
  let mut x314: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x313, &mut x314, x312, x288, x285);
  let mut x315: u32 = 0;
  let mut x316: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x315, &mut x316, x314, x286, x283);
  let mut x317: u32 = 0;
  let mut x318: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x317, &mut x318, x316, x284, x281);
  let mut x319: u32 = 0;
  let mut x320: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x319, &mut x320, x318, x282, x279);
  let mut x321: u32 = 0;
  let mut x322: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x280, x277);
  let mut x323: u32 = 0;
  let mut x324: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x323, &mut x324, 0x0, x253, x299);
  let mut x325: u32 = 0;
  let mut x326: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x325, &mut x326, x324, x255, x301);
  let mut x327: u32 = 0;
  let mut x328: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x327, &mut x328, x326, x257, x303);
  let mut x329: u32 = 0;
  let mut x330: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x329, &mut x330, x328, x259, x305);
  let mut x331: u32 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x331, &mut x332, x330, x261, x307);
  let mut x333: u32 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x263, x309);
  let mut x335: u32 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x265, x311);
  let mut x337: u32 = 0;
  let mut x338: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x337, &mut x338, x336, x267, x313);
  let mut x339: u32 = 0;
  let mut x340: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x339, &mut x340, x338, x269, x315);
  let mut x341: u32 = 0;
  let mut x342: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x341, &mut x342, x340, x271, x317);
  let mut x343: u32 = 0;
  let mut x344: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x343, &mut x344, x342, x273, x319);
  let mut x345: u32 = 0;
  let mut x346: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x345, &mut x346, x344, x275, x321);
  let mut x347: u32 = 0;
  let mut x348: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x347, &mut x348, x323, 0xe88fdc45);
  let mut x349: u32 = 0;
  let mut x350: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x349, &mut x350, x347, 0xffffffff);
  let mut x351: u32 = 0;
  let mut x352: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x351, &mut x352, x347, 0xffffffff);
  let mut x353: u32 = 0;
  let mut x354: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x353, &mut x354, x347, 0xffffffff);
  let mut x355: u32 = 0;
  let mut x356: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x355, &mut x356, x347, 0xffffffff);
  let mut x357: u32 = 0;
  let mut x358: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x357, &mut x358, x347, 0xffffffff);
  let mut x359: u32 = 0;
  let mut x360: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x359, &mut x360, x347, 0xffffffff);
  let mut x361: u32 = 0;
  let mut x362: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x361, &mut x362, x347, 0xc7634d81);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x363, &mut x364, x347, 0xf4372ddf);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x365, &mut x366, x347, 0x581a0db2);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x367, &mut x368, x347, 0x48b0a77a);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x369, &mut x370, x347, 0xecec196a);
  let mut x371: u32 = 0;
  let mut x372: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x371, &mut x372, x347, 0xccc52973);
  let mut x373: u32 = 0;
  let mut x374: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x373, &mut x374, 0x0, x372, x369);
  let mut x375: u32 = 0;
  let mut x376: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x375, &mut x376, x374, x370, x367);
  let mut x377: u32 = 0;
  let mut x378: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x377, &mut x378, x376, x368, x365);
  let mut x379: u32 = 0;
  let mut x380: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x366, x363);
  let mut x381: u32 = 0;
  let mut x382: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x364, x361);
  let mut x383: u32 = 0;
  let mut x384: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x362, x359);
  let mut x385: u32 = 0;
  let mut x386: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x360, x357);
  let mut x387: u32 = 0;
  let mut x388: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x358, x355);
  let mut x389: u32 = 0;
  let mut x390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x356, x353);
  let mut x391: u32 = 0;
  let mut x392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x354, x351);
  let mut x393: u32 = 0;
  let mut x394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x393, &mut x394, x392, x352, x349);
  let mut x395: u32 = 0;
  let mut x396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x395, &mut x396, 0x0, x323, x371);
  let mut x397: u32 = 0;
  let mut x398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x397, &mut x398, x396, x325, x373);
  let mut x399: u32 = 0;
  let mut x400: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x399, &mut x400, x398, x327, x375);
  let mut x401: u32 = 0;
  let mut x402: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x329, x377);
  let mut x403: u32 = 0;
  let mut x404: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x331, x379);
  let mut x405: u32 = 0;
  let mut x406: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x405, &mut x406, x404, x333, x381);
  let mut x407: u32 = 0;
  let mut x408: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x407, &mut x408, x406, x335, x383);
  let mut x409: u32 = 0;
  let mut x410: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x409, &mut x410, x408, x337, x385);
  let mut x411: u32 = 0;
  let mut x412: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x411, &mut x412, x410, x339, x387);
  let mut x413: u32 = 0;
  let mut x414: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x413, &mut x414, x412, x341, x389);
  let mut x415: u32 = 0;
  let mut x416: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x415, &mut x416, x414, x343, x391);
  let mut x417: u32 = 0;
  let mut x418: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x417, &mut x418, x416, x345, x393);
  let mut x419: u32 = 0;
  let mut x420: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x419, &mut x420, x418, (((x346 as u32) + (x276 as u32)) + ((x322 as u32) + x278)), ((x394 as u32) + x350));
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x421, &mut x422, x3, 0xc84ee01);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x423, &mut x424, x3, 0x2b39bf21);
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x425, &mut x426, x3, 0x3fb05b7a);
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x427, &mut x428, x3, 0x28266895);
  let mut x429: u32 = 0;
  let mut x430: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x429, &mut x430, x3, 0xd40d4917);
  let mut x431: u32 = 0;
  let mut x432: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x431, &mut x432, x3, 0x4aab1cc5);
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x433, &mut x434, x3, 0xbc3e483a);
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x435, &mut x436, x3, 0xfcb82947);
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x437, &mut x438, x3, 0xff3d81e5);
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x439, &mut x440, x3, 0xdf1aa419);
  let mut x441: u32 = 0;
  let mut x442: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x441, &mut x442, x3, 0x2d319b24);
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x443, &mut x444, x3, 0x19b409a9);
  let mut x445: u32 = 0;
  let mut x446: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x445, &mut x446, 0x0, x444, x441);
  let mut x447: u32 = 0;
  let mut x448: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x447, &mut x448, x446, x442, x439);
  let mut x449: u32 = 0;
  let mut x450: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x449, &mut x450, x448, x440, x437);
  let mut x451: u32 = 0;
  let mut x452: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x451, &mut x452, x450, x438, x435);
  let mut x453: u32 = 0;
  let mut x454: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x453, &mut x454, x452, x436, x433);
  let mut x455: u32 = 0;
  let mut x456: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x455, &mut x456, x454, x434, x431);
  let mut x457: u32 = 0;
  let mut x458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x457, &mut x458, x456, x432, x429);
  let mut x459: u32 = 0;
  let mut x460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x459, &mut x460, x458, x430, x427);
  let mut x461: u32 = 0;
  let mut x462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x461, &mut x462, x460, x428, x425);
  let mut x463: u32 = 0;
  let mut x464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x426, x423);
  let mut x465: u32 = 0;
  let mut x466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x424, x421);
  let mut x467: u32 = 0;
  let mut x468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x467, &mut x468, 0x0, x397, x443);
  let mut x469: u32 = 0;
  let mut x470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x399, x445);
  let mut x471: u32 = 0;
  let mut x472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x401, x447);
  let mut x473: u32 = 0;
  let mut x474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x473, &mut x474, x472, x403, x449);
  let mut x475: u32 = 0;
  let mut x476: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x475, &mut x476, x474, x405, x451);
  let mut x477: u32 = 0;
  let mut x478: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x477, &mut x478, x476, x407, x453);
  let mut x479: u32 = 0;
  let mut x480: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x479, &mut x480, x478, x409, x455);
  let mut x481: u32 = 0;
  let mut x482: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x481, &mut x482, x480, x411, x457);
  let mut x483: u32 = 0;
  let mut x484: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x483, &mut x484, x482, x413, x459);
  let mut x485: u32 = 0;
  let mut x486: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x485, &mut x486, x484, x415, x461);
  let mut x487: u32 = 0;
  let mut x488: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x487, &mut x488, x486, x417, x463);
  let mut x489: u32 = 0;
  let mut x490: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x489, &mut x490, x488, x419, x465);
  let mut x491: u32 = 0;
  let mut x492: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x491, &mut x492, x467, 0xe88fdc45);
  let mut x493: u32 = 0;
  let mut x494: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x493, &mut x494, x491, 0xffffffff);
  let mut x495: u32 = 0;
  let mut x496: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x495, &mut x496, x491, 0xffffffff);
  let mut x497: u32 = 0;
  let mut x498: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x497, &mut x498, x491, 0xffffffff);
  let mut x499: u32 = 0;
  let mut x500: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x499, &mut x500, x491, 0xffffffff);
  let mut x501: u32 = 0;
  let mut x502: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x501, &mut x502, x491, 0xffffffff);
  let mut x503: u32 = 0;
  let mut x504: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x503, &mut x504, x491, 0xffffffff);
  let mut x505: u32 = 0;
  let mut x506: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x505, &mut x506, x491, 0xc7634d81);
  let mut x507: u32 = 0;
  let mut x508: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x507, &mut x508, x491, 0xf4372ddf);
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x509, &mut x510, x491, 0x581a0db2);
  let mut x511: u32 = 0;
  let mut x512: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x511, &mut x512, x491, 0x48b0a77a);
  let mut x513: u32 = 0;
  let mut x514: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x513, &mut x514, x491, 0xecec196a);
  let mut x515: u32 = 0;
  let mut x516: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x515, &mut x516, x491, 0xccc52973);
  let mut x517: u32 = 0;
  let mut x518: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x517, &mut x518, 0x0, x516, x513);
  let mut x519: u32 = 0;
  let mut x520: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x519, &mut x520, x518, x514, x511);
  let mut x521: u32 = 0;
  let mut x522: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x521, &mut x522, x520, x512, x509);
  let mut x523: u32 = 0;
  let mut x524: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x523, &mut x524, x522, x510, x507);
  let mut x525: u32 = 0;
  let mut x526: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x525, &mut x526, x524, x508, x505);
  let mut x527: u32 = 0;
  let mut x528: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x527, &mut x528, x526, x506, x503);
  let mut x529: u32 = 0;
  let mut x530: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x529, &mut x530, x528, x504, x501);
  let mut x531: u32 = 0;
  let mut x532: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x531, &mut x532, x530, x502, x499);
  let mut x533: u32 = 0;
  let mut x534: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x533, &mut x534, x532, x500, x497);
  let mut x535: u32 = 0;
  let mut x536: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x535, &mut x536, x534, x498, x495);
  let mut x537: u32 = 0;
  let mut x538: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x537, &mut x538, x536, x496, x493);
  let mut x539: u32 = 0;
  let mut x540: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x539, &mut x540, 0x0, x467, x515);
  let mut x541: u32 = 0;
  let mut x542: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x541, &mut x542, x540, x469, x517);
  let mut x543: u32 = 0;
  let mut x544: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x543, &mut x544, x542, x471, x519);
  let mut x545: u32 = 0;
  let mut x546: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x545, &mut x546, x544, x473, x521);
  let mut x547: u32 = 0;
  let mut x548: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x547, &mut x548, x546, x475, x523);
  let mut x549: u32 = 0;
  let mut x550: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x549, &mut x550, x548, x477, x525);
  let mut x551: u32 = 0;
  let mut x552: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x551, &mut x552, x550, x479, x527);
  let mut x553: u32 = 0;
  let mut x554: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x553, &mut x554, x552, x481, x529);
  let mut x555: u32 = 0;
  let mut x556: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x555, &mut x556, x554, x483, x531);
  let mut x557: u32 = 0;
  let mut x558: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x485, x533);
  let mut x559: u32 = 0;
  let mut x560: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x487, x535);
  let mut x561: u32 = 0;
  let mut x562: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x561, &mut x562, x560, x489, x537);
  let mut x563: u32 = 0;
  let mut x564: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x563, &mut x564, x562, (((x490 as u32) + (x420 as u32)) + ((x466 as u32) + x422)), ((x538 as u32) + x494));
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x565, &mut x566, x4, 0xc84ee01);
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x567, &mut x568, x4, 0x2b39bf21);
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x569, &mut x570, x4, 0x3fb05b7a);
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x571, &mut x572, x4, 0x28266895);
  let mut x573: u32 = 0;
  let mut x574: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x573, &mut x574, x4, 0xd40d4917);
  let mut x575: u32 = 0;
  let mut x576: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x575, &mut x576, x4, 0x4aab1cc5);
  let mut x577: u32 = 0;
  let mut x578: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x577, &mut x578, x4, 0xbc3e483a);
  let mut x579: u32 = 0;
  let mut x580: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x579, &mut x580, x4, 0xfcb82947);
  let mut x581: u32 = 0;
  let mut x582: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x581, &mut x582, x4, 0xff3d81e5);
  let mut x583: u32 = 0;
  let mut x584: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x583, &mut x584, x4, 0xdf1aa419);
  let mut x585: u32 = 0;
  let mut x586: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x585, &mut x586, x4, 0x2d319b24);
  let mut x587: u32 = 0;
  let mut x588: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x587, &mut x588, x4, 0x19b409a9);
  let mut x589: u32 = 0;
  let mut x590: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x589, &mut x590, 0x0, x588, x585);
  let mut x591: u32 = 0;
  let mut x592: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x591, &mut x592, x590, x586, x583);
  let mut x593: u32 = 0;
  let mut x594: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x593, &mut x594, x592, x584, x581);
  let mut x595: u32 = 0;
  let mut x596: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x595, &mut x596, x594, x582, x579);
  let mut x597: u32 = 0;
  let mut x598: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x597, &mut x598, x596, x580, x577);
  let mut x599: u32 = 0;
  let mut x600: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x599, &mut x600, x598, x578, x575);
  let mut x601: u32 = 0;
  let mut x602: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x601, &mut x602, x600, x576, x573);
  let mut x603: u32 = 0;
  let mut x604: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x603, &mut x604, x602, x574, x571);
  let mut x605: u32 = 0;
  let mut x606: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x605, &mut x606, x604, x572, x569);
  let mut x607: u32 = 0;
  let mut x608: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x607, &mut x608, x606, x570, x567);
  let mut x609: u32 = 0;
  let mut x610: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x609, &mut x610, x608, x568, x565);
  let mut x611: u32 = 0;
  let mut x612: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x611, &mut x612, 0x0, x541, x587);
  let mut x613: u32 = 0;
  let mut x614: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x613, &mut x614, x612, x543, x589);
  let mut x615: u32 = 0;
  let mut x616: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x615, &mut x616, x614, x545, x591);
  let mut x617: u32 = 0;
  let mut x618: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x617, &mut x618, x616, x547, x593);
  let mut x619: u32 = 0;
  let mut x620: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x619, &mut x620, x618, x549, x595);
  let mut x621: u32 = 0;
  let mut x622: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x621, &mut x622, x620, x551, x597);
  let mut x623: u32 = 0;
  let mut x624: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x623, &mut x624, x622, x553, x599);
  let mut x625: u32 = 0;
  let mut x626: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x625, &mut x626, x624, x555, x601);
  let mut x627: u32 = 0;
  let mut x628: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x627, &mut x628, x626, x557, x603);
  let mut x629: u32 = 0;
  let mut x630: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x629, &mut x630, x628, x559, x605);
  let mut x631: u32 = 0;
  let mut x632: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x561, x607);
  let mut x633: u32 = 0;
  let mut x634: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x633, &mut x634, x632, x563, x609);
  let mut x635: u32 = 0;
  let mut x636: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x635, &mut x636, x611, 0xe88fdc45);
  let mut x637: u32 = 0;
  let mut x638: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x637, &mut x638, x635, 0xffffffff);
  let mut x639: u32 = 0;
  let mut x640: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x639, &mut x640, x635, 0xffffffff);
  let mut x641: u32 = 0;
  let mut x642: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x641, &mut x642, x635, 0xffffffff);
  let mut x643: u32 = 0;
  let mut x644: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x643, &mut x644, x635, 0xffffffff);
  let mut x645: u32 = 0;
  let mut x646: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x645, &mut x646, x635, 0xffffffff);
  let mut x647: u32 = 0;
  let mut x648: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x647, &mut x648, x635, 0xffffffff);
  let mut x649: u32 = 0;
  let mut x650: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x649, &mut x650, x635, 0xc7634d81);
  let mut x651: u32 = 0;
  let mut x652: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x651, &mut x652, x635, 0xf4372ddf);
  let mut x653: u32 = 0;
  let mut x654: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x653, &mut x654, x635, 0x581a0db2);
  let mut x655: u32 = 0;
  let mut x656: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x655, &mut x656, x635, 0x48b0a77a);
  let mut x657: u32 = 0;
  let mut x658: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x657, &mut x658, x635, 0xecec196a);
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x659, &mut x660, x635, 0xccc52973);
  let mut x661: u32 = 0;
  let mut x662: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x661, &mut x662, 0x0, x660, x657);
  let mut x663: u32 = 0;
  let mut x664: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x663, &mut x664, x662, x658, x655);
  let mut x665: u32 = 0;
  let mut x666: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x665, &mut x666, x664, x656, x653);
  let mut x667: u32 = 0;
  let mut x668: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x667, &mut x668, x666, x654, x651);
  let mut x669: u32 = 0;
  let mut x670: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x669, &mut x670, x668, x652, x649);
  let mut x671: u32 = 0;
  let mut x672: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x671, &mut x672, x670, x650, x647);
  let mut x673: u32 = 0;
  let mut x674: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x673, &mut x674, x672, x648, x645);
  let mut x675: u32 = 0;
  let mut x676: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x675, &mut x676, x674, x646, x643);
  let mut x677: u32 = 0;
  let mut x678: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x677, &mut x678, x676, x644, x641);
  let mut x679: u32 = 0;
  let mut x680: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x679, &mut x680, x678, x642, x639);
  let mut x681: u32 = 0;
  let mut x682: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x681, &mut x682, x680, x640, x637);
  let mut x683: u32 = 0;
  let mut x684: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x683, &mut x684, 0x0, x611, x659);
  let mut x685: u32 = 0;
  let mut x686: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x685, &mut x686, x684, x613, x661);
  let mut x687: u32 = 0;
  let mut x688: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x687, &mut x688, x686, x615, x663);
  let mut x689: u32 = 0;
  let mut x690: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x689, &mut x690, x688, x617, x665);
  let mut x691: u32 = 0;
  let mut x692: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x691, &mut x692, x690, x619, x667);
  let mut x693: u32 = 0;
  let mut x694: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x693, &mut x694, x692, x621, x669);
  let mut x695: u32 = 0;
  let mut x696: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x695, &mut x696, x694, x623, x671);
  let mut x697: u32 = 0;
  let mut x698: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x697, &mut x698, x696, x625, x673);
  let mut x699: u32 = 0;
  let mut x700: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x699, &mut x700, x698, x627, x675);
  let mut x701: u32 = 0;
  let mut x702: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x701, &mut x702, x700, x629, x677);
  let mut x703: u32 = 0;
  let mut x704: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x703, &mut x704, x702, x631, x679);
  let mut x705: u32 = 0;
  let mut x706: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x705, &mut x706, x704, x633, x681);
  let mut x707: u32 = 0;
  let mut x708: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x707, &mut x708, x706, (((x634 as u32) + (x564 as u32)) + ((x610 as u32) + x566)), ((x682 as u32) + x638));
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x709, &mut x710, x5, 0xc84ee01);
  let mut x711: u32 = 0;
  let mut x712: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x711, &mut x712, x5, 0x2b39bf21);
  let mut x713: u32 = 0;
  let mut x714: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x713, &mut x714, x5, 0x3fb05b7a);
  let mut x715: u32 = 0;
  let mut x716: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x715, &mut x716, x5, 0x28266895);
  let mut x717: u32 = 0;
  let mut x718: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x717, &mut x718, x5, 0xd40d4917);
  let mut x719: u32 = 0;
  let mut x720: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x719, &mut x720, x5, 0x4aab1cc5);
  let mut x721: u32 = 0;
  let mut x722: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x721, &mut x722, x5, 0xbc3e483a);
  let mut x723: u32 = 0;
  let mut x724: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x723, &mut x724, x5, 0xfcb82947);
  let mut x725: u32 = 0;
  let mut x726: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x725, &mut x726, x5, 0xff3d81e5);
  let mut x727: u32 = 0;
  let mut x728: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x727, &mut x728, x5, 0xdf1aa419);
  let mut x729: u32 = 0;
  let mut x730: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x729, &mut x730, x5, 0x2d319b24);
  let mut x731: u32 = 0;
  let mut x732: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x731, &mut x732, x5, 0x19b409a9);
  let mut x733: u32 = 0;
  let mut x734: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x733, &mut x734, 0x0, x732, x729);
  let mut x735: u32 = 0;
  let mut x736: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x735, &mut x736, x734, x730, x727);
  let mut x737: u32 = 0;
  let mut x738: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x737, &mut x738, x736, x728, x725);
  let mut x739: u32 = 0;
  let mut x740: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x739, &mut x740, x738, x726, x723);
  let mut x741: u32 = 0;
  let mut x742: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x741, &mut x742, x740, x724, x721);
  let mut x743: u32 = 0;
  let mut x744: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x743, &mut x744, x742, x722, x719);
  let mut x745: u32 = 0;
  let mut x746: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x745, &mut x746, x744, x720, x717);
  let mut x747: u32 = 0;
  let mut x748: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x747, &mut x748, x746, x718, x715);
  let mut x749: u32 = 0;
  let mut x750: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x749, &mut x750, x748, x716, x713);
  let mut x751: u32 = 0;
  let mut x752: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x751, &mut x752, x750, x714, x711);
  let mut x753: u32 = 0;
  let mut x754: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x753, &mut x754, x752, x712, x709);
  let mut x755: u32 = 0;
  let mut x756: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x755, &mut x756, 0x0, x685, x731);
  let mut x757: u32 = 0;
  let mut x758: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x757, &mut x758, x756, x687, x733);
  let mut x759: u32 = 0;
  let mut x760: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x759, &mut x760, x758, x689, x735);
  let mut x761: u32 = 0;
  let mut x762: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x761, &mut x762, x760, x691, x737);
  let mut x763: u32 = 0;
  let mut x764: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x763, &mut x764, x762, x693, x739);
  let mut x765: u32 = 0;
  let mut x766: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x765, &mut x766, x764, x695, x741);
  let mut x767: u32 = 0;
  let mut x768: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x767, &mut x768, x766, x697, x743);
  let mut x769: u32 = 0;
  let mut x770: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x769, &mut x770, x768, x699, x745);
  let mut x771: u32 = 0;
  let mut x772: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x771, &mut x772, x770, x701, x747);
  let mut x773: u32 = 0;
  let mut x774: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x773, &mut x774, x772, x703, x749);
  let mut x775: u32 = 0;
  let mut x776: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x775, &mut x776, x774, x705, x751);
  let mut x777: u32 = 0;
  let mut x778: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x777, &mut x778, x776, x707, x753);
  let mut x779: u32 = 0;
  let mut x780: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x779, &mut x780, x755, 0xe88fdc45);
  let mut x781: u32 = 0;
  let mut x782: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x781, &mut x782, x779, 0xffffffff);
  let mut x783: u32 = 0;
  let mut x784: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x783, &mut x784, x779, 0xffffffff);
  let mut x785: u32 = 0;
  let mut x786: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x785, &mut x786, x779, 0xffffffff);
  let mut x787: u32 = 0;
  let mut x788: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x787, &mut x788, x779, 0xffffffff);
  let mut x789: u32 = 0;
  let mut x790: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x789, &mut x790, x779, 0xffffffff);
  let mut x791: u32 = 0;
  let mut x792: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x791, &mut x792, x779, 0xffffffff);
  let mut x793: u32 = 0;
  let mut x794: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x793, &mut x794, x779, 0xc7634d81);
  let mut x795: u32 = 0;
  let mut x796: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x795, &mut x796, x779, 0xf4372ddf);
  let mut x797: u32 = 0;
  let mut x798: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x797, &mut x798, x779, 0x581a0db2);
  let mut x799: u32 = 0;
  let mut x800: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x799, &mut x800, x779, 0x48b0a77a);
  let mut x801: u32 = 0;
  let mut x802: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x801, &mut x802, x779, 0xecec196a);
  let mut x803: u32 = 0;
  let mut x804: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x803, &mut x804, x779, 0xccc52973);
  let mut x805: u32 = 0;
  let mut x806: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x805, &mut x806, 0x0, x804, x801);
  let mut x807: u32 = 0;
  let mut x808: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x807, &mut x808, x806, x802, x799);
  let mut x809: u32 = 0;
  let mut x810: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x809, &mut x810, x808, x800, x797);
  let mut x811: u32 = 0;
  let mut x812: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x811, &mut x812, x810, x798, x795);
  let mut x813: u32 = 0;
  let mut x814: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x813, &mut x814, x812, x796, x793);
  let mut x815: u32 = 0;
  let mut x816: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x815, &mut x816, x814, x794, x791);
  let mut x817: u32 = 0;
  let mut x818: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x817, &mut x818, x816, x792, x789);
  let mut x819: u32 = 0;
  let mut x820: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x819, &mut x820, x818, x790, x787);
  let mut x821: u32 = 0;
  let mut x822: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x821, &mut x822, x820, x788, x785);
  let mut x823: u32 = 0;
  let mut x824: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x823, &mut x824, x822, x786, x783);
  let mut x825: u32 = 0;
  let mut x826: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x825, &mut x826, x824, x784, x781);
  let mut x827: u32 = 0;
  let mut x828: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x827, &mut x828, 0x0, x755, x803);
  let mut x829: u32 = 0;
  let mut x830: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x829, &mut x830, x828, x757, x805);
  let mut x831: u32 = 0;
  let mut x832: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x831, &mut x832, x830, x759, x807);
  let mut x833: u32 = 0;
  let mut x834: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x833, &mut x834, x832, x761, x809);
  let mut x835: u32 = 0;
  let mut x836: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x835, &mut x836, x834, x763, x811);
  let mut x837: u32 = 0;
  let mut x838: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x837, &mut x838, x836, x765, x813);
  let mut x839: u32 = 0;
  let mut x840: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x839, &mut x840, x838, x767, x815);
  let mut x841: u32 = 0;
  let mut x842: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x841, &mut x842, x840, x769, x817);
  let mut x843: u32 = 0;
  let mut x844: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x843, &mut x844, x842, x771, x819);
  let mut x845: u32 = 0;
  let mut x846: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x845, &mut x846, x844, x773, x821);
  let mut x847: u32 = 0;
  let mut x848: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x847, &mut x848, x846, x775, x823);
  let mut x849: u32 = 0;
  let mut x850: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x849, &mut x850, x848, x777, x825);
  let mut x851: u32 = 0;
  let mut x852: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x851, &mut x852, x850, (((x778 as u32) + (x708 as u32)) + ((x754 as u32) + x710)), ((x826 as u32) + x782));
  let mut x853: u32 = 0;
  let mut x854: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x853, &mut x854, x6, 0xc84ee01);
  let mut x855: u32 = 0;
  let mut x856: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x855, &mut x856, x6, 0x2b39bf21);
  let mut x857: u32 = 0;
  let mut x858: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x857, &mut x858, x6, 0x3fb05b7a);
  let mut x859: u32 = 0;
  let mut x860: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x859, &mut x860, x6, 0x28266895);
  let mut x861: u32 = 0;
  let mut x862: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x861, &mut x862, x6, 0xd40d4917);
  let mut x863: u32 = 0;
  let mut x864: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x863, &mut x864, x6, 0x4aab1cc5);
  let mut x865: u32 = 0;
  let mut x866: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x865, &mut x866, x6, 0xbc3e483a);
  let mut x867: u32 = 0;
  let mut x868: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x867, &mut x868, x6, 0xfcb82947);
  let mut x869: u32 = 0;
  let mut x870: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x869, &mut x870, x6, 0xff3d81e5);
  let mut x871: u32 = 0;
  let mut x872: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x871, &mut x872, x6, 0xdf1aa419);
  let mut x873: u32 = 0;
  let mut x874: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x873, &mut x874, x6, 0x2d319b24);
  let mut x875: u32 = 0;
  let mut x876: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x875, &mut x876, x6, 0x19b409a9);
  let mut x877: u32 = 0;
  let mut x878: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x877, &mut x878, 0x0, x876, x873);
  let mut x879: u32 = 0;
  let mut x880: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x879, &mut x880, x878, x874, x871);
  let mut x881: u32 = 0;
  let mut x882: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x881, &mut x882, x880, x872, x869);
  let mut x883: u32 = 0;
  let mut x884: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x883, &mut x884, x882, x870, x867);
  let mut x885: u32 = 0;
  let mut x886: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x885, &mut x886, x884, x868, x865);
  let mut x887: u32 = 0;
  let mut x888: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x887, &mut x888, x886, x866, x863);
  let mut x889: u32 = 0;
  let mut x890: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x889, &mut x890, x888, x864, x861);
  let mut x891: u32 = 0;
  let mut x892: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x891, &mut x892, x890, x862, x859);
  let mut x893: u32 = 0;
  let mut x894: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x893, &mut x894, x892, x860, x857);
  let mut x895: u32 = 0;
  let mut x896: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x895, &mut x896, x894, x858, x855);
  let mut x897: u32 = 0;
  let mut x898: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x897, &mut x898, x896, x856, x853);
  let mut x899: u32 = 0;
  let mut x900: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x899, &mut x900, 0x0, x829, x875);
  let mut x901: u32 = 0;
  let mut x902: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x901, &mut x902, x900, x831, x877);
  let mut x903: u32 = 0;
  let mut x904: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x903, &mut x904, x902, x833, x879);
  let mut x905: u32 = 0;
  let mut x906: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x905, &mut x906, x904, x835, x881);
  let mut x907: u32 = 0;
  let mut x908: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x907, &mut x908, x906, x837, x883);
  let mut x909: u32 = 0;
  let mut x910: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x909, &mut x910, x908, x839, x885);
  let mut x911: u32 = 0;
  let mut x912: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x911, &mut x912, x910, x841, x887);
  let mut x913: u32 = 0;
  let mut x914: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x913, &mut x914, x912, x843, x889);
  let mut x915: u32 = 0;
  let mut x916: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x915, &mut x916, x914, x845, x891);
  let mut x917: u32 = 0;
  let mut x918: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x917, &mut x918, x916, x847, x893);
  let mut x919: u32 = 0;
  let mut x920: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x919, &mut x920, x918, x849, x895);
  let mut x921: u32 = 0;
  let mut x922: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x921, &mut x922, x920, x851, x897);
  let mut x923: u32 = 0;
  let mut x924: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x923, &mut x924, x899, 0xe88fdc45);
  let mut x925: u32 = 0;
  let mut x926: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x925, &mut x926, x923, 0xffffffff);
  let mut x927: u32 = 0;
  let mut x928: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x927, &mut x928, x923, 0xffffffff);
  let mut x929: u32 = 0;
  let mut x930: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x929, &mut x930, x923, 0xffffffff);
  let mut x931: u32 = 0;
  let mut x932: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x931, &mut x932, x923, 0xffffffff);
  let mut x933: u32 = 0;
  let mut x934: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x933, &mut x934, x923, 0xffffffff);
  let mut x935: u32 = 0;
  let mut x936: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x935, &mut x936, x923, 0xffffffff);
  let mut x937: u32 = 0;
  let mut x938: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x937, &mut x938, x923, 0xc7634d81);
  let mut x939: u32 = 0;
  let mut x940: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x939, &mut x940, x923, 0xf4372ddf);
  let mut x941: u32 = 0;
  let mut x942: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x941, &mut x942, x923, 0x581a0db2);
  let mut x943: u32 = 0;
  let mut x944: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x943, &mut x944, x923, 0x48b0a77a);
  let mut x945: u32 = 0;
  let mut x946: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x945, &mut x946, x923, 0xecec196a);
  let mut x947: u32 = 0;
  let mut x948: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x947, &mut x948, x923, 0xccc52973);
  let mut x949: u32 = 0;
  let mut x950: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x949, &mut x950, 0x0, x948, x945);
  let mut x951: u32 = 0;
  let mut x952: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x951, &mut x952, x950, x946, x943);
  let mut x953: u32 = 0;
  let mut x954: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x953, &mut x954, x952, x944, x941);
  let mut x955: u32 = 0;
  let mut x956: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x955, &mut x956, x954, x942, x939);
  let mut x957: u32 = 0;
  let mut x958: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x957, &mut x958, x956, x940, x937);
  let mut x959: u32 = 0;
  let mut x960: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x959, &mut x960, x958, x938, x935);
  let mut x961: u32 = 0;
  let mut x962: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x961, &mut x962, x960, x936, x933);
  let mut x963: u32 = 0;
  let mut x964: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x963, &mut x964, x962, x934, x931);
  let mut x965: u32 = 0;
  let mut x966: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x965, &mut x966, x964, x932, x929);
  let mut x967: u32 = 0;
  let mut x968: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x967, &mut x968, x966, x930, x927);
  let mut x969: u32 = 0;
  let mut x970: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x969, &mut x970, x968, x928, x925);
  let mut x971: u32 = 0;
  let mut x972: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x971, &mut x972, 0x0, x899, x947);
  let mut x973: u32 = 0;
  let mut x974: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x973, &mut x974, x972, x901, x949);
  let mut x975: u32 = 0;
  let mut x976: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x975, &mut x976, x974, x903, x951);
  let mut x977: u32 = 0;
  let mut x978: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x977, &mut x978, x976, x905, x953);
  let mut x979: u32 = 0;
  let mut x980: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x979, &mut x980, x978, x907, x955);
  let mut x981: u32 = 0;
  let mut x982: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x981, &mut x982, x980, x909, x957);
  let mut x983: u32 = 0;
  let mut x984: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x983, &mut x984, x982, x911, x959);
  let mut x985: u32 = 0;
  let mut x986: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x985, &mut x986, x984, x913, x961);
  let mut x987: u32 = 0;
  let mut x988: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x987, &mut x988, x986, x915, x963);
  let mut x989: u32 = 0;
  let mut x990: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x989, &mut x990, x988, x917, x965);
  let mut x991: u32 = 0;
  let mut x992: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x991, &mut x992, x990, x919, x967);
  let mut x993: u32 = 0;
  let mut x994: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x993, &mut x994, x992, x921, x969);
  let mut x995: u32 = 0;
  let mut x996: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x995, &mut x996, x994, (((x922 as u32) + (x852 as u32)) + ((x898 as u32) + x854)), ((x970 as u32) + x926));
  let mut x997: u32 = 0;
  let mut x998: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x997, &mut x998, x7, 0xc84ee01);
  let mut x999: u32 = 0;
  let mut x1000: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x999, &mut x1000, x7, 0x2b39bf21);
  let mut x1001: u32 = 0;
  let mut x1002: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1001, &mut x1002, x7, 0x3fb05b7a);
  let mut x1003: u32 = 0;
  let mut x1004: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1003, &mut x1004, x7, 0x28266895);
  let mut x1005: u32 = 0;
  let mut x1006: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1005, &mut x1006, x7, 0xd40d4917);
  let mut x1007: u32 = 0;
  let mut x1008: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1007, &mut x1008, x7, 0x4aab1cc5);
  let mut x1009: u32 = 0;
  let mut x1010: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1009, &mut x1010, x7, 0xbc3e483a);
  let mut x1011: u32 = 0;
  let mut x1012: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1011, &mut x1012, x7, 0xfcb82947);
  let mut x1013: u32 = 0;
  let mut x1014: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1013, &mut x1014, x7, 0xff3d81e5);
  let mut x1015: u32 = 0;
  let mut x1016: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1015, &mut x1016, x7, 0xdf1aa419);
  let mut x1017: u32 = 0;
  let mut x1018: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1017, &mut x1018, x7, 0x2d319b24);
  let mut x1019: u32 = 0;
  let mut x1020: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1019, &mut x1020, x7, 0x19b409a9);
  let mut x1021: u32 = 0;
  let mut x1022: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1021, &mut x1022, 0x0, x1020, x1017);
  let mut x1023: u32 = 0;
  let mut x1024: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1023, &mut x1024, x1022, x1018, x1015);
  let mut x1025: u32 = 0;
  let mut x1026: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1025, &mut x1026, x1024, x1016, x1013);
  let mut x1027: u32 = 0;
  let mut x1028: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1027, &mut x1028, x1026, x1014, x1011);
  let mut x1029: u32 = 0;
  let mut x1030: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1029, &mut x1030, x1028, x1012, x1009);
  let mut x1031: u32 = 0;
  let mut x1032: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1031, &mut x1032, x1030, x1010, x1007);
  let mut x1033: u32 = 0;
  let mut x1034: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1033, &mut x1034, x1032, x1008, x1005);
  let mut x1035: u32 = 0;
  let mut x1036: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1035, &mut x1036, x1034, x1006, x1003);
  let mut x1037: u32 = 0;
  let mut x1038: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1037, &mut x1038, x1036, x1004, x1001);
  let mut x1039: u32 = 0;
  let mut x1040: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1039, &mut x1040, x1038, x1002, x999);
  let mut x1041: u32 = 0;
  let mut x1042: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1041, &mut x1042, x1040, x1000, x997);
  let mut x1043: u32 = 0;
  let mut x1044: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1043, &mut x1044, 0x0, x973, x1019);
  let mut x1045: u32 = 0;
  let mut x1046: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1045, &mut x1046, x1044, x975, x1021);
  let mut x1047: u32 = 0;
  let mut x1048: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1047, &mut x1048, x1046, x977, x1023);
  let mut x1049: u32 = 0;
  let mut x1050: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1049, &mut x1050, x1048, x979, x1025);
  let mut x1051: u32 = 0;
  let mut x1052: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1051, &mut x1052, x1050, x981, x1027);
  let mut x1053: u32 = 0;
  let mut x1054: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1053, &mut x1054, x1052, x983, x1029);
  let mut x1055: u32 = 0;
  let mut x1056: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1055, &mut x1056, x1054, x985, x1031);
  let mut x1057: u32 = 0;
  let mut x1058: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1057, &mut x1058, x1056, x987, x1033);
  let mut x1059: u32 = 0;
  let mut x1060: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1059, &mut x1060, x1058, x989, x1035);
  let mut x1061: u32 = 0;
  let mut x1062: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1061, &mut x1062, x1060, x991, x1037);
  let mut x1063: u32 = 0;
  let mut x1064: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1063, &mut x1064, x1062, x993, x1039);
  let mut x1065: u32 = 0;
  let mut x1066: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1065, &mut x1066, x1064, x995, x1041);
  let mut x1067: u32 = 0;
  let mut x1068: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1067, &mut x1068, x1043, 0xe88fdc45);
  let mut x1069: u32 = 0;
  let mut x1070: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1069, &mut x1070, x1067, 0xffffffff);
  let mut x1071: u32 = 0;
  let mut x1072: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1071, &mut x1072, x1067, 0xffffffff);
  let mut x1073: u32 = 0;
  let mut x1074: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1073, &mut x1074, x1067, 0xffffffff);
  let mut x1075: u32 = 0;
  let mut x1076: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1075, &mut x1076, x1067, 0xffffffff);
  let mut x1077: u32 = 0;
  let mut x1078: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1077, &mut x1078, x1067, 0xffffffff);
  let mut x1079: u32 = 0;
  let mut x1080: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1079, &mut x1080, x1067, 0xffffffff);
  let mut x1081: u32 = 0;
  let mut x1082: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1081, &mut x1082, x1067, 0xc7634d81);
  let mut x1083: u32 = 0;
  let mut x1084: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1083, &mut x1084, x1067, 0xf4372ddf);
  let mut x1085: u32 = 0;
  let mut x1086: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1085, &mut x1086, x1067, 0x581a0db2);
  let mut x1087: u32 = 0;
  let mut x1088: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1087, &mut x1088, x1067, 0x48b0a77a);
  let mut x1089: u32 = 0;
  let mut x1090: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1089, &mut x1090, x1067, 0xecec196a);
  let mut x1091: u32 = 0;
  let mut x1092: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1091, &mut x1092, x1067, 0xccc52973);
  let mut x1093: u32 = 0;
  let mut x1094: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1093, &mut x1094, 0x0, x1092, x1089);
  let mut x1095: u32 = 0;
  let mut x1096: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1095, &mut x1096, x1094, x1090, x1087);
  let mut x1097: u32 = 0;
  let mut x1098: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1097, &mut x1098, x1096, x1088, x1085);
  let mut x1099: u32 = 0;
  let mut x1100: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1099, &mut x1100, x1098, x1086, x1083);
  let mut x1101: u32 = 0;
  let mut x1102: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1101, &mut x1102, x1100, x1084, x1081);
  let mut x1103: u32 = 0;
  let mut x1104: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1103, &mut x1104, x1102, x1082, x1079);
  let mut x1105: u32 = 0;
  let mut x1106: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1105, &mut x1106, x1104, x1080, x1077);
  let mut x1107: u32 = 0;
  let mut x1108: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1107, &mut x1108, x1106, x1078, x1075);
  let mut x1109: u32 = 0;
  let mut x1110: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1109, &mut x1110, x1108, x1076, x1073);
  let mut x1111: u32 = 0;
  let mut x1112: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1111, &mut x1112, x1110, x1074, x1071);
  let mut x1113: u32 = 0;
  let mut x1114: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1113, &mut x1114, x1112, x1072, x1069);
  let mut x1115: u32 = 0;
  let mut x1116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1115, &mut x1116, 0x0, x1043, x1091);
  let mut x1117: u32 = 0;
  let mut x1118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1117, &mut x1118, x1116, x1045, x1093);
  let mut x1119: u32 = 0;
  let mut x1120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1119, &mut x1120, x1118, x1047, x1095);
  let mut x1121: u32 = 0;
  let mut x1122: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1121, &mut x1122, x1120, x1049, x1097);
  let mut x1123: u32 = 0;
  let mut x1124: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1123, &mut x1124, x1122, x1051, x1099);
  let mut x1125: u32 = 0;
  let mut x1126: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1125, &mut x1126, x1124, x1053, x1101);
  let mut x1127: u32 = 0;
  let mut x1128: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1127, &mut x1128, x1126, x1055, x1103);
  let mut x1129: u32 = 0;
  let mut x1130: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1129, &mut x1130, x1128, x1057, x1105);
  let mut x1131: u32 = 0;
  let mut x1132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1131, &mut x1132, x1130, x1059, x1107);
  let mut x1133: u32 = 0;
  let mut x1134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1133, &mut x1134, x1132, x1061, x1109);
  let mut x1135: u32 = 0;
  let mut x1136: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1135, &mut x1136, x1134, x1063, x1111);
  let mut x1137: u32 = 0;
  let mut x1138: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1137, &mut x1138, x1136, x1065, x1113);
  let mut x1139: u32 = 0;
  let mut x1140: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1139, &mut x1140, x1138, (((x1066 as u32) + (x996 as u32)) + ((x1042 as u32) + x998)), ((x1114 as u32) + x1070));
  let mut x1141: u32 = 0;
  let mut x1142: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1141, &mut x1142, x8, 0xc84ee01);
  let mut x1143: u32 = 0;
  let mut x1144: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1143, &mut x1144, x8, 0x2b39bf21);
  let mut x1145: u32 = 0;
  let mut x1146: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1145, &mut x1146, x8, 0x3fb05b7a);
  let mut x1147: u32 = 0;
  let mut x1148: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1147, &mut x1148, x8, 0x28266895);
  let mut x1149: u32 = 0;
  let mut x1150: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1149, &mut x1150, x8, 0xd40d4917);
  let mut x1151: u32 = 0;
  let mut x1152: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1151, &mut x1152, x8, 0x4aab1cc5);
  let mut x1153: u32 = 0;
  let mut x1154: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1153, &mut x1154, x8, 0xbc3e483a);
  let mut x1155: u32 = 0;
  let mut x1156: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1155, &mut x1156, x8, 0xfcb82947);
  let mut x1157: u32 = 0;
  let mut x1158: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1157, &mut x1158, x8, 0xff3d81e5);
  let mut x1159: u32 = 0;
  let mut x1160: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1159, &mut x1160, x8, 0xdf1aa419);
  let mut x1161: u32 = 0;
  let mut x1162: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1161, &mut x1162, x8, 0x2d319b24);
  let mut x1163: u32 = 0;
  let mut x1164: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1163, &mut x1164, x8, 0x19b409a9);
  let mut x1165: u32 = 0;
  let mut x1166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1165, &mut x1166, 0x0, x1164, x1161);
  let mut x1167: u32 = 0;
  let mut x1168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1167, &mut x1168, x1166, x1162, x1159);
  let mut x1169: u32 = 0;
  let mut x1170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1169, &mut x1170, x1168, x1160, x1157);
  let mut x1171: u32 = 0;
  let mut x1172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1171, &mut x1172, x1170, x1158, x1155);
  let mut x1173: u32 = 0;
  let mut x1174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1173, &mut x1174, x1172, x1156, x1153);
  let mut x1175: u32 = 0;
  let mut x1176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1175, &mut x1176, x1174, x1154, x1151);
  let mut x1177: u32 = 0;
  let mut x1178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1177, &mut x1178, x1176, x1152, x1149);
  let mut x1179: u32 = 0;
  let mut x1180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1179, &mut x1180, x1178, x1150, x1147);
  let mut x1181: u32 = 0;
  let mut x1182: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1181, &mut x1182, x1180, x1148, x1145);
  let mut x1183: u32 = 0;
  let mut x1184: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1183, &mut x1184, x1182, x1146, x1143);
  let mut x1185: u32 = 0;
  let mut x1186: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1185, &mut x1186, x1184, x1144, x1141);
  let mut x1187: u32 = 0;
  let mut x1188: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1187, &mut x1188, 0x0, x1117, x1163);
  let mut x1189: u32 = 0;
  let mut x1190: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1189, &mut x1190, x1188, x1119, x1165);
  let mut x1191: u32 = 0;
  let mut x1192: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1191, &mut x1192, x1190, x1121, x1167);
  let mut x1193: u32 = 0;
  let mut x1194: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1193, &mut x1194, x1192, x1123, x1169);
  let mut x1195: u32 = 0;
  let mut x1196: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1195, &mut x1196, x1194, x1125, x1171);
  let mut x1197: u32 = 0;
  let mut x1198: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1197, &mut x1198, x1196, x1127, x1173);
  let mut x1199: u32 = 0;
  let mut x1200: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1199, &mut x1200, x1198, x1129, x1175);
  let mut x1201: u32 = 0;
  let mut x1202: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1201, &mut x1202, x1200, x1131, x1177);
  let mut x1203: u32 = 0;
  let mut x1204: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1203, &mut x1204, x1202, x1133, x1179);
  let mut x1205: u32 = 0;
  let mut x1206: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1205, &mut x1206, x1204, x1135, x1181);
  let mut x1207: u32 = 0;
  let mut x1208: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1207, &mut x1208, x1206, x1137, x1183);
  let mut x1209: u32 = 0;
  let mut x1210: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1209, &mut x1210, x1208, x1139, x1185);
  let mut x1211: u32 = 0;
  let mut x1212: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1211, &mut x1212, x1187, 0xe88fdc45);
  let mut x1213: u32 = 0;
  let mut x1214: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1213, &mut x1214, x1211, 0xffffffff);
  let mut x1215: u32 = 0;
  let mut x1216: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1215, &mut x1216, x1211, 0xffffffff);
  let mut x1217: u32 = 0;
  let mut x1218: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1217, &mut x1218, x1211, 0xffffffff);
  let mut x1219: u32 = 0;
  let mut x1220: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1219, &mut x1220, x1211, 0xffffffff);
  let mut x1221: u32 = 0;
  let mut x1222: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1221, &mut x1222, x1211, 0xffffffff);
  let mut x1223: u32 = 0;
  let mut x1224: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1223, &mut x1224, x1211, 0xffffffff);
  let mut x1225: u32 = 0;
  let mut x1226: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1225, &mut x1226, x1211, 0xc7634d81);
  let mut x1227: u32 = 0;
  let mut x1228: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1227, &mut x1228, x1211, 0xf4372ddf);
  let mut x1229: u32 = 0;
  let mut x1230: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1229, &mut x1230, x1211, 0x581a0db2);
  let mut x1231: u32 = 0;
  let mut x1232: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1231, &mut x1232, x1211, 0x48b0a77a);
  let mut x1233: u32 = 0;
  let mut x1234: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1233, &mut x1234, x1211, 0xecec196a);
  let mut x1235: u32 = 0;
  let mut x1236: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1235, &mut x1236, x1211, 0xccc52973);
  let mut x1237: u32 = 0;
  let mut x1238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1237, &mut x1238, 0x0, x1236, x1233);
  let mut x1239: u32 = 0;
  let mut x1240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1239, &mut x1240, x1238, x1234, x1231);
  let mut x1241: u32 = 0;
  let mut x1242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1241, &mut x1242, x1240, x1232, x1229);
  let mut x1243: u32 = 0;
  let mut x1244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1243, &mut x1244, x1242, x1230, x1227);
  let mut x1245: u32 = 0;
  let mut x1246: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1245, &mut x1246, x1244, x1228, x1225);
  let mut x1247: u32 = 0;
  let mut x1248: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1247, &mut x1248, x1246, x1226, x1223);
  let mut x1249: u32 = 0;
  let mut x1250: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1249, &mut x1250, x1248, x1224, x1221);
  let mut x1251: u32 = 0;
  let mut x1252: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1251, &mut x1252, x1250, x1222, x1219);
  let mut x1253: u32 = 0;
  let mut x1254: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1253, &mut x1254, x1252, x1220, x1217);
  let mut x1255: u32 = 0;
  let mut x1256: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1255, &mut x1256, x1254, x1218, x1215);
  let mut x1257: u32 = 0;
  let mut x1258: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1257, &mut x1258, x1256, x1216, x1213);
  let mut x1259: u32 = 0;
  let mut x1260: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1259, &mut x1260, 0x0, x1187, x1235);
  let mut x1261: u32 = 0;
  let mut x1262: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1261, &mut x1262, x1260, x1189, x1237);
  let mut x1263: u32 = 0;
  let mut x1264: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1263, &mut x1264, x1262, x1191, x1239);
  let mut x1265: u32 = 0;
  let mut x1266: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1265, &mut x1266, x1264, x1193, x1241);
  let mut x1267: u32 = 0;
  let mut x1268: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1267, &mut x1268, x1266, x1195, x1243);
  let mut x1269: u32 = 0;
  let mut x1270: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1269, &mut x1270, x1268, x1197, x1245);
  let mut x1271: u32 = 0;
  let mut x1272: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1271, &mut x1272, x1270, x1199, x1247);
  let mut x1273: u32 = 0;
  let mut x1274: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1273, &mut x1274, x1272, x1201, x1249);
  let mut x1275: u32 = 0;
  let mut x1276: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1275, &mut x1276, x1274, x1203, x1251);
  let mut x1277: u32 = 0;
  let mut x1278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1277, &mut x1278, x1276, x1205, x1253);
  let mut x1279: u32 = 0;
  let mut x1280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1279, &mut x1280, x1278, x1207, x1255);
  let mut x1281: u32 = 0;
  let mut x1282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1281, &mut x1282, x1280, x1209, x1257);
  let mut x1283: u32 = 0;
  let mut x1284: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1283, &mut x1284, x1282, (((x1210 as u32) + (x1140 as u32)) + ((x1186 as u32) + x1142)), ((x1258 as u32) + x1214));
  let mut x1285: u32 = 0;
  let mut x1286: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1285, &mut x1286, x9, 0xc84ee01);
  let mut x1287: u32 = 0;
  let mut x1288: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1287, &mut x1288, x9, 0x2b39bf21);
  let mut x1289: u32 = 0;
  let mut x1290: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1289, &mut x1290, x9, 0x3fb05b7a);
  let mut x1291: u32 = 0;
  let mut x1292: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1291, &mut x1292, x9, 0x28266895);
  let mut x1293: u32 = 0;
  let mut x1294: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1293, &mut x1294, x9, 0xd40d4917);
  let mut x1295: u32 = 0;
  let mut x1296: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1295, &mut x1296, x9, 0x4aab1cc5);
  let mut x1297: u32 = 0;
  let mut x1298: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1297, &mut x1298, x9, 0xbc3e483a);
  let mut x1299: u32 = 0;
  let mut x1300: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1299, &mut x1300, x9, 0xfcb82947);
  let mut x1301: u32 = 0;
  let mut x1302: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1301, &mut x1302, x9, 0xff3d81e5);
  let mut x1303: u32 = 0;
  let mut x1304: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1303, &mut x1304, x9, 0xdf1aa419);
  let mut x1305: u32 = 0;
  let mut x1306: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1305, &mut x1306, x9, 0x2d319b24);
  let mut x1307: u32 = 0;
  let mut x1308: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1307, &mut x1308, x9, 0x19b409a9);
  let mut x1309: u32 = 0;
  let mut x1310: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1309, &mut x1310, 0x0, x1308, x1305);
  let mut x1311: u32 = 0;
  let mut x1312: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1311, &mut x1312, x1310, x1306, x1303);
  let mut x1313: u32 = 0;
  let mut x1314: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1313, &mut x1314, x1312, x1304, x1301);
  let mut x1315: u32 = 0;
  let mut x1316: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1315, &mut x1316, x1314, x1302, x1299);
  let mut x1317: u32 = 0;
  let mut x1318: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1317, &mut x1318, x1316, x1300, x1297);
  let mut x1319: u32 = 0;
  let mut x1320: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1319, &mut x1320, x1318, x1298, x1295);
  let mut x1321: u32 = 0;
  let mut x1322: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1321, &mut x1322, x1320, x1296, x1293);
  let mut x1323: u32 = 0;
  let mut x1324: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1323, &mut x1324, x1322, x1294, x1291);
  let mut x1325: u32 = 0;
  let mut x1326: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1325, &mut x1326, x1324, x1292, x1289);
  let mut x1327: u32 = 0;
  let mut x1328: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1327, &mut x1328, x1326, x1290, x1287);
  let mut x1329: u32 = 0;
  let mut x1330: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1329, &mut x1330, x1328, x1288, x1285);
  let mut x1331: u32 = 0;
  let mut x1332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1331, &mut x1332, 0x0, x1261, x1307);
  let mut x1333: u32 = 0;
  let mut x1334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1333, &mut x1334, x1332, x1263, x1309);
  let mut x1335: u32 = 0;
  let mut x1336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1335, &mut x1336, x1334, x1265, x1311);
  let mut x1337: u32 = 0;
  let mut x1338: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1337, &mut x1338, x1336, x1267, x1313);
  let mut x1339: u32 = 0;
  let mut x1340: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1339, &mut x1340, x1338, x1269, x1315);
  let mut x1341: u32 = 0;
  let mut x1342: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1341, &mut x1342, x1340, x1271, x1317);
  let mut x1343: u32 = 0;
  let mut x1344: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1343, &mut x1344, x1342, x1273, x1319);
  let mut x1345: u32 = 0;
  let mut x1346: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1345, &mut x1346, x1344, x1275, x1321);
  let mut x1347: u32 = 0;
  let mut x1348: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1347, &mut x1348, x1346, x1277, x1323);
  let mut x1349: u32 = 0;
  let mut x1350: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1349, &mut x1350, x1348, x1279, x1325);
  let mut x1351: u32 = 0;
  let mut x1352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1351, &mut x1352, x1350, x1281, x1327);
  let mut x1353: u32 = 0;
  let mut x1354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1353, &mut x1354, x1352, x1283, x1329);
  let mut x1355: u32 = 0;
  let mut x1356: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1355, &mut x1356, x1331, 0xe88fdc45);
  let mut x1357: u32 = 0;
  let mut x1358: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1357, &mut x1358, x1355, 0xffffffff);
  let mut x1359: u32 = 0;
  let mut x1360: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1359, &mut x1360, x1355, 0xffffffff);
  let mut x1361: u32 = 0;
  let mut x1362: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1361, &mut x1362, x1355, 0xffffffff);
  let mut x1363: u32 = 0;
  let mut x1364: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1363, &mut x1364, x1355, 0xffffffff);
  let mut x1365: u32 = 0;
  let mut x1366: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1365, &mut x1366, x1355, 0xffffffff);
  let mut x1367: u32 = 0;
  let mut x1368: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1367, &mut x1368, x1355, 0xffffffff);
  let mut x1369: u32 = 0;
  let mut x1370: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1369, &mut x1370, x1355, 0xc7634d81);
  let mut x1371: u32 = 0;
  let mut x1372: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1371, &mut x1372, x1355, 0xf4372ddf);
  let mut x1373: u32 = 0;
  let mut x1374: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1373, &mut x1374, x1355, 0x581a0db2);
  let mut x1375: u32 = 0;
  let mut x1376: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1375, &mut x1376, x1355, 0x48b0a77a);
  let mut x1377: u32 = 0;
  let mut x1378: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1377, &mut x1378, x1355, 0xecec196a);
  let mut x1379: u32 = 0;
  let mut x1380: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1379, &mut x1380, x1355, 0xccc52973);
  let mut x1381: u32 = 0;
  let mut x1382: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1381, &mut x1382, 0x0, x1380, x1377);
  let mut x1383: u32 = 0;
  let mut x1384: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1383, &mut x1384, x1382, x1378, x1375);
  let mut x1385: u32 = 0;
  let mut x1386: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1385, &mut x1386, x1384, x1376, x1373);
  let mut x1387: u32 = 0;
  let mut x1388: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1387, &mut x1388, x1386, x1374, x1371);
  let mut x1389: u32 = 0;
  let mut x1390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1389, &mut x1390, x1388, x1372, x1369);
  let mut x1391: u32 = 0;
  let mut x1392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1391, &mut x1392, x1390, x1370, x1367);
  let mut x1393: u32 = 0;
  let mut x1394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1393, &mut x1394, x1392, x1368, x1365);
  let mut x1395: u32 = 0;
  let mut x1396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1395, &mut x1396, x1394, x1366, x1363);
  let mut x1397: u32 = 0;
  let mut x1398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1397, &mut x1398, x1396, x1364, x1361);
  let mut x1399: u32 = 0;
  let mut x1400: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1399, &mut x1400, x1398, x1362, x1359);
  let mut x1401: u32 = 0;
  let mut x1402: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1401, &mut x1402, x1400, x1360, x1357);
  let mut x1403: u32 = 0;
  let mut x1404: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1403, &mut x1404, 0x0, x1331, x1379);
  let mut x1405: u32 = 0;
  let mut x1406: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1405, &mut x1406, x1404, x1333, x1381);
  let mut x1407: u32 = 0;
  let mut x1408: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1407, &mut x1408, x1406, x1335, x1383);
  let mut x1409: u32 = 0;
  let mut x1410: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1409, &mut x1410, x1408, x1337, x1385);
  let mut x1411: u32 = 0;
  let mut x1412: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1411, &mut x1412, x1410, x1339, x1387);
  let mut x1413: u32 = 0;
  let mut x1414: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1413, &mut x1414, x1412, x1341, x1389);
  let mut x1415: u32 = 0;
  let mut x1416: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1415, &mut x1416, x1414, x1343, x1391);
  let mut x1417: u32 = 0;
  let mut x1418: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1417, &mut x1418, x1416, x1345, x1393);
  let mut x1419: u32 = 0;
  let mut x1420: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1419, &mut x1420, x1418, x1347, x1395);
  let mut x1421: u32 = 0;
  let mut x1422: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1421, &mut x1422, x1420, x1349, x1397);
  let mut x1423: u32 = 0;
  let mut x1424: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1423, &mut x1424, x1422, x1351, x1399);
  let mut x1425: u32 = 0;
  let mut x1426: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1425, &mut x1426, x1424, x1353, x1401);
  let mut x1427: u32 = 0;
  let mut x1428: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1427, &mut x1428, x1426, (((x1354 as u32) + (x1284 as u32)) + ((x1330 as u32) + x1286)), ((x1402 as u32) + x1358));
  let mut x1429: u32 = 0;
  let mut x1430: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1429, &mut x1430, x10, 0xc84ee01);
  let mut x1431: u32 = 0;
  let mut x1432: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1431, &mut x1432, x10, 0x2b39bf21);
  let mut x1433: u32 = 0;
  let mut x1434: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1433, &mut x1434, x10, 0x3fb05b7a);
  let mut x1435: u32 = 0;
  let mut x1436: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1435, &mut x1436, x10, 0x28266895);
  let mut x1437: u32 = 0;
  let mut x1438: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1437, &mut x1438, x10, 0xd40d4917);
  let mut x1439: u32 = 0;
  let mut x1440: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1439, &mut x1440, x10, 0x4aab1cc5);
  let mut x1441: u32 = 0;
  let mut x1442: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1441, &mut x1442, x10, 0xbc3e483a);
  let mut x1443: u32 = 0;
  let mut x1444: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1443, &mut x1444, x10, 0xfcb82947);
  let mut x1445: u32 = 0;
  let mut x1446: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1445, &mut x1446, x10, 0xff3d81e5);
  let mut x1447: u32 = 0;
  let mut x1448: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1447, &mut x1448, x10, 0xdf1aa419);
  let mut x1449: u32 = 0;
  let mut x1450: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1449, &mut x1450, x10, 0x2d319b24);
  let mut x1451: u32 = 0;
  let mut x1452: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1451, &mut x1452, x10, 0x19b409a9);
  let mut x1453: u32 = 0;
  let mut x1454: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1453, &mut x1454, 0x0, x1452, x1449);
  let mut x1455: u32 = 0;
  let mut x1456: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1455, &mut x1456, x1454, x1450, x1447);
  let mut x1457: u32 = 0;
  let mut x1458: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1457, &mut x1458, x1456, x1448, x1445);
  let mut x1459: u32 = 0;
  let mut x1460: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1459, &mut x1460, x1458, x1446, x1443);
  let mut x1461: u32 = 0;
  let mut x1462: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1461, &mut x1462, x1460, x1444, x1441);
  let mut x1463: u32 = 0;
  let mut x1464: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1463, &mut x1464, x1462, x1442, x1439);
  let mut x1465: u32 = 0;
  let mut x1466: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1465, &mut x1466, x1464, x1440, x1437);
  let mut x1467: u32 = 0;
  let mut x1468: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1467, &mut x1468, x1466, x1438, x1435);
  let mut x1469: u32 = 0;
  let mut x1470: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1469, &mut x1470, x1468, x1436, x1433);
  let mut x1471: u32 = 0;
  let mut x1472: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1471, &mut x1472, x1470, x1434, x1431);
  let mut x1473: u32 = 0;
  let mut x1474: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1473, &mut x1474, x1472, x1432, x1429);
  let mut x1475: u32 = 0;
  let mut x1476: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1475, &mut x1476, 0x0, x1405, x1451);
  let mut x1477: u32 = 0;
  let mut x1478: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1477, &mut x1478, x1476, x1407, x1453);
  let mut x1479: u32 = 0;
  let mut x1480: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1479, &mut x1480, x1478, x1409, x1455);
  let mut x1481: u32 = 0;
  let mut x1482: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1481, &mut x1482, x1480, x1411, x1457);
  let mut x1483: u32 = 0;
  let mut x1484: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1483, &mut x1484, x1482, x1413, x1459);
  let mut x1485: u32 = 0;
  let mut x1486: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1485, &mut x1486, x1484, x1415, x1461);
  let mut x1487: u32 = 0;
  let mut x1488: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1487, &mut x1488, x1486, x1417, x1463);
  let mut x1489: u32 = 0;
  let mut x1490: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1489, &mut x1490, x1488, x1419, x1465);
  let mut x1491: u32 = 0;
  let mut x1492: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1491, &mut x1492, x1490, x1421, x1467);
  let mut x1493: u32 = 0;
  let mut x1494: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1493, &mut x1494, x1492, x1423, x1469);
  let mut x1495: u32 = 0;
  let mut x1496: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1495, &mut x1496, x1494, x1425, x1471);
  let mut x1497: u32 = 0;
  let mut x1498: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1497, &mut x1498, x1496, x1427, x1473);
  let mut x1499: u32 = 0;
  let mut x1500: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1499, &mut x1500, x1475, 0xe88fdc45);
  let mut x1501: u32 = 0;
  let mut x1502: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1501, &mut x1502, x1499, 0xffffffff);
  let mut x1503: u32 = 0;
  let mut x1504: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1503, &mut x1504, x1499, 0xffffffff);
  let mut x1505: u32 = 0;
  let mut x1506: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1505, &mut x1506, x1499, 0xffffffff);
  let mut x1507: u32 = 0;
  let mut x1508: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1507, &mut x1508, x1499, 0xffffffff);
  let mut x1509: u32 = 0;
  let mut x1510: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1509, &mut x1510, x1499, 0xffffffff);
  let mut x1511: u32 = 0;
  let mut x1512: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1511, &mut x1512, x1499, 0xffffffff);
  let mut x1513: u32 = 0;
  let mut x1514: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1513, &mut x1514, x1499, 0xc7634d81);
  let mut x1515: u32 = 0;
  let mut x1516: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1515, &mut x1516, x1499, 0xf4372ddf);
  let mut x1517: u32 = 0;
  let mut x1518: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1517, &mut x1518, x1499, 0x581a0db2);
  let mut x1519: u32 = 0;
  let mut x1520: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1519, &mut x1520, x1499, 0x48b0a77a);
  let mut x1521: u32 = 0;
  let mut x1522: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1521, &mut x1522, x1499, 0xecec196a);
  let mut x1523: u32 = 0;
  let mut x1524: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1523, &mut x1524, x1499, 0xccc52973);
  let mut x1525: u32 = 0;
  let mut x1526: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1525, &mut x1526, 0x0, x1524, x1521);
  let mut x1527: u32 = 0;
  let mut x1528: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1527, &mut x1528, x1526, x1522, x1519);
  let mut x1529: u32 = 0;
  let mut x1530: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1529, &mut x1530, x1528, x1520, x1517);
  let mut x1531: u32 = 0;
  let mut x1532: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1531, &mut x1532, x1530, x1518, x1515);
  let mut x1533: u32 = 0;
  let mut x1534: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1533, &mut x1534, x1532, x1516, x1513);
  let mut x1535: u32 = 0;
  let mut x1536: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1535, &mut x1536, x1534, x1514, x1511);
  let mut x1537: u32 = 0;
  let mut x1538: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1537, &mut x1538, x1536, x1512, x1509);
  let mut x1539: u32 = 0;
  let mut x1540: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1539, &mut x1540, x1538, x1510, x1507);
  let mut x1541: u32 = 0;
  let mut x1542: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1541, &mut x1542, x1540, x1508, x1505);
  let mut x1543: u32 = 0;
  let mut x1544: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1543, &mut x1544, x1542, x1506, x1503);
  let mut x1545: u32 = 0;
  let mut x1546: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1545, &mut x1546, x1544, x1504, x1501);
  let mut x1547: u32 = 0;
  let mut x1548: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1547, &mut x1548, 0x0, x1475, x1523);
  let mut x1549: u32 = 0;
  let mut x1550: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1549, &mut x1550, x1548, x1477, x1525);
  let mut x1551: u32 = 0;
  let mut x1552: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1551, &mut x1552, x1550, x1479, x1527);
  let mut x1553: u32 = 0;
  let mut x1554: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1553, &mut x1554, x1552, x1481, x1529);
  let mut x1555: u32 = 0;
  let mut x1556: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1555, &mut x1556, x1554, x1483, x1531);
  let mut x1557: u32 = 0;
  let mut x1558: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1557, &mut x1558, x1556, x1485, x1533);
  let mut x1559: u32 = 0;
  let mut x1560: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1559, &mut x1560, x1558, x1487, x1535);
  let mut x1561: u32 = 0;
  let mut x1562: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1561, &mut x1562, x1560, x1489, x1537);
  let mut x1563: u32 = 0;
  let mut x1564: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1563, &mut x1564, x1562, x1491, x1539);
  let mut x1565: u32 = 0;
  let mut x1566: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1565, &mut x1566, x1564, x1493, x1541);
  let mut x1567: u32 = 0;
  let mut x1568: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1567, &mut x1568, x1566, x1495, x1543);
  let mut x1569: u32 = 0;
  let mut x1570: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1569, &mut x1570, x1568, x1497, x1545);
  let mut x1571: u32 = 0;
  let mut x1572: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1571, &mut x1572, x1570, (((x1498 as u32) + (x1428 as u32)) + ((x1474 as u32) + x1430)), ((x1546 as u32) + x1502));
  let mut x1573: u32 = 0;
  let mut x1574: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1573, &mut x1574, x11, 0xc84ee01);
  let mut x1575: u32 = 0;
  let mut x1576: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1575, &mut x1576, x11, 0x2b39bf21);
  let mut x1577: u32 = 0;
  let mut x1578: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1577, &mut x1578, x11, 0x3fb05b7a);
  let mut x1579: u32 = 0;
  let mut x1580: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1579, &mut x1580, x11, 0x28266895);
  let mut x1581: u32 = 0;
  let mut x1582: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1581, &mut x1582, x11, 0xd40d4917);
  let mut x1583: u32 = 0;
  let mut x1584: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1583, &mut x1584, x11, 0x4aab1cc5);
  let mut x1585: u32 = 0;
  let mut x1586: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1585, &mut x1586, x11, 0xbc3e483a);
  let mut x1587: u32 = 0;
  let mut x1588: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1587, &mut x1588, x11, 0xfcb82947);
  let mut x1589: u32 = 0;
  let mut x1590: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1589, &mut x1590, x11, 0xff3d81e5);
  let mut x1591: u32 = 0;
  let mut x1592: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1591, &mut x1592, x11, 0xdf1aa419);
  let mut x1593: u32 = 0;
  let mut x1594: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1593, &mut x1594, x11, 0x2d319b24);
  let mut x1595: u32 = 0;
  let mut x1596: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1595, &mut x1596, x11, 0x19b409a9);
  let mut x1597: u32 = 0;
  let mut x1598: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1597, &mut x1598, 0x0, x1596, x1593);
  let mut x1599: u32 = 0;
  let mut x1600: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1599, &mut x1600, x1598, x1594, x1591);
  let mut x1601: u32 = 0;
  let mut x1602: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1601, &mut x1602, x1600, x1592, x1589);
  let mut x1603: u32 = 0;
  let mut x1604: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1603, &mut x1604, x1602, x1590, x1587);
  let mut x1605: u32 = 0;
  let mut x1606: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1605, &mut x1606, x1604, x1588, x1585);
  let mut x1607: u32 = 0;
  let mut x1608: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1607, &mut x1608, x1606, x1586, x1583);
  let mut x1609: u32 = 0;
  let mut x1610: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1609, &mut x1610, x1608, x1584, x1581);
  let mut x1611: u32 = 0;
  let mut x1612: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1611, &mut x1612, x1610, x1582, x1579);
  let mut x1613: u32 = 0;
  let mut x1614: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1613, &mut x1614, x1612, x1580, x1577);
  let mut x1615: u32 = 0;
  let mut x1616: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1615, &mut x1616, x1614, x1578, x1575);
  let mut x1617: u32 = 0;
  let mut x1618: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1617, &mut x1618, x1616, x1576, x1573);
  let mut x1619: u32 = 0;
  let mut x1620: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1619, &mut x1620, 0x0, x1549, x1595);
  let mut x1621: u32 = 0;
  let mut x1622: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1621, &mut x1622, x1620, x1551, x1597);
  let mut x1623: u32 = 0;
  let mut x1624: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1623, &mut x1624, x1622, x1553, x1599);
  let mut x1625: u32 = 0;
  let mut x1626: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1625, &mut x1626, x1624, x1555, x1601);
  let mut x1627: u32 = 0;
  let mut x1628: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1627, &mut x1628, x1626, x1557, x1603);
  let mut x1629: u32 = 0;
  let mut x1630: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1629, &mut x1630, x1628, x1559, x1605);
  let mut x1631: u32 = 0;
  let mut x1632: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1631, &mut x1632, x1630, x1561, x1607);
  let mut x1633: u32 = 0;
  let mut x1634: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1633, &mut x1634, x1632, x1563, x1609);
  let mut x1635: u32 = 0;
  let mut x1636: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1635, &mut x1636, x1634, x1565, x1611);
  let mut x1637: u32 = 0;
  let mut x1638: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1637, &mut x1638, x1636, x1567, x1613);
  let mut x1639: u32 = 0;
  let mut x1640: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1639, &mut x1640, x1638, x1569, x1615);
  let mut x1641: u32 = 0;
  let mut x1642: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1641, &mut x1642, x1640, x1571, x1617);
  let mut x1643: u32 = 0;
  let mut x1644: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1643, &mut x1644, x1619, 0xe88fdc45);
  let mut x1645: u32 = 0;
  let mut x1646: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1645, &mut x1646, x1643, 0xffffffff);
  let mut x1647: u32 = 0;
  let mut x1648: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1647, &mut x1648, x1643, 0xffffffff);
  let mut x1649: u32 = 0;
  let mut x1650: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1649, &mut x1650, x1643, 0xffffffff);
  let mut x1651: u32 = 0;
  let mut x1652: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1651, &mut x1652, x1643, 0xffffffff);
  let mut x1653: u32 = 0;
  let mut x1654: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1653, &mut x1654, x1643, 0xffffffff);
  let mut x1655: u32 = 0;
  let mut x1656: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1655, &mut x1656, x1643, 0xffffffff);
  let mut x1657: u32 = 0;
  let mut x1658: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1657, &mut x1658, x1643, 0xc7634d81);
  let mut x1659: u32 = 0;
  let mut x1660: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1659, &mut x1660, x1643, 0xf4372ddf);
  let mut x1661: u32 = 0;
  let mut x1662: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1661, &mut x1662, x1643, 0x581a0db2);
  let mut x1663: u32 = 0;
  let mut x1664: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1663, &mut x1664, x1643, 0x48b0a77a);
  let mut x1665: u32 = 0;
  let mut x1666: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1665, &mut x1666, x1643, 0xecec196a);
  let mut x1667: u32 = 0;
  let mut x1668: u32 = 0;
  fiat_p384_scalar_mulx_u32(&mut x1667, &mut x1668, x1643, 0xccc52973);
  let mut x1669: u32 = 0;
  let mut x1670: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1669, &mut x1670, 0x0, x1668, x1665);
  let mut x1671: u32 = 0;
  let mut x1672: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1671, &mut x1672, x1670, x1666, x1663);
  let mut x1673: u32 = 0;
  let mut x1674: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1673, &mut x1674, x1672, x1664, x1661);
  let mut x1675: u32 = 0;
  let mut x1676: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1675, &mut x1676, x1674, x1662, x1659);
  let mut x1677: u32 = 0;
  let mut x1678: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1677, &mut x1678, x1676, x1660, x1657);
  let mut x1679: u32 = 0;
  let mut x1680: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1679, &mut x1680, x1678, x1658, x1655);
  let mut x1681: u32 = 0;
  let mut x1682: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1681, &mut x1682, x1680, x1656, x1653);
  let mut x1683: u32 = 0;
  let mut x1684: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1683, &mut x1684, x1682, x1654, x1651);
  let mut x1685: u32 = 0;
  let mut x1686: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1685, &mut x1686, x1684, x1652, x1649);
  let mut x1687: u32 = 0;
  let mut x1688: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1687, &mut x1688, x1686, x1650, x1647);
  let mut x1689: u32 = 0;
  let mut x1690: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1689, &mut x1690, x1688, x1648, x1645);
  let mut x1691: u32 = 0;
  let mut x1692: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1691, &mut x1692, 0x0, x1619, x1667);
  let mut x1693: u32 = 0;
  let mut x1694: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1693, &mut x1694, x1692, x1621, x1669);
  let mut x1695: u32 = 0;
  let mut x1696: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1695, &mut x1696, x1694, x1623, x1671);
  let mut x1697: u32 = 0;
  let mut x1698: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1697, &mut x1698, x1696, x1625, x1673);
  let mut x1699: u32 = 0;
  let mut x1700: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1699, &mut x1700, x1698, x1627, x1675);
  let mut x1701: u32 = 0;
  let mut x1702: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1701, &mut x1702, x1700, x1629, x1677);
  let mut x1703: u32 = 0;
  let mut x1704: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1703, &mut x1704, x1702, x1631, x1679);
  let mut x1705: u32 = 0;
  let mut x1706: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1705, &mut x1706, x1704, x1633, x1681);
  let mut x1707: u32 = 0;
  let mut x1708: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1707, &mut x1708, x1706, x1635, x1683);
  let mut x1709: u32 = 0;
  let mut x1710: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1709, &mut x1710, x1708, x1637, x1685);
  let mut x1711: u32 = 0;
  let mut x1712: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1711, &mut x1712, x1710, x1639, x1687);
  let mut x1713: u32 = 0;
  let mut x1714: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1713, &mut x1714, x1712, x1641, x1689);
  let mut x1715: u32 = 0;
  let mut x1716: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1715, &mut x1716, x1714, (((x1642 as u32) + (x1572 as u32)) + ((x1618 as u32) + x1574)), ((x1690 as u32) + x1646));
  let mut x1717: u32 = 0;
  let mut x1718: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1717, &mut x1718, 0x0, x1693, 0xccc52973);
  let mut x1719: u32 = 0;
  let mut x1720: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1719, &mut x1720, x1718, x1695, 0xecec196a);
  let mut x1721: u32 = 0;
  let mut x1722: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1721, &mut x1722, x1720, x1697, 0x48b0a77a);
  let mut x1723: u32 = 0;
  let mut x1724: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1723, &mut x1724, x1722, x1699, 0x581a0db2);
  let mut x1725: u32 = 0;
  let mut x1726: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1725, &mut x1726, x1724, x1701, 0xf4372ddf);
  let mut x1727: u32 = 0;
  let mut x1728: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1727, &mut x1728, x1726, x1703, 0xc7634d81);
  let mut x1729: u32 = 0;
  let mut x1730: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1729, &mut x1730, x1728, x1705, 0xffffffff);
  let mut x1731: u32 = 0;
  let mut x1732: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1731, &mut x1732, x1730, x1707, 0xffffffff);
  let mut x1733: u32 = 0;
  let mut x1734: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1733, &mut x1734, x1732, x1709, 0xffffffff);
  let mut x1735: u32 = 0;
  let mut x1736: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1735, &mut x1736, x1734, x1711, 0xffffffff);
  let mut x1737: u32 = 0;
  let mut x1738: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1737, &mut x1738, x1736, x1713, 0xffffffff);
  let mut x1739: u32 = 0;
  let mut x1740: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1739, &mut x1740, x1738, x1715, 0xffffffff);
  let mut x1741: u32 = 0;
  let mut x1742: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x1741, &mut x1742, x1740, (x1716 as u32), (0x0 as u32));
  let mut x1743: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1743, x1742, x1717, x1693);
  let mut x1744: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1744, x1742, x1719, x1695);
  let mut x1745: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1745, x1742, x1721, x1697);
  let mut x1746: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1746, x1742, x1723, x1699);
  let mut x1747: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1747, x1742, x1725, x1701);
  let mut x1748: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1748, x1742, x1727, x1703);
  let mut x1749: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1749, x1742, x1729, x1705);
  let mut x1750: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1750, x1742, x1731, x1707);
  let mut x1751: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1751, x1742, x1733, x1709);
  let mut x1752: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1752, x1742, x1735, x1711);
  let mut x1753: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1753, x1742, x1737, x1713);
  let mut x1754: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1754, x1742, x1739, x1715);
  out1[0] = x1743;
  out1[1] = x1744;
  out1[2] = x1745;
  out1[3] = x1746;
  out1[4] = x1747;
  out1[5] = x1748;
  out1[6] = x1749;
  out1[7] = x1750;
  out1[8] = x1751;
  out1[9] = x1752;
  out1[10] = x1753;
  out1[11] = x1754;
}

/// The function fiat_p384_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p384_scalar_nonzero(out1: &mut u32, arg1: &[u32; 12]) {
  let x1: u32 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
  *out1 = x1;
}

/// The function fiat_p384_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_scalar_selectznz(out1: &mut [u32; 12], arg1: fiat_p384_scalar_u1, arg2: &[u32; 12], arg3: &[u32; 12]) {
  let mut x1: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x9, arg1, (arg2[8]), (arg3[8]));
  let mut x10: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x10, arg1, (arg2[9]), (arg3[9]));
  let mut x11: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x11, arg1, (arg2[10]), (arg3[10]));
  let mut x12: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x12, arg1, (arg2[11]), (arg3[11]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
}

/// The function fiat_p384_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p384_scalar_to_bytes(out1: &mut [u8; 48], arg1: &[u32; 12]) {
  let x1: u32 = (arg1[11]);
  let x2: u32 = (arg1[10]);
  let x3: u32 = (arg1[9]);
  let x4: u32 = (arg1[8]);
  let x5: u32 = (arg1[7]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[5]);
  let x8: u32 = (arg1[4]);
  let x9: u32 = (arg1[3]);
  let x10: u32 = (arg1[2]);
  let x11: u32 = (arg1[1]);
  let x12: u32 = (arg1[0]);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u32 = (x12 >> 8);
  let x15: u8 = ((x14 & (0xff as u32)) as u8);
  let x16: u32 = (x14 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u8 = ((x16 >> 8) as u8);
  let x19: u8 = ((x11 & (0xff as u32)) as u8);
  let x20: u32 = (x11 >> 8);
  let x21: u8 = ((x20 & (0xff as u32)) as u8);
  let x22: u32 = (x20 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u8 = ((x22 >> 8) as u8);
  let x25: u8 = ((x10 & (0xff as u32)) as u8);
  let x26: u32 = (x10 >> 8);
  let x27: u8 = ((x26 & (0xff as u32)) as u8);
  let x28: u32 = (x26 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u8 = ((x28 >> 8) as u8);
  let x31: u8 = ((x9 & (0xff as u32)) as u8);
  let x32: u32 = (x9 >> 8);
  let x33: u8 = ((x32 & (0xff as u32)) as u8);
  let x34: u32 = (x32 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u8 = ((x34 >> 8) as u8);
  let x37: u8 = ((x8 & (0xff as u32)) as u8);
  let x38: u32 = (x8 >> 8);
  let x39: u8 = ((x38 & (0xff as u32)) as u8);
  let x40: u32 = (x38 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u8 = ((x40 >> 8) as u8);
  let x43: u8 = ((x7 & (0xff as u32)) as u8);
  let x44: u32 = (x7 >> 8);
  let x45: u8 = ((x44 & (0xff as u32)) as u8);
  let x46: u32 = (x44 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u8 = ((x46 >> 8) as u8);
  let x49: u8 = ((x6 & (0xff as u32)) as u8);
  let x50: u32 = (x6 >> 8);
  let x51: u8 = ((x50 & (0xff as u32)) as u8);
  let x52: u32 = (x50 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u8 = ((x52 >> 8) as u8);
  let x55: u8 = ((x5 & (0xff as u32)) as u8);
  let x56: u32 = (x5 >> 8);
  let x57: u8 = ((x56 & (0xff as u32)) as u8);
  let x58: u32 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u32)) as u8);
  let x60: u8 = ((x58 >> 8) as u8);
  let x61: u8 = ((x4 & (0xff as u32)) as u8);
  let x62: u32 = (x4 >> 8);
  let x63: u8 = ((x62 & (0xff as u32)) as u8);
  let x64: u32 = (x62 >> 8);
  let x65: u8 = ((x64 & (0xff as u32)) as u8);
  let x66: u8 = ((x64 >> 8) as u8);
  let x67: u8 = ((x3 & (0xff as u32)) as u8);
  let x68: u32 = (x3 >> 8);
  let x69: u8 = ((x68 & (0xff as u32)) as u8);
  let x70: u32 = (x68 >> 8);
  let x71: u8 = ((x70 & (0xff as u32)) as u8);
  let x72: u8 = ((x70 >> 8) as u8);
  let x73: u8 = ((x2 & (0xff as u32)) as u8);
  let x74: u32 = (x2 >> 8);
  let x75: u8 = ((x74 & (0xff as u32)) as u8);
  let x76: u32 = (x74 >> 8);
  let x77: u8 = ((x76 & (0xff as u32)) as u8);
  let x78: u8 = ((x76 >> 8) as u8);
  let x79: u8 = ((x1 & (0xff as u32)) as u8);
  let x80: u32 = (x1 >> 8);
  let x81: u8 = ((x80 & (0xff as u32)) as u8);
  let x82: u32 = (x80 >> 8);
  let x83: u8 = ((x82 & (0xff as u32)) as u8);
  let x84: u8 = ((x82 >> 8) as u8);
  out1[0] = x13;
  out1[1] = x15;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x21;
  out1[6] = x23;
  out1[7] = x24;
  out1[8] = x25;
  out1[9] = x27;
  out1[10] = x29;
  out1[11] = x30;
  out1[12] = x31;
  out1[13] = x33;
  out1[14] = x35;
  out1[15] = x36;
  out1[16] = x37;
  out1[17] = x39;
  out1[18] = x41;
  out1[19] = x42;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x54;
  out1[28] = x55;
  out1[29] = x57;
  out1[30] = x59;
  out1[31] = x60;
  out1[32] = x61;
  out1[33] = x63;
  out1[34] = x65;
  out1[35] = x66;
  out1[36] = x67;
  out1[37] = x69;
  out1[38] = x71;
  out1[39] = x72;
  out1[40] = x73;
  out1[41] = x75;
  out1[42] = x77;
  out1[43] = x78;
  out1[44] = x79;
  out1[45] = x81;
  out1[46] = x83;
  out1[47] = x84;
}

/// The function fiat_p384_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_scalar_from_bytes(out1: &mut [u32; 12], arg1: &[u8; 48]) {
  let x1: u32 = (((arg1[47]) as u32) << 24);
  let x2: u32 = (((arg1[46]) as u32) << 16);
  let x3: u32 = (((arg1[45]) as u32) << 8);
  let x4: u8 = (arg1[44]);
  let x5: u32 = (((arg1[43]) as u32) << 24);
  let x6: u32 = (((arg1[42]) as u32) << 16);
  let x7: u32 = (((arg1[41]) as u32) << 8);
  let x8: u8 = (arg1[40]);
  let x9: u32 = (((arg1[39]) as u32) << 24);
  let x10: u32 = (((arg1[38]) as u32) << 16);
  let x11: u32 = (((arg1[37]) as u32) << 8);
  let x12: u8 = (arg1[36]);
  let x13: u32 = (((arg1[35]) as u32) << 24);
  let x14: u32 = (((arg1[34]) as u32) << 16);
  let x15: u32 = (((arg1[33]) as u32) << 8);
  let x16: u8 = (arg1[32]);
  let x17: u32 = (((arg1[31]) as u32) << 24);
  let x18: u32 = (((arg1[30]) as u32) << 16);
  let x19: u32 = (((arg1[29]) as u32) << 8);
  let x20: u8 = (arg1[28]);
  let x21: u32 = (((arg1[27]) as u32) << 24);
  let x22: u32 = (((arg1[26]) as u32) << 16);
  let x23: u32 = (((arg1[25]) as u32) << 8);
  let x24: u8 = (arg1[24]);
  let x25: u32 = (((arg1[23]) as u32) << 24);
  let x26: u32 = (((arg1[22]) as u32) << 16);
  let x27: u32 = (((arg1[21]) as u32) << 8);
  let x28: u8 = (arg1[20]);
  let x29: u32 = (((arg1[19]) as u32) << 24);
  let x30: u32 = (((arg1[18]) as u32) << 16);
  let x31: u32 = (((arg1[17]) as u32) << 8);
  let x32: u8 = (arg1[16]);
  let x33: u32 = (((arg1[15]) as u32) << 24);
  let x34: u32 = (((arg1[14]) as u32) << 16);
  let x35: u32 = (((arg1[13]) as u32) << 8);
  let x36: u8 = (arg1[12]);
  let x37: u32 = (((arg1[11]) as u32) << 24);
  let x38: u32 = (((arg1[10]) as u32) << 16);
  let x39: u32 = (((arg1[9]) as u32) << 8);
  let x40: u8 = (arg1[8]);
  let x41: u32 = (((arg1[7]) as u32) << 24);
  let x42: u32 = (((arg1[6]) as u32) << 16);
  let x43: u32 = (((arg1[5]) as u32) << 8);
  let x44: u8 = (arg1[4]);
  let x45: u32 = (((arg1[3]) as u32) << 24);
  let x46: u32 = (((arg1[2]) as u32) << 16);
  let x47: u32 = (((arg1[1]) as u32) << 8);
  let x48: u8 = (arg1[0]);
  let x49: u32 = (x47 + (x48 as u32));
  let x50: u32 = (x46 + x49);
  let x51: u32 = (x45 + x50);
  let x52: u32 = (x43 + (x44 as u32));
  let x53: u32 = (x42 + x52);
  let x54: u32 = (x41 + x53);
  let x55: u32 = (x39 + (x40 as u32));
  let x56: u32 = (x38 + x55);
  let x57: u32 = (x37 + x56);
  let x58: u32 = (x35 + (x36 as u32));
  let x59: u32 = (x34 + x58);
  let x60: u32 = (x33 + x59);
  let x61: u32 = (x31 + (x32 as u32));
  let x62: u32 = (x30 + x61);
  let x63: u32 = (x29 + x62);
  let x64: u32 = (x27 + (x28 as u32));
  let x65: u32 = (x26 + x64);
  let x66: u32 = (x25 + x65);
  let x67: u32 = (x23 + (x24 as u32));
  let x68: u32 = (x22 + x67);
  let x69: u32 = (x21 + x68);
  let x70: u32 = (x19 + (x20 as u32));
  let x71: u32 = (x18 + x70);
  let x72: u32 = (x17 + x71);
  let x73: u32 = (x15 + (x16 as u32));
  let x74: u32 = (x14 + x73);
  let x75: u32 = (x13 + x74);
  let x76: u32 = (x11 + (x12 as u32));
  let x77: u32 = (x10 + x76);
  let x78: u32 = (x9 + x77);
  let x79: u32 = (x7 + (x8 as u32));
  let x80: u32 = (x6 + x79);
  let x81: u32 = (x5 + x80);
  let x82: u32 = (x3 + (x4 as u32));
  let x83: u32 = (x2 + x82);
  let x84: u32 = (x1 + x83);
  out1[0] = x51;
  out1[1] = x54;
  out1[2] = x57;
  out1[3] = x60;
  out1[4] = x63;
  out1[5] = x66;
  out1[6] = x69;
  out1[7] = x72;
  out1[8] = x75;
  out1[9] = x78;
  out1[10] = x81;
  out1[11] = x84;
}

/// The function fiat_p384_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_set_one(out1: &mut fiat_p384_scalar_montgomery_domain_field_element) {
  out1[0] = 0x333ad68d;
  out1[1] = 0x1313e695;
  out1[2] = 0xb74f5885;
  out1[3] = 0xa7e5f24d;
  out1[4] = 0xbc8d220;
  out1[5] = 0x389cb27e;
  out1[6] = (0x0 as u32);
  out1[7] = (0x0 as u32);
  out1[8] = (0x0 as u32);
  out1[9] = (0x0 as u32);
  out1[10] = (0x0 as u32);
  out1[11] = (0x0 as u32);
}

/// The function fiat_p384_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_scalar_msat(out1: &mut [u32; 13]) {
  out1[0] = 0xccc52973;
  out1[1] = 0xecec196a;
  out1[2] = 0x48b0a77a;
  out1[3] = 0x581a0db2;
  out1[4] = 0xf4372ddf;
  out1[5] = 0xc7634d81;
  out1[6] = 0xffffffff;
  out1[7] = 0xffffffff;
  out1[8] = 0xffffffff;
  out1[9] = 0xffffffff;
  out1[10] = 0xffffffff;
  out1[11] = 0xffffffff;
  out1[12] = (0x0 as u32);
}

/// The function fiat_p384_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_scalar_divstep(out1: &mut u32, out2: &mut [u32; 13], out3: &mut [u32; 13], out4: &mut [u32; 12], out5: &mut [u32; 12], arg1: u32, arg2: &[u32; 13], arg3: &[u32; 13], arg4: &[u32; 12], arg5: &[u32; 12]) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_p384_scalar_u1 = (((x1 >> 31) as fiat_p384_scalar_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p384_scalar_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x15, x3, (arg2[8]), (arg3[8]));
  let mut x16: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x16, x3, (arg2[9]), (arg3[9]));
  let mut x17: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x17, x3, (arg2[10]), (arg3[10]));
  let mut x18: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x18, x3, (arg2[11]), (arg3[11]));
  let mut x19: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x19, x3, (arg2[12]), (arg3[12]));
  let mut x20: u32 = 0;
  let mut x21: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x20, &mut x21, 0x0, (0x1 as u32), (!(arg2[0])));
  let mut x22: u32 = 0;
  let mut x23: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(arg2[1])));
  let mut x24: u32 = 0;
  let mut x25: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(arg2[2])));
  let mut x26: u32 = 0;
  let mut x27: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(arg2[3])));
  let mut x28: u32 = 0;
  let mut x29: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(arg2[4])));
  let mut x30: u32 = 0;
  let mut x31: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(arg2[5])));
  let mut x32: u32 = 0;
  let mut x33: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(arg2[6])));
  let mut x34: u32 = 0;
  let mut x35: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x34, &mut x35, x33, (0x0 as u32), (!(arg2[7])));
  let mut x36: u32 = 0;
  let mut x37: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x36, &mut x37, x35, (0x0 as u32), (!(arg2[8])));
  let mut x38: u32 = 0;
  let mut x39: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x38, &mut x39, x37, (0x0 as u32), (!(arg2[9])));
  let mut x40: u32 = 0;
  let mut x41: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x40, &mut x41, x39, (0x0 as u32), (!(arg2[10])));
  let mut x42: u32 = 0;
  let mut x43: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x42, &mut x43, x41, (0x0 as u32), (!(arg2[11])));
  let mut x44: u32 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x44, &mut x45, x43, (0x0 as u32), (!(arg2[12])));
  let mut x46: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x46, x3, (arg3[0]), x20);
  let mut x47: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x47, x3, (arg3[1]), x22);
  let mut x48: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x48, x3, (arg3[2]), x24);
  let mut x49: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x49, x3, (arg3[3]), x26);
  let mut x50: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x50, x3, (arg3[4]), x28);
  let mut x51: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x51, x3, (arg3[5]), x30);
  let mut x52: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x52, x3, (arg3[6]), x32);
  let mut x53: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x53, x3, (arg3[7]), x34);
  let mut x54: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x54, x3, (arg3[8]), x36);
  let mut x55: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x55, x3, (arg3[9]), x38);
  let mut x56: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x56, x3, (arg3[10]), x40);
  let mut x57: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x57, x3, (arg3[11]), x42);
  let mut x58: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x58, x3, (arg3[12]), x44);
  let mut x59: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x59, x3, (arg4[0]), (arg5[0]));
  let mut x60: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x60, x3, (arg4[1]), (arg5[1]));
  let mut x61: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x61, x3, (arg4[2]), (arg5[2]));
  let mut x62: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x62, x3, (arg4[3]), (arg5[3]));
  let mut x63: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x63, x3, (arg4[4]), (arg5[4]));
  let mut x64: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x64, x3, (arg4[5]), (arg5[5]));
  let mut x65: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x65, x3, (arg4[6]), (arg5[6]));
  let mut x66: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x66, x3, (arg4[7]), (arg5[7]));
  let mut x67: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x67, x3, (arg4[8]), (arg5[8]));
  let mut x68: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x68, x3, (arg4[9]), (arg5[9]));
  let mut x69: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x69, x3, (arg4[10]), (arg5[10]));
  let mut x70: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x70, x3, (arg4[11]), (arg5[11]));
  let mut x71: u32 = 0;
  let mut x72: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x71, &mut x72, 0x0, x59, x59);
  let mut x73: u32 = 0;
  let mut x74: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x73, &mut x74, x72, x60, x60);
  let mut x75: u32 = 0;
  let mut x76: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x61, x61);
  let mut x77: u32 = 0;
  let mut x78: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x77, &mut x78, x76, x62, x62);
  let mut x79: u32 = 0;
  let mut x80: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x79, &mut x80, x78, x63, x63);
  let mut x81: u32 = 0;
  let mut x82: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x81, &mut x82, x80, x64, x64);
  let mut x83: u32 = 0;
  let mut x84: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x83, &mut x84, x82, x65, x65);
  let mut x85: u32 = 0;
  let mut x86: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x85, &mut x86, x84, x66, x66);
  let mut x87: u32 = 0;
  let mut x88: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x87, &mut x88, x86, x67, x67);
  let mut x89: u32 = 0;
  let mut x90: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x89, &mut x90, x88, x68, x68);
  let mut x91: u32 = 0;
  let mut x92: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x91, &mut x92, x90, x69, x69);
  let mut x93: u32 = 0;
  let mut x94: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x93, &mut x94, x92, x70, x70);
  let mut x95: u32 = 0;
  let mut x96: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x95, &mut x96, 0x0, x71, 0xccc52973);
  let mut x97: u32 = 0;
  let mut x98: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x97, &mut x98, x96, x73, 0xecec196a);
  let mut x99: u32 = 0;
  let mut x100: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x99, &mut x100, x98, x75, 0x48b0a77a);
  let mut x101: u32 = 0;
  let mut x102: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x101, &mut x102, x100, x77, 0x581a0db2);
  let mut x103: u32 = 0;
  let mut x104: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x103, &mut x104, x102, x79, 0xf4372ddf);
  let mut x105: u32 = 0;
  let mut x106: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x105, &mut x106, x104, x81, 0xc7634d81);
  let mut x107: u32 = 0;
  let mut x108: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x107, &mut x108, x106, x83, 0xffffffff);
  let mut x109: u32 = 0;
  let mut x110: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x109, &mut x110, x108, x85, 0xffffffff);
  let mut x111: u32 = 0;
  let mut x112: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x111, &mut x112, x110, x87, 0xffffffff);
  let mut x113: u32 = 0;
  let mut x114: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x113, &mut x114, x112, x89, 0xffffffff);
  let mut x115: u32 = 0;
  let mut x116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x115, &mut x116, x114, x91, 0xffffffff);
  let mut x117: u32 = 0;
  let mut x118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x117, &mut x118, x116, x93, 0xffffffff);
  let mut x119: u32 = 0;
  let mut x120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x119, &mut x120, x118, (x94 as u32), (0x0 as u32));
  let x121: u32 = (arg4[11]);
  let x122: u32 = (arg4[10]);
  let x123: u32 = (arg4[9]);
  let x124: u32 = (arg4[8]);
  let x125: u32 = (arg4[7]);
  let x126: u32 = (arg4[6]);
  let x127: u32 = (arg4[5]);
  let x128: u32 = (arg4[4]);
  let x129: u32 = (arg4[3]);
  let x130: u32 = (arg4[2]);
  let x131: u32 = (arg4[1]);
  let x132: u32 = (arg4[0]);
  let mut x133: u32 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x133, &mut x134, 0x0, (0x0 as u32), x132);
  let mut x135: u32 = 0;
  let mut x136: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x135, &mut x136, x134, (0x0 as u32), x131);
  let mut x137: u32 = 0;
  let mut x138: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x137, &mut x138, x136, (0x0 as u32), x130);
  let mut x139: u32 = 0;
  let mut x140: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x139, &mut x140, x138, (0x0 as u32), x129);
  let mut x141: u32 = 0;
  let mut x142: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x141, &mut x142, x140, (0x0 as u32), x128);
  let mut x143: u32 = 0;
  let mut x144: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x143, &mut x144, x142, (0x0 as u32), x127);
  let mut x145: u32 = 0;
  let mut x146: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x145, &mut x146, x144, (0x0 as u32), x126);
  let mut x147: u32 = 0;
  let mut x148: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x147, &mut x148, x146, (0x0 as u32), x125);
  let mut x149: u32 = 0;
  let mut x150: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x149, &mut x150, x148, (0x0 as u32), x124);
  let mut x151: u32 = 0;
  let mut x152: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x151, &mut x152, x150, (0x0 as u32), x123);
  let mut x153: u32 = 0;
  let mut x154: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x153, &mut x154, x152, (0x0 as u32), x122);
  let mut x155: u32 = 0;
  let mut x156: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x155, &mut x156, x154, (0x0 as u32), x121);
  let mut x157: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x157, x156, (0x0 as u32), 0xffffffff);
  let mut x158: u32 = 0;
  let mut x159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x158, &mut x159, 0x0, x133, (x157 & 0xccc52973));
  let mut x160: u32 = 0;
  let mut x161: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x135, (x157 & 0xecec196a));
  let mut x162: u32 = 0;
  let mut x163: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x162, &mut x163, x161, x137, (x157 & 0x48b0a77a));
  let mut x164: u32 = 0;
  let mut x165: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x139, (x157 & 0x581a0db2));
  let mut x166: u32 = 0;
  let mut x167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x166, &mut x167, x165, x141, (x157 & 0xf4372ddf));
  let mut x168: u32 = 0;
  let mut x169: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x168, &mut x169, x167, x143, (x157 & 0xc7634d81));
  let mut x170: u32 = 0;
  let mut x171: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x145, x157);
  let mut x172: u32 = 0;
  let mut x173: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x172, &mut x173, x171, x147, x157);
  let mut x174: u32 = 0;
  let mut x175: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x174, &mut x175, x173, x149, x157);
  let mut x176: u32 = 0;
  let mut x177: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x151, x157);
  let mut x178: u32 = 0;
  let mut x179: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x153, x157);
  let mut x180: u32 = 0;
  let mut x181: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x155, x157);
  let mut x182: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x182, x3, (arg5[0]), x158);
  let mut x183: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x183, x3, (arg5[1]), x160);
  let mut x184: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x184, x3, (arg5[2]), x162);
  let mut x185: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x185, x3, (arg5[3]), x164);
  let mut x186: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x186, x3, (arg5[4]), x166);
  let mut x187: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x187, x3, (arg5[5]), x168);
  let mut x188: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x188, x3, (arg5[6]), x170);
  let mut x189: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x189, x3, (arg5[7]), x172);
  let mut x190: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x190, x3, (arg5[8]), x174);
  let mut x191: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x191, x3, (arg5[9]), x176);
  let mut x192: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x192, x3, (arg5[10]), x178);
  let mut x193: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x193, x3, (arg5[11]), x180);
  let x194: fiat_p384_scalar_u1 = ((x46 & (0x1 as u32)) as fiat_p384_scalar_u1);
  let mut x195: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x195, x194, (0x0 as u32), x7);
  let mut x196: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x196, x194, (0x0 as u32), x8);
  let mut x197: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x197, x194, (0x0 as u32), x9);
  let mut x198: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x198, x194, (0x0 as u32), x10);
  let mut x199: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x199, x194, (0x0 as u32), x11);
  let mut x200: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x200, x194, (0x0 as u32), x12);
  let mut x201: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x201, x194, (0x0 as u32), x13);
  let mut x202: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x202, x194, (0x0 as u32), x14);
  let mut x203: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x203, x194, (0x0 as u32), x15);
  let mut x204: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x204, x194, (0x0 as u32), x16);
  let mut x205: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x205, x194, (0x0 as u32), x17);
  let mut x206: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x206, x194, (0x0 as u32), x18);
  let mut x207: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x207, x194, (0x0 as u32), x19);
  let mut x208: u32 = 0;
  let mut x209: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x208, &mut x209, 0x0, x46, x195);
  let mut x210: u32 = 0;
  let mut x211: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x210, &mut x211, x209, x47, x196);
  let mut x212: u32 = 0;
  let mut x213: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x212, &mut x213, x211, x48, x197);
  let mut x214: u32 = 0;
  let mut x215: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x214, &mut x215, x213, x49, x198);
  let mut x216: u32 = 0;
  let mut x217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x216, &mut x217, x215, x50, x199);
  let mut x218: u32 = 0;
  let mut x219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x218, &mut x219, x217, x51, x200);
  let mut x220: u32 = 0;
  let mut x221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x220, &mut x221, x219, x52, x201);
  let mut x222: u32 = 0;
  let mut x223: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x222, &mut x223, x221, x53, x202);
  let mut x224: u32 = 0;
  let mut x225: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x224, &mut x225, x223, x54, x203);
  let mut x226: u32 = 0;
  let mut x227: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x226, &mut x227, x225, x55, x204);
  let mut x228: u32 = 0;
  let mut x229: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x228, &mut x229, x227, x56, x205);
  let mut x230: u32 = 0;
  let mut x231: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x230, &mut x231, x229, x57, x206);
  let mut x232: u32 = 0;
  let mut x233: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x232, &mut x233, x231, x58, x207);
  let mut x234: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x234, x194, (0x0 as u32), x59);
  let mut x235: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x235, x194, (0x0 as u32), x60);
  let mut x236: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x236, x194, (0x0 as u32), x61);
  let mut x237: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x237, x194, (0x0 as u32), x62);
  let mut x238: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x238, x194, (0x0 as u32), x63);
  let mut x239: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x239, x194, (0x0 as u32), x64);
  let mut x240: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x240, x194, (0x0 as u32), x65);
  let mut x241: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x241, x194, (0x0 as u32), x66);
  let mut x242: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x242, x194, (0x0 as u32), x67);
  let mut x243: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x243, x194, (0x0 as u32), x68);
  let mut x244: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x244, x194, (0x0 as u32), x69);
  let mut x245: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x245, x194, (0x0 as u32), x70);
  let mut x246: u32 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x246, &mut x247, 0x0, x182, x234);
  let mut x248: u32 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x183, x235);
  let mut x250: u32 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x250, &mut x251, x249, x184, x236);
  let mut x252: u32 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x252, &mut x253, x251, x185, x237);
  let mut x254: u32 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x254, &mut x255, x253, x186, x238);
  let mut x256: u32 = 0;
  let mut x257: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x256, &mut x257, x255, x187, x239);
  let mut x258: u32 = 0;
  let mut x259: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x258, &mut x259, x257, x188, x240);
  let mut x260: u32 = 0;
  let mut x261: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x260, &mut x261, x259, x189, x241);
  let mut x262: u32 = 0;
  let mut x263: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x262, &mut x263, x261, x190, x242);
  let mut x264: u32 = 0;
  let mut x265: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x264, &mut x265, x263, x191, x243);
  let mut x266: u32 = 0;
  let mut x267: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x266, &mut x267, x265, x192, x244);
  let mut x268: u32 = 0;
  let mut x269: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x268, &mut x269, x267, x193, x245);
  let mut x270: u32 = 0;
  let mut x271: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x270, &mut x271, 0x0, x246, 0xccc52973);
  let mut x272: u32 = 0;
  let mut x273: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x272, &mut x273, x271, x248, 0xecec196a);
  let mut x274: u32 = 0;
  let mut x275: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x274, &mut x275, x273, x250, 0x48b0a77a);
  let mut x276: u32 = 0;
  let mut x277: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x276, &mut x277, x275, x252, 0x581a0db2);
  let mut x278: u32 = 0;
  let mut x279: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x278, &mut x279, x277, x254, 0xf4372ddf);
  let mut x280: u32 = 0;
  let mut x281: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x280, &mut x281, x279, x256, 0xc7634d81);
  let mut x282: u32 = 0;
  let mut x283: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x282, &mut x283, x281, x258, 0xffffffff);
  let mut x284: u32 = 0;
  let mut x285: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x284, &mut x285, x283, x260, 0xffffffff);
  let mut x286: u32 = 0;
  let mut x287: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x286, &mut x287, x285, x262, 0xffffffff);
  let mut x288: u32 = 0;
  let mut x289: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x288, &mut x289, x287, x264, 0xffffffff);
  let mut x290: u32 = 0;
  let mut x291: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x290, &mut x291, x289, x266, 0xffffffff);
  let mut x292: u32 = 0;
  let mut x293: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x292, &mut x293, x291, x268, 0xffffffff);
  let mut x294: u32 = 0;
  let mut x295: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u32(&mut x294, &mut x295, x293, (x269 as u32), (0x0 as u32));
  let mut x296: u32 = 0;
  let mut x297: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u32(&mut x296, &mut x297, 0x0, x6, (0x1 as u32));
  let x298: u32 = ((x208 >> 1) | ((x210 << 31) & 0xffffffff));
  let x299: u32 = ((x210 >> 1) | ((x212 << 31) & 0xffffffff));
  let x300: u32 = ((x212 >> 1) | ((x214 << 31) & 0xffffffff));
  let x301: u32 = ((x214 >> 1) | ((x216 << 31) & 0xffffffff));
  let x302: u32 = ((x216 >> 1) | ((x218 << 31) & 0xffffffff));
  let x303: u32 = ((x218 >> 1) | ((x220 << 31) & 0xffffffff));
  let x304: u32 = ((x220 >> 1) | ((x222 << 31) & 0xffffffff));
  let x305: u32 = ((x222 >> 1) | ((x224 << 31) & 0xffffffff));
  let x306: u32 = ((x224 >> 1) | ((x226 << 31) & 0xffffffff));
  let x307: u32 = ((x226 >> 1) | ((x228 << 31) & 0xffffffff));
  let x308: u32 = ((x228 >> 1) | ((x230 << 31) & 0xffffffff));
  let x309: u32 = ((x230 >> 1) | ((x232 << 31) & 0xffffffff));
  let x310: u32 = ((x232 & 0x80000000) | (x232 >> 1));
  let mut x311: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x311, x120, x95, x71);
  let mut x312: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x312, x120, x97, x73);
  let mut x313: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x313, x120, x99, x75);
  let mut x314: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x314, x120, x101, x77);
  let mut x315: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x315, x120, x103, x79);
  let mut x316: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x316, x120, x105, x81);
  let mut x317: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x317, x120, x107, x83);
  let mut x318: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x318, x120, x109, x85);
  let mut x319: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x319, x120, x111, x87);
  let mut x320: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x320, x120, x113, x89);
  let mut x321: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x321, x120, x115, x91);
  let mut x322: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x322, x120, x117, x93);
  let mut x323: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x323, x295, x270, x246);
  let mut x324: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x324, x295, x272, x248);
  let mut x325: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x325, x295, x274, x250);
  let mut x326: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x326, x295, x276, x252);
  let mut x327: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x327, x295, x278, x254);
  let mut x328: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x328, x295, x280, x256);
  let mut x329: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x329, x295, x282, x258);
  let mut x330: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x330, x295, x284, x260);
  let mut x331: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x331, x295, x286, x262);
  let mut x332: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x332, x295, x288, x264);
  let mut x333: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x333, x295, x290, x266);
  let mut x334: u32 = 0;
  fiat_p384_scalar_cmovznz_u32(&mut x334, x295, x292, x268);
  *out1 = x296;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out2[9] = x16;
  out2[10] = x17;
  out2[11] = x18;
  out2[12] = x19;
  out3[0] = x298;
  out3[1] = x299;
  out3[2] = x300;
  out3[3] = x301;
  out3[4] = x302;
  out3[5] = x303;
  out3[6] = x304;
  out3[7] = x305;
  out3[8] = x306;
  out3[9] = x307;
  out3[10] = x308;
  out3[11] = x309;
  out3[12] = x310;
  out4[0] = x311;
  out4[1] = x312;
  out4[2] = x313;
  out4[3] = x314;
  out4[4] = x315;
  out4[5] = x316;
  out4[6] = x317;
  out4[7] = x318;
  out4[8] = x319;
  out4[9] = x320;
  out4[10] = x321;
  out4[11] = x322;
  out5[0] = x323;
  out5[1] = x324;
  out5[2] = x325;
  out5[3] = x326;
  out5[4] = x327;
  out5[5] = x328;
  out5[6] = x329;
  out5[7] = x330;
  out5[8] = x331;
  out5[9] = x332;
  out5[10] = x333;
  out5[11] = x334;
}

/// The function fiat_p384_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p384_scalar_divstep_precomp(out1: &mut [u32; 12]) {
  out1[0] = 0xe6045b6a;
  out1[1] = 0x49589ae0;
  out1[2] = 0x870040ed;
  out1[3] = 0x3c9a5352;
  out1[4] = 0x977dc242;
  out1[5] = 0xdacb097e;
  out1[6] = 0xd1ecbe36;
  out1[7] = 0xb5ab30a6;
  out1[8] = 0x1f959973;
  out1[9] = 0x97d7a108;
  out1[10] = 0xd27192bc;
  out1[11] = 0x2ba012f8;
}
