mod flags {
    #![allow(unused)]

    use std::path::PathBuf;

    xflags::xflags! {
        src "./examples/longer.rs"

        cmd rust-analyzer {
            /// Set verbosity level
            repeated -v, --verbose
            /// Log to the specified file instead of stderr.
            optional --log-file path: PathBuf

            default cmd run-server {
                /// Print version
                optional --version
            }

            /// Parse tree
            cmd parse {
                /// Suppress printing
                optional --no-dump
            }

            /// Benchmark specific analysis operation
            cmd analysis-bench
                /// Directory with Cargo.toml
                optional path: PathBuf
            {
                /// Compute syntax highlighting for this file
                required --highlight path: PathBuf
                /// Compute highlighting for this line
                optional --line num: u32
            }
        }
    }

    // generated start
    // The following code is generated by `xflags` macro.
    // Run `env UPDATE_XFLAGS=1 cargo build` to regenerate.
    #[derive(Debug)]
    pub struct RustAnalyzer {
        pub verbose: u32,
        pub log_file: Option<PathBuf>,
        pub subcommand: RustAnalyzerCmd,
    }

    #[derive(Debug)]
    pub enum RustAnalyzerCmd {
        RunServer(RunServer),
        Parse(Parse),
        AnalysisBench(AnalysisBench),
    }

    #[derive(Debug)]
    pub struct RunServer {
        pub version: bool,
    }

    #[derive(Debug)]
    pub struct Parse {
        pub no_dump: bool,
    }

    #[derive(Debug)]
    pub struct AnalysisBench {
        pub path: Option<PathBuf>,

        pub highlight: PathBuf,
        pub line: Option<u32>,
    }

    impl RustAnalyzer {
        pub const HELP: &'static str = Self::HELP_;

        pub fn from_env() -> xflags::Result<Self> {
            Self::from_env_()
        }

        pub fn from_vec(args: Vec<std::ffi::OsString>) -> xflags::Result<Self> {
            Self::from_vec_(args)
        }
    }
    // generated end
}

fn main() {
    match flags::RustAnalyzer::from_env() {
        Ok(flags) => eprintln!("{:#?}", flags),
        Err(err) => eprintln!("{}", err),
    }
}
