#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:40:57 
# uninstall-pam.sh
# shell main install entry point

# P A R S E   C O M M A N D   L I N E
hasfile=
oprev=
for o ;do
	# if the previous option needs an argument, assign it.
  	if [ -n "${oprev}" ]; then
		eval "${oprev}=\${o}"
		oprev=
 		continue
 	fi

  	case "${o}" in
		-f) 
			oprev=file 
			hasfile=true 
		;;
	esac
done
if [ ! -z "${hasfile}" ]; then
	[ -n "${file}" ] || file="sadms.settings"
	i=0
	while read line; do
		name=`echo ${line} | awk 'BEGIN{FS="="}{print $1}'`
		value=`echo ${line} | awk 'BEGIN{FS="="}{print $2}'`
		#echo "+${line} = ${name} + ${value}"
		case ${name} in
			cifsmountpoint) MYMOUNTPOINT="${value}" ; i=$(( i + 1 )) ;;
		esac
	MYNARGS=${i}		
	done < ${file}
	echo "+read ${MYNARGS} settings from ${file}"
	echo 
else
	# echo no file
	MYNARGS=$#
	MYMOUNTPOINT="$3"
fi

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "install PAM"
echo "-------------------------------------------------------------------------------"

# check testing/enforcing mode
MYENFORCE=
if [ -z "${MYENFORCE}" ]; then
	read -p 'Enforce (y/n): ' MYENFORCE
	if [ "${MYENFORCE}" != "y" ]; then
		MYENFORCE='-t'
	else
		MYENFORCE=
	fi
fi

# parameter
if [ -z "${MYMOUNTPOINT}" ]; then
	read -p 'CIFS Mount point (default:~/.cifsmount): ' MYMOUNTPOINT
	[ -z "${MYMOUNTPOINT}" ] &&  MYMOUNTPOINT='~/.cifsmount'
fi

# display
echo
echo 'CIFS mount point: '"${MYMOUNTPOINT}"
if [ "${MYENFORCE}" == "-t" ]; then
	echo 'Testing'
else
	echo 'Enforcing'
fi
echo
read -p 'Do you want to proceed (y/n) ?: ' yes
case ${yes} in
y*|Y*)
	./_uninstall-pam-core.sh ${MYENFORCE} -w -h -m "${MYMOUNTPOINT}"
	exit $?
	;;
*)
	exit
	;;
esac
