/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli \
 *     --scli-exclude='icmp' IP-MIB
 *
 * Derived from IP-MIB:
 *   The MIB module for managing IP and ICMP implementations, but
 *   excluding their management of IP routes.
 *   
 *   Copyright (C) The Internet Society (2006).  This version of
 *   this MIB module is part of RFC 4293; see the RFC itself for
 *   full legal notices.
 *
 * Revision 2006-02-02 00:00:
 *   The IP version neutral revision with added IPv6 objects for
 *   ND, default routers, and router advertisements.  As well as
 *   being the successor to RFC 2011, this MIB is also the
 *   successor to RFCs 2465 and 2466.  Published as RFC 4293.
 *
 * Revision 1994-11-01 00:00:
 *   A separate MIB module (IP-MIB) for IP and ICMP management
 *   objects.  Published as RFC 2011.
 *
 * Revision 1991-03-31 00:00:
 *   The initial revision of this MIB module was part of MIB-II,
 *   which was published as RFC 1213.
 *
 * $Id: ip-mib.h 3180 2009-07-29 22:36:13Z schoenw $
 */

#ifndef _IP_MIB_H_
#define _IP_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define IP_MIB_IPFORWARDING_FORWARDING    1
#define IP_MIB_IPFORWARDING_NOTFORWARDING 2

extern GNetSnmpEnum const ip_mib_enums_ipForwarding[];

#define IP_MIB_IPNETTOMEDIATYPE_OTHER   1
#define IP_MIB_IPNETTOMEDIATYPE_INVALID 2
#define IP_MIB_IPNETTOMEDIATYPE_DYNAMIC 3
#define IP_MIB_IPNETTOMEDIATYPE_STATIC  4

extern GNetSnmpEnum const ip_mib_enums_ipNetToMediaType[];

#define IP_MIB_IPV6IPFORWARDING_FORWARDING    1
#define IP_MIB_IPV6IPFORWARDING_NOTFORWARDING 2

extern GNetSnmpEnum const ip_mib_enums_ipv6IpForwarding[];

#define IP_MIB_IPV4INTERFACEENABLESTATUS_UP   1
#define IP_MIB_IPV4INTERFACEENABLESTATUS_DOWN 2

extern GNetSnmpEnum const ip_mib_enums_ipv4InterfaceEnableStatus[];

#define IP_MIB_IPV6INTERFACEENABLESTATUS_UP   1
#define IP_MIB_IPV6INTERFACEENABLESTATUS_DOWN 2

extern GNetSnmpEnum const ip_mib_enums_ipv6InterfaceEnableStatus[];

#define IP_MIB_IPV6INTERFACEFORWARDING_FORWARDING    1
#define IP_MIB_IPV6INTERFACEFORWARDING_NOTFORWARDING 2

extern GNetSnmpEnum const ip_mib_enums_ipv6InterfaceForwarding[];

#define IP_MIB_IPADDRESSTYPE_UNICAST   1
#define IP_MIB_IPADDRESSTYPE_ANYCAST   2
#define IP_MIB_IPADDRESSTYPE_BROADCAST 3

extern GNetSnmpEnum const ip_mib_enums_ipAddressType[];

#define IP_MIB_IPNETTOPHYSICALTYPE_OTHER   1
#define IP_MIB_IPNETTOPHYSICALTYPE_INVALID 2
#define IP_MIB_IPNETTOPHYSICALTYPE_DYNAMIC 3
#define IP_MIB_IPNETTOPHYSICALTYPE_STATIC  4
#define IP_MIB_IPNETTOPHYSICALTYPE_LOCAL   5

extern GNetSnmpEnum const ip_mib_enums_ipNetToPhysicalType[];

#define IP_MIB_IPNETTOPHYSICALSTATE_REACHABLE  1
#define IP_MIB_IPNETTOPHYSICALSTATE_STALE      2
#define IP_MIB_IPNETTOPHYSICALSTATE_DELAY      3
#define IP_MIB_IPNETTOPHYSICALSTATE_PROBE      4
#define IP_MIB_IPNETTOPHYSICALSTATE_INVALID    5
#define IP_MIB_IPNETTOPHYSICALSTATE_UNKNOWN    6
#define IP_MIB_IPNETTOPHYSICALSTATE_INCOMPLETE 7

extern GNetSnmpEnum const ip_mib_enums_ipNetToPhysicalState[];

#define IP_MIB_IPDEFAULTROUTERPREFERENCE_RESERVED -2
#define IP_MIB_IPDEFAULTROUTERPREFERENCE_LOW      -1
#define IP_MIB_IPDEFAULTROUTERPREFERENCE_MEDIUM   0
#define IP_MIB_IPDEFAULTROUTERPREFERENCE_HIGH     1

extern GNetSnmpEnum const ip_mib_enums_ipDefaultRouterPreference[];

#define IP_MIB_IPADDRESSORIGINTC_OTHER     1
#define IP_MIB_IPADDRESSORIGINTC_MANUAL    2
#define IP_MIB_IPADDRESSORIGINTC_DHCP      4
#define IP_MIB_IPADDRESSORIGINTC_LINKLAYER 5
#define IP_MIB_IPADDRESSORIGINTC_RANDOM    6

extern GNetSnmpEnum const ip_mib_enums_IpAddressOriginTC[];

#define IP_MIB_IPADDRESSSTATUSTC_PREFERRED    1
#define IP_MIB_IPADDRESSSTATUSTC_DEPRECATED   2
#define IP_MIB_IPADDRESSSTATUSTC_INVALID      3
#define IP_MIB_IPADDRESSSTATUSTC_INACCESSIBLE 4
#define IP_MIB_IPADDRESSSTATUSTC_UNKNOWN      5
#define IP_MIB_IPADDRESSSTATUSTC_TENTATIVE    6
#define IP_MIB_IPADDRESSSTATUSTC_DUPLICATE    7
#define IP_MIB_IPADDRESSSTATUSTC_OPTIMISTIC   8

extern GNetSnmpEnum const ip_mib_enums_IpAddressStatusTC[];

#define IP_MIB_IPADDRESSPREFIXORIGINTC_OTHER     1
#define IP_MIB_IPADDRESSPREFIXORIGINTC_MANUAL    2
#define IP_MIB_IPADDRESSPREFIXORIGINTC_WELLKNOWN 3
#define IP_MIB_IPADDRESSPREFIXORIGINTC_DHCP      4
#define IP_MIB_IPADDRESSPREFIXORIGINTC_ROUTERADV 5

extern GNetSnmpEnum const ip_mib_enums_IpAddressPrefixOriginTC[];


/*
 * C type definitions for IP-MIB::ip.
 */

#define IP_MIB_IPFORWARDING                 (1 << 0) 
#define IP_MIB_IPDEFAULTTTL                 (1 << 1) 
#define IP_MIB_IPINRECEIVES                 (1 << 2) 
#define IP_MIB_IPINHDRERRORS                (1 << 3) 
#define IP_MIB_IPINADDRERRORS               (1 << 4) 
#define IP_MIB_IPFORWDATAGRAMS              (1 << 5) 
#define IP_MIB_IPINUNKNOWNPROTOS            (1 << 6) 
#define IP_MIB_IPINDISCARDS                 (1 << 7) 
#define IP_MIB_IPINDELIVERS                 (1 << 8) 
#define IP_MIB_IPOUTREQUESTS                (1 << 9) 
#define IP_MIB_IPOUTDISCARDS                (1 << 10) 
#define IP_MIB_IPOUTNOROUTES                (1 << 11) 
#define IP_MIB_IPREASMTIMEOUT               (1 << 12) 
#define IP_MIB_IPREASMREQDS                 (1 << 13) 
#define IP_MIB_IPREASMOKS                   (1 << 14) 
#define IP_MIB_IPREASMFAILS                 (1 << 15) 
#define IP_MIB_IPFRAGOKS                    (1 << 16) 
#define IP_MIB_IPFRAGFAILS                  (1 << 17) 
#define IP_MIB_IPFRAGCREATES                (1 << 18) 
#define IP_MIB_IPROUTINGDISCARDS            (1 << 19) 
#define IP_MIB_IPV6IPFORWARDING             (1 << 20) 
#define IP_MIB_IPV6IPDEFAULTHOPLIMIT        (1 << 21) 
#define IP_MIB_IPV4INTERFACETABLELASTCHANGE (1 << 22) 
#define IP_MIB_IPV6INTERFACETABLELASTCHANGE (1 << 23) 
#define IP_MIB_IPADDRESSSPINLOCK            (1 << 24) 
#define IP_MIB_IPV6ROUTERADVERTSPINLOCK     (1 << 25) 

typedef struct {
    gint32   *ipForwarding;                     /* rw */
    gint32   *ipDefaultTTL;                     /* rw */
    guint32  *ipInReceives;                     /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipInHdrErrors;                    /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipInAddrErrors;                   /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipForwDatagrams;                  /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipInUnknownProtos;                /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipInDiscards;                     /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipInDelivers;                     /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipOutRequests;                    /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipOutDiscards;                    /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipOutNoRoutes;                    /* ro SNMPv2-SMI::Counter32 */
    gint32   *ipReasmTimeout;                   /* ro Integer32 [seconds] */
    guint32  *ipReasmReqds;                     /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipReasmOKs;                       /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipReasmFails;                     /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipFragOKs;                        /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipFragFails;                      /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipFragCreates;                    /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipRoutingDiscards;                /* ro SNMPv2-SMI::Counter32 */
    gint32   *ipv6IpForwarding;                 /* rw */
    gint32   *ipv6IpDefaultHopLimit;            /* rw */
    guint32  *ipv4InterfaceTableLastChange;     /* ro SNMPv2-TC::TimeStamp */
    guint32  *ipv6InterfaceTableLastChange;     /* ro SNMPv2-TC::TimeStamp */
    gint32   *ipAddressSpinLock;                /* rw SNMPv2-TC::TestAndIncr */
    gint32   *ipv6RouterAdvertSpinLock;         /* rw SNMPv2-TC::TestAndIncr */
} ip_mib_ip_t;

extern ip_mib_ip_t *
ip_mib_new_ip(void);

extern void
ip_mib_get_ip(GNetSnmp *s, ip_mib_ip_t **ip, gint64 mask, GError **error);

extern void
ip_mib_set_ip(GNetSnmp *s, ip_mib_ip_t *ip, gint64 mask, GError **error);

extern void
ip_mib_free_ip(ip_mib_ip_t *ip);

/*
 * C type definitions for IP-MIB::ipAddrEntry.
 */

#define IP_MIB_IPADENTADDR         (1 << 0) 
#define IP_MIB_IPADENTIFINDEX      (1 << 1) 
#define IP_MIB_IPADENTNETMASK      (1 << 2) 
#define IP_MIB_IPADENTBCASTADDR    (1 << 3) 
#define IP_MIB_IPADENTREASMMAXSIZE (1 << 4) 

typedef struct {
    guchar   ipAdEntAddr[4];          /* ro SNMPv2-SMI::IpAddress */
#define IP_MIB_IPADENTADDRLENGTH 4
    gint32   *ipAdEntIfIndex;          /* ro */
    guchar   *ipAdEntNetMask;          /* ro SNMPv2-SMI::IpAddress */
#define IP_MIB_IPADENTNETMASKLENGTH 4
    gint32   *ipAdEntBcastAddr;        /* ro */
    gint32   *ipAdEntReasmMaxSize;     /* ro */
} ip_mib_ipAddrEntry_t;

extern void
ip_mib_get_ipAddrTable(GNetSnmp *s, ip_mib_ipAddrEntry_t ***ipAddrEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddrTable(ip_mib_ipAddrEntry_t **ipAddrEntry);

extern ip_mib_ipAddrEntry_t *
ip_mib_new_ipAddrEntry(void);

extern void
ip_mib_get_ipAddrEntry(GNetSnmp *s, ip_mib_ipAddrEntry_t **ipAddrEntry, guchar *ipAdEntAddr, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddrEntry(ip_mib_ipAddrEntry_t *ipAddrEntry);

/*
 * C type definitions for IP-MIB::ipNetToMediaEntry.
 */

#define IP_MIB_IPNETTOMEDIAIFINDEX     (1 << 0) 
#define IP_MIB_IPNETTOMEDIAPHYSADDRESS (1 << 1) 
#define IP_MIB_IPNETTOMEDIANETADDRESS  (1 << 2) 
#define IP_MIB_IPNETTOMEDIATYPE        (1 << 3) 

typedef struct {
    gint32   ipNetToMediaIfIndex;          /* rw */
    guchar   ipNetToMediaNetAddress[4];   /* rw SNMPv2-SMI::IpAddress */
#define IP_MIB_IPNETTOMEDIANETADDRESSLENGTH 4
    guchar   *ipNetToMediaPhysAddress;     /* rw */
#define IP_MIB_IPNETTOMEDIAPHYSADDRESSMINLENGTH 0
#define IP_MIB_IPNETTOMEDIAPHYSADDRESSMAXLENGTH 65535
    guint16  _ipNetToMediaPhysAddressLength;
    gint32   *ipNetToMediaType;            /* rw */
} ip_mib_ipNetToMediaEntry_t;

extern void
ip_mib_get_ipNetToMediaTable(GNetSnmp *s, ip_mib_ipNetToMediaEntry_t ***ipNetToMediaEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipNetToMediaTable(ip_mib_ipNetToMediaEntry_t **ipNetToMediaEntry);

extern ip_mib_ipNetToMediaEntry_t *
ip_mib_new_ipNetToMediaEntry(void);

extern void
ip_mib_get_ipNetToMediaEntry(GNetSnmp *s, ip_mib_ipNetToMediaEntry_t **ipNetToMediaEntry, gint32 ipNetToMediaIfIndex, guchar *ipNetToMediaNetAddress, gint64 mask, GError **error);

extern void
ip_mib_set_ipNetToMediaEntry(GNetSnmp *s, ip_mib_ipNetToMediaEntry_t *ipNetToMediaEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipNetToMediaEntry(ip_mib_ipNetToMediaEntry_t *ipNetToMediaEntry);

/*
 * C type definitions for IP-MIB::ipv4InterfaceEntry.
 */

#define IP_MIB_IPV4INTERFACEREASMMAXSIZE   (1 << 0) 
#define IP_MIB_IPV4INTERFACEENABLESTATUS   (1 << 1) 
#define IP_MIB_IPV4INTERFACERETRANSMITTIME (1 << 2) 

typedef struct {
    gint32   ipv4InterfaceIfIndex;             /* na IF-MIB::InterfaceIndex */
    gint32   *ipv4InterfaceReasmMaxSize;       /* ro */
    gint32   *ipv4InterfaceEnableStatus;       /* rw */
    guint32  *ipv4InterfaceRetransmitTime;     /* ro Unsigned32 [milliseconds] */
} ip_mib_ipv4InterfaceEntry_t;

extern void
ip_mib_get_ipv4InterfaceTable(GNetSnmp *s, ip_mib_ipv4InterfaceEntry_t ***ipv4InterfaceEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv4InterfaceTable(ip_mib_ipv4InterfaceEntry_t **ipv4InterfaceEntry);

extern ip_mib_ipv4InterfaceEntry_t *
ip_mib_new_ipv4InterfaceEntry(void);

extern void
ip_mib_get_ipv4InterfaceEntry(GNetSnmp *s, ip_mib_ipv4InterfaceEntry_t **ipv4InterfaceEntry, gint32 ipv4InterfaceIfIndex, gint64 mask, GError **error);

extern void
ip_mib_set_ipv4InterfaceEntry(GNetSnmp *s, ip_mib_ipv4InterfaceEntry_t *ipv4InterfaceEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv4InterfaceEntry(ip_mib_ipv4InterfaceEntry_t *ipv4InterfaceEntry);

/*
 * C type definitions for IP-MIB::ipv6InterfaceEntry.
 */

#define IP_MIB_IPV6INTERFACEREASMMAXSIZE   (1 << 0) 
#define IP_MIB_IPV6INTERFACEIDENTIFIER     (1 << 1) 
#define IP_MIB_IPV6INTERFACEENABLESTATUS   (1 << 2) 
#define IP_MIB_IPV6INTERFACEREACHABLETIME  (1 << 3) 
#define IP_MIB_IPV6INTERFACERETRANSMITTIME (1 << 4) 
#define IP_MIB_IPV6INTERFACEFORWARDING     (1 << 5) 

typedef struct {
    gint32   ipv6InterfaceIfIndex;             /* na IF-MIB::InterfaceIndex */
    guint32  *ipv6InterfaceReasmMaxSize;       /* ro [octets] */
    guchar   *ipv6InterfaceIdentifier;         /* ro IP-MIB::Ipv6AddressIfIdentifierTC */
#define IP_MIB_IPV6INTERFACEIDENTIFIERMINLENGTH 0
#define IP_MIB_IPV6INTERFACEIDENTIFIERMAXLENGTH 8
    guint16  _ipv6InterfaceIdentifierLength;
    gint32   *ipv6InterfaceEnableStatus;       /* rw */
    guint32  *ipv6InterfaceReachableTime;      /* ro Unsigned32 [milliseconds] */
    guint32  *ipv6InterfaceRetransmitTime;     /* ro Unsigned32 [milliseconds] */
    gint32   *ipv6InterfaceForwarding;         /* rw */
} ip_mib_ipv6InterfaceEntry_t;

extern void
ip_mib_get_ipv6InterfaceTable(GNetSnmp *s, ip_mib_ipv6InterfaceEntry_t ***ipv6InterfaceEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6InterfaceTable(ip_mib_ipv6InterfaceEntry_t **ipv6InterfaceEntry);

extern ip_mib_ipv6InterfaceEntry_t *
ip_mib_new_ipv6InterfaceEntry(void);

extern void
ip_mib_get_ipv6InterfaceEntry(GNetSnmp *s, ip_mib_ipv6InterfaceEntry_t **ipv6InterfaceEntry, gint32 ipv6InterfaceIfIndex, gint64 mask, GError **error);

extern void
ip_mib_set_ipv6InterfaceEntry(GNetSnmp *s, ip_mib_ipv6InterfaceEntry_t *ipv6InterfaceEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6InterfaceEntry(ip_mib_ipv6InterfaceEntry_t *ipv6InterfaceEntry);

/*
 * C type definitions for IP-MIB::ipTrafficStats.
 */

#define IP_MIB_IPIFSTATSTABLELASTCHANGE (1 << 0) 

typedef struct {
    guint32  *ipIfStatsTableLastChange;     /* ro SNMPv2-TC::TimeStamp */
} ip_mib_ipTrafficStats_t;

extern ip_mib_ipTrafficStats_t *
ip_mib_new_ipTrafficStats(void);

extern void
ip_mib_get_ipTrafficStats(GNetSnmp *s, ip_mib_ipTrafficStats_t **ipTrafficStats, gint64 mask, GError **error);

extern void
ip_mib_free_ipTrafficStats(ip_mib_ipTrafficStats_t *ipTrafficStats);

/*
 * C type definitions for IP-MIB::ipSystemStatsEntry.
 */

#define IP_MIB_IPSYSTEMSTATSINRECEIVES         (1 << 0) 
#define IP_MIB_IPSYSTEMSTATSHCINRECEIVES       (1 << 1) 
#define IP_MIB_IPSYSTEMSTATSINOCTETS           (1 << 2) 
#define IP_MIB_IPSYSTEMSTATSHCINOCTETS         (1 << 3) 
#define IP_MIB_IPSYSTEMSTATSINHDRERRORS        (1 << 4) 
#define IP_MIB_IPSYSTEMSTATSINNOROUTES         (1 << 5) 
#define IP_MIB_IPSYSTEMSTATSINADDRERRORS       (1 << 6) 
#define IP_MIB_IPSYSTEMSTATSINUNKNOWNPROTOS    (1 << 7) 
#define IP_MIB_IPSYSTEMSTATSINTRUNCATEDPKTS    (1 << 8) 
#define IP_MIB_IPSYSTEMSTATSINFORWDATAGRAMS    (1 << 9) 
#define IP_MIB_IPSYSTEMSTATSHCINFORWDATAGRAMS  (1 << 10) 
#define IP_MIB_IPSYSTEMSTATSREASMREQDS         (1 << 11) 
#define IP_MIB_IPSYSTEMSTATSREASMOKS           (1 << 12) 
#define IP_MIB_IPSYSTEMSTATSREASMFAILS         (1 << 13) 
#define IP_MIB_IPSYSTEMSTATSINDISCARDS         (1 << 14) 
#define IP_MIB_IPSYSTEMSTATSINDELIVERS         (1 << 15) 
#define IP_MIB_IPSYSTEMSTATSHCINDELIVERS       (1 << 16) 
#define IP_MIB_IPSYSTEMSTATSOUTREQUESTS        (1 << 17) 
#define IP_MIB_IPSYSTEMSTATSHCOUTREQUESTS      (1 << 18) 
#define IP_MIB_IPSYSTEMSTATSOUTNOROUTES        (1 << 19) 
#define IP_MIB_IPSYSTEMSTATSOUTFORWDATAGRAMS   (1 << 20) 
#define IP_MIB_IPSYSTEMSTATSHCOUTFORWDATAGRAMS (1 << 21) 
#define IP_MIB_IPSYSTEMSTATSOUTDISCARDS        (1 << 22) 
#define IP_MIB_IPSYSTEMSTATSOUTFRAGREQDS       (1 << 23) 
#define IP_MIB_IPSYSTEMSTATSOUTFRAGOKS         (1 << 24) 
#define IP_MIB_IPSYSTEMSTATSOUTFRAGFAILS       (1 << 25) 
#define IP_MIB_IPSYSTEMSTATSOUTFRAGCREATES     (1 << 26) 
#define IP_MIB_IPSYSTEMSTATSOUTTRANSMITS       (1 << 27) 
#define IP_MIB_IPSYSTEMSTATSHCOUTTRANSMITS     (1 << 28) 
#define IP_MIB_IPSYSTEMSTATSOUTOCTETS          (1 << 29) 
#define IP_MIB_IPSYSTEMSTATSHCOUTOCTETS        (1 << 30) 
#define IP_MIB_IPSYSTEMSTATSINMCASTPKTS        (1 << 31) 
#define IP_MIB_IPSYSTEMSTATSHCINMCASTPKTS      (1 << 32) 
#define IP_MIB_IPSYSTEMSTATSINMCASTOCTETS      (1 << 33) 
#define IP_MIB_IPSYSTEMSTATSHCINMCASTOCTETS    (1 << 34) 
#define IP_MIB_IPSYSTEMSTATSOUTMCASTPKTS       (1 << 35) 
#define IP_MIB_IPSYSTEMSTATSHCOUTMCASTPKTS     (1 << 36) 
#define IP_MIB_IPSYSTEMSTATSOUTMCASTOCTETS     (1 << 37) 
#define IP_MIB_IPSYSTEMSTATSHCOUTMCASTOCTETS   (1 << 38) 
#define IP_MIB_IPSYSTEMSTATSINBCASTPKTS        (1 << 39) 
#define IP_MIB_IPSYSTEMSTATSHCINBCASTPKTS      (1 << 40) 
#define IP_MIB_IPSYSTEMSTATSOUTBCASTPKTS       (1 << 41) 
#define IP_MIB_IPSYSTEMSTATSHCOUTBCASTPKTS     (1 << 42) 
#define IP_MIB_IPSYSTEMSTATSDISCONTINUITYTIME  (1 << 43) 
#define IP_MIB_IPSYSTEMSTATSREFRESHRATE        (1 << 44) 

typedef struct {
    gint32   ipSystemStatsIPVersion;               /* na INET-ADDRESS-MIB::InetVersion */
    guint32  *ipSystemStatsInReceives;             /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInReceives;           /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsInOctets;               /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInOctets;             /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsInHdrErrors;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInNoRoutes;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInAddrErrors;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInUnknownProtos;        /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInTruncatedPkts;        /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInForwDatagrams;        /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInForwDatagrams;      /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsReasmReqds;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsReasmOKs;               /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsReasmFails;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInDiscards;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsInDelivers;             /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInDelivers;           /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutRequests;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutRequests;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutNoRoutes;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutForwDatagrams;       /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutForwDatagrams;     /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutDiscards;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutFragReqds;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutFragOKs;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutFragFails;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutFragCreates;         /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipSystemStatsOutTransmits;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutTransmits;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutOctets;              /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutOctets;            /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsInMcastPkts;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInMcastPkts;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsInMcastOctets;          /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInMcastOctets;        /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutMcastPkts;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutMcastPkts;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutMcastOctets;         /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutMcastOctets;       /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsInBcastPkts;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCInBcastPkts;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsOutBcastPkts;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipSystemStatsHCOutBcastPkts;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipSystemStatsDiscontinuityTime;      /* ro SNMPv2-TC::TimeStamp */
    guint32  *ipSystemStatsRefreshRate;            /* ro Unsigned32 [milli-seconds] */
} ip_mib_ipSystemStatsEntry_t;

extern void
ip_mib_get_ipSystemStatsTable(GNetSnmp *s, ip_mib_ipSystemStatsEntry_t ***ipSystemStatsEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipSystemStatsTable(ip_mib_ipSystemStatsEntry_t **ipSystemStatsEntry);

extern ip_mib_ipSystemStatsEntry_t *
ip_mib_new_ipSystemStatsEntry(void);

extern void
ip_mib_get_ipSystemStatsEntry(GNetSnmp *s, ip_mib_ipSystemStatsEntry_t **ipSystemStatsEntry, gint32 ipSystemStatsIPVersion, gint64 mask, GError **error);

extern void
ip_mib_free_ipSystemStatsEntry(ip_mib_ipSystemStatsEntry_t *ipSystemStatsEntry);

/*
 * C type definitions for IP-MIB::ipIfStatsEntry.
 */

#define IP_MIB_IPIFSTATSINRECEIVES         (1 << 0) 
#define IP_MIB_IPIFSTATSHCINRECEIVES       (1 << 1) 
#define IP_MIB_IPIFSTATSINOCTETS           (1 << 2) 
#define IP_MIB_IPIFSTATSHCINOCTETS         (1 << 3) 
#define IP_MIB_IPIFSTATSINHDRERRORS        (1 << 4) 
#define IP_MIB_IPIFSTATSINNOROUTES         (1 << 5) 
#define IP_MIB_IPIFSTATSINADDRERRORS       (1 << 6) 
#define IP_MIB_IPIFSTATSINUNKNOWNPROTOS    (1 << 7) 
#define IP_MIB_IPIFSTATSINTRUNCATEDPKTS    (1 << 8) 
#define IP_MIB_IPIFSTATSINFORWDATAGRAMS    (1 << 9) 
#define IP_MIB_IPIFSTATSHCINFORWDATAGRAMS  (1 << 10) 
#define IP_MIB_IPIFSTATSREASMREQDS         (1 << 11) 
#define IP_MIB_IPIFSTATSREASMOKS           (1 << 12) 
#define IP_MIB_IPIFSTATSREASMFAILS         (1 << 13) 
#define IP_MIB_IPIFSTATSINDISCARDS         (1 << 14) 
#define IP_MIB_IPIFSTATSINDELIVERS         (1 << 15) 
#define IP_MIB_IPIFSTATSHCINDELIVERS       (1 << 16) 
#define IP_MIB_IPIFSTATSOUTREQUESTS        (1 << 17) 
#define IP_MIB_IPIFSTATSHCOUTREQUESTS      (1 << 18) 
#define IP_MIB_IPIFSTATSOUTFORWDATAGRAMS   (1 << 19) 
#define IP_MIB_IPIFSTATSHCOUTFORWDATAGRAMS (1 << 20) 
#define IP_MIB_IPIFSTATSOUTDISCARDS        (1 << 21) 
#define IP_MIB_IPIFSTATSOUTFRAGREQDS       (1 << 22) 
#define IP_MIB_IPIFSTATSOUTFRAGOKS         (1 << 23) 
#define IP_MIB_IPIFSTATSOUTFRAGFAILS       (1 << 24) 
#define IP_MIB_IPIFSTATSOUTFRAGCREATES     (1 << 25) 
#define IP_MIB_IPIFSTATSOUTTRANSMITS       (1 << 26) 
#define IP_MIB_IPIFSTATSHCOUTTRANSMITS     (1 << 27) 
#define IP_MIB_IPIFSTATSOUTOCTETS          (1 << 28) 
#define IP_MIB_IPIFSTATSHCOUTOCTETS        (1 << 29) 
#define IP_MIB_IPIFSTATSINMCASTPKTS        (1 << 30) 
#define IP_MIB_IPIFSTATSHCINMCASTPKTS      (1 << 31) 
#define IP_MIB_IPIFSTATSINMCASTOCTETS      (1 << 32) 
#define IP_MIB_IPIFSTATSHCINMCASTOCTETS    (1 << 33) 
#define IP_MIB_IPIFSTATSOUTMCASTPKTS       (1 << 34) 
#define IP_MIB_IPIFSTATSHCOUTMCASTPKTS     (1 << 35) 
#define IP_MIB_IPIFSTATSOUTMCASTOCTETS     (1 << 36) 
#define IP_MIB_IPIFSTATSHCOUTMCASTOCTETS   (1 << 37) 
#define IP_MIB_IPIFSTATSINBCASTPKTS        (1 << 38) 
#define IP_MIB_IPIFSTATSHCINBCASTPKTS      (1 << 39) 
#define IP_MIB_IPIFSTATSOUTBCASTPKTS       (1 << 40) 
#define IP_MIB_IPIFSTATSHCOUTBCASTPKTS     (1 << 41) 
#define IP_MIB_IPIFSTATSDISCONTINUITYTIME  (1 << 42) 
#define IP_MIB_IPIFSTATSREFRESHRATE        (1 << 43) 

typedef struct {
    gint32   ipIfStatsIPVersion;               /* na INET-ADDRESS-MIB::InetVersion */
    gint32   ipIfStatsIfIndex;                 /* na IF-MIB::InterfaceIndex */
    guint32  *ipIfStatsInReceives;             /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInReceives;           /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsInOctets;               /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInOctets;             /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsInHdrErrors;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInNoRoutes;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInAddrErrors;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInUnknownProtos;        /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInTruncatedPkts;        /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInForwDatagrams;        /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInForwDatagrams;      /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsReasmReqds;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsReasmOKs;               /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsReasmFails;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInDiscards;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsInDelivers;             /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInDelivers;           /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutRequests;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutRequests;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutForwDatagrams;       /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutForwDatagrams;     /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutDiscards;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsOutFragReqds;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsOutFragOKs;             /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsOutFragFails;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsOutFragCreates;         /* ro SNMPv2-SMI::Counter32 */
    guint32  *ipIfStatsOutTransmits;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutTransmits;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutOctets;              /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutOctets;            /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsInMcastPkts;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInMcastPkts;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsInMcastOctets;          /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInMcastOctets;        /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutMcastPkts;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutMcastPkts;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutMcastOctets;         /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutMcastOctets;       /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsInBcastPkts;            /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCInBcastPkts;          /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsOutBcastPkts;           /* ro SNMPv2-SMI::Counter32 */
    guint64  *ipIfStatsHCOutBcastPkts;         /* ro SNMPv2-SMI::Counter64 */
    guint32  *ipIfStatsDiscontinuityTime;      /* ro SNMPv2-TC::TimeStamp */
    guint32  *ipIfStatsRefreshRate;            /* ro Unsigned32 [milli-seconds] */
} ip_mib_ipIfStatsEntry_t;

extern void
ip_mib_get_ipIfStatsTable(GNetSnmp *s, ip_mib_ipIfStatsEntry_t ***ipIfStatsEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipIfStatsTable(ip_mib_ipIfStatsEntry_t **ipIfStatsEntry);

extern ip_mib_ipIfStatsEntry_t *
ip_mib_new_ipIfStatsEntry(void);

extern void
ip_mib_get_ipIfStatsEntry(GNetSnmp *s, ip_mib_ipIfStatsEntry_t **ipIfStatsEntry, gint32 ipIfStatsIPVersion, gint32 ipIfStatsIfIndex, gint64 mask, GError **error);

extern void
ip_mib_free_ipIfStatsEntry(ip_mib_ipIfStatsEntry_t *ipIfStatsEntry);

/*
 * C type definitions for IP-MIB::ipAddressPrefixEntry.
 */

#define IP_MIB_IPADDRESSPREFIXORIGIN               (1 << 0) 
#define IP_MIB_IPADDRESSPREFIXONLINKFLAG           (1 << 1) 
#define IP_MIB_IPADDRESSPREFIXAUTONOMOUSFLAG       (1 << 2) 
#define IP_MIB_IPADDRESSPREFIXADVPREFERREDLIFETIME (1 << 3) 
#define IP_MIB_IPADDRESSPREFIXADVVALIDLIFETIME     (1 << 4) 

typedef struct {
    gint32   ipAddressPrefixIfIndex;                   /* na IF-MIB::InterfaceIndex */
    gint32   ipAddressPrefixType;                      /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   ipAddressPrefixPrefix[118];                /* na INET-ADDRESS-MIB::InetAddress */
#define IP_MIB_IPADDRESSPREFIXPREFIXMINLENGTH 0
#define IP_MIB_IPADDRESSPREFIXPREFIXMAXLENGTH 118
    guint16  _ipAddressPrefixPrefixLength;
    guint32  ipAddressPrefixLength;                    /* na INET-ADDRESS-MIB::InetAddressPrefixLength */
    gint32   *ipAddressPrefixOrigin;                   /* ro IP-MIB::IpAddressPrefixOriginTC */
    gint32   *ipAddressPrefixOnLinkFlag;               /* ro SNMPv2-TC::TruthValue */
    gint32   *ipAddressPrefixAutonomousFlag;           /* ro SNMPv2-TC::TruthValue */
    guint32  *ipAddressPrefixAdvPreferredLifetime;     /* ro Unsigned32 [seconds] */
    guint32  *ipAddressPrefixAdvValidLifetime;         /* ro Unsigned32 [seconds] */
} ip_mib_ipAddressPrefixEntry_t;

extern void
ip_mib_get_ipAddressPrefixTable(GNetSnmp *s, ip_mib_ipAddressPrefixEntry_t ***ipAddressPrefixEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddressPrefixTable(ip_mib_ipAddressPrefixEntry_t **ipAddressPrefixEntry);

extern ip_mib_ipAddressPrefixEntry_t *
ip_mib_new_ipAddressPrefixEntry(void);

extern void
ip_mib_get_ipAddressPrefixEntry(GNetSnmp *s, ip_mib_ipAddressPrefixEntry_t **ipAddressPrefixEntry, gint32 ipAddressPrefixIfIndex, gint32 ipAddressPrefixType, guchar *ipAddressPrefixPrefix, guint16 _ipAddressPrefixPrefixLength, guint32 ipAddressPrefixLength, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddressPrefixEntry(ip_mib_ipAddressPrefixEntry_t *ipAddressPrefixEntry);

/*
 * C type definitions for IP-MIB::ipAddressEntry.
 */

#define IP_MIB_IPADDRESSIFINDEX     (1 << 0) 
#define IP_MIB_IPADDRESSTYPE        (1 << 1) 
#define IP_MIB_IPADDRESSPREFIX      (1 << 2) 
#define IP_MIB_IPADDRESSORIGIN      (1 << 3) 
#define IP_MIB_IPADDRESSSTATUS      (1 << 4) 
#define IP_MIB_IPADDRESSCREATED     (1 << 5) 
#define IP_MIB_IPADDRESSLASTCHANGED (1 << 6) 
#define IP_MIB_IPADDRESSROWSTATUS   (1 << 7) 
#define IP_MIB_IPADDRESSSTORAGETYPE (1 << 8) 

typedef struct {
    gint32   ipAddressAddrType;         /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   ipAddressAddr[118];         /* na INET-ADDRESS-MIB::InetAddress */
#define IP_MIB_IPADDRESSADDRMINLENGTH 0
#define IP_MIB_IPADDRESSADDRMAXLENGTH 118
    guint16  _ipAddressAddrLength;
    gint32   *ipAddressIfIndex;         /* rw IF-MIB::InterfaceIndex */
    gint32   *ipAddressType;            /* rw */
    guint32  *ipAddressPrefix;          /* ro SNMPv2-TC::RowPointer */
#define IP_MIB_IPADDRESSPREFIXMINLENGTH 0
#define IP_MIB_IPADDRESSPREFIXMAXLENGTH 128
    guint16  _ipAddressPrefixLength;
    gint32   *ipAddressOrigin;          /* ro IP-MIB::IpAddressOriginTC */
    gint32   *ipAddressStatus;          /* rw IP-MIB::IpAddressStatusTC */
    guint32  *ipAddressCreated;         /* ro SNMPv2-TC::TimeStamp */
    guint32  *ipAddressLastChanged;     /* ro SNMPv2-TC::TimeStamp */
    gint32   *ipAddressRowStatus;       /* rw SNMPv2-TC::RowStatus */
    gint32   *ipAddressStorageType;     /* rw SNMPv2-TC::StorageType */
} ip_mib_ipAddressEntry_t;

extern void
ip_mib_get_ipAddressTable(GNetSnmp *s, ip_mib_ipAddressEntry_t ***ipAddressEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddressTable(ip_mib_ipAddressEntry_t **ipAddressEntry);

extern ip_mib_ipAddressEntry_t *
ip_mib_new_ipAddressEntry(void);

extern void
ip_mib_get_ipAddressEntry(GNetSnmp *s, ip_mib_ipAddressEntry_t **ipAddressEntry, gint32 ipAddressAddrType, guchar *ipAddressAddr, guint16 _ipAddressAddrLength, gint64 mask, GError **error);

extern void
ip_mib_set_ipAddressEntry(GNetSnmp *s, ip_mib_ipAddressEntry_t *ipAddressEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipAddressEntry(ip_mib_ipAddressEntry_t *ipAddressEntry);

/*
 * C type definitions for IP-MIB::ipNetToPhysicalEntry.
 */

#define IP_MIB_IPNETTOPHYSICALPHYSADDRESS (1 << 0) 
#define IP_MIB_IPNETTOPHYSICALLASTUPDATED (1 << 1) 
#define IP_MIB_IPNETTOPHYSICALTYPE        (1 << 2) 
#define IP_MIB_IPNETTOPHYSICALSTATE       (1 << 3) 
#define IP_MIB_IPNETTOPHYSICALROWSTATUS   (1 << 4) 

typedef struct {
    gint32   ipNetToPhysicalIfIndex;          /* na IF-MIB::InterfaceIndex */
    gint32   ipNetToPhysicalNetAddressType;   /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   ipNetToPhysicalNetAddress[118];   /* na INET-ADDRESS-MIB::InetAddress */
#define IP_MIB_IPNETTOPHYSICALNETADDRESSMINLENGTH 0
#define IP_MIB_IPNETTOPHYSICALNETADDRESSMAXLENGTH 118
    guint16  _ipNetToPhysicalNetAddressLength;
    guchar   *ipNetToPhysicalPhysAddress;     /* rw */
#define IP_MIB_IPNETTOPHYSICALPHYSADDRESSMINLENGTH 0
#define IP_MIB_IPNETTOPHYSICALPHYSADDRESSMAXLENGTH 65535
    guint16  _ipNetToPhysicalPhysAddressLength;
    guint32  *ipNetToPhysicalLastUpdated;     /* ro SNMPv2-TC::TimeStamp */
    gint32   *ipNetToPhysicalType;            /* rw */
    gint32   *ipNetToPhysicalState;           /* ro */
    gint32   *ipNetToPhysicalRowStatus;       /* rw SNMPv2-TC::RowStatus */
} ip_mib_ipNetToPhysicalEntry_t;

extern void
ip_mib_get_ipNetToPhysicalTable(GNetSnmp *s, ip_mib_ipNetToPhysicalEntry_t ***ipNetToPhysicalEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipNetToPhysicalTable(ip_mib_ipNetToPhysicalEntry_t **ipNetToPhysicalEntry);

extern ip_mib_ipNetToPhysicalEntry_t *
ip_mib_new_ipNetToPhysicalEntry(void);

extern void
ip_mib_get_ipNetToPhysicalEntry(GNetSnmp *s, ip_mib_ipNetToPhysicalEntry_t **ipNetToPhysicalEntry, gint32 ipNetToPhysicalIfIndex, gint32 ipNetToPhysicalNetAddressType, guchar *ipNetToPhysicalNetAddress, guint16 _ipNetToPhysicalNetAddressLength, gint64 mask, GError **error);

extern void
ip_mib_set_ipNetToPhysicalEntry(GNetSnmp *s, ip_mib_ipNetToPhysicalEntry_t *ipNetToPhysicalEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipNetToPhysicalEntry(ip_mib_ipNetToPhysicalEntry_t *ipNetToPhysicalEntry);

/*
 * C type definitions for IP-MIB::ipv6ScopeZoneIndexEntry.
 */

#define IP_MIB_IPV6SCOPEZONEINDEXLINKLOCAL         (1 << 0) 
#define IP_MIB_IPV6SCOPEZONEINDEX3                 (1 << 1) 
#define IP_MIB_IPV6SCOPEZONEINDEXADMINLOCAL        (1 << 2) 
#define IP_MIB_IPV6SCOPEZONEINDEXSITELOCAL         (1 << 3) 
#define IP_MIB_IPV6SCOPEZONEINDEX6                 (1 << 4) 
#define IP_MIB_IPV6SCOPEZONEINDEX7                 (1 << 5) 
#define IP_MIB_IPV6SCOPEZONEINDEXORGANIZATIONLOCAL (1 << 6) 
#define IP_MIB_IPV6SCOPEZONEINDEX9                 (1 << 7) 
#define IP_MIB_IPV6SCOPEZONEINDEXA                 (1 << 8) 
#define IP_MIB_IPV6SCOPEZONEINDEXB                 (1 << 9) 
#define IP_MIB_IPV6SCOPEZONEINDEXC                 (1 << 10) 
#define IP_MIB_IPV6SCOPEZONEINDEXD                 (1 << 11) 

typedef struct {
    gint32   ipv6ScopeZoneIndexIfIndex;                /* na IF-MIB::InterfaceIndex */
    guint32  *ipv6ScopeZoneIndexLinkLocal;             /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndex3;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexAdminLocal;            /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexSiteLocal;             /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndex6;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndex7;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexOrganizationLocal;     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndex9;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexA;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexB;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexC;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
    guint32  *ipv6ScopeZoneIndexD;                     /* ro INET-ADDRESS-MIB::InetZoneIndex */
} ip_mib_ipv6ScopeZoneIndexEntry_t;

extern void
ip_mib_get_ipv6ScopeZoneIndexTable(GNetSnmp *s, ip_mib_ipv6ScopeZoneIndexEntry_t ***ipv6ScopeZoneIndexEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6ScopeZoneIndexTable(ip_mib_ipv6ScopeZoneIndexEntry_t **ipv6ScopeZoneIndexEntry);

extern ip_mib_ipv6ScopeZoneIndexEntry_t *
ip_mib_new_ipv6ScopeZoneIndexEntry(void);

extern void
ip_mib_get_ipv6ScopeZoneIndexEntry(GNetSnmp *s, ip_mib_ipv6ScopeZoneIndexEntry_t **ipv6ScopeZoneIndexEntry, gint32 ipv6ScopeZoneIndexIfIndex, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6ScopeZoneIndexEntry(ip_mib_ipv6ScopeZoneIndexEntry_t *ipv6ScopeZoneIndexEntry);

/*
 * C type definitions for IP-MIB::ipDefaultRouterEntry.
 */

#define IP_MIB_IPDEFAULTROUTERLIFETIME   (1 << 0) 
#define IP_MIB_IPDEFAULTROUTERPREFERENCE (1 << 1) 

typedef struct {
    gint32   ipDefaultRouterAddressType;     /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   ipDefaultRouterAddress[118];     /* na INET-ADDRESS-MIB::InetAddress */
#define IP_MIB_IPDEFAULTROUTERADDRESSMINLENGTH 0
#define IP_MIB_IPDEFAULTROUTERADDRESSMAXLENGTH 118
    guint16  _ipDefaultRouterAddressLength;
    gint32   ipDefaultRouterIfIndex;         /* na IF-MIB::InterfaceIndex */
    guint32  *ipDefaultRouterLifetime;       /* ro [seconds] */
    gint32   *ipDefaultRouterPreference;     /* ro */
} ip_mib_ipDefaultRouterEntry_t;

extern void
ip_mib_get_ipDefaultRouterTable(GNetSnmp *s, ip_mib_ipDefaultRouterEntry_t ***ipDefaultRouterEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipDefaultRouterTable(ip_mib_ipDefaultRouterEntry_t **ipDefaultRouterEntry);

extern ip_mib_ipDefaultRouterEntry_t *
ip_mib_new_ipDefaultRouterEntry(void);

extern void
ip_mib_get_ipDefaultRouterEntry(GNetSnmp *s, ip_mib_ipDefaultRouterEntry_t **ipDefaultRouterEntry, gint32 ipDefaultRouterAddressType, guchar *ipDefaultRouterAddress, guint16 _ipDefaultRouterAddressLength, gint32 ipDefaultRouterIfIndex, gint64 mask, GError **error);

extern void
ip_mib_free_ipDefaultRouterEntry(ip_mib_ipDefaultRouterEntry_t *ipDefaultRouterEntry);

/*
 * C type definitions for IP-MIB::ipv6RouterAdvertEntry.
 */

#define IP_MIB_IPV6ROUTERADVERTSENDADVERTS     (1 << 0) 
#define IP_MIB_IPV6ROUTERADVERTMAXINTERVAL     (1 << 1) 
#define IP_MIB_IPV6ROUTERADVERTMININTERVAL     (1 << 2) 
#define IP_MIB_IPV6ROUTERADVERTMANAGEDFLAG     (1 << 3) 
#define IP_MIB_IPV6ROUTERADVERTOTHERCONFIGFLAG (1 << 4) 
#define IP_MIB_IPV6ROUTERADVERTLINKMTU         (1 << 5) 
#define IP_MIB_IPV6ROUTERADVERTREACHABLETIME   (1 << 6) 
#define IP_MIB_IPV6ROUTERADVERTRETRANSMITTIME  (1 << 7) 
#define IP_MIB_IPV6ROUTERADVERTCURHOPLIMIT     (1 << 8) 
#define IP_MIB_IPV6ROUTERADVERTDEFAULTLIFETIME (1 << 9) 
#define IP_MIB_IPV6ROUTERADVERTROWSTATUS       (1 << 10) 

typedef struct {
    gint32   ipv6RouterAdvertIfIndex;              /* na IF-MIB::InterfaceIndex */
    gint32   *ipv6RouterAdvertSendAdverts;         /* rw SNMPv2-TC::TruthValue */
    guint32  *ipv6RouterAdvertMaxInterval;         /* rw [seconds] */
    guint32  *ipv6RouterAdvertMinInterval;         /* rw [seconds] */
    gint32   *ipv6RouterAdvertManagedFlag;         /* rw SNMPv2-TC::TruthValue */
    gint32   *ipv6RouterAdvertOtherConfigFlag;     /* rw SNMPv2-TC::TruthValue */
    guint32  *ipv6RouterAdvertLinkMTU;             /* rw Unsigned32 */
    guint32  *ipv6RouterAdvertReachableTime;       /* rw [milliseconds] */
    guint32  *ipv6RouterAdvertRetransmitTime;      /* rw Unsigned32 [milliseconds] */
    guint32  *ipv6RouterAdvertCurHopLimit;         /* rw */
    guint32  *ipv6RouterAdvertDefaultLifetime;     /* rw [seconds] */
    gint32   *ipv6RouterAdvertRowStatus;           /* rw SNMPv2-TC::RowStatus */
} ip_mib_ipv6RouterAdvertEntry_t;

extern void
ip_mib_get_ipv6RouterAdvertTable(GNetSnmp *s, ip_mib_ipv6RouterAdvertEntry_t ***ipv6RouterAdvertEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6RouterAdvertTable(ip_mib_ipv6RouterAdvertEntry_t **ipv6RouterAdvertEntry);

extern ip_mib_ipv6RouterAdvertEntry_t *
ip_mib_new_ipv6RouterAdvertEntry(void);

extern void
ip_mib_get_ipv6RouterAdvertEntry(GNetSnmp *s, ip_mib_ipv6RouterAdvertEntry_t **ipv6RouterAdvertEntry, gint32 ipv6RouterAdvertIfIndex, gint64 mask, GError **error);

extern void
ip_mib_set_ipv6RouterAdvertEntry(GNetSnmp *s, ip_mib_ipv6RouterAdvertEntry_t *ipv6RouterAdvertEntry, gint64 mask, GError **error);

extern void
ip_mib_free_ipv6RouterAdvertEntry(ip_mib_ipv6RouterAdvertEntry_t *ipv6RouterAdvertEntry);


G_END_DECLS

#endif /* _IP_MIB_H_ */
