// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_FIND_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FIND_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AbndmAlgo

struct AbndmAlgo;       	// "seqan-1.3.1/seqan/find/find_abndm.h"(92)

//____________________________________________________________________________
// AhoCorasick_

struct AhoCorasick_;       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(61)

//____________________________________________________________________________
// AlignTextBanded

template <typename TSpec, typename TFinderCharSetPolicy , typename TPatternCharSetPolicy > struct AlignTextBanded;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(78)

//____________________________________________________________________________
// Bfam

template <typename TSpec > struct Bfam;       	// "seqan-1.3.1/seqan/find/find_bom.h"(90)

//____________________________________________________________________________
// BndmAlgo_

struct BndmAlgo_;       	// "seqan-1.3.1/seqan/find/find_bndm.h"(59)

//____________________________________________________________________________
// DPSearch

template <typename TScore, typename TSpec , typename TFindBeginPatternSpec > struct DPSearch;       	// "seqan-1.3.1/seqan/find/find_score.h"(47)
template <typename TScore, typename TSpec, typename TFindBeginPatternSpec> struct DPSearch;       	// "seqan-1.3.1/seqan/find/find_begin.h"(49)

//____________________________________________________________________________
// DefaultFindBeginPatternSpec

template <typename TScore , typename THasState > struct DefaultFindBeginPatternSpec;       	// "seqan-1.3.1/seqan/find/find_begin.h"(70)

//____________________________________________________________________________
// DefaultFinder

template <typename TObject > struct DefaultFinder;       	// "seqan-1.3.1/seqan/find/find_base.h"(82)

//____________________________________________________________________________
// DefaultPattern

template <typename TObject > struct DefaultPattern;       	// "seqan-1.3.1/seqan/find/find_base.h"(97)

//____________________________________________________________________________
// FileReader

template <typename TFormat, typename TFile, typename TSpec> struct FileReader;       	// "seqan-1.3.1/seqan/find/find_horspool.h"(297)

//____________________________________________________________________________
// FindBeginImpl_

template <typename TFindBeginPatternSpec> struct FindBeginImpl_;       	// "seqan-1.3.1/seqan/find/find_begin.h"(124)

//____________________________________________________________________________
// FindBeginPattern

template <typename TPattern> struct FindBeginPattern;       	// "seqan-1.3.1/seqan/find/find_begin.h"(95)

//____________________________________________________________________________
// FindBeginPatternSpec

template <typename TPattern> struct FindBeginPatternSpec;       	// "seqan-1.3.1/seqan/find/find_begin.h"(86)

//____________________________________________________________________________
// FindBegin_

template <typename TPattern, typename TFindBeginPatternSpec > struct FindBegin_;       	// "seqan-1.3.1/seqan/find/find_begin.h"(107)

//____________________________________________________________________________
// FindInfix

struct FindInfix;       	// "seqan-1.3.1/seqan/find/find_base.h"(56)

//____________________________________________________________________________
// FindPrefix

struct FindPrefix;       	// "seqan-1.3.1/seqan/find/find_base.h"(67)

//____________________________________________________________________________
// Finder

template <typename THaystack, typename TSpec > class Finder;       	// "seqan-1.3.1/seqan/find/find_base.h"(197)

//____________________________________________________________________________
// HammingSimple_

struct HammingSimple_;       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(59)

//____________________________________________________________________________
// Haystack

template <typename TFinder> struct Haystack;       	// "seqan-1.3.1/seqan/find/find_base.h"(116)

//____________________________________________________________________________
// Hierarchical

struct Hierarchical;       	// "seqan-1.3.1/seqan/find/find_pex.h"(44)

//____________________________________________________________________________
// Horspool_

struct Horspool_;       	// "seqan-1.3.1/seqan/find/find_horspool.h"(58)

//____________________________________________________________________________
// MultiBfam

template <typename TSpec > struct MultiBfam;       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(75)

//____________________________________________________________________________
// MultiPatternFinder_

struct MultiPatternFinder_;       	// "seqan-1.3.1/seqan/find/find_multi.h"(43)

//____________________________________________________________________________
// MultipleShiftAnd_

struct MultipleShiftAnd_;       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(59)

//____________________________________________________________________________
// Myers

template <typename TSpec, typename THasState, typename TFindBeginPatternSpec> struct Myers;       	// "seqan-1.3.1/seqan/find/find_begin.h"(53)
template <typename TSpec , typename THasState , typename TFindBeginPatternSpec > struct Myers;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(70)

//____________________________________________________________________________
// MyersLargePattern_

template <typename TNeedle, typename TSpec> struct MyersLargePattern_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(377)

//____________________________________________________________________________
// MyersLargeState_

template <typename TNeedle, typename TSpec> struct MyersLargeState_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(250)

//____________________________________________________________________________
// MyersSmallAlphabet_

template <typename TValue> struct MyersSmallAlphabet_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(163)

//____________________________________________________________________________
// MyersSmallPattern_

template <typename TNeedle, typename TSpec> struct MyersSmallPattern_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(345)

//____________________________________________________________________________
// MyersSmallStateBandedShift_

template <typename TNeedle, typename TSmallAlphabet> struct MyersSmallStateBandedShift_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(211)

//____________________________________________________________________________
// MyersSmallState_

template <typename TNeedle, typename TSpec> struct MyersSmallState_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(197)

//____________________________________________________________________________
// MyersUkkonenHP0_

template <typename T> struct MyersUkkonenHP0_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(152)

//____________________________________________________________________________
// NMatchesAll_

struct NMatchesAll_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(74)

//____________________________________________________________________________
// NMatchesN_

struct NMatchesN_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(73)

//____________________________________________________________________________
// NMatchesNone_

struct NMatchesNone_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(72)

//____________________________________________________________________________
// Needle

template <typename TPattern> struct Needle;       	// "seqan-1.3.1/seqan/find/find_base.h"(133)

//____________________________________________________________________________
// NonHierarchical

struct NonHierarchical;       	// "seqan-1.3.1/seqan/find/find_pex.h"(45)

//____________________________________________________________________________
// Oracle

struct Oracle;       	// "seqan-1.3.1/seqan/find/find_bom.h"(86)

//____________________________________________________________________________
// Pattern

template <typename TNeedle, typename TSpec > class Pattern;       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(64)

//____________________________________________________________________________
// PatternState

template <typename TPattern> struct PatternState;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(477)

//____________________________________________________________________________
// PatternState_

template <typename TNeedle, typename TSpec> class PatternState_;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(284)

//____________________________________________________________________________
// Pex

template <typename TVerification, typename TMultiFinder > struct Pex;       	// "seqan-1.3.1/seqan/find/find_pex.h"(49)

//____________________________________________________________________________
// PexMultiFinder

template <typename T> struct PexMultiFinder;       	// "seqan-1.3.1/seqan/find/find_pex.h"(77)

//____________________________________________________________________________
// PexRange_

template <typename TPosition,typename TScore,typename TVerifier,typename TNeedle> struct PexRange_;       	// "seqan-1.3.1/seqan/find/find_pex.h"(88)

//____________________________________________________________________________
// ScoringScheme

template <typename TNeedle> struct ScoringScheme;       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(150)

//____________________________________________________________________________
// SetHorspool_

struct SetHorspool_;       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(59)

//____________________________________________________________________________
// ShiftAnd_

struct ShiftAnd_;       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(59)

//____________________________________________________________________________
// ShiftOr_

struct ShiftOr_;       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(59)

//____________________________________________________________________________
// Trie

struct Trie;       	// "seqan-1.3.1/seqan/find/find_bom.h"(87)

//____________________________________________________________________________
// WildShiftAnd_

struct WildShiftAnd_;       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(66)

//____________________________________________________________________________
// WuManberHash_

template <typename TNeedle, int Q> struct WuManberHash_;       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(117)

//____________________________________________________________________________
// WuManberImpl_

template <typename TNeedle, int Q> struct WuManberImpl_;       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(125)

//____________________________________________________________________________
// WuManber_

struct WuManber_;       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(58)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AhoCorasick

typedef Tag<AhoCorasick_> AhoCorasick;       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(62)

//____________________________________________________________________________
// BndmAlgo

typedef Tag<BndmAlgo_> BndmAlgo;       	// "seqan-1.3.1/seqan/find/find_bndm.h"(60)

//____________________________________________________________________________
// BomAlgo

typedef Bfam<Oracle> BomAlgo;       	// "seqan-1.3.1/seqan/find/find_bom.h"(92)

//____________________________________________________________________________
// HammingSimple

typedef Tag<HammingSimple_> HammingSimple;       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(60)

//____________________________________________________________________________
// Horspool

typedef Tag<Horspool_> Horspool;       	// "seqan-1.3.1/seqan/find/find_horspool.h"(59)

//____________________________________________________________________________
// MultipatternFinder

typedef Tag<MultiPatternFinder_> MultipatternFinder;       	// "seqan-1.3.1/seqan/find/find_multi.h"(44)

//____________________________________________________________________________
// MultipleShiftAnd

typedef Tag<MultipleShiftAnd_> MultipleShiftAnd;       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(60)

//____________________________________________________________________________
// MyersUkkonen

typedef Myers<FindInfix, True, void> MyersUkkonen;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(96)

//____________________________________________________________________________
// MyersUkkonenBanded

typedef Myers<AlignTextBanded<FindInfix, NMatchesN_, NMatchesN_>, True, void> MyersUkkonenBanded;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(142)

//____________________________________________________________________________
// MyersUkkonenGlobal

typedef Myers<FindPrefix, True, void> MyersUkkonenGlobal;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(112)

//____________________________________________________________________________
// MyersUkkonenGlobalBanded

typedef Myers<AlignTextBanded<FindPrefix, NMatchesN_, NMatchesN_>, True, void> MyersUkkonenGlobalBanded;       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(143)

//____________________________________________________________________________
// PexHierarchical

typedef Pex<Hierarchical,AhoCorasick>   PexHierarchical;       	// "seqan-1.3.1/seqan/find/find_pex.h"(51)

//____________________________________________________________________________
// PexNonHierarchical

typedef Pex<NonHierarchical,AhoCorasick>  PexNonHierarchical;       	// "seqan-1.3.1/seqan/find/find_pex.h"(52)

//____________________________________________________________________________
// SBomAlgo

typedef MultiBfam<Oracle> SBomAlgo;       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(77)

//____________________________________________________________________________
// SetHorspool

typedef Tag<SetHorspool_> SetHorspool;       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(60)

//____________________________________________________________________________
// ShiftAnd

typedef Tag<ShiftAnd_> ShiftAnd;       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(60)

//____________________________________________________________________________
// ShiftOr

typedef Tag<ShiftOr_> ShiftOr;       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(60)

//____________________________________________________________________________
// WildShiftAnd

typedef Tag<WildShiftAnd_> WildShiftAnd;       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(67)

//____________________________________________________________________________
// WuManber

typedef Tag<WuManber_> WuManber;       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(59)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _buildAutomatonMultiBfam

template <typename TNeedle, typename TStrs> inline void _buildAutomatonMultiBfam(Pattern<TNeedle, MultiBfam<Oracle> > & me, TStrs const & strs);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(137)
template <typename TNeedle, typename TStrs> inline void _buildAutomatonMultiBfam(Pattern<TNeedle, MultiBfam<Trie> > & me, TStrs const & strs);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(145)

//____________________________________________________________________________
// _createAcTrie

template <typename TNeedle> inline void _createAcTrie(Pattern<TNeedle, AhoCorasick> & me);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(135)

//____________________________________________________________________________
// _createTree

template <typename TNeedle, typename TMultiFinder> void _createTree(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, unsigned start, unsigned end, unsigned k, unsigned parent, unsigned direction, unsigned idx, unsigned plen);       	// "seqan-1.3.1/seqan/find/find_pex.h"(532)

//____________________________________________________________________________
// _dataHost

template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(164)
template <typename TNeedle, typename TSpec> inline Holder<TNeedle> & _dataHost(Pattern<TNeedle, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(170)

//____________________________________________________________________________
// _findAbndmLargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndmLargeNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(400)

//____________________________________________________________________________
// _findAbndmSmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findAbndmSmallNeedle(TFinder & finder, Pattern<TNeedle, AbndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(266)

//____________________________________________________________________________
// _findBeginInit

template <typename TPattern, typename TNeedle> inline void _findBeginInit(TPattern & pattern, TNeedle & needle_);       	// "seqan-1.3.1/seqan/find/find_begin.h"(322)

//____________________________________________________________________________
// _findBndmLargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndmLargeNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(190)

//____________________________________________________________________________
// _findBndmSmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findBndmSmallNeedle(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(159)

//____________________________________________________________________________
// _findHammingSimpleCharsEqual

template <typename TAlphabet, typename TNeedle> inline bool _findHammingSimpleCharsEqual(TAlphabet const & a, TAlphabet const & b, Pattern<TNeedle, HammingSimple> const &);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(162)
template <typename TNeedle> inline bool _findHammingSimpleCharsEqual(Dna5 const & ndlChar, Dna5 const & hstckChar, Pattern<TNeedle, HammingSimple> const & pattern);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(168)
template <typename TNeedle> inline bool _findHammingSimpleCharsEqual(Dna5Q const & a, Dna5 const & b, Pattern<TNeedle, HammingSimple> const & pattern);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(180)
template <typename TNeedle> inline bool _findHammingSimpleCharsEqual(Dna5 const & a, Dna5Q const & b, Pattern<TNeedle, HammingSimple> const & pattern);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(186)
template <typename TNeedle> inline bool _findHammingSimpleCharsEqual(Dna5Q const & a, Dna5Q const & b, Pattern<TNeedle, HammingSimple> const & pattern);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(192)

//____________________________________________________________________________
// _findHorspool

template <typename TFinder, typename TNeedle2> bool _findHorspool(TFinder & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(140)
template <typename TValue, typename TFormat, typename TFile, typename FileReaderTSpec, typename TFinderSpec, typename TNeedle2> bool _findHorspool(Finder<String<TValue, FileReader<TFormat, TFile, FileReaderTSpec> >, TFinderSpec > & finder, Pattern<TNeedle2, Horspool> & me, bool find_first);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(304)

//____________________________________________________________________________
// _findMyersLargePatterns

template <typename TFinder, typename TNeedle, typename TSpec, typename THasState, typename THasState2, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersLargePatterns (TFinder & finder, Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<TSpec, THasState2, TFindBeginPatternSpec> > & state, TSize haystack_length);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1285)

//____________________________________________________________________________
// _findMyersSmallPatterns

template <typename TFinder, typename TNeedle, typename TSpec, typename THasState, typename THasState2, typename TFindBeginPatternSpec, typename TSize> inline bool _findMyersSmallPatterns( TFinder & finder, Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<TSpec, THasState2, TFindBeginPatternSpec> > & state, TSize haystack_length);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1401)

//____________________________________________________________________________
// _findMyersSmallPatternsBanded

template <typename TFinder, typename TNeedle, typename TNeedle2, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec> finline bool _findMyersSmallPatternsBanded( TFinder & finder, TNeedle const & needle, PatternState_<TNeedle2, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1460)

//____________________________________________________________________________
// _findScoreSimpleProportional

template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> bool _findScoreSimpleProportional(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(376)

//____________________________________________________________________________
// _findShiftAndLargeNeedle

template <typename TFinder, typename TNeedle> bool _findShiftAndLargeNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(330)
template <typename TFinder, typename TNeedle> inline bool _findShiftAndLargeNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(625)
template <typename TFinder, typename TNeedle> inline bool _findShiftAndLargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(236)

//____________________________________________________________________________
// _findShiftAndSmallNeedle

template <typename TFinder, typename TNeedle> bool _findShiftAndSmallNeedle(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(276)
template <typename TFinder, typename TNeedle> inline bool _findShiftAndSmallNeedle(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(602)
template <typename TFinder, typename TNeedle> inline bool _findShiftAndSmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(213)

//____________________________________________________________________________
// _findShiftOrLargeNeedle

template <typename TFinder, typename TNeedle> inline bool _findShiftOrLargeNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(269)

//____________________________________________________________________________
// _findShiftOrSmallNeedle

template <typename TFinder, typename TNeedle> inline bool _findShiftOrSmallNeedle(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(233)

//____________________________________________________________________________
// _finderInit

template <typename TNeedle> inline void _finderInit(Pattern<TNeedle, HammingSimple> & me);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(133)

//____________________________________________________________________________
// _finderSetNonEmpty

template <typename T> inline void _finderSetNonEmpty(T & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(568)
template <typename THaystack, typename TSpec> inline void _finderSetNonEmpty(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(577)

//____________________________________________________________________________
// _getCharacterClass

template <typename TValue,typename TNeedle2> String <unsigned> _getCharacterClass(TNeedle2 const & host,unsigned start,unsigned end);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(296)

//____________________________________________________________________________
// _getRoot

template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(238)
template <typename TNeedle, typename TMultiFinder> int _getRoot(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &);       	// "seqan-1.3.1/seqan/find/find_pex.h"(245)

//____________________________________________________________________________
// _isUnsigned

inline bool _isUnsigned(String<char> const & number);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(134)

//____________________________________________________________________________
// _lengthWithoutWildcards

template <typename TNeedle> unsigned _lengthWithoutWildcards(TNeedle const & needle);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(224)

//____________________________________________________________________________
// _myersAdjustBitmask

template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec, typename TValue, typename TShift> finline void _myersAdjustBitmask(PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > &state, TValue const value, TShift, True);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(876)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec, typename TValue, typename TShift> finline void _myersAdjustBitmask(PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > &state, TValue const value, TShift const shift, False);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(929)

//____________________________________________________________________________
// _myersGetBitmask

template <typename TNeedle, typename TSpec, typename TValue, typename TShift> finline typename PatternState_<TNeedle, TSpec>::TWord _myersGetBitmask(PatternState_<TNeedle, TSpec> &state, TValue const value, TShift, True);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(902)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec, typename TValue, typename TShift> finline typename PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> >::TWord _myersGetBitmask(PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > &state, TValue const value, TShift const shift, False);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(947)

//____________________________________________________________________________
// _myersPostInit

template <typename TNeedle, typename TSpec> finline void _myersPostInit(PatternState_<TNeedle, TSpec> &state, True);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(867)
template <typename TNeedle, typename TSpec> finline void _myersPostInit(PatternState_<TNeedle, TSpec> &, False);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(923)

//____________________________________________________________________________
// _myersPreInit

template <typename TNeedle, typename TSpec> finline void _myersPreInit(PatternState_<TNeedle, TSpec> &state, True);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(858)
template <typename TNeedle, typename TSpec> finline void _myersPreInit(PatternState_<TNeedle, TSpec> &state, False);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(914)

//____________________________________________________________________________
// _myersSetHost

template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void _myersSetHost(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > &, TNeedle2 const &);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(639)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void _myersSetHost(Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > & pattern, TNeedle2 const & ndl);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(645)

//____________________________________________________________________________
// _patternFirstInit

template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(494)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void _patternFirstInit(Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > & pattern, TNeedle2 & ndl);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(535)

//____________________________________________________________________________
// _patternInit

template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(233)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Horspool> &);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(130)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AbndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(224)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline void _patternInit (Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(310)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, SetHorspool> & me);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(190)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(553)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(202)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, ShiftOr> & me);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(202)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, WuManber> & me);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(457)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, BndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(146)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > &me, TFinder &);       	// "seqan-1.3.1/seqan/find/find_pex.h"(291)
template <typename TNeedle, typename TFinder, typename TMultiFinder> void _patternInit(Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > &me, TFinder &);       	// "seqan-1.3.1/seqan/find/find_pex.h"(570)
template <typename TNeedle, typename TSpec> inline void _patternInit (Pattern<TNeedle, Bfam<TSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_bom.h"(191)
template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, AhoCorasick> & me);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(241)
template <typename TNeedle, typename TAutomaton> inline void _patternInit (Pattern<TNeedle, MultiBfam<TAutomaton> > & me);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(245)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec, typename TFinder> inline bool _patternInit(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & state, TFinder &);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(815)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TFinder> inline bool _patternInit(Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & pattern, TFinder & finder);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1267)

//____________________________________________________________________________
// _patternInitSmallStateBanded

template <typename TFinder, typename TNeedle, typename TNeedle2, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec> inline bool _patternInitSmallStateBanded( TFinder &finder, TNeedle2 const & needle, PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(981)

//____________________________________________________________________________
// _patternMatchNOfFinder

template <typename TNeedle> inline void _patternMatchNOfFinder(Pattern<TNeedle, HammingSimple> & pattern, bool matchN);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(102)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline void _patternMatchNOfFinder(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(619)
template <typename TNeedle, typename TSpec, typename THasState> inline void _patternMatchNOfFinder(Pattern<TNeedle, Myers<TSpec, THasState, void> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(629)

//____________________________________________________________________________
// _patternMatchNOfFinderImpl

template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline void _patternMatchNOfFinderImpl(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(598)

//____________________________________________________________________________
// _patternMatchNOfPattern

template <typename TNeedle> inline void _patternMatchNOfPattern(Pattern<TNeedle, HammingSimple> & pattern, bool matchN);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(91)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline void _patternMatchNOfPattern(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(579)
template <typename TNeedle, typename TSpec, typename THasState> inline void _patternMatchNOfPattern(Pattern<TNeedle, Myers<TSpec, THasState, void> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(589)

//____________________________________________________________________________
// _patternMatchNOfPatternImpl

template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline void _patternMatchNOfPatternImpl(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, bool match);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(543)

//____________________________________________________________________________
// _printMask

inline void _printMask(String <unsigned> const & mask,String <char> name);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(47)
inline void _printMask(String <unsigned> const & mask,unsigned start, unsigned len,String <char> name);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(60)

//____________________________________________________________________________
// _printR

template <typename TNeedle> void _printR(Pattern<TNeedle, AbndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(155)

//____________________________________________________________________________
// _setFinderEnd

template <typename THaystack, typename TSpec> inline void _setFinderEnd(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(318)
template <typename THaystack, typename TSpec, typename TPosition> inline void _setFinderEnd(Finder<THaystack, TSpec> & me, TPosition end_pos);       	// "seqan-1.3.1/seqan/find/find_base.h"(326)

//____________________________________________________________________________
// _setFinderLength

template <typename THaystack, typename TSpec, typename TSize> inline void _setFinderLength(Finder<THaystack, TSpec> & me, TSize _length);       	// "seqan-1.3.1/seqan/find/find_base.h"(337)

//____________________________________________________________________________
// _setHostMultiBfam

template <typename TNeedle, typename TAutomaton, typename TNeedle2> void _setHostMultiBfam(Pattern<TNeedle, MultiBfam<TAutomaton> > & me, TNeedle2 const & needle_);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(154)

//____________________________________________________________________________
// _setHostWuManber

template <typename TNeedle, typename TNeedle2> void _setHostWuManber(Pattern<TNeedle, WuManber> & me, TNeedle2 const & needle_);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(351)

//____________________________________________________________________________
// _startVerifyMultiBfam

template <typename TNeedle, typename TAutomaton, typename THaystackIterator> inline bool _startVerifyMultiBfam(Pattern<TNeedle, MultiBfam<TAutomaton> > &, THaystackIterator);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(260)
template <typename TNeedle, typename THaystackIterator> inline bool _startVerifyMultiBfam(Pattern<TNeedle, MultiBfam<Oracle> > & me, THaystackIterator tit);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(269)

//____________________________________________________________________________
// _stateInit

template <typename TFinder, typename TNeedle, typename TNeedle2, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec> bool _stateInit( TFinder &finder, TNeedle const & needle, PatternState_<TNeedle2, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1215)

//____________________________________________________________________________
// _validate

template <typename TNeedle2> bool _validate(TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(146)

//____________________________________________________________________________
// atBegin

template <typename THaystack, typename TSpec> inline bool atBegin(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(587)

//____________________________________________________________________________
// atEnd

template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(595)

//____________________________________________________________________________
// begin

template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack, Tag<TTag> const>::Type begin(Finder<THaystack, TSpec> & me, Tag<TTag> const tag);       	// "seqan-1.3.1/seqan/find/find_base.h"(367)
template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack const, Tag<TTag> const>::Type begin(Finder<THaystack, TSpec> const & me, Tag<TTag> const tag);       	// "seqan-1.3.1/seqan/find/find_base.h"(376)

//____________________________________________________________________________
// beginPosition

template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & beginPosition(Pattern<TNeedle, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(197)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & beginPosition(Pattern<TNeedle, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(203)
template <typename THaystack, typename TSpec> inline typename Position<THaystack>::Type beginPosition(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(347)
template <typename THaystack, typename TSpec> inline typename Position<THaystack const>::Type beginPosition(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(355)

//____________________________________________________________________________
// clear

template <typename THaystack, typename TSpec> inline void clear(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(558)

//____________________________________________________________________________
// container

template <typename THaystack, typename TSpec> inline typename Parameter_<THaystack>::Type container(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(492)
template <typename THaystack, typename TSpec> inline typename Parameter_<THaystack>::Type container(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(500)

//____________________________________________________________________________
// empty

template <typename THaystack, typename TSpec> inline bool empty(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(550)

//____________________________________________________________________________
// end

template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack, Tag<TTag> const>::Type end(Finder<THaystack, TSpec> & me, Tag<TTag> const tag);       	// "seqan-1.3.1/seqan/find/find_base.h"(407)
template <typename THaystack, typename TSpec, typename TTag> inline typename Iterator<THaystack const, Tag<TTag> const>::Type end(Finder<THaystack, TSpec> const & me, Tag<TTag> const tag);       	// "seqan-1.3.1/seqan/find/find_base.h"(416)

//____________________________________________________________________________
// endPosition

template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> >::Type & endPosition(Pattern<TNeedle, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(221)
template <typename TNeedle, typename TSpec> inline typename Position<Pattern<TNeedle, TSpec> const >::Type & endPosition(Pattern<TNeedle, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(227)
template <typename THaystack, typename TSpec> inline typename Position<THaystack>::Type endPosition(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(387)
template <typename THaystack, typename TSpec> inline typename Position<THaystack const>::Type endPosition(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(395)

//____________________________________________________________________________
// find

template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(405)
template <typename TFinder, typename TNeedle2> bool find(TFinder & finder, Pattern<TNeedle2, Horspool> & me);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(440)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(604)
template <typename TFinder, typename TNeedle> inline bool find (TFinder & finder, Pattern<TNeedle, AbndmAlgo > & me, int const k);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(630)
template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(479)
template <typename TFinder, typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline bool find(TFinder & finder, Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, int const limit_);       	// "seqan-1.3.1/seqan/find/find_score.h"(489)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, SetHorspool> & me);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(228)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(666)
template <typename TFinder, typename TNeedle> inline bool find(TFinder &finder, Pattern<TNeedle, HammingSimple> &me);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(199)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(278)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, ShiftOr> & me);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(313)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, WuManber> & me);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(468)
template <typename THaystack, typename THaystack2, typename TNeedle> inline bool find(Finder<THaystack, MultipatternFinder> & me, THaystack2 & hstk, TNeedle const & ndl);       	// "seqan-1.3.1/seqan/find/find_multi.h"(143)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, Simple> & me);       	// "seqan-1.3.1/seqan/find/find_simple.h"(118)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, BndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(240)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<NonHierarchical, TMultiFinder > > & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(380)
template <typename TFinder, typename TNeedle, typename TMultiFinder> inline bool find (TFinder & finder, Pattern<TNeedle, Pex<Hierarchical, TMultiFinder > > & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(613)
template <typename TFinder, typename TNeedle, typename TSpec> inline bool find(TFinder & finder, Pattern<TNeedle, Bfam<TSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_bom.h"(203)
template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, AhoCorasick> & me);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(261)
template <typename TFinder, typename TAutomaton, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, MultiBfam<TAutomaton> > & me);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(293)
template <typename TFinder, typename TNeedle, typename TNeedle2, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, TNeedle const & needle, PatternState_<TNeedle2, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1549)
template <typename TFinder, typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename THasState, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1588)
template <typename TFinder, typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1597)
template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1641)
template <typename TFinder, typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern, PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & state, int const minScore);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1651)
template <typename TFinder, typename TNeedle, typename TNeedle2, typename TSpec, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, TNeedle const & needle, PatternState_<TNeedle2, Myers<TSpec, True, TFindBeginPatternSpec> > & state, int const minScore);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1661)
template <typename TFinder, typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline bool find (TFinder & finder, Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & pattern, int const minScore);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(1670)

//____________________________________________________________________________
// findBegin

template <typename TFinder, typename TPattern> inline bool findBegin(TFinder & finder, TPattern & pattern);       	// "seqan-1.3.1/seqan/find/find_begin.h"(354)
template <typename TFinder, typename TPattern, typename TLimit> inline bool findBegin(TFinder & finder, TPattern & pattern, TLimit limit);       	// "seqan-1.3.1/seqan/find/find_begin.h"(363)

//____________________________________________________________________________
// getBeginScore

template <typename TPattern> inline typename Value<typename ScoringScheme<TPattern>::Type>::Type getBeginScore(TPattern & pattern);       	// "seqan-1.3.1/seqan/find/find_begin.h"(386)

//____________________________________________________________________________
// getScore

template <typename TNeedle> int getScore(Pattern<TNeedle, AbndmAlgo > & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(257)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Value<TScore>::Type getScore(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(301)
template <typename TNeedle> inline int getScore(const Pattern<TNeedle, HammingSimple> &me);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(147)
template <typename TNeedle, typename TVerification, typename TMultiFinder> int getScore(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(255)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline int getScore(PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > const & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(799)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline int getScore(Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > const & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(805)

//____________________________________________________________________________
// goBegin

template <typename THaystack, typename TSpec> inline void goBegin(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(611)

//____________________________________________________________________________
// goEnd

template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(626)

//____________________________________________________________________________
// haystack

template <typename TObject > inline typename Haystack<TObject>::Type & haystack(TObject &obj);       	// "seqan-1.3.1/seqan/find/find_base.h"(792)
template <typename TObject > inline typename Haystack<TObject const>::Type & haystack(TObject const &obj);       	// "seqan-1.3.1/seqan/find/find_base.h"(798)

//____________________________________________________________________________
// host

template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, TSpec> >::Type & host(Pattern<TNeedle, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(263)
template <typename TNeedle, typename TSpec> inline typename Host<Pattern<TNeedle, TSpec> const>::Type & host(Pattern<TNeedle, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(271)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(251)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, MultipleShiftAnd>const>::Type & host(Pattern<TNeedle, MultipleShiftAnd> const & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(259)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo> >::Type & host(Pattern<TNeedle, AbndmAlgo> & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(238)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, AbndmAlgo> const>::Type & host(Pattern<TNeedle, AbndmAlgo> const & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(246)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > >::Type & host(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(174)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const>::Type & host(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(182)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> & me);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(203)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, SetHorspool>const>::Type & host(Pattern<TNeedle, SetHorspool> const & me);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(211)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(585)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WildShiftAnd>const>::Type & host(Pattern<TNeedle, WildShiftAnd> const & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(593)
template <typename TNeedle> inline TNeedle host(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(151)
template <typename TNeedle> inline TNeedle host(Pattern<TNeedle, ShiftAnd> & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(174)
template <typename TNeedle> inline TNeedle host(Pattern<TNeedle, ShiftOr> const & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(151)
template <typename TNeedle> inline TNeedle host(Pattern<TNeedle, ShiftOr> & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(174)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WuManber> >::Type & host(Pattern<TNeedle, WuManber> & me);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(430)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, WuManber> const>::Type & host(Pattern<TNeedle, WuManber> const & me);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(438)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > >::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(221)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline typename Host<Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const>::Type & host(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(229)
template <typename TNeedle, typename TAutomaton> inline typename Host<Pattern<TNeedle, MultiBfam<TAutomaton> > >::Type & host(Pattern<TNeedle, MultiBfam<TAutomaton> > & me);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(218)
template <typename TNeedle, typename TAutomaton> inline typename Host<Pattern<TNeedle, MultiBfam<TAutomaton> > const>::Type & host(Pattern<TNeedle, MultiBfam<TAutomaton> > const & me);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(226)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename THasState, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > >::Type & host(Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(677)
template <typename TNeedle, typename TSpec, typename TFinderCSP, typename TPatternCSP, typename THasState, typename TFindBeginPatternSpec> inline typename Host<Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > const>::Type & host(Pattern<TNeedle, Myers<AlignTextBanded<TSpec, TFinderCSP, TPatternCSP>, THasState, TFindBeginPatternSpec> > const & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(686)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline TNeedle host(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(695)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline TNeedle host(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(719)
template <typename THaystack, typename TSpec> inline typename Parameter_<THaystack>::Type host(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(476)
template <typename THaystack, typename TSpec> inline typename Parameter_<THaystack>::Type host(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(484)

//____________________________________________________________________________
// hostIterator

template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type & hostIterator(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(532)
template <typename THaystack, typename TSpec> inline typename Iterator<THaystack, Rooted>::Type const & hostIterator(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(540)

//____________________________________________________________________________
// infix

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type infix(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(456)
template <typename THaystack, typename TSpec> inline typename Infix<THaystack const>::Type infix(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(465)

//____________________________________________________________________________
// init

template <typename THaystack> inline void init(Finder<THaystack, MultipatternFinder> & me);       	// "seqan-1.3.1/seqan/find/find_multi.h"(131)

//____________________________________________________________________________
// length

template <typename THaystack, typename TSpec> inline typename Size<THaystack>::Type length(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(427)
template <typename THaystack, typename TSpec> inline typename Size<THaystack const>::Type length(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(434)

//____________________________________________________________________________
// needle

template <typename TObject > inline typename Needle<TObject>::Type & needle(TObject &obj);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(298)
template <typename TObject > inline typename Needle<TObject const>::Type & needle(TObject const &obj);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(305)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> >::Type & needle(Pattern<TNeedle, TSpec> & obj);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(315)
template <typename TNeedle, typename TSpec > inline typename Needle< Pattern<TNeedle, TSpec> const>::Type & needle(Pattern<TNeedle, TSpec> const & obj);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(322)
template <typename TNeedle> inline TNeedle needle(Pattern<TNeedle, ShiftAnd> const & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(184)
template <typename TNeedle> inline TNeedle needle(Pattern<TNeedle, ShiftAnd> & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(192)
template <typename TNeedle> inline TNeedle needle(Pattern<TNeedle, ShiftOr> const & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(184)
template <typename TNeedle> inline TNeedle needle(Pattern<TNeedle, ShiftOr> & pattern);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(192)
template <typename THaystack> inline unsigned int & needle(Finder<THaystack, MultipatternFinder> & me);       	// "seqan-1.3.1/seqan/find/find_multi.h"(105)
template <typename THaystack> inline unsigned int const & needle(Finder<THaystack, MultipatternFinder> const & me);       	// "seqan-1.3.1/seqan/find/find_multi.h"(112)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline TNeedle needle(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > const & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(730)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec> inline TNeedle needle(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(738)

//____________________________________________________________________________
// operator+

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator+ (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "seqan-1.3.1/seqan/find/find_base.h"(704)

//____________________________________________________________________________
// operator++

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator++(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(688)

//____________________________________________________________________________
// operator+=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator+= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "seqan-1.3.1/seqan/find/find_base.h"(717)

//____________________________________________________________________________
// operator-

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> const operator- (Finder<THaystack, TSpec> const & left, TIntegral right);       	// "seqan-1.3.1/seqan/find/find_base.h"(730)
template <typename THaystack, typename TSpec, typename TIntegral> inline typename Difference<Finder<THaystack, TSpec> const>::Type operator- (Finder<THaystack, TSpec> const & left, Finder<THaystack, TSpec> const & right);       	// "seqan-1.3.1/seqan/find/find_base.h"(738)

//____________________________________________________________________________
// operator--

template <typename THaystack, typename TSpec> inline Finder<THaystack, TSpec> & operator--(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(679)

//____________________________________________________________________________
// operator-=

template <typename THaystack, typename TSpec, typename TIntegral> inline Finder<THaystack, TSpec> & operator-= (Finder<THaystack, TSpec> & left, TIntegral right);       	// "seqan-1.3.1/seqan/find/find_base.h"(751)

//____________________________________________________________________________
// position

template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, MultipleShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(270)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, SetHorspool> & me);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(222)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, WuManber> & me);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(448)
template <typename TNeedle> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, AhoCorasick> & me);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(255)
template <typename TNeedle, typename TAutomaton> inline typename Size<TNeedle>::Type position(Pattern<TNeedle, MultiBfam<TAutomaton> > & me);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(236)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(637)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, TSpec> >::Type position(Finder<THaystack, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_base.h"(646)

//____________________________________________________________________________
// score

template <typename TNeedle> inline int score(const Pattern<TNeedle, HammingSimple> &me);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(140)

//____________________________________________________________________________
// scoreLimit

template <typename TNeedle> inline int scoreLimit(Pattern<TNeedle, AbndmAlgo > const & me);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(580)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline typename Value<TScore>::Type scoreLimit(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > const & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(256)
template <typename TNeedle, typename TVerification, typename TMultiFinder> inline int scoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > const & me);       	// "seqan-1.3.1/seqan/find/find_pex.h"(266)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline int scoreLimit(PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > const & state);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(751)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec> inline int scoreLimit(Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > const & pattern);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(759)

//____________________________________________________________________________
// scoringScheme

template <typename TNeedle, typename TSpec> inline typename ScoringScheme<Pattern<TNeedle, TSpec> >::Type scoringScheme(Pattern<TNeedle, TSpec> &);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(362)
template <typename TNeedle, typename TSpec> inline typename ScoringScheme<Pattern<TNeedle, TSpec> const>::Type scoringScheme(Pattern<TNeedle, TSpec> const &);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(369)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec> inline TScore const & scoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me);       	// "seqan-1.3.1/seqan/find/find_score.h"(214)

//____________________________________________________________________________
// segment

template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(244)
template <typename TNeedle, typename TSpec> inline typename Infix<TNeedle>::Type segment(Pattern<TNeedle, TSpec> const & me);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(251)

//____________________________________________________________________________
// setBeginPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setBeginPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(212)

//____________________________________________________________________________
// setContainer

template <typename THaystack, typename TSpec> inline void setContainer(Finder<THaystack, TSpec> & me, typename Parameter_<THaystack>::Type container_);       	// "seqan-1.3.1/seqan/find/find_base.h"(521)

//____________________________________________________________________________
// setEndPosition

template <typename TNeedle, typename TSpec, typename TPosition> inline void setEndPosition(Pattern<TNeedle, TSpec> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(235)

//____________________________________________________________________________
// setHaystack

template <typename THaystack, typename TSpec > inline void setHaystack(Finder<THaystack, TSpec> &obj, THaystack const &hstk);       	// "seqan-1.3.1/seqan/find/find_base.h"(774)

//____________________________________________________________________________
// setHost

template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 const & ndl);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(182)
template <typename TNeedle, typename TSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, TSpec> & me, TNeedle2 & ndl);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(189)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(139)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, MultipleShiftAnd> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_multiple_shiftand.h"(224)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & me, TNeedle2 const & ndl);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(91)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, Horspool> & horsp, TNeedle2 & ndl);       	// "seqan-1.3.1/seqan/find/find_horspool.h"(122)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 const& needle);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(168)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AbndmAlgo> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(216)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TNeedle2 & ndl);       	// "seqan-1.3.1/seqan/find/find_score.h"(194)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TNeedle2> void setHost(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TNeedle2 const & ndl);       	// "seqan-1.3.1/seqan/find/find_score.h"(202)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(127)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, SetHorspool> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_set_horspool.h"(181)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(324)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, WildShiftAnd> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(544)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, HammingSimple> & me, const TNeedle2 & needle, int k);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(113)
template <typename TNeedle, typename TNeedle2> void setHost(Pattern<TNeedle, HammingSimple> &horsp, TNeedle2 &ndl, int k);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(126)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, ShiftAnd> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(98)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, ShiftAnd> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_shiftand.h"(142)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, ShiftOr> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(98)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, ShiftOr> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_shiftor.h"(142)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, WuManber> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(413)
template <typename TNeedle, typename TNeedle2> inline void setHost(Pattern<TNeedle, WuManber> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_wumanber.h"(421)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, Simple> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_simple.h"(102)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, Simple> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_simple.h"(108)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 const& needle);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(97)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, BndmAlgo> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_bndm.h"(137)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_pex.h"(201)
template <typename TNeedle, typename TNeedle2, typename TVerification, typename TMultiFinder> void setHost (Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_pex.h"(212)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Bfam<Oracle> > & me, TNeedle2 const& needle);       	// "seqan-1.3.1/seqan/find/find_bom.h"(151)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Bfam<Trie> > & me, TNeedle2 const& needle);       	// "seqan-1.3.1/seqan/find/find_bom.h"(163)
template <typename TNeedle, typename TNeedle2, typename TSpec> inline void setHost (Pattern<TNeedle, Bfam<TSpec> > & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_bom.h"(182)
template <typename TNeedle, typename TNeedle2> void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(203)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, AhoCorasick> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_ahocorasick.h"(232)
template <typename TNeedle, typename TAutomaton, typename TNeedle2> void setHost (Pattern<TNeedle, MultiBfam<TAutomaton> > & me, TNeedle2 const & needle);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(201)
template <typename TNeedle, typename TAutomaton, typename TNeedle2> inline void setHost(Pattern<TNeedle, MultiBfam<TAutomaton> > & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/find/find_multiple_bfam.h"(209)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, TNeedle2 & ndl);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(652)
template <typename TNeedle, typename TSpec, typename THasState, typename TFindBeginPatternSpec, typename TNeedle2> inline void setHost(Pattern<TNeedle, Myers<TSpec, THasState, TFindBeginPatternSpec> > & pattern, TNeedle2 const & ndl);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(663)
template <typename THaystack, typename TSpec> inline void setHost(Finder<THaystack, TSpec> & me, typename Parameter_<THaystack>::Type container_);       	// "seqan-1.3.1/seqan/find/find_base.h"(511)

//____________________________________________________________________________
// setNeedle

template <typename TNeedle, typename TSpec > inline void setNeedle(Pattern<TNeedle, TSpec> &obj, TNeedle const &ndl);       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(340)
template <typename THaystack> inline void setNeedle(Finder<THaystack, MultipatternFinder> & me, unsigned int const needleIndex_);       	// "seqan-1.3.1/seqan/find/find_multi.h"(121)

//____________________________________________________________________________
// setPosition

template <typename THaystack, typename TSpec, typename TPosition> inline void setPosition(Finder<THaystack, TSpec> & me, TPosition pos_);       	// "seqan-1.3.1/seqan/find/find_base.h"(669)

//____________________________________________________________________________
// setScoreLimit

template <typename TNeedle, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, AbndmAlgo > & me, TScoreValue _limit);       	// "seqan-1.3.1/seqan/find/find_abndm.h"(593)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScoreValue _limit);       	// "seqan-1.3.1/seqan/find/find_score.h"(277)
template <typename TNeedle> inline void setScoreLimit(Pattern<TNeedle, HammingSimple> & me, int _limit);       	// "seqan-1.3.1/seqan/find/find_hamming_simple.h"(154)
template <typename TNeedle, typename TScoreValue,typename TVerification, typename TMultiFinder> inline void setScoreLimit(Pattern<TNeedle, Pex<TVerification,TMultiFinder > > & me, TScoreValue _limit);       	// "seqan-1.3.1/seqan/find/find_pex.h"(279)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TScoreValue> inline void setScoreLimit(PatternState_<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & state, TScoreValue minScore);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(773)
template <typename TNeedle, typename TSpec, typename TFindBeginPatternSpec, typename TScoreValue> inline void setScoreLimit(Pattern<TNeedle, Myers<TSpec, True, TFindBeginPatternSpec> > & pattern, TScoreValue minScore);       	// "seqan-1.3.1/seqan/find/find_myers_ukkonen.h"(783)

//____________________________________________________________________________
// setScoringScheme

template <typename TNeedle, typename TSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, TSpec> & , TScore2 & );       	// "seqan-1.3.1/seqan/find/find_pattern_base.h"(391)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScore2 & score);       	// "seqan-1.3.1/seqan/find/find_score.h"(226)
template <typename TNeedle, typename TScore, typename TSpec, typename TFindBeginPatternSpec, typename TScore2> inline void setScoringScheme(Pattern<TNeedle, DPSearch<TScore, TSpec, TFindBeginPatternSpec> > & me, TScore2 const & score);       	// "seqan-1.3.1/seqan/find/find_score.h"(235)

//____________________________________________________________________________
// valid

template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(566)
template <typename TNeedle> inline bool valid(Pattern <TNeedle,WildShiftAnd> const & me);       	// "seqan-1.3.1/seqan/find/find_wild_shiftand.h"(574)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

