3.4 エンベロープ・サンプル

# エンベロープ・サンプル
ADSRエンベロープを用いて、サンプルのデュレーション（再生時間）とアンプ（音量）を編集することもできます。しかしながら、シンセのADSRエンベロープとは少しだけ異なったように作用します。サンプルに使用するエンベロープは、サンプルのアンプとデュレーションを減らすことしかできません。決して増やすことはできないのです。サンプルは、それが再生され終わったときか、エンベロープが完了したときのいずれかで停止します。どちらが先でも停止します。非常に長い`release:`を使ったとしても、サンプルのデュレーションは延長されません。

## アーメン・エンベロープ

わたしたちのお気に入りのフレーズ、アーメン・ブレイクに戻ります。

```
sample :loop_amen
```

オプションが設定されていない場合、全サンプルがフル・アンプ（最大音量）で聞こえます。
もし1秒間のフェード・インを使いたい場合、`attack:`パラメータを使います。
（フェード・インとは徐々に音が大きくなることです。）

```
sample :loop_amen, attack: 1
```

もっと短いフェード・インの場合は、`attack:`の値を小さくします。

```
sample :loop_amen, attack: 0.3
```

## オート・サステイン

ADSR エンベロープの特徴が標準的なシンセ・エンベロープと異なる点は、*サステイン（持続時間）*の値です。
標準的なシンセのエンベロープでは、もし手動で変更しなければ、 0 に設定されています。ですが、
サンプルでは、サステインの値は通常、*魔法のように全自動*にセットされます。サステインの時間は、サンプルの残りを
演奏するように調整されます。デフォルトの値を渡さないときに、サンプルがフルで流れるのはこのためです。
アタック、ディケイ、サステイン、リリース(この４つの頭文字がADSR)の値が全て 0 のときは、何の音も聞こえません。
Sonic Piはサンプルの長さがどれくらいなのか計算し、アタック、ディケイ、リリース・タイムを差し引いて、
あなたのサステイン・タイムの結果を使用します。もし、アタック、ディケイ、リリースの値が
サンプルのデュレーションより長く追加された場合、サステインは 0 にセットされます。

## フェード・アウト

これまでのことをを求するために、我らがアーメン・ブレイクをさらに詳細にみてみます。Sonic Piにサンプルがどれくらいの長さなのか尋ねてみます。

```
print sample_duration :loop_amen
```

1秒間のサンプルの長さは 1.753310657596372 と答えるでしょう。ここでは、便宜的に1.75 としますリリース・タイムを  0.75 にすると、驚くべきことが起こります。

```
sample :loop_amen, release: 0.75
```

サンプルの最初の1秒をフル・アンプで再生し、最後の 0.75 秒はフェード・アウトします。これが *オート・サステイン*の動きです。標準では、`release:`はいつもサンプルの最後から動作します。
もしサンプルの長さが10.75 秒なら、最初の10秒はフル・アンプで再生し、最後の0.75秒はフェード・アウトします。

通常、`release:`はサンプルの最後でフェード・アウトするということを覚えておいてください。

## フェード・インとフェード・アウト

サンプルのデュレーションの間にフェード・アウトとインを行うには
`attack:`と`release:`の両方を使うことができます。オート・サステインの仕組みと一緒に、
使用できます。

```
sample :loop_amen, attack: 0.75, release: 0.75
```

サンプルのアーメンブレイク全体のデュレーションは1.75秒なので、
アタックとリリースの時間が1.5秒まで追加されると、
サステインは自動的に0.25秒にセットされます。
これで簡単にサンプルをフェード・イン、アウトすることができます。

## 明白なサステイン

手動で`sustain:`を 0 などにセットして、通常のADSRシンセの挙動に簡単に戻すこともできます。

```
sample :loop_amen, sustain: 0, release: 0.75
```

いま、サンプルはトータルで0.75秒間だけ再生されました。`attack:`と`decay:`の通常値0ですので、
サンプルはフル・アンプ（最大音量）に直接変わり、0秒間サスティン(持続)し、リリースの0.75秒間で0アンプに戻ります。

## 打楽器のシンバル
この仕様を、長いサウンドのサンプルを短く、より打楽器的にするために、効果的に使うことができます。
`:drum_cymbal_open`:

```
sample :drum_cymbal_open
```

上のサンプルでは一定時間シンバルの音が鳴っているのが聞こえます。ですが、もっとパーカッシブ（打楽器的）にしてみましょう。

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0, release: 0.1
```

シンバルを叩いた後のサスティン（持続時間）を増やすことで、響かせるような効果も出すすることができます。

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0.3, release: 0.1
```

今すぐ、サンプルを楽しくさせるエンベロープをいじってみましょう。
面白い結果を得るために数値を思いきり変更してみましょう。
