; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 -relocation-model=static < %s | FileCheck %s --check-prefixes=CHECK,STATIC
; RUN: llc -mtriple=aarch64 -relocation-model=pic < %s | FileCheck %s --check-prefixes=CHECK,PIC

@preemptable_var = dso_preemptable global i32 42
define i32* @get_preemptable_var() nounwind {
; CHECK-LABEL: get_preemptable_var:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, :got:preemptable_var
; CHECK-NEXT:    ldr x0, [x0, :got_lo12:preemptable_var]
; CHECK-NEXT:    ret
  ret i32* @preemptable_var
}

@dsolocal_var = dso_local global i32 42
define i32* @get_dsolocal_var() nounwind {
; STATIC-LABEL: get_dsolocal_var:
; STATIC:       // %bb.0:
; STATIC-NEXT:    adrp x0, dsolocal_var
; STATIC-NEXT:    add x0, x0, :lo12:dsolocal_var
; STATIC-NEXT:    ret
;
; PIC-LABEL: get_dsolocal_var:
; PIC:       // %bb.0:
; PIC-NEXT:    adrp x0, .Ldsolocal_var$local
; PIC-NEXT:    add x0, x0, :lo12:.Ldsolocal_var$local
; PIC-NEXT:    ret
  ret i32* @dsolocal_var
}

@weak_dsolocal_var = weak dso_local global i32 42
define i32* @get_weak_dsolocal_var() nounwind {
; CHECK-LABEL: get_weak_dsolocal_var:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, weak_dsolocal_var
; CHECK-NEXT:    add x0, x0, :lo12:weak_dsolocal_var
; CHECK-NEXT:    ret
  ret i32* @weak_dsolocal_var
}

@hidden_var = hidden global i32 42
define i32* @get_hidden_var() nounwind {
; CHECK-LABEL: get_hidden_var:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, hidden_var
; CHECK-NEXT:    add x0, x0, :lo12:hidden_var
; CHECK-NEXT:    ret
  ret i32* @hidden_var
}

@protected_var = protected global i32 42
define i32* @get_protected_var() nounwind {
; CHECK-LABEL: get_protected_var:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, protected_var
; CHECK-NEXT:    add x0, x0, :lo12:protected_var
; CHECK-NEXT:    ret
  ret i32* @protected_var
}

define dso_preemptable void()* @preemptable_func() nounwind {
; CHECK-LABEL: preemptable_func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, :got:preemptable_func
; CHECK-NEXT:    ldr x0, [x0, :got_lo12:preemptable_func]
; CHECK-NEXT:    ret
  ret void()* bitcast(void()*()* @preemptable_func to void()*)
}

define dso_local void()* @dsolocal_func() nounwind {
; STATIC-LABEL: dsolocal_func:
; STATIC:       // %bb.0:
; STATIC-NEXT:    adrp x0, dsolocal_func
; STATIC-NEXT:    add x0, x0, :lo12:dsolocal_func
; STATIC-NEXT:    ret
;
; PIC-LABEL: dsolocal_func:
; PIC:       .Ldsolocal_func$local:
; PIC-NEXT:    .type .Ldsolocal_func$local,@function
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x0, .Ldsolocal_func$local
; PIC-NEXT:    add x0, x0, :lo12:.Ldsolocal_func$local
; PIC-NEXT:    ret
  ret void()* bitcast(void()*()* @dsolocal_func to void()*)
}
; UTC-ARGS: --disable
; PIC: [[END_LABEL:.Lfunc_end.+]]:
; PIC-NEXT: .size	dsolocal_func, [[END_LABEL]]-dsolocal_func
; PIC-NEXT: .size	.Ldsolocal_func$local, [[END_LABEL]]-dsolocal_func
; UTC-ARGS: --enable

define weak dso_local void()* @weak_dsolocal_func() nounwind {
; CHECK-LABEL: weak_dsolocal_func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x0, weak_dsolocal_func
; CHECK-NEXT:    add x0, x0, :lo12:weak_dsolocal_func
; CHECK-NEXT:    ret
  ret void()* bitcast(void()*()* @weak_dsolocal_func to void()*)
}

;; bl .Ldsolocal_func$local either resolves to a constant at assembly time
;; or produces a relocation which can potentially cause a veneer.
define dso_local void @call_dsolocal_func() nounwind {
; STATIC-LABEL: call_dsolocal_func:
; STATIC:       // %bb.0:
; STATIC-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; STATIC-NEXT:    bl dsolocal_func
; STATIC-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; STATIC-NEXT:    ret
;
; PIC-LABEL: call_dsolocal_func:
; PIC:       .Lcall_dsolocal_func$local:
; PIC-NEXT:    .type .Lcall_dsolocal_func$local,@function
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; PIC-NEXT:    bl .Ldsolocal_func$local
; PIC-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; PIC-NEXT:    ret
  call void()* @dsolocal_func()
  ret void
}
; UTC-ARGS: --disable
; PIC: [[END_LABEL:.Lfunc_end.+]]:
; PIC-NEXT: .size	call_dsolocal_func, [[END_LABEL]]-call_dsolocal_func
; PIC-NEXT: .size	.Lcall_dsolocal_func$local, [[END_LABEL]]-call_dsolocal_func
; UTC-ARGS: --enable
