/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MASKWIDGET_H
#define MASKWIDGET_H

#include <QWidget>

#include "libukcc_global.h"

class LIBUKCC_EXPORT MaskWidget : public QWidget
{
    Q_OBJECT

public:
    explicit MaskWidget(QWidget *parent);
    ~MaskWidget();

public:
    void setDemandWidth(int w);
    void setDemandHigh(int h);
    void setDemandRadius(int r);
    void setDemandColor(int color);

protected:
    void paintEvent(QPaintEvent *event);

private:
    int pWidth;
    int pHeigh;
    int pRadius;
    int pBorder;
    QString pColor;
};

#endif // MASKWIDGET_H
