/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Quadric;

public class Sphere3D {
    Graphics3D g3d;
    private static final int maxSphereCache = 128;
    private static final int maxOddSizeSphere = 49;
    static final int maxSphereDiameter = 1000;
    static final int maxSphereDiameter2 = 2000;
    private static final int[][] sphereShapeCache = new int[128][];
    private double[] zroot = new double[2];
    private static int nOut;
    private static int nIn;
    private Matrix3f mat;
    private double[] coef;
    private Matrix4f mDeriv;
    private int selectedOctant;
    private Point3i[] octantPoints;
    private int planeShade;
    private int[] zbuf;
    private int width;
    private int height;
    private int depth;
    private int slab;
    private int offsetPbufBeginLine;
    private boolean addAllPixels;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private int x;
    private int y;
    private int z;
    private int diameter;
    private boolean tScreened;
    private int[] shades;
    private static final int SHADE_SLAB_CLIPPED = 47;
    private final Point3f ptTemp = new Point3f();
    private final int[] planeShades = new int[3];
    private final float[][] dxyz = new float[3][3];
    private static byte[][][] ellipsoidShades;
    private static final int SLIM = 20;
    private static final int SDIM = 40;

    Sphere3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
    }

    static synchronized void flushSphereCache() {
        int n = 128;
        while (--n >= 0) {
            Sphere3D.sphereShapeCache[n] = null;
        }
        ellipsoidShades = null;
    }

    private static int[] getSphereShape(int n) {
        int[] nArray = sphereShapeCache[n - 1];
        return nArray == null ? Sphere3D.createSphereShape(n) : nArray;
    }

    private static synchronized int[] createSphereShape(int n) {
        float f;
        int n2 = 0;
        boolean bl = (n & 1) != 0;
        float f2 = (float)n / 2.0f;
        float f3 = f2 * f2;
        int n3 = (n + 1) / 2;
        float f4 = bl ? 0.0f : 0.5f;
        int n4 = 0;
        while (n4 < n3) {
            float f5 = f4 * f4;
            float f6 = bl ? 0.0f : 0.5f;
            int n5 = 0;
            while (n5 < n3) {
                f = f6 * f6;
                float f7 = f3 - f5 - f;
                if (f7 >= 0.0f) {
                    ++n2;
                }
                ++n5;
                f6 += 1.0f;
            }
            ++n4;
            f4 += 1.0f;
        }
        int[] nArray = new int[n2];
        int n6 = 0;
        f4 = bl ? 0.0f : 0.5f;
        int n7 = 0;
        while (n7 < n3) {
            float f8 = f4 * f4;
            f = bl ? 0.0f : 0.5f;
            int n8 = 0;
            while (n8 < n3) {
                float f9 = f * f;
                float f10 = f3 - f8 - f9;
                if (f10 >= 0.0f) {
                    float f11 = (float)Math.sqrt(f10);
                    int n9 = (int)f11;
                    byte by = Shade3D.getDitheredNoisyShadeIndex(f, f4, f11, f2);
                    byte by2 = Shade3D.getDitheredNoisyShadeIndex(-f, f4, f11, f2);
                    byte by3 = Shade3D.getDitheredNoisyShadeIndex(f, -f4, f11, f2);
                    byte by4 = Shade3D.getDitheredNoisyShadeIndex(-f, -f4, f11, f2);
                    int n10 = n9 | by << 7 | by2 << 13 | by3 << 19 | by4 << 25;
                    nArray[n6++] = n10;
                }
                ++n8;
                f += 1.0f;
            }
            int n11 = n6 - 1;
            nArray[n11] = nArray[n11] | Integer.MIN_VALUE;
            ++n7;
            f4 += 1.0f;
        }
        Sphere3D.sphereShapeCache[n - 1] = nArray;
        return nArray;
    }

    void render(int[] nArray, boolean bl, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, int n5, Point3i[] point3iArray) {
        if (n4 == 1) {
            return;
        }
        this.width = this.g3d.width;
        this.height = this.g3d.height;
        if (n > 49) {
            n &= 0xFFFFFFFE;
        }
        if (this.g3d.isClippedXY(n, n2, n3)) {
            return;
        }
        int n6 = n + 1 >> 1;
        this.minX = n2 - n6;
        this.maxX = n2 + n6;
        this.minY = n3 - n6;
        this.maxY = n3 + n6;
        this.slab = this.g3d.slab;
        this.depth = this.g3d.depth;
        this.minZ = n4 - n6;
        this.maxZ = n4 + n6;
        if (this.maxZ < this.slab || this.minZ > this.depth) {
            return;
        }
        nIn = 0;
        nOut = 0;
        this.zbuf = this.g3d.zbuf;
        this.addAllPixels = this.g3d.addAllPixels;
        this.offsetPbufBeginLine = this.width * n3 + n2;
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.diameter = n;
        this.tScreened = bl;
        this.shades = nArray;
        this.mat = matrix3f;
        if (matrix3f != null) {
            this.coef = dArray;
            this.mDeriv = matrix4f;
            this.selectedOctant = n5;
            this.octantPoints = point3iArray;
        }
        if (matrix3f != null || n > 128) {
            this.renderLarge();
            if (matrix3f != null) {
                this.mat = null;
                this.coef = null;
                this.mDeriv = null;
                this.octantPoints = null;
            }
        } else {
            int[] nArray2 = Sphere3D.getSphereShape(n);
            if (this.minX < 0 || this.maxX >= this.width || this.minY < 0 || this.maxY >= this.height || this.minZ < this.slab || n4 > this.depth) {
                this.renderShapeClipped(nArray2);
            } else {
                this.renderShapeUnclipped(nArray2);
            }
        }
        this.shades = null;
        this.zbuf = null;
    }

    private void renderShapeUnclipped(int[] nArray) {
        int n = 0;
        int n2 = 1 - (this.diameter & 1);
        int n3 = this.offsetPbufBeginLine;
        int n4 = n3 - n2 * this.width;
        int n5 = (this.diameter + 1) / 2;
        if (!this.tScreened) {
            do {
                int n6;
                int n7 = n3;
                int n8 = n3 - n2;
                int n9 = n4;
                int n10 = n4 - n2;
                do {
                    int n11;
                    if ((n11 = this.z - ((n6 = nArray[n++]) & 0x7F)) < this.zbuf[n7]) {
                        this.g3d.addPixel(n7, n11, this.shades[n6 >> 7 & 0x3F]);
                    }
                    if (n11 < this.zbuf[n8]) {
                        this.g3d.addPixel(n8, n11, this.shades[n6 >> 13 & 0x3F]);
                    }
                    if (n11 < this.zbuf[n9]) {
                        this.g3d.addPixel(n9, n11, this.shades[n6 >> 19 & 0x3F]);
                    }
                    if (n11 < this.zbuf[n10]) {
                        this.g3d.addPixel(n10, n11, this.shades[n6 >> 25 & 0x3F]);
                    }
                    ++n7;
                    --n8;
                    ++n9;
                    --n10;
                } while (n6 >= 0);
                n3 += this.width;
                n4 -= this.width;
            } while (--n5 > 0);
            return;
        }
        int n12 = (this.x ^ this.y) & 1;
        int n13 = n12 ^ n2;
        int n14 = n12;
        int n15 = n12 ^ n2;
        int n16 = n13;
        int n17 = n13 ^ n2;
        int n18 = n14 | n15 << 1 | n16 << 2 | n17 << 3;
        do {
            int n19;
            int n20 = n3;
            int n21 = n3 - n2;
            int n22 = n4;
            int n23 = n4 - n2;
            int n24 = n18 ^= 0xFFFFFFFF;
            do {
                n19 = nArray[n++];
                int n25 = this.z - (n19 & 0x7F);
                if ((n24 & 1) != 0 && n25 < this.zbuf[n20]) {
                    this.g3d.addPixel(n20, n25, this.shades[n19 >> 7 & 0x3F]);
                }
                if ((n24 & 2) != 0 && n25 < this.zbuf[n21]) {
                    this.g3d.addPixel(n21, n25, this.shades[n19 >> 13 & 0x3F]);
                }
                if ((n24 & 4) != 0 && n25 < this.zbuf[n22]) {
                    this.g3d.addPixel(n22, n25, this.shades[n19 >> 19 & 0x3F]);
                }
                if ((n24 & 8) != 0 && n25 < this.zbuf[n23]) {
                    this.g3d.addPixel(n23, n25, this.shades[n19 >> 25 & 0x3F]);
                }
                ++n20;
                --n21;
                ++n22;
                --n23;
                n24 ^= 0xFFFFFFFF;
            } while (n19 >= 0);
            n3 += this.width;
            n4 -= this.width;
        } while (--n5 > 0);
    }

    private void renderShapeClipped(int[] nArray) {
        int n = 0;
        int n2 = 1 - (this.diameter & 1);
        int n3 = this.offsetPbufBeginLine;
        int n4 = n3 - n2 * this.width;
        int n5 = (this.diameter + 1) / 2;
        int n6 = this.y;
        int n7 = this.y - n2;
        int n8 = (this.x << 16) + (this.y << 1) ^ 0x33333333;
        int n9 = (this.x ^ this.y) & 1;
        int n10 = n9 ^ n2;
        int n11 = n9;
        int n12 = n9 ^ n2;
        int n13 = n10;
        int n14 = n10 ^ n2;
        int n15 = n11 | n12 << 1 | n13 << 2 | n14 << 3;
        do {
            int n16;
            boolean bl = n6 >= 0 && n6 < this.height;
            boolean bl2 = n7 >= 0 && n7 < this.height;
            int n17 = n3;
            int n18 = n3 - n2;
            int n19 = n4;
            int n20 = n4 - n2;
            int n21 = n15 ^= 0xFFFFFFFF;
            int n22 = this.x;
            int n23 = this.x - n2;
            do {
                boolean bl3;
                int n24;
                boolean bl4 = n23 >= 0 && n23 < this.width;
                boolean bl5 = n22 >= 0 && n22 < this.width;
                n16 = nArray[n++];
                int n25 = n16 & 0x7F;
                if (this.z < this.slab) {
                    n24 = this.z + n25;
                    bl3 = n24 >= this.slab;
                } else {
                    n24 = this.z - n25;
                    boolean bl6 = bl3 = n24 < this.slab;
                }
                if (bl3) {
                    n24 = this.slab;
                }
                if (n24 >= this.slab && n24 <= this.depth) {
                    int n26;
                    if (bl) {
                        if (bl5 && (this.addAllPixels || (n21 & 1) != 0) && n24 < this.zbuf[n17]) {
                            n26 = bl3 ? 44 + (n8 >> 7 & 7) : n16 >> 7 & 0x3F;
                            this.g3d.addPixel(n17, n24, this.shades[n26]);
                        }
                        if (bl4 && (this.addAllPixels || (n21 & 2) != 0) && n24 < this.zbuf[n18]) {
                            n26 = bl3 ? 44 + (n8 >> 13 & 7) : n16 >> 13 & 0x3F;
                            this.g3d.addPixel(n18, n24, this.shades[n26]);
                        }
                    }
                    if (bl2) {
                        if (bl5 && (!this.tScreened || (n21 & 4) != 0) && n24 < this.zbuf[n19]) {
                            n26 = bl3 ? 44 + (n8 >> 19 & 7) : n16 >> 19 & 0x3F;
                            this.g3d.addPixel(n19, n24, this.shades[n26]);
                        }
                        if (bl4 && (!this.tScreened || (n21 & 8) != 0) && n24 < this.zbuf[n20]) {
                            n26 = bl3 ? 44 + (n8 >> 25 & 7) : n16 >> 25 & 0x3F;
                            this.g3d.addPixel(n20, n24, this.shades[n26]);
                        }
                    }
                }
                ++n17;
                --n18;
                ++n19;
                --n20;
                ++n22;
                --n23;
                n21 ^= 0xFFFFFFFF;
                if (!bl3) continue;
                n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE;
            } while (n16 >= 0);
            n3 += this.width;
            n4 -= this.width;
            ++n6;
            --n7;
        } while (--n5 > 0);
    }

    private void renderLarge() {
        if (this.mat != null) {
            if (ellipsoidShades == null) {
                Sphere3D.createEllipsoidShades();
            }
            if (this.octantPoints != null) {
                this.setPlaneDerivatives();
            }
        } else if (!Shade3D.sphereShadingCalculated) {
            Shade3D.calcSphereShading();
        }
        this.renderQuadrant(-1, -1);
        this.renderQuadrant(-1, 1);
        this.renderQuadrant(1, -1);
        this.renderQuadrant(1, 1);
    }

    private void renderQuadrant(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5 = (this.x < 0 ? -1 : (this.x < this.width ? 0 : 1)) + ((n4 = this.x + (n3 = this.diameter / 2) * n) < 0 ? -2 : (n4 < this.width ? 0 : 2));
        if (n5 == -3 || n5 == 3) {
            return;
        }
        int n6 = (this.y < 0 ? -1 : (this.y < this.height ? 0 : 1)) + ((n4 = this.y + n3 * n2) < 0 ? -2 : (n4 < this.height ? 0 : 2));
        if (n6 == -3 || n6 == 3) {
            return;
        }
        boolean bl2 = bl = this.mat == null && n5 == 0 && n6 == 0 && this.z - n3 >= this.slab && this.z <= this.depth;
        if (bl) {
            this.renderQuadrantUnclipped(n3, n, n2);
        } else {
            this.renderQuadrantClipped(n3, n, n2);
        }
    }

    private void renderQuadrantUnclipped(int n, int n2, int n3) {
        int n4 = n * n;
        int n5 = n * 2 + 1;
        boolean bl = ((this.x ^ this.y) & 1) == 0;
        int n6 = n3 < 0 ? -this.width : this.width;
        int n7 = this.offsetPbufBeginLine;
        int n8 = 0;
        int n9 = 0;
        while (n9 <= n4) {
            int n10 = n7;
            bl = !bl;
            boolean bl2 = bl;
            int n11 = n4 - n9;
            int n12 = this.z - n;
            int n13 = (n8 * n3 + n << 8) / n5;
            int n14 = 0;
            int n15 = 0;
            while (n15 <= n11) {
                int n16;
                if ((this.addAllPixels || (bl2 = !bl2)) && this.zbuf[n10] > n12 && this.zbuf[n10] > (n12 = this.z - (n16 = (int)Math.sqrt(n11 - n15)))) {
                    int n17 = (n14 * n2 + n << 8) / n5;
                    this.g3d.addPixel(n10, n12, this.shades[Shade3D.sphereShadeIndexes[(n13 << 8) + n17]]);
                }
                n15 += n14++ + n14;
                n10 += n2;
            }
            n9 += n8++ + n8;
            n7 += n6;
        }
    }

    private void renderQuadrantClipped(int n, int n2, int n3) {
        boolean bl = this.mat != null;
        boolean bl2 = this.selectedOctant >= 0;
        int n4 = n * n;
        int n5 = n * 2 + 1;
        int n6 = n3 < 0 ? -this.width : this.width;
        int n7 = this.offsetPbufBeginLine;
        int n8 = (this.x << 16) + (this.y << 1) ^ 0x33333333;
        int n9 = this.y;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 <= n4) {
            block19: {
                block20: {
                    block18: {
                        if (n9 >= 0) break block18;
                        if (n3 < 0) {
                            return;
                        }
                        break block19;
                    }
                    if (n9 < this.height) break block20;
                    if (n3 > 0) {
                        return;
                    }
                    break block19;
                }
                int n14 = n4 - (bl ? 0 : n13);
                int n15 = this.x;
                if (!bl) {
                    n10 = (n12 * n3 + n << 8) / n5;
                }
                n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE;
                int n16 = -1;
                int n17 = 1;
                int n18 = n7;
                int n19 = 0;
                int n20 = 0;
                while (n20 <= n14) {
                    block22: {
                        int n21;
                        int n22;
                        block26: {
                            block24: {
                                block25: {
                                    block23: {
                                        block21: {
                                            if (n15 >= 0) break block21;
                                            if (n2 < 0) {
                                                break;
                                            }
                                            break block22;
                                        }
                                        if (n15 < this.width) break block23;
                                        if (n2 > 0) {
                                            break;
                                        }
                                        break block22;
                                    }
                                    if (this.tScreened && ((n15 ^ n9) & 1) != 0) break block22;
                                    if (!bl) break block24;
                                    if (Quadric.getQuardricZ(n15, n9, this.coef, this.zroot)) break block25;
                                    if (n16 >= 0) {
                                        break;
                                    }
                                    break block22;
                                }
                                n16 = this.z < this.slab ? 1 : 0;
                                n22 = (int)this.zroot[n16];
                                if (n22 == 0) {
                                    n22 = this.z;
                                }
                                n17 = 2;
                                if (bl2) {
                                    this.ptTemp.set(n15 - this.x, n9 - this.y, n22 - this.z);
                                    this.mat.transform(this.ptTemp);
                                    n21 = Quadric.getOctant(this.ptTemp);
                                    if (n21 == this.selectedOctant) {
                                        n11 = this.getPlaneShade(n15, n9, this.zroot);
                                        n22 = (int)this.zroot[0];
                                        n17 = 3;
                                    }
                                }
                                break block26;
                            }
                            n21 = (int)Math.sqrt(n14 - n20);
                            n22 = this.z + (this.z < this.slab ? n21 : -n21);
                        }
                        int n23 = this.z < this.slab ? (n22 >= this.slab ? 1 : 0) : (n21 = n22 < this.slab ? 1 : 0);
                        if (n21 != 0) {
                            n22 = this.slab;
                            n17 = 0;
                        }
                        if (n22 >= this.slab && n22 <= this.depth && this.zbuf[n18] > n22) {
                            switch (n17) {
                                case 0: {
                                    n11 = 44 + (n8 >> 8 & 7);
                                    n8 = (n8 << 16) + (n8 << 1) + n8 & Integer.MAX_VALUE;
                                    n17 = 1;
                                    break;
                                }
                                case 2: {
                                    n11 = Sphere3D.getEllipsoidShade(n15, n9, (float)this.zroot[n16], n, this.mDeriv);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    int n24 = (n19 * n2 + n << 8) / n5;
                                    n11 = Shade3D.sphereShadeIndexes[(n10 << 8) + n24];
                                }
                            }
                            this.g3d.addPixel(n18, n22, this.shades[n11]);
                        }
                    }
                    n20 += n19++ + n19;
                    n18 += n2;
                    n15 += n2;
                }
                n8 = (n8 + n15 + n9 | 1) & Integer.MAX_VALUE;
            }
            n13 += n12++ + n12;
            n7 += n6;
            n9 += n3;
        }
    }

    private void setPlaneDerivatives() {
        this.planeShade = -1;
        for (int i = 0; i < 3; ++i) {
            float f = this.octantPoints[i].x - this.x;
            this.dxyz[i][0] = f;
            float f2 = f;
            float f3 = this.octantPoints[i].y - this.y;
            this.dxyz[i][1] = f3;
            float f4 = f3;
            float f5 = this.octantPoints[i].z - this.z;
            this.dxyz[i][2] = f5;
            float f6 = f5;
            this.planeShades[i] = Shade3D.getShadeIndex(f2, f4, -f6);
            if (f2 != 0.0f || f4 != 0.0f) continue;
            this.planeShade = this.planeShades[i];
            return;
        }
    }

    private int getPlaneShade(int n, int n2, double[] dArray) {
        if (this.planeShade >= 0) {
            return this.planeShade;
        }
        int n3 = 3;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            float f2;
            float f3 = this.dxyz[i][2];
            if (f3 == 0.0f || !((f2 = (float)this.z + (-this.dxyz[i][0] * (float)(n - this.x) - this.dxyz[i][1] * (float)(n2 - this.y)) / f3) < f)) continue;
            f = f2;
            n3 = i;
        }
        if (n3 == 3) {
            n3 = 0;
            f = this.z;
        }
        dArray[0] = f;
        return this.planeShades[n3];
    }

    private static void createEllipsoidShades() {
        ellipsoidShades = new byte[40][40][40];
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < 40; ++k) {
                    Sphere3D.ellipsoidShades[i][j][k] = (byte)Shade3D.getShadeIndex(i - 20, j - 20, k);
                }
            }
        }
    }

    private static int getEllipsoidShade(float f, float f2, float f3, int n, Matrix4f matrix4f) {
        boolean bl;
        float f4 = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        float f5 = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        float f6 = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
        float f7 = Math.min((float)n / 2.0f, 45.0f) / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        int n2 = (int)(-f4 * f7);
        int n3 = (int)(-f5 * f7);
        int n4 = (int)(f6 * f7);
        boolean bl2 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        if (bl) {
            while (n2 % 2 == 0 && n3 % 2 == 0 && n4 % 2 == 0 && n2 + n3 + n4 > 0) {
                n2 >>= 1;
                n3 >>= 1;
                n4 >>= 1;
            }
            boolean bl3 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        }
        if (bl) {
            ++nOut;
        } else {
            ++nIn;
        }
        return bl ? Shade3D.getShadeIndex(n2, n3, n4) : ellipsoidShades[n2 + 20][n3 + 20][n4];
    }
}

