c
c---------------------------------------------------------------------
      subroutine pwLatgen( ibrav, celldm, p1, p2, p3, c1, c2, c3 )
c---------------------------------------------------------------------
c
c   This routine sets up the crystallographic vectors p1, p2, and p3.
c   The a's are expressed in units of celldm(1) ( a0 for
c   cubic lattices). This version contains all 14 Bravais lattices.
c
      implicit none
c
c     First the input variables
c
      real*8 
     +     celldm( 6 ),         ! input: the dimensions of the lattice
     +     p1( 3 ),             ! output: the first lattice vector (PRIMITIVE)
     +     p2( 3 ),             ! output: the second lattice vector
     +     p3( 3 ),             ! output: the third lattice vector
     +     c1( 3 ),             ! output: the first lattice vector(CONVETIONAL)
     +     c2( 3 ),             ! output: the second lattice vector
     +     c3( 3 )              ! output: the third lattice vector
      integer
     +       ibrav          ! input: the index of the Bravais lattice
c
c    Here the local variables required by the routine
c
      real*8
     +        sr2,          ! the square root of 2.0 
     +        sr3           ! the square root of 3.0
      parameter (sr2 = 1.4142 13562 373d0, sr3 = 1.7320 50807 569d0)
      real*8 
     +        term,         !\
     +        term1,        ! \ 
     +        term2,        !   Auxiliary variables
     +        cbya,         ! /
     +        singam,       !/ 
     +        sin,          ! the sine function
     +        sen
      integer 
     +        ipol          ! counter on the coordinates 

      if ( ibrav .eq. 0 ) then
c
c     user supplied lattice
c
         if ( celldm( 1 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 1 )
      else
         do  ipol = 1, 3
            p1( ipol ) = 0.d0
            p2( ipol ) = 0.d0
            p3( ipol ) = 0.d0

            c1( ipol ) = 0.d0
            c2( ipol ) = 0.d0
            c3( ipol ) = 0.d0
         end do
      endif

      if ( ibrav .eq. 1 ) then
c
c     simple cubic lattice
c
         if ( celldm( 1 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 1 )
         p1( 1 ) = 1.0d0
         p2( 2 ) = 1.0d0
         p3( 3 ) = 1.0d0
      elseif ( ibrav .eq. 2 ) then
c
c     fcc lattice
c
         if ( celldm( 1 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 2 )
         term = 1.0d0 / 2.d0
         p1( 1 ) = - term
         p1( 3 ) = term
         p2( 2 ) = term
         p2( 3 ) = term
         p3( 1 ) = - term
         p3( 2 ) = term

         c1( 1 ) = 1.0d0
         c2( 2 ) = 1.0d0
         c3( 3 ) = 1.0d0
c     **********
         return

      elseif ( ibrav .eq. 3 ) then
c
c     bcc lattice
c
         if ( celldm( 1 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 3 )
         term = 1.0d0 / 2.d0
         do 20 ipol = 1, 3
            p1( ipol ) = term
            p2( ipol ) = term
            p3( ipol ) = term
20       continue
         p2( 1 ) = - term
         p3( 1 ) = - term
         p3( 2 ) = - term

         c1( 1 ) = 1.0d0
         c2( 2 ) = 1.0d0
         c3( 3 ) = 1.0d0
c     **********
         return

      elseif ( ibrav .eq. 4 ) then
c
c     hexagonal lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 4 )
         cbya = celldm( 3 )
         p1( 1 ) = 1.0d0
         p2( 1 ) = -1.0d0 / 2.d0
         p2( 2 ) = sr3 / 2.d0
         p3( 3 ) = cbya

      elseif ( ibrav .eq. 5 ) then
c
c     trigonal lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 4 ) .le. -0.5d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 5 )

         term1=sqrt(1.d0+2.d0*celldm(4))
         term2=sqrt(1.d0-celldm(4))
         p2(2)=sr2*term2/sr3
         p2(3)=term1/sr3
         p1(1)=term2/sr2
         p1(2)=-p1(1)/sr3
         p1(3)= p2(3)
         p3(1)=-p1(1)
         p3(2)= p1(2)
         p3(3)= p2(3)
      elseif ( ibrav .eq. 6 ) then
c
c     tetragonal lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 6 )
         cbya = celldm( 3 )
         p1( 1 ) = 1.0d0
         p2( 2 ) = 1.0d0
         p3( 3 ) = cbya
      elseif ( ibrav .eq. 7 ) then
c
c     body centered tetragonal lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 7 )
         cbya=celldm(3)
         p2(1)=1.0d0/2.d0
         p2(2)=p2(1)
         p2(3)=cbya/2.d0
         p1(1)= p2(1)
         p1(2)=-p2(1)
         p1(3)= p2(3)
         p3(1)=-p2(1)
         p3(2)=-p2(1)
         p3(3)= p2(3)

         c1(1) = 1.0d0
         c2(2) = 1.0d0
         c3(3) = cbya
c     **********
         return

      elseif ( ibrav .eq. 8 ) then
c
c     Simple orthorombic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 8 )
         p1( 1 ) = 1.0d0
         p2( 2 ) = celldm( 2 )
         p3( 3 ) = celldm( 3 )
      elseif ( ibrav .eq. 9 ) then
c
c     One face centered orthorombic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 9 )
         p1( 1 ) = 0.5d0
         p1( 2 ) = 0.5d0 * celldm( 2 )
         p2( 1 ) = - p1( 1 )
         p2( 2 ) = p1( 2 )
         p3( 3 ) = celldm( 3 )  
 
         c1(1) = 1.0d0
         c2(2) = celldm(2)
         c3(3) = celldm(3)
c     ********** ????
         return

      elseif ( ibrav .eq. 10 ) then
c
c     All face centered orthorombic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 10 )
         p2( 1 ) = 0.5d0
         p2( 2 ) = 0.5d0 * celldm( 2 )
         p1( 1 ) = p2( 1 )
         p1( 3 ) = 0.5d0 * celldm( 3 )
         p3( 2 ) = 0.5d0 * celldm( 2 )
         p3( 3 ) = p1( 3 )

         c1(1) = 1.0d0
         c2(2) = celldm(2)
         c3(3) = celldm(3)
c     **********
         return

      elseif ( ibrav .eq. 11 ) then
c
c     Body centered orthorombic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 11 )
         p1( 1 ) = 0.5d0
         p1( 2 ) = 0.5d0 * celldm( 2 )
         p1( 3 ) = 0.5d0 * celldm( 3 )
         p2( 1 ) = - p1( 1 )
         p2( 2 ) = p1( 2 )
         p2( 3 ) = p1( 3 )
         p3( 1 ) = - p1( 1 )
         p3( 2 ) = - p1( 2 )
         p3( 3 ) = p1( 3 )

         c1(1) = 1.0d0
         c2(2) = celldm(2)
         c3(3) = celldm(3)
c     **********
         return

      elseif ( ibrav .eq. 12 ) then
c
c     Simple monoclinic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0
     +        .or. abs ( celldm( 4 ) ) .gt. 1.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 12 )
         sin = sqrt( 1.d0 - celldm( 4 ) ** 2 )
         p1( 1 ) = 1.0d0
         p2( 1 ) = celldm( 2 ) * celldm( 4 )
         p2( 2 ) = celldm( 2 ) * sin
         p3( 3 ) = celldm( 3 )
      elseif ( ibrav .eq. 13 ) then
c
c     One face centered monoclinic lattice
c
         if ( celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0 
     +        .or. abs ( celldm( 4 ) ) .gt. 1.d0 ) 
     +      call pwError( 'latgen', 'wrong celldm', 13 )

c         sin = sqrt( 1.d0 - celldm( 4 ) ** 2 )
c         p1( 1 ) = celldm( 4 )
c         p1( 3 ) = sin
c         p2( 1 ) = p1( 1 )
c         p2( 3 ) = - p1( 3 )
c         p3( 1 ) = celldm( 2 )
c         p3( 2 ) = celldm( 3 )

         sin = sqrt( 1.d0 - celldm(4) ** 2 )
         p1(1) = 0.5 
         p1(3) =-p1(1) * celldm(3)
         p2(1) = celldm(2) * celldm(4)
         p2(2) = celldm(2) * sin
         p3(1) = p1(1)
         p3(3) =-p1(3)
         
         c1(1) = 1.0d0
         c2(1) = p2(1)
         c2(2) = p2(2)
         c3(3) = celldm(3)
         return

      elseif ( ibrav .eq. 14 ) then
c
c     Triclinic lattice
c
         if (      celldm( 1 ) .le. 0.d0 .or. celldm( 2 ) .le. 0.d0
     +        .or. celldm( 3 ) .le. 0.d0
     +        .or. abs ( celldm( 4 ) ) .gt. 1.d0
     +        .or. abs ( celldm( 5 ) ) .gt. 1.d0
     +        .or. abs ( celldm( 6 ) ) .gt. 1.d0 )
     +      call pwError( 'latgen', 'wrong celldm', 14 )
         singam = sqrt( 1.d0 - celldm( 6 ) ** 2 )
         term = 1.d0
     $        +  2.d0 * celldm( 4 ) * celldm( 5 ) * celldm( 6 )
     $        - celldm( 4 )**2 
     +        - celldm( 5 )**2
     $        - celldm( 6 )**2 
         if (term < 0.d0) call pwError('latgen',
     $        'celldm do not make sense, check your data', ibrav)
         term = sqrt(term / ( 1.d0 - celldm( 6 ) ** 2 ))
         
         p1( 1 ) = 1.0d0
         p2( 1 ) = celldm( 2 ) * celldm( 6 )
         p2( 2 ) = celldm( 2 ) * singam
         p3( 1 ) = celldm( 3 ) * celldm( 5 )
         p3( 2 ) = celldm( 3 ) *
     $        (celldm(4) - celldm(5)*celldm(6)) / singam
         p3( 3 ) = celldm( 3 ) * term
      else
         call pwError('latgen', ' wrong ibrav ', ibrav )
      endif

c     **********
c     if we came here then just copy p vectors to c vectors !!!
c     **********
      do  ipol = 1, 3
         c1( ipol ) = p1( ipol )
         c2( ipol ) = p2( ipol )
         c3( ipol ) = p3( ipol )
      enddo
      return
      end



c
c-----------------------------------------------------------------------
      subroutine pwCryst_to_cart ( nvec, vec, trmat, iflag )
c-----------------------------------------------------------------------
c
c     This routine transforms the atomic positions or the k-point 
c     components from crystallographic to carthesian coordinates ( iflag=1)
c     and viceversa ( iflag=-1 ).
c     Output carth. coordinates are stored in the input ('vec') array. 
c
c
      implicit none
c
c     first the dummy variables
c
      integer 
     +        nvec,        ! input: number of vectors (atom. pos. or k-points)
     +                     !        to be transf. from cryst. to carth. axes 
     +        iflag        ! input: gives the sense of the transformation
      real*8 
     +        vec(3,nvec), ! input/output: cryst./carth. coord. of the vectors 
     +                     !               (atom. pos. or k-points)
     +        trmat(3,3)   ! input: transformation matrix
                           ! if iflag=1:
                           !    trmat = at ,  basis of the real-space latt. 
                           !                  for atoms   or 
                           !          = bg ,  basis of the rec.-space latt. 
                           !                  for k-points 
                           ! if iflag=-1: the opposite
c
c    here the local variables
c
      integer 
     +        nv,          ! counter on vectors 
     +        kpol         ! counter on polarizations

      real*8 
     +       vau(3)        ! auxil. vector (containing the temp. transf. coord.)
c
c     Compute the carth. coordinates of each vectors 
c     (atomic positions or k-points components)
c
      do nv = 1, nvec
         if ( iflag.eq.1 ) then
            do kpol = 1,3
               vau(kpol) = trmat(kpol,1)*vec(1,nv) + 
     +                     trmat(kpol,2)*vec(2,nv) +
     +                     trmat(kpol,3)*vec(3,nv)
            enddo
         else
            do kpol = 1,3
               vau(kpol) = trmat(1,kpol)*vec(1,nv) + 
     +                     trmat(2,kpol)*vec(2,nv) +
     +                     trmat(3,kpol)*vec(3,nv)
            enddo
         endif
         do kpol = 1,3
            vec(kpol,nv) = vau(kpol) 
         enddo
      enddo
c
      return
      end
