/* window-monitor.c generated by valac 0.19.0, the Vala compiler
 * generated from window-monitor.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define XNP_TYPE_WINDOW_MONITOR (xnp_window_monitor_get_type ())
#define XNP_WINDOW_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitor))
#define XNP_WINDOW_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitorClass))
#define XNP_IS_WINDOW_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW_MONITOR))
#define XNP_IS_WINDOW_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW_MONITOR))
#define XNP_WINDOW_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitorClass))

typedef struct _XnpWindowMonitor XnpWindowMonitor;
typedef struct _XnpWindowMonitorClass XnpWindowMonitorClass;
typedef struct _XnpWindowMonitorPrivate XnpWindowMonitorPrivate;

#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _XnpWindowMonitor {
	GObject parent_instance;
	XnpWindowMonitorPrivate * priv;
	XnpWindow* window;
};

struct _XnpWindowMonitorClass {
	GObjectClass parent_class;
};

struct _XnpWindowMonitorPrivate {
	GFileMonitor* monitor;
	guint monitor_timeout;
};


static gpointer xnp_window_monitor_parent_class = NULL;

GType xnp_window_monitor_get_type (void) G_GNUC_CONST;
GType xnp_window_get_type (void) G_GNUC_CONST;
#define XNP_WINDOW_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitorPrivate))
enum  {
	XNP_WINDOW_MONITOR_DUMMY_PROPERTY
};
XnpWindowMonitor* xnp_window_monitor_new (XnpWindow* window, GFile* file);
XnpWindowMonitor* xnp_window_monitor_construct (GType object_type, XnpWindow* window, GFile* file);
static void xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void xnp_window_monitor_window_updated_cb (XnpWindowMonitor* self);
static gboolean __lambda21_ (XnpWindowMonitor* self);
static gboolean ___lambda21__gsource_func (gpointer self);
static void xnp_window_monitor_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	xnp_window_monitor_monitor_change_cb (self, file, other_file, event_type);
}


XnpWindowMonitor* xnp_window_monitor_construct (GType object_type, XnpWindow* window, GFile* file) {
	XnpWindowMonitor * self = NULL;
	XnpWindow* _tmp0_;
	XnpWindow* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	self = (XnpWindowMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->window);
	self->window = _tmp1_;
	{
		GFile* _tmp2_;
		GFileMonitor* _tmp3_ = NULL;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		_tmp2_ = file;
		_tmp3_ = g_file_monitor_directory (_tmp2_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp4_;
		_tmp5_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp5_, 1000);
		_tmp6_ = self->priv->monitor;
		g_signal_connect_object (_tmp6_, "changed", (GCallback) _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed, self, 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_message ("window-monitor.vala:41: Unable to create a directory monitor: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


XnpWindowMonitor* xnp_window_monitor_new (XnpWindow* window, GFile* file) {
	return xnp_window_monitor_construct (XNP_TYPE_WINDOW_MONITOR, window, file);
}


static void xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* note_name;
	GFileMonitorEvent _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	note_name = _tmp1_;
	_tmp2_ = event;
	switch (_tmp2_) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			const gchar* _tmp3_;
			_tmp3_ = note_name;
			g_signal_emit_by_name (self, "note-updated", _tmp3_);
			xnp_window_monitor_window_updated_cb (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			const gchar* _tmp4_;
			_tmp4_ = note_name;
			g_signal_emit_by_name (self, "note-deleted", _tmp4_);
			xnp_window_monitor_window_updated_cb (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			const gchar* _tmp5_;
			_tmp5_ = note_name;
			g_signal_emit_by_name (self, "note-created", _tmp5_);
			break;
		}
		default:
		break;
	}
	_g_free0 (note_name);
}


static gboolean __lambda21_ (XnpWindowMonitor* self) {
	gboolean result = FALSE;
	XnpWindow* _tmp0_;
	_tmp0_ = self->window;
	g_signal_emit_by_name (self, "window-updated", _tmp0_);
	self->priv->monitor_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ___lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda21_ (self);
	return result;
}


static void xnp_window_monitor_window_updated_cb (XnpWindowMonitor* self) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->monitor_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->monitor_timeout = _tmp2_;
}


static void xnp_window_monitor_class_init (XnpWindowMonitorClass * klass) {
	xnp_window_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpWindowMonitorPrivate));
	G_OBJECT_CLASS (klass)->finalize = xnp_window_monitor_finalize;
	g_signal_new ("window_updated", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_WINDOW);
	g_signal_new ("note_updated", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("note_deleted", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("note_created", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void xnp_window_monitor_instance_init (XnpWindowMonitor * self) {
	self->priv = XNP_WINDOW_MONITOR_GET_PRIVATE (self);
	self->priv->monitor_timeout = (guint) 0;
}


static void xnp_window_monitor_finalize (GObject* obj) {
	XnpWindowMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitor);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (xnp_window_monitor_parent_class)->finalize (obj);
}


GType xnp_window_monitor_get_type (void) {
	static volatile gsize xnp_window_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_window_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpWindowMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindowMonitor), 0, (GInstanceInitFunc) xnp_window_monitor_instance_init, NULL };
		GType xnp_window_monitor_type_id;
		xnp_window_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpWindowMonitor", &g_define_type_info, 0);
		g_once_init_leave (&xnp_window_monitor_type_id__volatile, xnp_window_monitor_type_id);
	}
	return xnp_window_monitor_type_id__volatile;
}



