/*
 *  A Z-Machine
 *  Copyright (C) 2000 Andrew Hunter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * A vector version of font 3
 *
 * (We do things this way so that we can scale the font to be the same 
 * size as the fixed width font...)
 * All characters are 9x9
 */

#include <stdio.h>

#include "font3.h"

font3 font_3 =
{
  {
    { 0,
      { 0, 0,
	0, 8,
	8, 8,
	8, 0
      }
    }, /* 32 (space) */

    { 8,
      {
	3, 2,
	0, 4,
	0, 5,
	3, 7,
	3, 5,
	7, 5,
	7, 4,
	3, 4
      }
    }, /* 33 (left arrow) */

    { 8,
      {
	4,  2,
	7,  4,
	7,  5,
	4,  7,
	4,  5,
	0,  5,
	0,  4,
	4,  4
      }
    }, /* 34 (right arrow) */

    { 6,
      {
	8, 0,
	8, 1,
	1, 8,
	0, 8,
	0, 7,
	7, 0
      }
    }, /* 35 (left slant) */

    { 6,
      {
	0, 0,
	1, 0,
	8, 7,
	8, 8,
	7, 8,
	0, 1
      }
    }, /* 36 (right slant) */

    { 0,
      {
	0
      }
    }, /* 37 (blank) */

    { 4,
      {
	0, 4,
	8, 4,
	8, 5,
	0, 5
      }
    }, /* 38 (horiz line 1) */
    
    { 4,
      {
	0, 3,
	8, 3,
	8, 4,
	0, 4
      }
    }, /* 39 (horiz line 2) */

    { 4,
      {
	4, 0,
	4, 8,
	5, 8,
	5, 0
      }
    }, /* 40 (vert line 1) */
    
    { 4,
      {
	3, 0,
	3, 8,
	4, 8,
	4, 0
      }
    }, /* 41 (vert line 2) */
    
    { 8,
      {
	0, 3,
	4, 3,
	4, 0,
	5, 0,
	5, 3,
	8, 3,
	8, 4,
	0, 4
      }
    }, /* 42 */
    
    { 8,
      {
	0, 5,
	4, 5,
	4, 8,
	5, 8,
	5, 5,
	8, 5,
	8, 4,
	0, 4
      }
    }, /* 43 */
    
    { 8,
      {
	5, 0,
	5, 4,
	8, 4,
	8, 5,
	5, 5,
	5, 8,
	4, 8,
	4, 0
      }
    }, /* 44 */
    
    { 8,
      {
	3, 0,
	3, 4,
	0, 4,
	0, 5,
	3, 5,
	3, 8,
	4, 8,
	4, 0
      }
    }, /* 45 */
    
    { 6,
      {
	3, 0,
	3, 5,
	8, 5,
	8, 4,
	4, 4,
	4, 0
      }
    }, /* 46 */
    
    { 6,
      {
	3, 3,
	3, 8,
	4, 8,
	4, 4,
	8, 4,
	8, 3
      }
    }, /* 47 */
    
    { 6,
      {
	0, 3,
	5, 3,
	5, 8,
	4, 8,
	4, 4,
	0, 4
      }
    }, /* 48 */
    
    { 6,
      {
	0, 4,
	4, 4,
	4, 0,
	5, 0,
	5, 5,
	0, 5
      }
    }, /* 49 */
    
    { 10,
      {
	0, 8,
	1, 8,
	4, 5,
	8, 5,
	8, 4,
	4, 4,
	4, 0,
	3, 0,
	3, 4,
	0, 7
      }
    }, /* 50 */
    
    { 10,
      {
	0, 0,
	1, 0,
	4, 3,
	8, 3,
	8, 4,
	4, 4,
	4, 8,
	3, 8,
	3, 4,
	0, 1
      }
    }, /* 51 */
    { 10,
      {
	7, 0,
	4, 3,
	0, 3,
	0, 4,
	4, 4,
	4, 8,
	5, 8,
	5, 4,
	8, 1,
	8, 0
      }
    }, /* 52 */
    { 10,
      {
	0, 4,
	4, 4,
	4, 0,
	5, 0,
	5, 3,
	8, 7,
	8, 8,
	7, 8,
	4, 5,
	0, 5
      }
    }, /* 53 */

    { 4,
      {
	0,0,
	0,8,
	8,8,
	8,0
      }
    }, /* 54 */
    
    { 4,
      {
	0,0,
	8,0,
	8,5,
	0,5
      }
    }, /* 55 */
    
    { 4,
      {
	0, 3,
	8, 3,
	8, 8,
	0, 8
      }
    }, /* 56 */
    
    { 4,
      {
	5, 0,
	5, 8,
	0, 8,
	0, 0
      }
    }, /* 57 */
    
    { 4,
      {
	3, 0,
	3, 8,
	8, 8,
	8, 0
      }
    }, /* 58 */
    
    { 8,
      {
	0, 3,
	4, 3,
	4, 0,
	5, 0,
	5, 3,
	8, 3,
	8, 8,
	0, 8
      }
    }, /* 59 */
    
    { 8,
      {
	0, 5,
	4, 5,
	4, 8,
	5, 8,
	5, 5,
	8, 5,
	8, 0,
	0, 0
      }
    }, /* 60 */
    
    { 8,
      {
	5, 0,
	5, 4,
	8, 4,
	8, 5,
	5, 5,
	5, 8,
	0, 8,
	0, 0
      }
    }, /* 61 */
    
    { 8,
      {
	3, 0,
	3, 4,
	0, 4,
	0, 5,
	3, 5,
	3, 8,
	8, 8,
	8, 0
      }
    }, /* 62 */
    
    { 4,
      {
	3, 0,
	3, 5,
	8, 5,
	8, 0
      }
    }, /* 63 */
    
    { 4,
      {
	3, 3,
	8, 3,
	8, 8,
	3, 8
      }
    }, /* 64 */
    
    { 4,
      {
	0, 3,
	5, 3,
	5, 8,
	0, 8
      }
    }, /* 65 */
    
    { 4,
      {
	0,0,
	5,0,
	5,5,
	0,5
      }
    }, /* 66 */
    
    { 8,
      {
	0, 7,
	3, 4,
	3, 0,
	8, 0,
	8, 5,
	4, 5,
	1, 8,
	0, 8
      }
    }, /* 67 */
    
    { 8,
      {
	0, 0,
	1, 0,
	4, 3,
	8, 3,
	8, 8,
	3, 8,
	3, 4,
	0, 1
      }
    }, /* 68 */
    
    { 8,
      {
	0, 3,
	4, 3,
	7, 0,
	8, 0,
	5, 4,
	5, 8,
	0, 8
      }
    }, /* 69 */
    
    { 8,
      {
	0, 0,
	5, 0,
	5, 4,
	8, 7,
	8, 8,
	7, 8,
	4, 5,
	0, 5
      }
    }, /* 70 */
    
    { 4,
      {
	7, 0,
	8, 0,
	8, 1,
	7, 1
      }
    }, /* 71 */
    
    { 4,
      {
	7, 7,
	7, 8,
	8, 8,
	8, 7
      }
    }, /* 72 */
    
    { 4,
      {
	0, 7,
	1, 7,
	1, 8,
	0, 8
      }
    }, /* 73 */
    
    { 4,
      {
	0, 0,
	0, 1,
	1, 1,
	0, 0
      }
    }, /* 74 */
    
    { 4,
      {
	0, 0,
	0, 1,
	8, 1,
	8, 0
      }
    }, /* 75 */
    
    { 4,
      {
	0, 7,
	8, 7,
	8, 8,
	0, 8
      }
    }, /* 76 */
    
    { 4,
      {
	0, 0,
	1, 0,
	1, 8,
	0, 8
      }
    }, /* 77 */
    
    { 4,
      {
	7, 0,
	8, 0,
	8, 8,
	7, 8
      }
    }, /* 78 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	0, 2,
	0, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 79 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	1, 2,
	1, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 80 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	2, 2,
	2, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 81 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	3, 2,
	3, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 82 */
     
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	4, 2,
	4, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 83 */
   
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	5, 2,
	5, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 84 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	6, 2,
	6, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 85 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	7, 2,
	7, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 86 */
    
    { 8,
      {
	0, 1,
	8, 1,
	8, 2,
	8, 2,
	8, 6,
	8, 6,
	8, 7,
	0, 7
      }
    }, /* 87 */
    
    { 4,
      {
	7, 1,
	8, 1,
	8, 7,
	7, 7
      }
    }, /* 88 */
    
    { 4,
      {
	0, 1,
	1, 1,
	1, 7,
	0, 7
      }
    }, /* 89 */
    
    { 16,
      {
	0, 0,
	1, 0,
	4, 3,
	7, 0,
	8, 0,
	8, 1,
	5, 4,
	8, 7,
	8, 8,
	7, 8,
	4, 5,
	1, 8,
	0, 8,
	0, 7,
	3, 4,
	0, 1
      }
    }, /* 90 */
    
    { 12,
      {
	0, 4,
	4, 4,
	4, 0,
	5, 0,
	5, 4,
	8, 4,
	8, 5,
	5, 5,
	5, 8,
	4, 8,
	4, 5,
	0, 5
      }
    }, /* 91 */
    
    { 8,
      {
	2, 3,
	4, 0,
	5, 0,
	7, 3,
	5, 3,
	5, 7,
	4, 7,
	4, 3
      }
    }, /* 92 */
    
    { 8,
      {
	2, 4,
	4, 7,
	5, 7,
	7, 4,
	5, 4,
	5, 0,
	4, 0,
	4, 4
      }
    }, /* 93 */
    
    { 12,
      {
	4, 0,
	2, 3,
	4, 3,
	4, 5,
	2, 5,
	4, 8,
	5, 8,
	7, 5,
	5, 5,
	5, 3,
	7, 3,
	5, 0
      }
    }, /* 94 */
    
    { 12,
      {
	1, 1,
	1, 7,
	7, 7,
	7, 1,
	1, 1,
	0, 1,
	0, 0,
	0, 8,
	8, 8,
	8, 0,
	0, 0,
	0, 1
      }
    }, /* 95 */
    { 19,
      {
	1, 2,
	1, 1,
	2, 0,
	6, 0,
	7, 1,
	7, 3,
	5, 4,
	5, 5,
	5, 7,
	3, 7,
	3, 6,
	5, 6,
	5, 5,
	3, 5,
	3, 4, 
	5, 3,
	5, 1,
	3, 1,
	3, 2
      }
    }, /* 96 */
    { 13,
      {
	0, 7,
	0, 0,
	1, 0,
	3, 2,
	5, 0,
	6, 0,
	3, 3,
	1, 1,
	1, 3,
	4, 6,
	3, 6,
	1, 4,
	1, 7
      }
    }, /* 97 */
    { 19,
      {
	1, 0,
	2, 1,
	4, 3,
	2, 3,
	2, 1,
	1, 0,
	3, 0,
	5, 3,
	4, 3,
	4, 4,
	5, 4,
	3, 7,
	1, 7,
	2, 6,
	2, 4,
	4, 4,
	3, 5,
	2, 6,
	1, 7
      }
    }, /* 98 */
    { 10,
      {
	1, 3,
	3, 6,
	3, 0,
	4, 0,
	7, 3,
	6, 4,
	4, 1,
	4, 7,
	3, 7,
	0, 4
      }
    }, /* 99 */
    { 22,
      {
	0, 0,
	1, 0,
	3, 3,
	6, 0,
	7, 0,
	7, 7,
	6, 7,
	3, 4,
	1, 7,
	0, 7,
	1, 5,
	1, 2,
	3, 3,
	4, 3,
	6, 2,
	6, 5,
	4, 4,
	4, 3,
	3, 3,
	3, 4,
	1, 5,
	0, 7
      }
    }, /* 100 */
    { 12,
      {
	0, 7,
	0, 0,
	3, 3,
	4, 3,
	7, 0,
	7, 7,
	6, 7,
	6, 2,
	4, 4,
	3, 4,
	1, 2,
	1, 7
      }
    }, /* 101 */
    { 12,
      {
	0, 0,
	0, 7,
	1, 7,
	1, 5,
	7, 1,
	6, 0,
	1, 4,
	1, 3,
	4, 1,
	3, 0,
	1, 2,
	1, 0
      }
    }, /* 102 */
    { 16,
      {
	0, 1,
	1, 0,
	3, 3,
	4, 3,
	6, 0,
	7, 1,
	4, 3,
	4, 4,
	7, 6,
	6, 7,
	4, 4,
	3, 4,
	1, 7,
	0, 6,
	3, 4,
	3, 3
      }
    }, /* 103 */
    { 17,
      {
	0, 7,
	0, 0,
	2, 0,
	6, 4,
	6, 0,
	7, 0,
	7, 7,
	5, 7,

	1, 3,
	1, 1,
	2, 1,
	6, 5,
	6, 6,
	5, 6,
	1, 2,
	1, 1,
	1, 7
      }
    }, /* 104 */
    { 4,
      {
	3, 0,
	4, 0,
	4, 7,
	3, 7
      }
    }, /* 105 */
    { 20,
      {
	0, 3,
	3, 0,
	4, 0,
	7, 3,
	7, 4,
	6, 4,
	4, 6,
	4, 1,
	6, 3,
	6, 4,
	7, 4,
	4, 7,
	3, 7,
	0, 4,
	1, 4,
	1, 3,
	3, 1,
	3, 6,
	1, 4,
	0, 4
      }
    }, /* 106 */
    { 12,
      {
	3, 0,
	3, 3,
	0, 7,
	1, 7,
	3, 4,
	3, 7,
	4, 7,
	4, 4,
	6, 7,
	7, 7,
	4, 3,
	4, 0
      }
    }, /* 107 */
    { 7,
      {
	3, 0,
	4, 0,
	7, 3,
	7, 4,
	4, 1,
	4, 7,
	3, 7
      }
    }, /* 108 */
    { 22,
      {
	0, 0,
	2, 0,
	3, 2,
	4, 2,
	5, 0,
	7, 0,
	7, 7,
	6, 7,
	6, 1,
	4, 2,
	6, 4,
	6, 1,
	6, 5,
	4, 2,
	1, 5,
	1, 1,
	3, 2,
	1, 4,
	1, 1,
	1, 5,
	1, 7,
	0, 7
      }
    }, /* 109 */
    { 12,
      {
	0, 0,
	1, 0,
	3, 2,
	3, 0,
	4, 0,
	4, 3,
	7, 6,
	6, 6,
	4, 4,
	4, 7,
	3, 7,
	3, 4
      }
    }, /* 110 */
    { 17,
      {
	6, 0,
	6, 3,
	3, 5,
	1, 3,
	1, 7,
	0, 7,
	0, 0,
	1, 0,
	3, 2,
	6, 0,
	5, 1,
	5, 3,
	3, 4,
	1, 3,
	1, 1,
	3, 3,
	5, 1,
      }
    }, /* 111 */
    { 9,
      {
	0, 0,
	1, 0,
	1, 6,
	4, 3,
	7, 6,
	7, 7,
	4, 4,
	1, 7,
	0, 7
      }
    }, /* 112 */
    { 11,
      {
	1, 0,
	1, 7,
	2, 7,
	2, 4,
	5, 4,
	5, 7,
	6, 7,
	6, 4,
	5, 3,
	2, 3,
	2, 0
      }
    }, /* 113 */
    { 14,
      {
	1, 0,
	2, 0,
	5, 2,
	2, 4,
	2, 3,
	2, 1,
	4, 2,
	2, 3,
	2, 4,
	5, 7,
	4, 7,
	2, 5,
	2, 7,
	1, 7
      }
    }, /* 114 */
    { 8,
      {
	1, 0,
	1, 6,
	6, 1,
	6, 7,
	5, 7,
	5, 1,
	2, 5,
	2, 0
      }
    }, /* 115 */
    { 10,
      {
	0, 3,
	3, 0,
	4, 0,
	7, 3,
	7, 4,
	4, 1,
	4, 7,
	3, 7,
	3, 1,
	0, 4
      }
    }, /* 116 */
    { 8,
      {
	1, 0,
	5, 4,
	5, 7,
	4, 7,
	4, 5,
	2, 1,
	2, 7,
	1, 7
      }
    }, /* 117 */
    { 14,
      {
	0, 1,
	1, 2,
	3, 0,
	4, 0,
	6, 2,
	7, 1,
	7, 2,
	6, 3,
	4, 1,
	4, 7,
	3, 7,
	3, 1,
	1, 3,
	0, 2
      }
    }, /* 118 */
    { 11,
      {
 	1, 0,
	2, 0,
	5, 2,
	2, 4,
	2, 3,
	2, 1,
	4, 2,
	2, 3,
	2, 4,
	2, 7,
	1, 7
      }
    }, /* 119 */
    { 12,
      {
	3, 7,
	3, 4,
	0, 0,
	1, 0,
	3, 3,
	3, 0,
	4, 0,
	4, 3,
	6, 0,
	7, 0,
	4, 4,
	4, 7
      }
    }, /* 120 */
    { 10,
      {
	1, 7,
	1, 2,
	3, 4,
	3, 7,
	4, 7,
	4, 4,
	7, 7,
	7, 5,
	0, 0,
	0, 7
      }
    }, /* 121 */
    { 13,
      {
	1, 7,
	2, 7,
	6, 2,
	4, 3,
	3, 3,
	1, 2,
	5, 7,
	6, 7,
	2, 2,
	3, 1,
	4, 1,
	5, 2,
	1, 7
      }
    }, /* 122 */
    { -1,
      { 0 }
    }, /* 123 */
    { -1,
      { 0 }
    }, /* 124 */
    { -1,
      { 0 }
    }, /* 125 */
    { -1,
      { 0 }
    }, /* 126 */
    { -1,
      { 0 }
    }  /* 127 */
  }
};
