/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file is part of libebml.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: EbmlDummy.h,v 1.3 2003/09/13 17:19:57 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/
#ifndef LIBEBML_DUMMY_H
#define LIBEBML_DUMMY_H

#include "EbmlBinary.h"

START_LIBEBML_NAMESPACE

class EbmlDummy : public EbmlBinary {
	public:
		EbmlDummy() :DummyId(DummyRawId)  {}
		EbmlDummy(const EbmlId & aId) :EbmlBinary(), DummyId(aId) {}
		EbmlDummy(const EbmlDummy & ElementToClone):EbmlBinary(ElementToClone), DummyId(ElementToClone.DummyId) {}
		static EbmlElement & Create() {return *(new EbmlDummy);}
		const EbmlCallbacks & Generic() const {return ClassInfos;}
		static const EbmlCallbacks ClassInfos;
		operator const EbmlId &() const {return DummyId;}

		bool ValidateSize() const {return true;}
		bool IsDummy() const {return true;}
		bool IsDefaultValue() const {return true;}

		EbmlElement * Clone() const {return new EbmlDummy(*this);}

	protected:
		const EbmlId DummyId;
		static const EbmlId DummyRawId;
};

END_LIBEBML_NAMESPACE

#endif // LIBEBML_DUMMY_H
