/*******************************************************************************
* manager.h: Manager class definition
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: manager.h,v 1.1 2001/10/06 21:23:37 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _MANAGER_H_
#define _MANAGER_H_

//------------------------------------------------------------------------------
// C_Manager : manage all the inputs and their programs
//------------------------------------------------------------------------------
class C_Manager : public C_RequestHandler, public C_EventHandler,
                  public C_Thread
{
 public:
  C_Manager(handle hLog, C_EventHub* pEventHub);
  virtual ~C_Manager();

  int Init();
  int Run();
  int Stop();
  int Destroy();

  // Handlers
  virtual C_Answer HandleRequest(const C_Request& cRequest);
  virtual void HandleEvent(const C_Event& cEvent);

 protected:
  // Pgrm table management
  void InitPgrmTable();
  void DestroyPgrmTable();
  // Inputs management
  void InitInputs();
  void DestroyInputs();
  // Channels management
  void InitChannels();
  void DestroyChannels();  

  void StopPrograms();

  // Commands processing
  C_Answer Browse(const C_Request& cRequest);
  C_Answer Start(const C_Request& cRequest);
  C_Answer Resume(const C_Request& cRequest);
  C_Answer Suspend(const C_Request& cRequest);
  C_Answer Stop(const C_Request& cRequest);

  // C_Thread APIs to isolate events
  virtual void InitWork();
  virtual void DoWork();
  virtual void StopWork();
  virtual void CleanWork();

 private:
  virtual void PrivHandleEvent(const C_Event& cEvent);

  handle m_hLog;
  C_EventHub* m_pEventHub;
  C_Mutex m_cCmdLock;

  bool m_bStop;

  C_Mutex m_cEventFifoLock;
  C_Semaphore m_cEventQueued;
  C_Vector<C_Event> m_cEventFifo;

  // Ressources
  C_Repository<C_String, C_Input> m_cInputList;
  C_Repository<C_String, C_Channel> m_cChannelList;

  // Programs
  C_PgrmDirectory m_cProgramList;

  // Running broadcasts
  C_Repository<C_String, C_Broadcast> m_cBroadcasts;
};



#else
#error "Multiple inclusions of manager.h"
#endif

