/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.resources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.CustomFileFilter;
import vlcskineditor.Helper;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.BitmapEditEvent;
import vlcskineditor.resources.ImageResource;
import vlcskineditor.resources.SubBitmap;

public class Bitmap
extends ImageResource
implements ActionListener {
    public String file;
    public final String ALPHACOLOR_DEFAULT = "#FF00FF";
    public String alphacolor = "#FF00FF";
    final int NBFRAMES_DEFAULT = 1;
    public int nbframes = 1;
    public final int FPS_DEFAULT = 0;
    public int fps = 0;
    public List<SubBitmap> SubBitmaps = new LinkedList<SubBitmap>();
    private JFrame frame = null;
    private JTextField id_tf;
    private JTextField file_tf;
    private JTextField alphacolor_tf;
    private JTextField nbframes_tf;
    private JTextField fps_tf;
    private JButton file_btn;
    private JButton alphacolor_btn;
    private JButton ok_btn;
    private JButton cancel_btn;
    private JButton help_btn;
    private JFileChooser fc;

    public Bitmap(Node node, Skin skin) {
        this.type = Language.get("BITMAP");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", this.id);
        this.file = XML.getStringAttributeValue(node, "file", this.file);
        this.alphacolor = XML.getStringAttributeValue(node, "alphacolor", this.alphacolor);
        this.nbframes = XML.getIntAttributeValue(node, "nbframes", this.nbframes);
        this.fps = XML.getIntAttributeValue(node, "fps", this.fps);
        this.updateImage();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("SubBitmap")) continue;
            this.SubBitmaps.add(new SubBitmap(node2, this.s, this));
        }
    }

    public Bitmap(Skin skin, File file) {
        this.type = Language.get("BITMAP");
        this.s = skin;
        this.file = file.getPath().replace(this.s.skinfolder, "");
        String string = this.file.replaceAll("\\\\", "_").replaceAll("/", "_").substring(0, this.file.lastIndexOf("."));
        if (this.s.idExists(string)) {
            string = string + "_" + this.s.getNewId();
        }
        this.id = string;
        this.s.updateResources();
        this.updateImage();
    }

    public Bitmap(Bitmap bitmap) {
        this.type = Language.get("BITMAP");
        this.s = bitmap.s;
        this.id = bitmap.id;
        this.file = bitmap.file;
        this.alphacolor = bitmap.alphacolor;
        this.nbframes = bitmap.nbframes;
        this.fps = bitmap.fps;
        this.updateImage();
        for (SubBitmap subBitmap : bitmap.SubBitmaps) {
            this.SubBitmaps.add(new SubBitmap(subBitmap));
        }
    }

    public boolean updateImage() {
        try {
            this.image = ImageIO.read(new File(this.s.skinfolder + this.file));
            this.image = this.image.getSubimage(0, 0, this.image.getWidth(), this.image.getHeight() / this.nbframes);
            if (this.image.getType() != 13) {
                BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                int n = Color.decode(this.alphacolor).getRGB();
                for (int i = 0; i < this.image.getWidth(); ++i) {
                    for (int j = 0; j < this.image.getHeight(); ++j) {
                        int n2 = this.image.getRGB(i, j);
                        int n3 = n2 >> 16 & 0xFF;
                        int n4 = n2 >> 8 & 0xFF;
                        int n5 = n2 & 0xFF;
                        int n6 = n2 >> 24 & 0xFF;
                        if (this.image.getRGB(i, j) != n && n6 >= 255) {
                            graphics2D.setColor(new Color(n3, n4, n5, n6));
                            graphics2D.drawRect(i, j, 0, 0);
                            continue;
                        }
                        if (this.image.getRGB(i, j) == n || n6 <= 0) continue;
                        float f = n6;
                        graphics2D.setColor(new Color((int)((float)n3 * (f /= 255.0f)), (int)((float)n4 * f), (int)((float)n5 * f)));
                        graphics2D.drawRect(i, j, 0, 0);
                    }
                }
                this.image = bufferedImage;
            }
            for (int i = 0; i < this.SubBitmaps.size(); ++i) {
                this.SubBitmaps.get(i).updateImage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, Language.get("ERROR_BITMAP_LOAD").replaceAll("%i", this.id), Language.get("ERROR_BITMAP_LOAD_TITLE"), 0);
            this.image = new BufferedImage(32, 32, 2);
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.setColor(new Color(255, 0, 0, 128));
            graphics2D.fillRect(0, 0, 32, 32);
            return false;
        }
        return true;
    }

    @Override
    public void update() {
        BitmapEditEvent bitmapEditEvent = new BitmapEditEvent(this);
        this.file = this.file_tf.getText();
        this.alphacolor = this.alphacolor_tf.getText();
        this.nbframes = Integer.parseInt(this.nbframes_tf.getText());
        this.fps = Integer.parseInt(this.fps_tf.getText());
        String string = this.id;
        this.id = this.id_tf.getText();
        if (!string.equals(this.id)) {
            this.s.updateResources();
            this.s.expandResource(this.id);
        }
        bitmapEditEvent.setNew();
        this.s.m.hist.addEvent(bitmapEditEvent);
        this.fireResourceChangedEvent(string);
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_BITMAP_TITLE"));
            this.frame.setDefaultCloseOperation(2);
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            this.id_tf.setToolTipText(Language.get("WIN_ITEM_ID_TIP".replaceAll("%t", this.type)));
            JLabel jLabel2 = new JLabel(Language.get("WIN_BITMAP_FILE"));
            this.file_tf = new JTextField();
            this.file_tf.setToolTipText(Language.get("WIN_BITMAP_FILE_TIP"));
            this.file_btn = new JButton(Language.get("WIN_BITMAP_OPEN"));
            this.file_btn.addActionListener(this);
            JLabel jLabel3 = new JLabel(Language.get("WIN_BITMAP_ALPHACOLOR"));
            this.alphacolor_tf = new JTextField();
            this.alphacolor_tf.setToolTipText(Language.get("WIN_BITMAP_ALPHACOLOR_TIP"));
            this.alphacolor_btn = new JButton(Language.get("WIN_BITMAP_CHOOSE"));
            this.alphacolor_btn.addActionListener(this);
            JLabel jLabel4 = new JLabel(Language.get("WIN_BITMAP_NBFRAMES"));
            this.nbframes_tf = new JTextField();
            this.nbframes_tf.setDocument(new NumbersOnlyDocument());
            this.nbframes_tf.setToolTipText(Language.get("WIN_BITMAP_NBFRAMES_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_BITMAP_FPS"));
            this.fps_tf = new JTextField();
            this.fps_tf.setDocument(new NumbersOnlyDocument());
            this.fps_tf.setToolTipText(Language.get("WIN_BITMAP_FPS_TIP"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel6 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            Component[] componentArray2 = new Component[]{this.file_btn, this.alphacolor_btn};
            int n3 = Helper.maxWidth(componentArray2);
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jPanel.add(jLabel2);
            jPanel.add(this.file_tf);
            jPanel.add(this.file_btn);
            jPanel.add(jLabel3);
            jPanel.add(this.alphacolor_tf);
            jPanel.add(this.alphacolor_btn);
            this.file_tf.setPreferredSize(new Dimension(n2 - n3, this.file_tf.getPreferredSize().height));
            this.file_btn.setPreferredSize(new Dimension(n3, this.file_btn.getPreferredSize().height));
            this.alphacolor_tf.setPreferredSize(new Dimension(n2 - n3, this.alphacolor_tf.getPreferredSize().height));
            this.alphacolor_btn.setPreferredSize(new Dimension(n3, this.alphacolor_btn.getPreferredSize().height));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.id_tf, 0, "East", (Component)this.file_btn);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)jLabel);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.file_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.file_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.file_btn, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.file_btn, 5, "East", (Component)this.file_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.file_btn);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.alphacolor_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.alphacolor_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.alphacolor_btn, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.alphacolor_btn, 5, "East", (Component)this.alphacolor_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.alphacolor_btn);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)jLabel3);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel4);
            jPanel2.add(this.nbframes_tf);
            jPanel2.add(jLabel5);
            jPanel2.add(this.fps_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_BITMAP_ANIMATION")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            this.nbframes_tf.setPreferredSize(new Dimension(n2, this.nbframes_tf.getPreferredSize().height));
            springLayout2.putConstraint("North", (Component)jLabel4, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.nbframes_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.nbframes_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.nbframes_tf);
            springLayout2.putConstraint("North", (Component)jLabel5, 10, "South", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.fps_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.fps_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.fps_tf, 0, "East", (Component)this.nbframes_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)jLabel5);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel6);
            SpringLayout springLayout3 = new SpringLayout();
            this.frame.setLayout(springLayout3);
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 5, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel6, 5, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel6, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("East", (Component)jLabel6, 5, "East", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 5, "South", (Component)jLabel6);
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 5, "South", (Component)jLabel6);
            springLayout3.putConstraint("North", (Component)this.help_btn, 5, "South", (Component)jLabel6);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 5, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.file_tf.setText(this.file);
        this.alphacolor_tf.setText(this.alphacolor);
        this.nbframes_tf.setText(String.valueOf(this.nbframes));
        this.fps_tf.setText(String.valueOf(this.fps));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.file_btn)) {
            int n;
            if (this.fc == null) {
                this.fc = new JFileChooser();
                this.fc.setFileFilter(new CustomFileFilter(this.fc, "png", "*.png (Portable Network Graphics) " + Language.get("FILE_INDIR"), true, this.s.skinfolder));
                this.fc.setCurrentDirectory(new File(this.s.skinfolder));
                this.fc.setAcceptAllFileFilterUsed(false);
            }
            if ((n = this.fc.showOpenDialog(this.frame)) == 0) {
                this.file_tf.setText(this.fc.getSelectedFile().getPath().replace(this.s.skinfolder, ""));
            }
        } else if (actionEvent.getSource().equals(this.alphacolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_BITMAP_CHOOSER_TITLE"), Color.decode(this.alphacolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.alphacolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (this.file_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_FILE_INVALID_MSG"), Language.get("ERROR_FILE_INVALID_TITLE"), 1);
                return;
            }
            if (Integer.parseInt(this.nbframes_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_NBFRAMES_MSG"), Language.get("ERROR_NBFRAMES_TITLE"), 1);
                return;
            }
            this.update();
            if (this.updateImage()) {
                this.frame.setVisible(false);
                this.frame.dispose();
                this.frame = null;
            } else {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_INVALID_MSG"), Language.get("ERROR_FILE_INVALID_TITLE"), 0);
            }
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/res-bitmap.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Bitmap id=\"" + this.id + "\" file=\"" + this.file + "\"";
        string2 = string2 + " alphacolor=\"" + this.alphacolor + "\"";
        if (this.nbframes != 1) {
            string2 = string2 + " nbframes=\"" + String.valueOf(this.nbframes) + "\"";
        }
        if (this.fps != 0) {
            string2 = string2 + " fps=\"" + String.valueOf(this.fps) + "\"";
        }
        if (this.SubBitmaps.size() > 0) {
            string2 = string2 + ">\n";
            for (int i = 0; i < this.SubBitmaps.size(); ++i) {
                string2 = string2 + this.SubBitmaps.get(i).returnCode(string + Skin.indentation);
            }
            string2 = string2 + string + "</Bitmap>\n";
        } else {
            string2 = string2 + "/>\n";
        }
        return string2;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Bitmap: " + this.id);
        for (int i = 0; i < this.SubBitmaps.size(); ++i) {
            defaultMutableTreeNode.add(this.SubBitmaps.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    @Override
    public Resource getParentOf(String string) {
        for (SubBitmap subBitmap : this.SubBitmaps) {
            if (!subBitmap.id.equals(string)) continue;
            return this;
        }
        return null;
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        for (SubBitmap subBitmap : this.SubBitmaps) {
            subBitmap.renameForCopy(string2);
        }
    }
}

