/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import org.havi.ui.HConfigurationException;
import org.havi.ui.HGraphicsConfigTemplate;
import org.havi.ui.HGraphicsConfiguration;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HScreenDevice;
import org.videolan.Logger;

public class HGraphicsDevice
extends HScreenDevice {
    private HGraphicsConfiguration[] hgcArray;
    private HGraphicsConfiguration hgc;
    private static final Logger logger = Logger.getLogger(HGraphicsDevice.class.getName());

    protected HGraphicsDevice() {
        int length = HScreenConfigTemplate.defaultConfig.length;
        this.hgcArray = new HGraphicsConfiguration[length];
        for (int i = 0; i < length; ++i) {
            HGraphicsConfigTemplate hgct = new HGraphicsConfigTemplate();
            HScreenConfigTemplate.initDefaultConfigTemplate(hgct, i);
            this.hgcArray[i] = new HGraphicsConfiguration(hgct);
        }
        this.hgc = this.hgcArray[0];
    }

    public HGraphicsConfiguration[] getConfigurations() {
        return this.hgcArray;
    }

    public HGraphicsConfiguration getDefaultConfiguration() {
        return this.hgcArray[0];
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate hgct) {
        int score = -1;
        HGraphicsConfiguration hgc = null;
        for (int i = 0; i < this.hgcArray.length; ++i) {
            if (hgct.match(this.hgcArray[i]) <= score) continue;
            hgc = this.hgcArray[i];
        }
        return hgc;
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate[] hgcta) {
        int score = -1;
        HGraphicsConfiguration hgc = null;
        for (int i = 0; i < this.hgcArray.length; ++i) {
            for (int j = 0; j < hgcta.length; ++j) {
                if (hgcta[j].match(this.hgcArray[i]) <= score) continue;
                hgc = this.hgcArray[i];
            }
        }
        return hgc;
    }

    public HGraphicsConfiguration getCurrentConfiguration() {
        return this.hgc;
    }

    public boolean setGraphicsConfiguration(HGraphicsConfiguration hgc) throws SecurityException, HPermissionDeniedException, HConfigurationException {
        this.hgc = hgc;
        logger.unimplemented("setGraphicsConfiguration");
        return true;
    }
}

