/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2004 Ingo Ralf Blum.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: KaxConfig.h,v 1.5 2004/01/17 21:40:47 mosu Exp $
*/
#ifndef LIBMATROSKA_CONFIG_H
#define LIBMATROSKA_CONFIG_H

// We allow the user to set the namespace for the library for cases, where the name conflicts
#ifdef NO_NAMESPACE // for older GCC

#define LIBMATROSKA_NAMESPACE libmatroska
#define START_LIBMATROSKA_NAMESPACE
#define END_LIBMATROSKA_NAMESPACE
#else // NO_NAMESPACE

#ifndef LIBMATROSKA_NAMESPACE
#define LIBMATROSKA_NAMESPACE libmatroska
#define START_LIBMATROSKA_NAMESPACE namespace LIBMATROSKA_NAMESPACE {
#define END_LIBMATROSKA_NAMESPACE   };
#endif // LIBMATROSKA_NAMESPACE

#endif // NO_NAMESPACE

// There are special implementations for certain platforms. For example on Windows
// we use the Win32 file API. here we set the appropriate macros.
#if defined(_WIN32)||defined(WIN32)

#if defined(MATROSKA_DLL)
# if defined(MATROSKA_DLL_EXPORT)
#  define MATROSKA_DLL_API __declspec(dllexport)
# else // MATROSKA_DLL_EXPORT
#  define MATROSKA_DLL_API __declspec(dllimport)
# endif // MATROSKA_DLL_EXPORT
#else // MATROSKA_DLL
# define MATROSKA_DLL_API
#endif // MATROSKA_DLL

#define LIBMATROSKA_WIN32
#else
#define LIBMATROSKA_UNIX
#define MATROSKA_DLL_API
#endif

// The MATROSKA_DEBUG symbol is defined, when we are creating a debug build. In this
// case the debug logging code is compiled in.
#if (defined(DEBUG)||defined(_DEBUG))&&!defined(LIBMATROSKA_DEBUG)
#define LIBMATROSKA_DEBUG
#endif

#if !defined(MATROSKA_VERSION)
#define MATROSKA_VERSION  1
#endif // MATROSKA_VERSION


#endif // LIBMATROSKA_CONFIG_H
