/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2004 Steve Lhomme.  All rights reserved.
**
** This file is part of libmatroska.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: KaxContexts.h,v 1.5 2004/01/17 21:40:47 mosu Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/
#ifndef LIBMATROSKA_CONTEXTS_H
#define LIBMATROSKA_CONTEXTS_H

#include "matroska/KaxTypes.h"
#include "ebml/EbmlElement.h"

using namespace LIBEBML_NAMESPACE;

START_LIBMATROSKA_NAMESPACE

extern const EbmlSemanticContext MATROSKA_DLL_API KaxSegment_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxAttachments_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxAttached_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxFileDescription_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxFileName_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxMimeType_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxFileData_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxChapters_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCluster_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTags_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTag_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxBlockGroup_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxReferencePriority_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxReferenceBlock_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxReferenceVirtual_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCues_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxInfo_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxSeekHead_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTracks_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackEntry_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackNumber_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackType_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackFlagEnabled_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackFlagDefault_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackFlagLacing_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackName_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackLanguage_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecID_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecPrivate_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecName_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecSettings_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecInfoURL_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecDownloadURL_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxCodecDecodeAll_Context;
extern const EbmlSemanticContext MATROSKA_DLL_API KaxTrackOverlay_Context;

extern const EbmlSemanticContext & MATROSKA_DLL_API GetKaxGlobal_Context();
extern const EbmlSemanticContext & MATROSKA_DLL_API GetKaxTagsGlobal_Context();

END_LIBMATROSKA_NAMESPACE

#endif // LIBMATROSKA_CONTEXTS_H
