/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.videolan.BUMFAsset;
import org.videolan.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BUMFParser
extends DefaultHandler {
    private LinkedList assets = new LinkedList();
    private static final int ELEMENT_NONE = 0;
    private static final int ELEMENT_ASSET = 1;
    private static final int ELEMENT_BUDA_FILE = 2;
    private boolean inBudaFile = false;
    private boolean inDocument = false;
    private int element = 0;
    private String vpFile = null;
    private String budaFile = null;
    private static final Logger logger = Logger.getLogger(BUMFParser.class.getName());

    public static BUMFAsset[] parse(String manifestFile) {
        try {
            return new BUMFParser(manifestFile).getAssets();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BUMFAsset[] getAssets() {
        return this.assets.toArray(new BUMFAsset[this.assets.size()]);
    }

    private BUMFParser(String manifestFile) throws Exception {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(manifestFile);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)stream, (DefaultHandler)this);
        }
        catch (Exception e) {
            logger.error("Binding unit manifest file parsing failed: " + e);
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block13: {
            block12: {
                if (qName.equalsIgnoreCase("bumf:manifest")) {
                    this.inBudaFile = true;
                    return;
                }
                if (!this.inBudaFile) {
                    logger.error("invalid start element: " + qName);
                    throw new SAXException("element not supported");
                }
                if (qName.equalsIgnoreCase("Assets")) {
                    this.inDocument = true;
                    return;
                }
                if (!this.inDocument) {
                    logger.error("unknown element: " + qName + " (expected Assets)");
                    throw new SAXException("element not supported");
                }
                if (qName.equalsIgnoreCase("Asset")) {
                    this.vpFile = null;
                    this.budaFile = null;
                    this.element = 1;
                } else if (qName.equalsIgnoreCase("BUDAFile")) {
                    this.element = 2;
                } else {
                    logger.error("unknown element: " + qName);
                    throw new SAXException("element not supported");
                }
                if (this.element != 1) break block12;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrName = attributes.getQName(i);
                    if (!attrName.equals("VPFilename")) {
                        logger.error("unknown VPFilename attribute: " + attrName);
                        throw new SAXException("invalid attribute name: " + attrName);
                    }
                    this.vpFile = attributes.getValue(i);
                }
                break block13;
            }
            if (this.element != 2) break block13;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                if (!attrName.equals("name")) {
                    logger.error("unknown BUDAFile attribute: " + attrName);
                    throw new SAXException("invalid attribute name: " + attrName);
                }
                this.budaFile = attributes.getValue(i);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("Assets")) {
            this.inDocument = false;
            return;
        }
        if (this.inDocument && qName.equalsIgnoreCase("Asset")) {
            logger.info("Asset: " + this.vpFile + " <- " + this.budaFile);
            if (this.vpFile != null && this.budaFile != null) {
                this.assets.add(new BUMFAsset(this.vpFile, this.budaFile));
            }
            this.vpFile = null;
            this.budaFile = null;
        }
        this.element = 0;
    }
}

