/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import javax.media.Control;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.media.MediaSelectFailedEvent;
import javax.tv.media.MediaSelectListener;
import javax.tv.media.MediaSelectSucceededEvent;
import javax.tv.service.selection.InsufficientResourcesException;
import javax.tv.service.selection.InvalidServiceComponentException;
import org.bluray.media.AsynchronousPiPControl;
import org.bluray.net.BDLocator;
import org.dvb.media.DVBMediaSelectControl;
import org.videolan.BDJListeners;
import org.videolan.Logger;
import org.videolan.PlaylistInfo;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.StreamControl;

public class DVBMediaSelectControlImpl
implements DVBMediaSelectControl {
    private BDJListeners listeners = new BDJListeners();
    private Handler player;

    protected DVBMediaSelectControlImpl(Handler player) {
        this.player = player;
    }

    public void add(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (!this.checkLocator(component)) {
            throw new InvalidLocatorException(component);
        }
        BDLocator locator = (BDLocator)component;
        if (locator.getSecondaryVideoStreamNumber() <= 0) {
            throw new InvalidServiceComponentException(component);
        }
        AsynchronousPiPControl control = (AsynchronousPiPControl)this.player.getControl("org.bluray.media.AsynchronousPiPControl");
        if (control.getCurrentStreamNumber() > 0) {
            throw new InsufficientResourcesException();
        }
        try {
            control.selectStreamNumber(locator.getSecondaryVideoStreamNumber());
        }
        catch (Exception e) {
            System.err.println("" + e + "\n" + Logger.dumpStack(e));
            this.postMediaSelectFailedEvent(new Locator[]{component});
        }
    }

    public void remove(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, SecurityException {
        if (!this.checkLocator(component)) {
            throw new InvalidLocatorException(component);
        }
        BDLocator locator = (BDLocator)component;
        if (locator.getSecondaryVideoStreamNumber() <= 0) {
            throw new InvalidServiceComponentException(component);
        }
        AsynchronousPiPControl control = (AsynchronousPiPControl)this.player.getControl("org.bluray.media.AsynchronousPiPControl");
        if (control.getCurrentStreamNumber() != locator.getSecondaryVideoStreamNumber()) {
            throw new InvalidLocatorException(component);
        }
        try {
            control.stop();
        }
        catch (Exception e) {
            System.err.println("" + e + "\n" + Logger.dumpStack(e));
            this.postMediaSelectFailedEvent(new Locator[]{component});
        }
    }

    public void select(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (!this.checkLocator(component)) {
            throw new InvalidLocatorException(component);
        }
        Control control = this.getControl((BDLocator)component);
        if (control == null) {
            throw new InvalidLocatorException(component);
        }
        if (!(control instanceof StreamControl)) {
            return;
        }
        int stream = this.getStream((BDLocator)component);
        if (stream <= 0) {
            throw new InvalidLocatorException(component);
        }
        try {
            ((StreamControl)control).selectStreamNumber(stream);
        }
        catch (Exception e) {
            this.postMediaSelectFailedEvent(new Locator[]{component});
            throw new InvalidLocatorException(component);
        }
    }

    public void select(Locator[] components) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        for (int i = 0; i < components.length; ++i) {
            this.select(components[i]);
        }
    }

    public void replace(Locator fromComponent, Locator toComponent) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (!this.checkLocator(fromComponent)) {
            throw new InvalidLocatorException(fromComponent);
        }
        if (!this.checkLocator(toComponent)) {
            throw new InvalidLocatorException(toComponent);
        }
        Control fromControl = this.getControl((BDLocator)fromComponent);
        if (fromControl == null) {
            throw new InvalidLocatorException(fromComponent);
        }
        Control toControl = this.getControl((BDLocator)toComponent);
        if (toControl == null) {
            throw new InvalidLocatorException(toComponent);
        }
        if (fromControl != toControl) {
            throw new InvalidLocatorException(fromComponent);
        }
        int fromStream = this.getStream((BDLocator)fromComponent);
        if (fromStream <= 0 || fromStream != ((StreamControl)fromControl).getCurrentStreamNumber()) {
            throw new InvalidLocatorException(fromComponent);
        }
        int toStream = this.getStream((BDLocator)toComponent);
        if (toStream <= 0) {
            throw new InvalidLocatorException(toComponent);
        }
        try {
            ((StreamControl)fromControl).selectStreamNumber(toStream);
        }
        catch (Exception e) {
            this.postMediaSelectFailedEvent(new Locator[]{toComponent});
            throw new InvalidLocatorException(toComponent);
        }
    }

    public void addMediaSelectListener(MediaSelectListener listener) {
        this.listeners.add(listener);
    }

    public void removeMediaSelectListener(MediaSelectListener listener) {
        this.listeners.remove(listener);
    }

    private void postMediaSelectFailedEvent(Locator[] selection) {
        this.listeners.putCallback(new MediaSelectFailedEvent(this.player, selection));
    }

    protected void postMediaSelectSucceededEvent(Locator[] selection) {
        this.listeners.putCallback(new MediaSelectSucceededEvent(this.player, selection));
    }

    public Locator[] getCurrentSelection() {
        BDLocator locator = this.player.getCurrentLocator();
        if (locator == null) {
            return new Locator[0];
        }
        String[] tags = locator.getComponentTags();
        if (tags.length <= 0) {
            return new Locator[0];
        }
        Locator[] selections = new Locator[tags.length];
        String[] tag = new String[1];
        for (int i = 0; i < tags.length; ++i) {
            tag[0] = tags[i];
            try {
                selections[i] = new BDLocator(locator.getDiscId(), locator.getTitleNumber(), locator.getPlayListId(), locator.getPlayItemId(), locator.getMarkId(), tag);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Locator[0];
            }
        }
        return selections;
    }

    public void selectServiceMediaComponents(Locator locator) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException {
        if (!(locator instanceof BDLocator)) {
            throw new InvalidLocatorException(locator);
        }
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            throw new InsufficientResourcesException();
        }
        if (((BDLocator)locator).getPlayListId() != pi.getPlaylist()) {
            throw new InvalidLocatorException(locator);
        }
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            throw new InsufficientResourcesException();
        }
        String[] tags = ((BDLocator)locator).getComponentTags();
        String[] tag = new String[1];
        for (int i = 0; i < tags.length; ++i) {
            tag[0] = tags[i];
            try {
                this.select(new BDLocator(null, -1, pi.getPlaylist(), ci.getIndex(), -1, tag));
                continue;
            }
            catch (org.davic.net.InvalidLocatorException e) {
                e.printStackTrace();
                throw new InvalidLocatorException(locator);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new InsufficientResourcesException();
            }
        }
    }

    public Component getControlComponent() {
        return null;
    }

    private boolean checkLocator(Locator locator) {
        if (locator == null || !(locator instanceof BDLocator)) {
            return false;
        }
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            return false;
        }
        BDLocator bdLocator = (BDLocator)locator;
        if (bdLocator.getComponentTagsCount() != 1) {
            return false;
        }
        if (bdLocator.getPlayListId() != -1 && bdLocator.getPlayListId() != pi.getPlaylist()) {
            return false;
        }
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            return false;
        }
        return bdLocator.getPlayItemId() == -1 || bdLocator.getPlayItemId() == ci.getIndex();
    }

    private int getStream(BDLocator locator) {
        if (locator.getPrimaryVideoStreamNumber() > 0) {
            return locator.getPrimaryVideoStreamNumber();
        }
        if (locator.getPrimaryAudioStreamNumber() > 0) {
            return locator.getPrimaryAudioStreamNumber();
        }
        if (locator.getSecondaryVideoStreamNumber() > 0) {
            return locator.getSecondaryVideoStreamNumber();
        }
        if (locator.getSecondaryAudioStreamNumber() > 0) {
            return locator.getSecondaryAudioStreamNumber();
        }
        if (locator.getPGTextStreamNumber() > 0) {
            return locator.getPGTextStreamNumber();
        }
        return -1;
    }

    private Control getControl(BDLocator locator) {
        if (locator.getPrimaryVideoStreamNumber() > 0) {
            return this.player.getControl("org.bluray.media.BackgroundVideoPresentationControl");
        }
        if (locator.getPrimaryAudioStreamNumber() > 0) {
            return this.player.getControl("org.bluray.media.PrimaryAudioControl");
        }
        if (locator.getSecondaryVideoStreamNumber() > 0) {
            return this.player.getControl("org.bluray.media.AsynchronousPiPControl");
        }
        if (locator.getSecondaryAudioStreamNumber() > 0) {
            return this.player.getControl("org.bluray.media.SecondaryAudioControl");
        }
        if (locator.getPGTextStreamNumber() > 0) {
            return this.player.getControl("org.bluray.media.SubtitlingControl");
        }
        return null;
    }
}

