.TH XLOAD 1 "18 August 1985" "X Version 10"
.SH NAME
xload - X window system load average display
.SH SYNOPSIS
.B xload
[ option ] ...
.SH DESCRIPTION
.I xload 
continuously displays the system load average under the
.I X
window system.
.I xload
creates a window in which the load average is represented as a bar graph
with n divisions. Each division represents one unit of load average.
The name of the host is displayed in the upper left corner.
.PP
.I xload
understands the following options:
.PP
.TP 8
.B \-bd \fIcolor\fP
Specify the border color.
On monochrome displays this option is ignored.
The default color is ``black''.
.PP
.TP 8
.B \-bg \fIcolor\fP
Specify the background color.
On monochrome displays this option is ignored.
The default color is ``white''.
.PP
.TP 8
.B \-bw \fIpixels\fP
Specify the width in pixels of the border around the
.I xload
window. The default value is 3 pixels.
.PP
.TP 8
.B \-fg \fIcolor\fP
Specify the graph color.
On monochrome displays this option is ignored.
The default color is ``black''.
.PP
.TP 8
.B \-fn \fIfontname\fP
The hostname will be displayed in the specified font (if none
is specified, this defaults to 6x10).
.PP
.TP 8
.B \-hl \fIcolor\fP
Specify the hostname and scale line color; the default is to make it the same
as the graph color.
.PP
.TP 8
.B \-rv
Reverses the default color values (i.e., black becomes white and white
becomes black).
.PP
.TP 8
.B \-fw
Forces the default color values to remain at their predetermined settings
(i.e., white is white and black is black).
.PP
.TP 8
.B \-scale \fIinteger\fP
Specify the minimum number of divisions on the graph (default 1).
.I Xload
is free to use more divisions if the load gets too high to display,
but it will never use fewer divisions than this.
.PP
.TP 8
.B \-update \fIseconds\fP
Specify the frequency in seconds with which
.I xload
updates its display (except if the
.I xload
window is obscured and then exposed, immediate redisplay occurs).  The default
update frequency is 5 seconds.  Specification of a frequency
less than 5 seconds is ignored and the default frequency is used instead.
.PP
.TP 8
.B =\fIgeometry\fP
The load graph window is created with the specified
size and location
determined
by the supplied geometry specification.
See \fIX(1)\fP for a full explanation.
.PP
.TP 8
.B \[\fIhost\fP]:\[\fIdisplay\fP]
Normally,
.I xload
gets the host and display number to use from the environment
variable ``DISPLAY''.  Either or both can be specified with this option.
.I host
specifies which machine to create the
.I xload
window on, and
.I display
specifies the display number.
For example,
``mit-grape-nehi:0'' creates an
.I xload
on display 0 on machine mit-grape-nehi. Either value can be defaulted
by omission but ``:'' is necessary to specify one or both.
.SH X DEFAULTS
.PP
.TP 8
.B Foreground
Set the graph color.  Ignored on monochrome displays.
.PP
.TP 8
.B Background
Set the background color.  Ignored on monochrome display.
.PP
.TP 8
.B BodyFont
Set the hostname font.
.PP
.TP 8
.B Border
Set the internal border padding.
.PP
.TP 8
.B BorderColor
Set the border color.
Ignored on monochrome displays.
.PP
.TP 8
.B BorderWidth
Set the border width of the window.
.PP
.TP 8
.B Highlight
Set the hostname and scale line color.
Ignored on monochrome displays.
.PP
.TP 8
.B ReverseVideo
If ``on'', reverse the effect of the defaults colors.
Ignored on color displays.
.PP
.TP 8
.B Scale
Set the minimum scale.
.PP
.TP 8
.B Update
Set the update interval.
.SH ENVIRONMENT
DISPLAY - to get the default host and display number.
.SH SEE ALSO
X(10, xwm(1), X(8C), mem(4), select(2)
.SH DIAGNOSTICS
Unable to open display or create window. Unable to open /dev/kmem.
Unable to query window for dimensions. Various X errors.
.SH BUGS
.I xload
requires the ability to open and read /dev/kmem. On most systems, this requires
the suid bit set with root ownership or the sgid bit set and membership in 
the same group as /dev/kmem. 
.SH AUTHORS
K. Shane Hartman (MIT-LCS), Stuart A. Malone (MIT-LCS)
.br
Host name feature added by Jim Gettys (MIT-Athena).
Scale feature added by Bob Scheifler (MIT-LCS).
Automatic rescaling feature added by Stuart A. Malone (MIT-LCS).
Color enhancements added by Tony Della Fera (MIT-Athena)
.br
Copyright (c) 1985, Massachusetts Institute of Technology.
.br
See X(1) for a complete copyright notice.
