.TH XLOAD 1 "1 March 1988" "X Version 11"
.SH NAME
xload - load average display for X
.SH SYNOPSIS
.B xload
[-\fItoolkitoption\fP ...] [-scale \fIinteger\fP] [-update \fIseconds\fP]
.SH DESCRIPTION
The 
.I xload 
program displays a periodically updating histogram of the system load average.
This program is nothing more than a wrapper around the Athena Load widget.
.SH OPTIONS
.PP
.I Xload
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.PP
.TP 8
.B \-scale \fIinteger\fP
This option specifies the minimum number of tick marks in the histogram,
where one division represents one load average point.  If the load goes
above this number, \fIxload\fP will create more divisions, but it will never
use fewer than this number.  The default is 1.
.PP
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which
.I xload
updates its display.  Expose events will cause automatic updating.  The minimum
as well as default time is 5 seconds.
.PP
The following standard X Toolkit arguments are commonly used
with \fIxload\fP.
.PP
.TP 8
.B \-bd \fIcolor\fP
This option specifies the border color.
The default color is ``black''.
.PP
.TP 8
.B \-bg \fIcolor\fP
This option specifies the background color.
The default color is ``white''.
.PP
.TP 8
.B \-bw \fIpixels\fP
This option specifies the width in pixels of the border around the window.
The default value is 2.
.PP
.TP 8
.B \-fg \fIcolor\fP
This option specifies the graph color.
The default color is ``black''.
.PP
.TP 8
.B \-fn \fIfontname\fP
This option specifies the font to be used in displaying the name of the 
host whose load is being monitored.  The default is ``6x10.''
.PP
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping the
foreground and background colors.
.PP
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the prefered size and postion of the window;
see \fIX(1)\fP.
.PP
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact; see \fIX(1)\fP.
.PP
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH "X DEFAULTS"
.PP
This program uses the 
.I Load
widget in the X Toolkit.  It understands all of the core resource names and
classes as well as:
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the load average graph.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the load average graph.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the load should be redisplayed.
.TP 8
.B scale (\fPclass\fB Scale)
Specifies the initial number of ticks on the graph.  The default is 1.
.TP 8
.B minScale (\fPclass\fB Scale)
Specifies the minimum number of ticks that will be displayed.  The default
is 1.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the graph.  Using the class specifies the
color for all things that normally would appear in the foreground color.
The default is ``black'' since the core default for background is ``white.''
.TP 8
.B label (\fPclass\fB Label)
Specifies the label to use on the graph.  The default is the hostname.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for the label.  The default is ``fixed.''
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background should be reversed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY 
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources 
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
X(1), xrdb(1), mem(4), Athena Load widget
.SH DIAGNOSTICS
Unable to open display or create window. Unable to open /dev/kmem.
Unable to query window for dimensions. Various X errors.
.SH BUGS
This program 
requires the ability to open and read /dev/kmem. On most systems, this requires
the suid bit set with root ownership or the sgid bit set and membership in 
the same group as /dev/kmem. 
.PP
Reading /dev/kmem is inherently non-portable.
.PP
Border color has to be explicitly specified when reverse video is used.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
K. Shane Hartman (MIT-LCS) and Stuart A. Malone (MIT-LCS);
.br
with features added by Jim Gettys (MIT-Athena), Bob Scheifler (MIT-LCS),
and Tony Della Fera (MIT-Athena)
