.TH XCLIPBOARD 1 "23 October 1988" "X Version 11"
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.SH NAME
xclipboard - X clipboard client
.SH SYNOPSIS
\fBxclipboard\fP [ \fI-toolkitoption\fP ...] [-w] [-nw]
.SH DESCRIPTION
The \fIxclipboard\fP program is used to collect and display text selections 
that are sent to the CLIP_BOARD by other clients.  It is typically used to
gather together and hold a block of text that has been selected from
a variety of
different places.
.PP
Since \fIxclipboard\fP uses a Text Widget to display the contents of the 
clipboard, text sent to the CLIP_BOARD may be re-selected
for use in other applications.
.PP
An \fIxclipboard\fP window has the following buttons across the top:
.TP 8
.I "    quit"
When this button is pressed, \fIxclipboard\fP exits.
.TP 8
.I "    erase"
When this button is pressed, the contents of the text window are erased.
.SH OPTIONS
The \fIxclipboard\fP program accepts all of the standard X Toolkit command 
line options as well as the following:
.TP 8
.B \-w
This option indicates that lines of text that are too long to be displayed on
one line in the clipboard should wrap around to the following lines.
.TP 8
.B \-nw
This option indicates that long lines of text should not wrap around.
.SH SENDING TO CLIPBOARD
Text is copied to the clipboard whenever a client asserts ownership of
the \fBCLIP_BOARD\fP selection.  Examples of event bindings that a user
may wish to include in his/her resource configuration file to use
the clipboard are:
.sp
.Ds 5
.TA .5i
.ta .5i 3.0i
*VT100.Translations: #override \\
	Button1 <Btn2Down>:	select-end(CLIPBOARD) \\n\\
	Button1 <Btn2Up>:	ignore()

*Text.Translations: #override \\
	Button1 <Btn2Down>:	extend-end(CLIPBOARD)
.De
.sp
.SH X DEFAULTS
This program accepts all of the standard X Toolkit resource names and classes
as well as:
.TP 8
.B "wordWrap (\fPclass\fB WordWrap)"
This resource specifies whether or not lines of text should wrap around to
the following lines.  The default is \fIno\fP.
.SH "SEE ALSO"
X(1), xcutsel(1), xterm(1), individual client documentation for how to make a 
selection and send it to the CLIP_BOARD.
.SH BUGS
The erase button is not yet implemented.
.PP
It would be nice to have a way of specifying the file in which the
clipboard contents are saved.
.SH FILES
/usr/lib/X11/app-defaults/XClipboard - specifies required resources
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Ralph R. Swick, DEC/MIT Project Athena
