'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" t
.TH XConfigureWindow 3X11 "Release 6.6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XConfigureWindow, XMoveWindow, XResizeWindow, XMoveResizeWindow, XSetWindowBorderWidth, XWindowChanges \- configure windows and window changes structure
.SH SYNTAX
XConfigureWindow\^(\^\fIdisplay\fP, \fIw\fP\^, \fIvalue_mask\fP\^, \fIvalues\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned int \fIvalue_mask\fP\^;
.br
      XWindowChanges *\fIvalues\fP\^;
.LP
XMoveWindow\^(\^\fIdisplay\fP, \fIw\fP\^, \fIx\fP\^, \fIy\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.LP
XResizeWindow\^(\^\fIdisplay\fP, \fIw\fP\^, \fIwidth\fP\^, \fIheight\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned int \fIwidth\fP\^, \fIheight\fP\^;
.LP
XMoveResizeWindow\^(\^\fIdisplay\fP, \fIw\fP\^, \fIx\fP\^, \fIy\fP\^, \fIwidth\fP\^, \fIheight\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.br
      unsigned int \fIwidth\fP\^, \fIheight\fP\^;
.LP
XSetWindowBorderWidth\^(\^\fIdisplay\fP, \fIw\fP, \fIwidth\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      unsigned int \fIwidth\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIvalue_mask\fP 1i
Specifies which values are to be set using information in
the values structure.
This mask is the bitwise inclusive OR of the valid configure window values bits.
.IP \fIvalues\fP 1i
Specifies the 
.ZN XWindowChanges 
structure.
.ds Wi to be reconfigured, moved, or resized.
.IP \fIw\fP 1i
Specifies the window \*(Wi.
.IP \fIwidth\fP 1i
Specifies the width of the window border.
.ds Wh , which are the interior dimensions of the window
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height\*(Wh.
.ds Xy , which define the new location of the top-left pixel \
of the window's border or the window itself if it has no border \
or define the new position of the window relative to its parent
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
The
.ZN XConfigureWindow
function uses the values specified in the
.ZN XWindowChanges
structure to reconfigure a window's size, position, border, and stacking order.
Values not specified are taken from the existing geometry of the window.
.LP
If a sibling is specified without a stack_mode or if the window
is not actually a sibling,
a
.ZN BadMatch
error results. 
Note that the computations for
.ZN BottomIf ,
.ZN TopIf ,
and
.ZN Opposite
are performed with respect to the window's final geometry (as controlled by the
other arguments passed to
.ZN XConfigureWindow ),
not its initial geometry.
Any backing store contents of the window, its
inferiors, and other newly visible windows are either discarded or
changed to reflect the current screen contents 
(depending on the implementation).
.LP
.ZN XConfigureWindow
can generate
.ZN BadMatch ,
.ZN BadValue ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XMoveWindow
function moves the specified window to the specified x and y coordinates,
but it does not change the window's size, raise the window, or
change the mapping state of the window.
Moving a mapped window may or may not lose the window's contents 
depending on if the window is obscured by nonchildren 
and if no backing store exists.
If the contents of the window are lost, 
the X server generates
.ZN Expose 
events.
Moving a mapped window generates
.ZN Expose 
events on any formerly obscured windows. 
.LP
If the override-redirect flag of the window is 
.ZN False 
and some
other client has selected 
.ZN SubstructureRedirectMask 
on the parent, the X server generates a
.ZN ConfigureRequest 
event, and no further processing is
performed.  
Otherwise, the window is moved.
.LP
.ZN XMoveWindow
can generate a
.ZN BadWindow 
error.
.LP
The
.ZN XResizeWindow
function changes the inside dimensions of the specified window, not including
its borders.
This function does not change the window's upper-left coordinate or
the origin and does not restack the window.
Changing the size of a mapped window may lose its contents and generate
.ZN Expose 
events.
If a mapped window is made smaller, 
changing its size generates
.ZN Expose 
events on windows that the mapped window formerly obscured.
.LP
If the override-redirect flag of the window is 
.ZN False 
and some
other client has selected 
.ZN SubstructureRedirectMask 
on the parent, the X server generates a
.ZN ConfigureRequest 
event, and no further processing is performed.  
If either width or height is zero,
a
.ZN BadValue
error results.
.LP
.ZN XResizeWindow
can generate
.ZN BadValue
and
.ZN BadWindow 
errors.
.LP
The
.ZN XMoveResizeWindow
function changes the size and location of the specified window 
without raising it.
Moving and resizing a mapped window may generate an
.ZN Expose 
event on the window.
Depending on the new size and location parameters,
moving and resizing a window may generate 
.ZN Expose 
events on windows that the window formerly obscured. 
.LP
If the override-redirect flag of the window is 
.ZN False 
and some
other client has selected 
.ZN SubstructureRedirectMask 
on the parent, the X server generates a
.ZN ConfigureRequest 
event, and no further processing is performed.  
Otherwise, the window size and location are changed.
.LP
.ZN XMoveResizeWindow
can generate
.ZN BadValue
and
.ZN BadWindow 
errors.
.LP
The
.ZN XSetWindowBorderWidth
function sets the specified window's border width to the specified width.
.LP
.ZN XSetWindowBorderWidth
can generate a
.ZN BadWindow 
error.
.SH STRUCTURES
The
.ZN XWindowChanges
structure contains:
.LP
.LP
/* Configure window value mask bits */
.TS
lw(.5i) lw(2.5i) lw(.8i).
T{
#define
T}	T{
.ZN CWX
T}	T{
(1<<0)
T}
T{
#define
T}	T{
.ZN CWY
T}	T{
(1<<1)
T}
T{
#define
T}	T{
.ZN CWWidth
T}	T{
(1<<2)
T}
T{
#define
T}	T{
.ZN CWHeight
T}	T{
(1<<3)
T}
T{
#define
T}	T{
.ZN CWBorderWidth
T}	T{
(1<<4)
T}
T{
#define
T}	T{
.ZN CWSibling
T}	T{
(1<<5)
T}
T{
#define
T}	T{
.ZN CWStackMode
T}	T{
(1<<6)
T}
.TE
.IN "XWindowChanges" "" "@DEF@"
.Ds 0
.TA .5i 3i
.ta .5i 3i
/* Values */

typedef struct {
	int x, y;
	int width, height;
	int border_width;
	Window sibling;
	int stack_mode;
} XWindowChanges;
.De
.LP
The x and y members are used to set the window's x and y coordinates,
which are relative to the parent's origin
and indicate the position of the upper-left outer corner of the window.
The width and height members are used to set the inside size of the window,
not including the border, and must be nonzero, or a
.ZN BadValue
error results.
Attempts to configure a root window have no effect.
.LP
The border_width member is used to set the width of the border in pixels.
Note that setting just the border width leaves the outer-left corner of the window
in a fixed position but moves the absolute position of the window's origin.
If you attempt to set the border-width attribute of an
.ZN InputOnly
window nonzero, a
.ZN BadMatch
error results. 
.LP
The sibling member is used to set the sibling window for stacking operations.
The stack_mode member is used to set how the window is to be restacked 
and can be set to
.ZN Above , 
.ZN Below , 
.ZN TopIf , 
.ZN BottomIf ,
or 
.ZN Opposite .
.SH DIAGNOSTICS
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XChangeWindowAttributes(3X11),
XCreateWindow(3X11),
XDestroyWindow(3X11),
XMapWindow(3X11),
XRaiseWindow(3X11),
XUnmapWindow(3X11)
.br
\fI\*(xL\fP
