.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XInitial.man,v 1.4 2003/04/28 22:17:55 herrb Exp $
.\" $XdotOrg: xc/doc/man/X11/XInitial.man,v 1.1.4.3.4.1 2004/03/04 17:45:54 eich Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XrmInitialize 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XrmInitialize, XrmParseCommand, XrmValue, XrmOptionKind, XrmOptionDescRec \- initialize the Resource Manager, Resource Manager structures, and parse the command line
.SH SYNTAX
.HP
void XrmInitialize\^(void\^);
.HP
void XrmParseCommand\^(\^XrmDatabase *\fIdatabase\fP\^, XrmOptionDescList
\fItable\fP\^, int \fItable_count\fP\^, char *\fIname\fP\^, int
*\fIargc_in_out\fP\^, char **\fIargv_in_out\fP\^); 
.SH ARGUMENTS
.IP \fIargc_in_out\fP 1i
Specifies the number of arguments and returns the number of remaining arguments.
.IP \fIargv_in_out\fP 1i
Specifies the command line arguments
and returns the remaining arguments.
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIname\fP 1i
Specifies the application name.
.IP \fItable\fP 1i
Specifies the table of command line arguments to be parsed.
.IP \fItable_count\fP 1i
Specifies the number of entries in the table.
.SH DESCRIPTION
The
.ZN XrmInitialize
function initialize the resource manager.
It must be called before any other Xrm functions are used.
.LP
The
.ZN XrmParseCommand
function parses an (argc, argv) pair according to the specified option table,
loads recognized options into the specified database with type ``String,''
and modifies the (argc, argv) pair to remove all recognized options.
If database contains NULL,
.ZN XrmParseCommand
creates a new database and returns a pointer to it.
Otherwise, entries are added to the database specified.
If a database is created, it is created in the current locale.
.LP
The specified table is used to parse the command line.
Recognized options in the table are removed from argv,
and entries are added to the specified resource database
in the order they occur in argv.
The table entries contain information on the option string,
the option name, the style of option, 
and a value to provide if the option kind is 
.ZN XrmoptionNoArg .
The option names are compared byte-for-byte to arguments in argv,
independent of any locale.
The resource values given in the table are stored in the resource database
without modification.
All resource database entries are created
using a ``String'' representation type.
The argc argument specifies the number of arguments in argv
and is set on return to the remaining number of arguments that were not parsed.
The name argument should be the name of your application
for use in building the database entry.
The name argument is prefixed to the resourceName in the option table
before storing a database entry.
The name argument is treated as a single component, even if it
has embedded periods.
No separating (binding) character is inserted,
so the table must contain either a period (.) or an asterisk (*)
as the first character in each resourceName entry.
To specify a more completely qualified resource name,
the resourceName entry can contain multiple components.
If the name argument and the resourceNames are not in the
Host Portable Character Encoding,
the result is implementation-dependent.
.SH STRUCTURES
The
.ZN XrmValue ,
.ZN XrmOptionKind ,
and
.ZN XrmOptionDescRec
structures contain:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	unsigned int size;
	XPointer addr;
} XrmValue, *XrmValuePtr;
.De
.LP
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef enum {
	XrmoptionNoArg,	/\(** Value is specified in XrmOptionDescRec.value */
	XrmoptionIsArg,	/\(** Value is the option string itself */
	XrmoptionStickyArg,	/\(** Value is characters immediately following option */
	XrmoptionSepArg,	/\(** Value is next argument in argv */
	XrmoptionResArg,	/\(** Resource and value in next argument in argv */
	XrmoptionSkipArg,	/\(** Ignore this option and the next argument in argv */
	XrmoptionSkipLine,	/\(** Ignore this option and the rest of argv */
	XrmoptionSkipNArgs	/\(** Ignore this option and the next
		\ \ \ XrmOptionDescRec.value arguments in argv */
} XrmOptionKind;
.De
.LP
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	char *option;	/\(** Option specification string in argv		    */
	char *specifier;	/\(** Binding and resource name (sans application name)    */
	XrmOptionKind argKind;	/\(** Which style of option it is	    */
	XPointer value;	/\(** Value to provide if XrmoptionNoArg or 
		\ \ \ XrmoptionSkipNArgs   */
} XrmOptionDescRec, *XrmOptionDescList;
.De
.SH "SEE ALSO"
XrmGetResource(3X11),
XrmMergeDatabases(3X11),
XrmPutResource(3X11),
XrmUniqueQuark(3X11)
.br
\fI\*(xL\fP
