.TH XvStopVideo 3X __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvStopVideo.man,v 1.5 2001/01/27 18:20:36 dawes Exp $
.SH Name
XvStopVideo \- stop active video 
.\"
.SH Syntax
\fB#include <X11/extensions/Xvlib.h>
.sp 1l
\fBXvStopVideo(\fIdpy, port, draw\fR)
.sp 1l
\fBDisplay \fI*dpy\fR;
.br
\fBXvPortID \fIport\fR;
.br
\fBDrawable \fIdraw\fR;
.\"
.SH Arguments
.\"
.\"
.IP \fIdpy\fR 15
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIport\fR 15
Specifies the port for which video is to be stopped.
.IP \fIdraw\fR 15
Specifies the drawable associated with the named port.
.SH Description
.\"
XvStopVideo(3X) stops active video for the specified port and
drawable.  If the port is not processing video, or if it is processing
video in a different drawable, the request is ignored.  When video is
stopped a XvVideoNotify(3X) event with detail XvStopped is generated
for the associated drawable.
.\"
.SH Returned Values
.IP [Success] 8
Returned if XvStopVideo(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvStopVideo(3X) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.\"
.SH See Also
XvGetVideo(3X), XvPutVideo(3X), XvVideoNotifyEvent(3X)
.br
