.\" $NCDId: @(#)nas.man,v 1.2 1994/06/07 20:42:44 greg Exp $
.TH "NETWORK AUDIO SYSTEM" 1 "" ""
.SH NAME
Network Audio System \- a portable, network-transparent audio system
.SH SYNOPSIS
.PP
The Network Audio System service is a network-transparent system developed at 
Network Computing Devices for playing, recording, and manipulating audio data
over a network.  It uses the client/server model to separate application code
from the software drivers needed to control specific audio input and output 
devices.
.SH DESCRIPTION
The Network Audio System service provides applications with the
ability to send and receive audio data such as voice, sound effects,
and music in a network environment.  A audio server inside the desktop
terminal or personal computer controls the various input and output
devices in response to messages sent from client programs running on
other hosts.
.PP
A variety of
utility programs are provided that can be used to play or record audio using
shell scripts or command-line procedures.  More ambitious applications can
communicate directly with the audio server using a C-language programming 
library.
.PP
The Network Audio System service supports a variety of the common
formats used to store sound data.  Audio inputs and outputs can run at
a any of a range of sampling rates.  The audio server automatically
converts all data to the designed format or rate.
.PP
Streams of data from multiple inputs can be mixed together
and directed to any attached output device.  Sounds that are used many times
can be stored in the server so that they do not need to be transmitted over
the network each time they are played.  Furthermore, inputs can be hooked
directly to outputs (for example, a CD player can be connected to a set of
speakers) so that data can be played without requiring any 
client intervention or network traffic.
.SH "AUDIO SERVER NAMES"
.PP
Each audio server has a name that is used by applications in establishing
a connection.  The format of the name depends upon the type of network
being used.  In TCP/IP environments, audio server names look like:
.sp
.ce 1
tcp/\fIhostname\fP:\fIportnum\fP
.sp
where \fIhostname\fP is the name or numeric IP address 
of the desktop machine to be contacted and \fIportnum\fP
is the port number on which the server is listening.  If the ``tcp/'' prefix
is not given, 8000 is automatically added to \fIportnum\fP so that the 
audio server name is compatible with the X Window System display name.
.PP
In DECnet environments, audio server names look like:
.sp
.ce 1
decnet/\fInodename\fP::\fInum\fP
.sp
where \fInodename\fP is the name or numeric DECnet address of the desktop 
machine to be contacted and \fInum\fP is the DECnet task AUDIO$\fInum\fP.  If
the ``decnet/'' prefix is omitted, it is automatically added so that the
audio server name is compatible with the X Window System display name.
.PP
Most audio utilities accept a command line argument \fI\-audio servername\fP
for specifying the audio server to be contacted.
.sp
.nf
    % auinfo -audio tcp/ncdunit:8000
.fi
.sp
If no server is specified on the command line, the AUDIOSERVER environment 
variable is checked to see
if a name has been stored there.  Otherwise, the DISPLAY environment variable 
used by X Window System applications is checked and the corresponding
audio server is used.
.SH "SAMPLE PROGRAMS"
.PP
Several sample programs that use the Network Audio System service are
provided by NCD:
.TP 8
.B auplay
This program simply plays the files listed on its command line.  It is 
typically used from shell scripts, command-line procedures, or other programs
that just need to ``dump'' sound data to the audio server.
.TP 8
.B audemo
This program allows the user to select and play pre\-recorded sound
files or to record new sound files.  It provides a simple control
panel for dynamically changing the volume while a sound is being
played and for aborting a sound.
.TP 8
.B audial
This program generates North American telephone touch tones correspond to a 
given string.  \fIaudial\fP can also recognize touch tones and produce
the corresponding string.
.TP 8
.B autool
This program is compatible with the Sun \fIaudiotool\fP program and is
typically used to play prerecorded sound files.  Unlike \fIauplay\fP it
provides a graphical interface to allow the user to replay or cancel the data.
.TP 8
.B auinfo
This program lists information describing the capabilities of an audio server.
.TP 8
.B auctl
This program can be used to change various device parameters.
.TP 8
.B aupanel
This program provides an X-based window-oriented interface allowing
the user to adjust the attributes of the devices provided by the
Network Audio System service.
.TP 8
.B auedit
This program provides an X-based window-oriented interface allowing the user
to edit audio files.
.TP 8
.B auconvert
This program allows the user to perform various conversion operations on
sound files.
.TP 8
.B auphone
This program provides an X-based window-oriented interface allowing
two-way real time voice communication between two audio servers.
.TP 8
.B aurecord
This program is used to record audio data from an audio server into a
file.
.TP 8
.B auwave
This program provides an X-based window-oriented interface
demonstrating the use of waveform elements.
.SH "AUDIO FILES"
.PP
The audio programming library and utility programs can be used to read and
write files in any of the following file formats:
.IP "\fBSun/NeXT\fP"
These files typically have a '.au' or '.snd' extension.  They are usually
produced by Sun or NeXT workstations.
.IP "\fBCreative Labs\fP"
These files typically have a '.voc' extension.  They are usually produced by
by Soundblaster audio cards on IBM PC compatible computers.
.IP "\fBMicrosoft WAVE\fP"
These files typically have a '.wav' extension.  They are usually produced by
IBM PC compatible computers.
.IP "\fBAIFF\fP"
.br
These files typically have an '.aiff' or '.aif' extension.  They are usually
produced by SGI workstations or Apple computers.
.IP "\fBAmiga IFF/8SVX\fP"
These files typically have an '.iff' extension.
.PP
Due to the nature of the file formats, only the Sun/NeXT file format
can be piped through standard input and/or standard output.  The
convention for specifying standard input or standard output is to use
a hyphen ("\-") as the file name.
.SH "PROGRAMMING"
.PP
Application developers may create their own audio clients using the
Network Audio System programming library.
.SH "ENVIRONMENT VARIABLES"
.PP
The following environment variables are used by Network Audio System programs:
.TP 8
.B AUDIOSERVER
This specifies the name of default audio server to contact if no name is 
explicitly given on the command line.
.TP 8
.B DISPLAY
This specifies the name of an X Window System display that should be assumed
to also have a corresponding Network Audio System server.
.SH "SEE ALSO"
.PP
auplay(1), audemo(1), audial(1), autool(1), auinfo(1), auctl(1),
aupanel(1), auedit(1), auconvert(1), auphone(1), aurecord(1),
auwave(1)
\fINetwork Audio System Overview and Programmers Guide\fP
.SH "COPYRIGHT"
.PP
The following copyright and permission notice applies to all files in
the Network Audio System application programming libraries and example
programs provided in source form by Network Computing Devices:
.sp
Copyright 1993, 1994 Network Computing Devices, Inc.
.sp
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name Network Computing Devices, Inc. not be
used in advertising or publicity pertaining to distribution of this 
software without specific, written prior permission.
.sp
THIS SOFTWARE IS PROVIDED `AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.SH TRADEMARKS
.PP
NCD, NCD Display Station, and NCDware are all trademarks of
Network Computing Devices, Inc.
.PP
X Window System is a trademark of the Massachusetts Institute of Technology.
.SH AUTHORS
.PP
Greg Renda, Jim Fulton, David Lemke
