/***************************************************************************
 * Copyright (C) 2003-2006 by XGI Technology, Taiwan.			   *
 *									   *
 * All Rights Reserved.							   *
 *									   *
 * Permission is hereby granted, free of charge, to any person obtaining   *
 * a copy of this software and associated documentation files (the	   *
 * "Software"), to deal in the Software without restriction, including	   *
 * without limitation on the rights to use, copy, modify, merge,	   *
 * publish, distribute, sublicense, and/or sell copies of the Software,	   *
 * and to permit persons to whom the Software is furnished to do so,	   *
 * subject to the following conditions:					   *
 *									   *
 * The above copyright notice and this permission notice (including the	   *
 * next paragraph) shall be included in all copies or substantial	   *
 * portions of the Software.						   *
 *									   *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,	   *
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF	   *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND		   *
 * NON-INFRINGEMENT.  IN NO EVENT SHALL XGI AND/OR			   *
 * ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	   *
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,	   *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER	   *
 * DEALINGS IN THE SOFTWARE.						   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "xgi.h"
#include "xgi_regs.h"
#include "xgi_bios.h"
#include "xg47_tv.h"

static CARD16   currentXRes;
static CARD16   currentYRes;
static CARD16   currentColor;
static CARD16   m_MV7_APS;
static CARD16   I2C0E, I2C0F, I2C1E, I2C1F, I2C20, I2C22;
static CARD16   flicker;
static CARD32   dwHandle;

static CARD16 MV7SetRegisters(XGIPtr pXGI, CARD16 aps);
static void XG47DelayTimer(XGIPtr pXGI, unsigned loop);
static void XG47SetExternalRegister(XGIPtr pXGI, CARD16 index, CARD16 value);
static  CARD16 XG47GetExternalRegister(XGIPtr pXGI, CARD16 index);
static XGIDigitalTVInfoRec *XG47GetCurrentTable(XGIPtr pXGI,
    CARD16 xRes, CARD16 yRes, CARD16 color);
static unsigned long XG47DetectTVConnection(XGIPtr pXGI);

typedef struct {
    CARD16                 xRes;
    CARD16                 yRes;
    CARD16                 color;
    XGIDigitalTVInfoRec    nInfo[6];
    XGIDigitalTVInfoRec    pInfo[6];
} XGIDigitalTVModeRec, *XGIDigitalTVModePtr;

/*
 * Definition of video mode information.
 */
XGIDigitalTVModeRec XG47DTVModeTable[] = {
{
  MONITOR_X640, MONITOR_Y432,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },          /*NTSC H*/
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },          /*     V*/
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },          /*     Tint*/
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },          /*     Saturation*/
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },          /*     Bright*/
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }           /*     Flicker*/
  },
    /*low,  high, swing,def, curr, delta*/
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },          /*PAL  H*/
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X640, MONITOR_Y480,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y480,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y576,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y514,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y600,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X1024,MONITOR_Y768,BITSPIXEL_08,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x01 },   /*0x02*/
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X640, MONITOR_Y432,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X640, MONITOR_Y480,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y480,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y576,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y514,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y600,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X1024,MONITOR_Y768,BITSPIXEL_16,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x01 },   /*0x02*/
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X640, MONITOR_Y432,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X640, MONITOR_Y480,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y480,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X720, MONITOR_Y576,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y514,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X800, MONITOR_Y600,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
},
{
  MONITOR_X1024,MONITOR_Y768,BITSPIXEL_32,
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x01 },   /*0x02*/
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  },
  { { 0x00, 0x00, 0x14, 0x0A, 0x00, 0x04 },
    { 0x00, 0x00, 0x0A, 0x05, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x20, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x02 },
    { 0x00, 0x00, 0x20, 0x10, 0x00, 0x01 },
    { 0x00, 0x00, 0x04, 0x03, 0x00, 0x01 }
  }
}
};

static unsigned long XG47DTVModeTableSize = sizeof(XG47DTVModeTable)/sizeof(XGIDigitalTVModeRec);

/* fliker.c */

CARD8 lumai[]= { 0xb8, 0xb9, 0xba, 0xbb };
CARD8 chroi[]= { 0xbc, 0xbd, 0xbe, 0xbf };
CARD8 luma[][4] = {
    {0x80, 0x00, 0x80, 0x00},   /*By-pass*/
    {0xc0, 0x00, 0x00, 0x00},
    {0xcc, 0x9a, 0x00, 0x00},
    {0xb4, 0x0c, 0x00, 0x00},
    {0xb3, 0xa0, 0x06, 0x00},
    {0xab, 0xa0, 0x0a, 0x00},
    {0xa6, 0x9e, 0x0d, 0x02},
    {0xa0, 0x9b, 0x10, 0x05}
};
CARD8 chro[][4] = {
    {0x00, 0x00, 0x80, 0x00},   /*By-pass*/
    {0x40, 0x00, 0x00, 0x00},
    {0x4c, 0x9a, 0x00, 0x00},
    {0x34, 0x0c, 0x00, 0x00},
    {0x33, 0xa0, 0x06, 0x00},
    {0x2b, 0xa0, 0x0a, 0x00},
    {0x26, 0x9e, 0x0d, 0x02},
    {0x20, 0x9b, 0x10, 0x05}
};
CARD8 conv[] = { 1, 3, 5, 7 };    /*select table*/

/*
 * mv7.c
 */
#define MV7_REG 26

CARD8 indexi[MV7_REG] =
{
  0x19, 0x12, 0x13, 0x14, 0x15, 0x16, 0x1A, 0x1B, 0x1C, 0x1D, 0x21, 0x23,
  0x24, 0x26, 0x27, 0x28, 0x2A, 0x2B, 0x2D, 0x2E, 0x2F, 0x30, 0x36, 0x39,
  0x3A, 0x3B
};
CARD8 ntsc_mv7i[4][MV7_REG] =
{
 {0x00, 0x17, 0x21, 0x1B, 0x1B, 0x24, 0x0F, 0x0F, 0x60, 0x05, 0x04, 0x01,
  0x03, 0x0A, 0x05, 0x00, 0xFF, 0x03, 0x0F, 0x78, 0x00, 0x00, 0x00, 0x15,
  0x05, 0x15 },  /*Level0*/
 {0x36, 0x17, 0x21, 0x1B, 0x1B, 0x24, 0x0F, 0x0F, 0x60, 0x05, 0x02, 0x01,
  0x03, 0x0B, 0x03, 0x0F, 0xF3, 0x03, 0x0F, 0x78, 0x00, 0x00, 0x00, 0x15,
  0x05, 0x15 },  /*Level1*/
 {0x3E, 0x1D, 0x25, 0x1B, 0x1B, 0x24, 0x0F, 0x0F, 0x60, 0x01, 0x04, 0x01,
  0x00, 0x0A, 0x05, 0x00, 0xFF, 0x03, 0x0F, 0x78, 0x00, 0x00, 0x00, 0x11,
  0x07, 0x11 },  /*Level2*/
 {0x3E, 0x17, 0x21, 0x1B, 0x1B, 0x24, 0x0F, 0x0F, 0x60, 0x05, 0x04, 0x01,
  0x02, 0x0A, 0x05, 0x00, 0xFF, 0x03, 0x0F, 0x78, 0x00, 0x00, 0x00, 0x15,
  0x05, 0x15 }  /*Level3*/
};
CARD8 pal_mv7i[4][MV7_REG] =
{
 {0x00, 0x1A, 0x2A, 0x1C, 0x3D, 0x14, 0xFE, 0x7E, 0x60, 0x05, 0x07, 0x00,
  0x00, 0x08, 0x04, 0x00, 0x55, 0x01, 0x07, 0x7E, 0x02, 0x54, 0x00, 0x22,
  0x02, 0x22 },     /*Level0*/
 {0x36, 0x1A, 0x2A, 0x1C, 0x3D, 0x14, 0xFE, 0x7E, 0x60, 0x05, 0x07, 0x00,
  0x00, 0x08, 0x04, 0x00, 0x55, 0x01, 0x07, 0x7E, 0x02, 0x54, 0x00, 0x22,
  0x02, 0x22 },     /*Levle1*/
 {0x36, 0x1A, 0x2A, 0x1C, 0x3D, 0x14, 0xFE, 0x7E, 0x60, 0x05, 0x07, 0x00,
  0x00, 0x08, 0x04, 0x00, 0x55, 0x01, 0x07, 0x7E, 0x02, 0x54, 0x00, 0x22,
  0x02, 0x22 },     /*Level2*/
 {0x36, 0x1A, 0x2A, 0x1C, 0x3D, 0x14, 0xFE, 0x7E, 0x60, 0x05, 0x07, 0x00,
  0x00, 0x08, 0x04, 0x00, 0x55, 0x01, 0x07, 0x7E, 0x02, 0x54, 0x00, 0x22,
  0x02, 0x22 }      /*Level3*/
};

#define CVE2IDX 11
CARD8 cve2indexi[CVE2IDX] =
{
  0x1E, 0x1F, 0x0E, 0x0F, 0x3C, 0x3D, 0x10, 0x11, 0x35, 0x37, 0x38
};

CARD8 cve2ntsci[2][CVE2IDX] =
{
 {0xC6, 0x00, 0x46, 0x02, 0x4A, 0x00, 0x3C, 0x00, 0x48, 0xA3, 0xCA},/*En*/
 {0xC8, 0x00, 0x46, 0x02, 0x3C, 0x00, 0x3C, 0x00, 0x10, 0xA3, 0xCA} /*Dis*/
};
CARD8 cve2pali[2][CVE2IDX] =
{
 {0xBC, 0x01, 0x33, 0x00, 0x3E, 0x03, 0x33, 0x00, 0x10, 0x9C, 0xC0},/*En*/
 {0xC8, 0x00, 0x3E, 0x03, 0x3E, 0x03, 0x3E, 0x03, 0x10, 0x9C, 0xC0} /*Dis*/
/*0xD2/0xC8,  0x3F -Dis update*/
};

CARD16 MV7SetRegisters(XGIPtr pXGI, CARD16 aps)
{
    CARD8   *pMV7;
    CARD16  length;

    if(aps >= 0x04)
        aps = m_MV7_APS;
    else
        m_MV7_APS = aps & 0x03;

    OUTB(XGI_REG_CRX, 0xc0);
    if((CARD8)INB(XGI_REG_CRX+1) & 0x80)      /*PAL*/
    {
        pMV7 = pal_mv7i[aps];

        for(length = 0; length < MV7_REG; length++)
            XG47SetExternalRegister(pXGI, indexi[length], *(pMV7+length));

        pMV7 = (*(pMV7+0) ? cve2pali[0] : cve2pali[1]);
        for(length = 0; length < CVE2IDX; length++)
            XG47SetExternalRegister(pXGI, cve2indexi[length], *(pMV7+length));

        /*Black,White level depend on bios for Dis*/
        if(!aps)
        {
            XG47SetExternalRegister(pXGI, 0x0E, I2C0E);
            XG47SetExternalRegister(pXGI, 0x0F, I2C0F);
            XG47SetExternalRegister(pXGI, 0x1E, I2C1E);
            XG47SetExternalRegister(pXGI, 0x1F, I2C1F);
        }
    }
    else                                           /*NTSC*/
    {
        pMV7 = ntsc_mv7i[aps];

        for(length = 0; length < MV7_REG; length++)
            XG47SetExternalRegister(pXGI, indexi[length], *(pMV7+length));
        pMV7 = (*(pMV7+0)? cve2ntsci[0] : cve2ntsci[1]);
        for(length = 0; length < CVE2IDX; length++)
            XG47SetExternalRegister(pXGI, cve2indexi[length], *(pMV7+length));

        /*Black,White level depend on bios for Dis*/
        if(!aps)
        {
            XG47SetExternalRegister(pXGI, 0x0E, I2C0E);
            XG47SetExternalRegister(pXGI, 0x0F, I2C0F);
            XG47SetExternalRegister(pXGI, 0x1E, I2C1E);
            XG47SetExternalRegister(pXGI, 0x1F, I2C1F);
        }

    }
    return 0;
}

/*
 * init.c (dtv2)
 */
/*
 * Time = 31.25uSec * loop
 */
void XG47DelayTimer(XGIPtr pXGI, unsigned loop)
{
    int i;

    i = loop >> 8;
    do
    {
        OUTB(XGI_REG_GRX,0x3f);
        if (i)
        {
            OUTB(XGI_REG_GRX+1, 0xff);
        }
        else
        {
            OUTB(XGI_REG_GRX+1, loop & 0xff);
        }

        OUTB(XGI_REG_GRX,0x3e);
        OUTB(XGI_REG_GRX+1, (CARD8)INB(XGI_REG_GRX+1) | 0x80);
        while (1)
        {
            if (!((CARD8)INB(XGI_REG_GRX+1) & 0x80) ) break;
        }
    }while(i--);
}

/*
 * base.c (dtv2)
 */
/*
 * void SetExternalRegister(CARD16 index, CARD16 value)
 * Write TV register
 * index:    TV register index to write
 * value:    Value to write
 */
void XG47SetExternalRegister(XGIPtr pXGI, CARD16 index, CARD16 value)
{
    OUTB(XGI_REG_CRX,0xFE);
    OUTB(XGI_REG_CRX+1, (CARD8)(index & 0xFF));
    XG47DelayTimer(pXGI, 1);
    OUTB(XGI_REG_CRX,0xFF);
    OUTB(XGI_REG_CRX+1, (CARD8)(value & 0xFF));
}

/*
 * CARD16 GetExternalRegister(CARD16 index)
 * Read TV register
 * index:    TV register index to read
 */
CARD16 XG47GetExternalRegister(XGIPtr pXGI, CARD16 index)
{
    OUTB(XGI_REG_CRX,0xFE);
    OUTB(XGI_REG_CRX+1, (CARD8)(index & 0xFF));
    XG47DelayTimer(pXGI, 1);
    OUTB(XGI_REG_CRX,0xFF);
    return (CARD16)INB(XGI_REG_CRX+1);
}

/*
 * Function : Fine current table information
 * In       : xRes, yRes, Colr
 * Out      : Global pointer pXGI->pDtvInfo
 */
XGIDigitalTVInfoRec *XG47GetCurrentTable(XGIPtr pXGI, CARD16 xRes, CARD16 yRes, CARD16 color)
{
    XGIDigitalTVModeRec *pDtv;
    CARD16              i;

    pDtv = XG47DTVModeTable;
    if(xRes <= MONITOR_X640 && yRes <= MONITOR_Y432)
    {
        xRes = MONITOR_X640;
        yRes = MONITOR_Y432;
    }

    if(xRes > MONITOR_X1024 && yRes >  MONITOR_Y768)
    {
        xRes = MONITOR_X1024;
        yRes = MONITOR_Y768;
    }

    for(i= 0; i < XG47DTVModeTableSize; i++, pDtv++)
    {
        if(pDtv->xRes == xRes && pDtv->yRes == yRes && pDtv->color == color)
        {
            OUTB(0x3d4,0xc0);
            if(INB(0x3d5) & 0x80)
            {
                 return (pXGI->pDtvInfo = pDtv->pInfo);
            }
            else
            {
                return (pXGI->pDtvInfo = pDtv->nInfo);
            }
        }
    }
    return 0;
}

/*
 * Use BIOS INT 10 function to detect TV connection.
 * Input:    AX = 1280H
 *           BX = 0114H
 *
 *  Output:  AH = 0 if OK. (....)
 *           BX.    Bit0=1 Composite TV is connected.
 *               Bit1=1 S-Video is connected.
 */
unsigned long XG47DetectTVConnection(XGIPtr pXGI)
{
    unsigned long   device;
    CARD16          tv_a0, tv_a8;
    CARD8           suspend, path;

    tv_a0 = XG47GetExternalRegister(pXGI, 0xa0);
    OUTB(XGI_REG_CRX,0xd7);

    suspend = INB(XGI_REG_CRX+1);
    OUTB(XGI_REG_CRX+1, (CARD8)suspend & ~0xa0); /*Enable TV, DAC to TV*/
    OUTB(XGI_REG_GRX,0x27);
    path = INB(XGI_REG_GRX+1);
    if (path & 2)
    {
        /*
         * Because default of TV ouput is on, TV will will see the signal by set 3x5.d7.
         * So we need turn off TV output if TV is not current device.
         */
        XG47SetExternalRegister(pXGI, 0xa0, tv_a0 | 8);
        OUTB(XGI_REG_GRX,0x27);
        OUTB(XGI_REG_GRX+1, (CARD8)path & ~0x02);    /*TV GPIO  Path*/
    }

    XG47SetExternalRegister(pXGI, 0xa1, 0x56);
    XG47DelayTimer(pXGI, 320);     /*10mS*/
    if (tv_a0 & 4)          /*S-video*/
    {
        tv_a8 = XG47GetExternalRegister(pXGI, (CARD16)0xa8) & 0x10;
        if (!tv_a8)
        {
            XG47SetExternalRegister(pXGI, 0xa0, (XG47GetExternalRegister(pXGI, 0xa0) & ~0x04) | 0x01);
            XG47DelayTimer(pXGI, 320);     /*10mS*/
            tv_a8 = ((XG47GetExternalRegister(pXGI, (CARD16)0xa8) & 0x30) == 0x20) ? 0x20 : 0;
        }
    }
    else
    {
        tv_a8 = ((XG47GetExternalRegister(pXGI, (CARD16)0xa8) & 0x30) == 0x20) ? 0x20 : 0;
        if (!tv_a8)
        {
            XG47SetExternalRegister(pXGI, 0xa0, (XG47GetExternalRegister(pXGI, 0xa0) & ~0x01) | 0x04);
            XG47DelayTimer(pXGI, 320);     /*10mS*/
            tv_a8 = XG47GetExternalRegister(pXGI, (CARD16)0xa8) & 0x10;
        }
    }
    XG47SetExternalRegister(pXGI, 0xa1, 0);
    XG47SetExternalRegister(pXGI, 0xa0, tv_a0);

    OUTB(XGI_REG_CRX,0xd7);
    OUTB(XGI_REG_CRX+1, suspend); /*suspend*/
    OUTB(XGI_REG_GRX,0x27);
    OUTB(XGI_REG_GRX+1, path);    /*TV GPIO Path*/

    device = 0x00;
    if(tv_a8 & 0x20) device |= 0x01;
    if(tv_a8 & 0x10) device |= 0x02;
    return device;
}

/*
 * init.c (dtv2)
 * void InitTVScreen(CARD16 xRes, CARD16 yRes, CARD16 color, CARD16 attr)
 * Initial TV screen after set mode.
 *     xRes: Resolution, Width
 *     yRes: Resolution, Hight
 *     color: color depth(8, 16 or 32bit)
 *     Attr: Mode sub info
 */
void XG47InitTVScreen(XGIPtr pXGI, CARD16 xRes, CARD16 yRes, CARD16 color, CARD16 attr)
{
    CARD16  cal, cal2, offset;
    CARD8   tvDAC, tv_d7;

    /*Is it support mode?*/
    if (XG47GetCurrentTable(pXGI, xRes,yRes,color))
    {
        currentXRes = xRes;
        currentYRes = yRes;
        currentColor= color;
    }
    else
    {
        return;
    }

    /*enable TV*/
    OUTB(XGI_REG_CRX, 0xd7);
    tv_d7 = INB(XGI_REG_CRX+1);
    OUTB(XGI_REG_CRX+1, (tv_d7 & 0xDF));    /*clear bit5*/

    tvDAC = (CARD8)XG47GetExternalRegister(pXGI, 0xa0);
    XG47SetExternalRegister(pXGI, 0xa0, 0x00);    /*Dis TV*/
    I2C0E = XG47GetExternalRegister(pXGI, 0x0E);  /*Keep BIOS data*/
    I2C0F = XG47GetExternalRegister(pXGI, 0x0F);
    I2C1E = XG47GetExternalRegister(pXGI, 0x1E);
    I2C1F = XG47GetExternalRegister(pXGI, 0x1F);
    /*I2C20 = XG47GetExternalRegister(pXGI, 0x20);*/
    /*I2C22 = XG47GetExternalRegister(pXGI, 0x22);*/

    /*Calibration logic from BIOS value to Logical minal value*/
    /*Horizontal*/
    cal  = (XG47GetExternalRegister(pXGI, 0x95)<<8) & 0x1f00;
    cal |= XG47GetExternalRegister(pXGI, 0x94);
    offset = pXGI->pDtvInfo[HTOTAL].defoffset * pXGI->pDtvInfo[HTOTAL].delta;
    cal += offset;
    pXGI->pDtvInfo[HTOTAL].low    = cal;

    cal  = (XG47GetExternalRegister(pXGI, 0x99)<<8) & 0x3F00;
    cal |= XG47GetExternalRegister(pXGI, 0x98);
    offset = pXGI->pDtvInfo[HTOTAL].defoffset * pXGI->pDtvInfo[HTOTAL].delta;
    cal += offset;
    pXGI->pDtvInfo[HTOTAL].high    = cal;

    /*Vertical*/
    cal  = (XG47GetExternalRegister(pXGI, 0x8f)<<4) & 0x0f00;
    cal |= XG47GetExternalRegister(pXGI, 0x8e);                  /*V start*/
    cal2 = (XG47GetExternalRegister(pXGI, 0x8f)<<8) & 0x0f00;
    cal2|= XG47GetExternalRegister(pXGI, 0x90);                  /*V end*/
    offset = pXGI->pDtvInfo[VTOTAL].defoffset * pXGI->pDtvInfo[VTOTAL].delta;
    cal += offset;
    cal2+= offset;
    pXGI->pDtvInfo[VTOTAL].low  = cal;
    pXGI->pDtvInfo[VTOTAL].high = cal2;

    /*Tint*/
    XG47SetExternalRegister(pXGI, 0x25, 0x00);
    XG47DelayTimer(pXGI, 1);
    cal = 0x00;
    offset = pXGI->pDtvInfo[TINT].defoffset * pXGI->pDtvInfo[TINT].delta;
    pXGI->pDtvInfo[TINT].low    = (cal - offset);
    pXGI->pDtvInfo[TINT].high   = 0x00;

    /*Saturation*/
    /*XG47SetExternalRegister(pXGI, 0x20, I2C20);*/
    /*XG47SetExternalRegister(pXGI, 0x22, I2C22);*/
    offset = pXGI->pDtvInfo[SATUR].defoffset * pXGI->pDtvInfo[SATUR].delta;
    pXGI->pDtvInfo[SATUR].low   = XG47GetExternalRegister(pXGI, 0x20) - offset;
    pXGI->pDtvInfo[SATUR].high  = XG47GetExternalRegister(pXGI, 0x22) - offset;

    /*Bright*/
    XG47SetExternalRegister(pXGI, 0x1e, I2C1E);
    XG47SetExternalRegister(pXGI, 0x1f, I2C1F);
    cal = I2C1E;
    offset = pXGI->pDtvInfo[BRIGHT].defoffset * pXGI->pDtvInfo[BRIGHT].delta;
    pXGI->pDtvInfo[BRIGHT].low  = cal - offset;

    /*Flicker*/
    /*TVX2*/
    pXGI->pDtvInfo[FLICKER].low = 0x00;
    pXGI->pDtvInfo[FLICKER].high = 0x00;

    MV7SetRegisters(pXGI, m_MV7_APS);
    /*LoadSetting_I();*/                    /*Get the curoffset save value*/

    XG47SetExternalRegister(pXGI, 0xa0, (CARD8)tvDAC);

    /*restore TV*/
    OUTB(XGI_REG_CRX,0xd7);
    OUTB(XGI_REG_CRX+1, tv_d7);
}


/*
 * void ControlTVDisplay(BOOLEAN ctrl)
 * Turn ON/OFF TV
 * ctrl  0:  off
 *      1:  ON
 */
void XG47ControlTVDisplay(XGIPtr pXGI, Bool ctrl)
{
    CARD16 TV_out, TV_set;

    if(ctrl)
    {
        /*For W2 TV output setting.*/
        if(!XG47GetExternalRegister(pXGI, (CARD16)0xa0))
        {
            OUTB(XGI_REG_CRX, 0xd7);
            OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) & ~0x80);
            TV_out = (CARD16)XG47DetectTVConnection(pXGI);
            if(TV_out == 1) TV_set = 0x71;
            else if (TV_out == 2) TV_set = 0x74;
            else if (TV_out == 3) TV_set = 0x75;
            else TV_set = 0x00;
            XG47SetExternalRegister(pXGI, 0xa0, TV_set);
        }
        /*TV on*/
        OUTB(XGI_REG_CRX, 0xd1);
        OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) | 0xe0);
        /*TV enable 3D5.D7*/
        OUTB(XGI_REG_CRX, 0xd7);
        OUTB(XGI_REG_GRX, 0x55);
        if(INB(XGI_REG_GRX+1)&0x04)       /* Check TV_DPMS status, 1: DPMS on, LCD should turn off. */
        {
            OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) | 0x20); /*Disable TV*/
        }
        else
        {
            OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) & ~0x20); /*Enable TV*/
        }
        OUTB(XGI_REG_GRX, 0x27);
        OUTB(XGI_REG_GRX+1, (CARD8)INB(XGI_REG_GRX+1) & ~0x02);  /*TV GPIO  Path*/
    }
    else
    {
        /*TV off*/
        OUTB(XGI_REG_CRX,0xd1);
        OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) & ~0xe0);
        /*TV suspend 3D5.D7*/
        OUTB(XGI_REG_CRX,0xd7);
        OUTB(XGI_REG_CRX+1, (CARD8)INB(XGI_REG_CRX+1) | 0x20); /*suspend*/
        OUTB(XGI_REG_GRX,0x27);
        OUTB(XGI_REG_GRX+1, (CARD8)INB(XGI_REG_GRX+1) | 0x02);  /*TV GPIO Path*/

    }
    /*TV dummy*/
    XG47GetExternalRegister(pXGI, 0x3e);
}

void XGI47BiosAttachDTV(XGIPtr pXGI)
{
    /*Initial lpMyinfo*/
    XG47GetCurrentTable(pXGI, MONITOR_X640, MONITOR_Y432, BITSPIXEL_08);
    flicker = 0; /*Flicker test*/
}

